/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class OSCTuning implements ILocalRegister {

    public static final byte ADDRESS = 0x07;
    public static final byte FACTORY_VALUE = 0x08;
    public static final String NAME = "OSC Tuning";
    public static final byte OSC_TUNING_HIGHEST = Bit.parseBit();
    public static final byte OSC_TUNING_LOWEST = Bit.parseBit(3, 2, 1, 0);

    @Override
    public Type getType() {
        return Type.READ_WRITE;
    }

    @Override
    public String getDescription(Bit bit) {
        switch (bit) {
            case BIT_3:
            case BIT_2:
            case BIT_1:
            case BIT_0:
                return "OSC_Tuning use to fine tune frequency of on-chip oscillator.\n" +
                        "\t0000: frequency is set to the highest adjustable value.\n" +
                        "\t1111: frequency is set to the lowest adjustable value.\n" +
                        "Note that on-chip frequency is tuned to 1.8432MHz during\n" +
                        "manufacturing. Generally, user don't need to tune the frequency.\n" +
                        "OSC_Tuning optionally provides a way to tune the frequency.";
            default:
                return "RFU";
        }
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte OSC_TUNING = Bit.parseBit(3, 2, 1, 0);
    }
}
