/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 7/16/2015
 */
public class GPIOIn implements ILocalRegister {

    public static final byte ADDRESS = 0x0B;
    public static final byte FACTORY_VALUE = 0x00;
    public static final String NAME = "GPIO In";

    @Override
    public Type getType() {
        return Type.READ_ONLY_STATUS;
    }

    @Override
    public String getDescription(Bit bit) {
        return "Register IN[n] report logic value present at IO Pins.\n" +
                "If direction is output, return OUT[n] value.";
    }

    @Override
    public byte getAddress() {
        return ADDRESS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return FACTORY_VALUE;
    }

    public static class Params {
        public static final byte IN = Bit.parseBit(7, 6, 5, 4, 3, 2, 1, 0);
    }
}
