/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.s4310;

import android.content.Context;

import com.sic.module.nfc.tech.chips.s4310.registers.PowerStatus;
import com.sic.module.nfc.tech.chips.s431x.SIC431x;
import com.sic.module.utils.AppContext;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.0
 * @since 11/16/2014
 */
public class SIC4310 extends SIC431x {

    private static final String TAG = SIC4310.class.getName();

    private static SIC4310 instance;

    protected SIC4310(Context context) {
        super(context);
    }

    public static SIC4310 getInstance() {
        return getInstance(AppContext.getInstance().getContext());
    }

    public static SIC4310 getInstance(Context context) {
        if (instance == null) {
            instance = new SIC4310(context);
        }
        return instance;
    }

    public Register getRegister() {
        return Register.getInstance();
    }

    public GPIO getGPIO() {
        return GPIO.getInstance();
    }

    public UART getUART() {
        return UART.getInstance();
    }

    public boolean isPowerSuperCapReady() {
        byte flag = getPowerMeasurementStatus();
        return ((flag & PowerStatus.Params.SCAP_RDY) == PowerStatus.Params.SCAP_RDY);
    }

    public boolean isPowerUARTReady() {
        byte flag = getPowerMeasurementStatus();
        return ((flag & PowerStatus.Params.UART_RDY) == PowerStatus.Params.UART_RDY);
    }

    public boolean isPowerXVDDReady() {
        byte flag = getPowerMeasurementStatus();
        return ((flag & PowerStatus.Params.XVDD_RDY) == PowerStatus.Params.XVDD_RDY);
    }

    public boolean isPowerReady() {
        byte flag = getPowerMeasurementStatus();
        return ((flag & PowerStatus.Params.RSPW_RDY) == PowerStatus.Params.RSPW_RDY);
    }

    public boolean isPowerLDOOn() {
        byte flag = getPowerMeasurementStatus();
        return ((flag & PowerStatus.Params.LDO_ON) == PowerStatus.Params.LDO_ON);
    }

    public boolean sync() {
        clearFlagsRegister();
        getRegister().sync();
        getGPIO().sync();
        return getRegister().isSync();
    }
}
