/*
 * Copyright (c) 2015 Silicon Craft Technology Co.,Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sic.module.nfc.tech.chips.extension;

/**
 * @author Tanawat Hongthai - http://www.sic.co.th/
 * @version 1.0.1
 * @since 10/16/2015
 */
public interface ExtDevice {
    /**
     * A complete UART command function not receive data (TRxRU).
     *
     * @param cmd specific command set.
     * @return data receive from NFC.
     */
    byte[] commandsTransceive(final ExtCommand cmd);

    /**
     * A transmit function from RF to UART, TxRU (transmit only).
     *
     * @param cmd  specific command set.
     * @param data byte array of data
     * @return data receive from NFC.
     */
    byte[] commandsTransceive(final ExtCommand cmd, byte[] data);

    /**
     * A transmit function from RF to UART, TxRU (transmit only). This function
     * sends address and data in same packet.
     *
     * @param cmd  specific command set.
     * @param addr byte array of address (e.g. bootloader)
     * @param data byte array of raw data
     * @return data receive from NFC.
     */
    byte[] commandsTransceive(final ExtCommand cmd, byte[] addr, byte[] data);

    /**
     * The complete UART command function with receive data (TRxRU). Specific
     * for transmission address and data in same packet.
     * <p>
     * A transceive function from RF to UART, TRxRU, (transmit and receive).
     * This function sends command, data and address in the same packet.
     *
     * @param cmd specific command set.
     * @return data receive from NFC.
     */
    byte[] commandsTransceiveWithReceiver(final ExtCommand cmd);

    /**
     * The complete UART command function with receive data (TRxRU). Specific
     * for transmission address and data in same packet.
     * <p>
     * A transceive function from RF to UART, TRxRU, (transmit and receive).
     * This function sends command, data and address in the same packet.
     *
     * @param cmd  specific command set.
     * @param addr byte array of address
     * @return data receive from NFC.
     */
    byte[] commandsTransceiveWithReceiver(final ExtCommand cmd, byte[] addr);

    /**
     * The complete UART command function with receive data (TRxRU). Specific
     * for transmission address and data in same packet.
     * <p>
     * A transceive function from RF to UART, TRxRU, (transmit and receive).
     * This function sends command, data and address in the same packet.
     *
     * @param cmd  specific command set.
     * @param addr byte array of address
     * @param data byte array of raw data
     * @return data receive from NFC.
     */
    byte[] commandsTransceiveWithReceiver(final ExtCommand cmd, byte[] addr, byte[] data);

}
