/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.xml;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CodecUtil;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XmlWorker
extends DefaultHandler
implements LexicalHandler {
    private XmlNode xmnStart = null;
    private Locator locator = null;
    private ArrayUtil<Element> auTags = null;
    private ArrayUtil<Boolean> auBreak = null;
    private List<XmlNode> liNamespaces = null;
    private String sSchema = null;
    private StringBuilder sbValueTrim = null;
    private List<String> liEncryptedNodes = null;
    private int iIndentation = 2;
    private boolean bInsertNewLines = false;
    private boolean bCreateDeclaration = true;
    private boolean bAutoDecrypt = false;
    private boolean bValidation = false;
    private boolean bFormatWhitespaces = true;

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        XmlNode xmlNode = new XmlNode(0, "comment");
        xmlNode.setLineNumber(this.locator.getLineNumber());
        xmlNode.setColumnNumber(this.locator.getColumnNumber());
        if (n2 > 0) {
            String string = new String(cArray, n, n2);
            xmlNode.setValue(this.trimValue(string, true));
        }
        this.auTags.get(this.auTags.size() - 1).node.add(xmlNode);
    }

    public void startCDATA() throws SAXException {
        int n = this.auTags.size() - 1;
        Element element = this.auTags.get(n);
        if (element.value != null) {
            element.value.setLength(0);
        }
    }

    public void endCDATA() throws SAXException {
        int n = this.auTags.size() - 1;
        Element element = this.auTags.get(n);
        element.cdata = element.value;
        element.value = null;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.auTags.get(0).node.add(XmlNode.createDoctype(string, string2, string3));
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.isValidationEnabled()) {
            throw sAXParseException;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.isValidationEnabled()) {
            throw sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.isValidationEnabled()) {
            throw sAXParseException;
        }
    }

    public void startDocument() {
        if (this.bCreateDeclaration) {
            XmlNode xmlNode = XmlNode.createXmlDeclaration();
            this.auTags = new ArrayUtil();
            this.auTags.add(new Element(xmlNode));
        }
        this.auBreak = new ArrayUtil();
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        XmlNode xmlNode = new XmlNode(string3);
        int n = this.locator.getLineNumber();
        int n2 = this.locator.getColumnNumber();
        xmlNode.setLineNumber(n);
        xmlNode.setColumnNumber(n2);
        if (this.xmnStart == null) {
            if (this.auTags != null) {
                this.xmnStart = this.auTags.get(0).node;
            } else {
                this.xmnStart = xmlNode;
                this.auTags = new ArrayUtil();
                this.auTags.add(new Element(this.xmnStart));
            }
        }
        if (this.liNamespaces != null) {
            for (XmlNode xmlNode2 : this.liNamespaces) {
                xmlNode.add(xmlNode2);
            }
            this.liNamespaces = null;
        }
        int n3 = attributes.getLength();
        for (int i = 0; i < n3; ++i) {
            XmlNode xmlNode3 = new XmlNode(2, attributes.getQName(i));
            String string4 = attributes.getValue(i);
            if (string4 != null && string4.trim().length() > 0) {
                xmlNode3.setValue(attributes.getValue(i));
            }
            xmlNode3.setLineNumber(n);
            xmlNode3.setColumnNumber(n2);
            xmlNode.add(xmlNode3);
        }
        this.auTags.add(new Element(xmlNode));
        if (!this.auBreak.isEmpty()) {
            this.auBreak.remove(this.auBreak.size() - 1);
            this.auBreak.add(Boolean.TRUE);
        }
        this.auBreak.add(Boolean.FALSE);
    }

    public void characters(char[] cArray, int n, int n2) {
        Element element = this.auTags.get(this.auTags.size() - 1);
        StringBuilder stringBuilder = element.value;
        String string = new String(cArray, n, n2);
        boolean bl = this.auBreak.get(this.auBreak.size() - 1);
        if (bl || stringBuilder == null || stringBuilder.length() == 0) {
            this.auBreak.remove(this.auBreak.size() - 1);
            this.auBreak.add(Boolean.FALSE);
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            element.value = stringBuilder;
        }
        stringBuilder.append(string);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Serializable serializable;
        int n = this.auTags.size() - 1;
        Element element = this.auTags.get(n);
        XmlNode xmlNode = element.node;
        if (element.cdata != null) {
            xmlNode.setValue(element.cdata.toString());
            xmlNode.setType((short)4);
        } else {
            serializable = element.value;
            if (serializable != null) {
                if (this.bFormatWhitespaces) {
                    serializable = new StringBuilder(((StringBuilder)serializable).toString().trim());
                    for (int i = 0; i < ((StringBuilder)serializable).length(); ++i) {
                        char c = ((StringBuilder)serializable).charAt(i);
                        if (c != '\n') continue;
                        int n2 = ((StringBuilder)serializable).length();
                        for (int j = i; j < n2; ++j) {
                            if (Character.isWhitespace(((StringBuilder)serializable).charAt(j))) continue;
                            if (j - i > 1) {
                                serializable = ((StringBuilder)serializable).replace(i, j, "\n ");
                                ++i;
                            }
                            j = n2;
                        }
                    }
                    if (((StringBuilder)serializable).length() > 0) {
                        xmlNode.setValue(((StringBuilder)serializable).toString());
                    }
                } else {
                    xmlNode.setValue(((StringBuilder)serializable).toString());
                }
            }
        }
        if (string3.equals(xmlNode.getName())) {
            this.auTags.remove(element);
            serializable = this.auTags.get(n - 1).node;
            if (serializable != xmlNode) {
                ((XmlNode)serializable).add(xmlNode);
            }
        } else {
            throw new SAXException("Element '" + string3 + "' was not closed!");
        }
        this.auBreak.remove(this.auBreak.size() - 1);
    }

    public void startPrefixMapping(String string, String string2) {
        if (this.liNamespaces == null) {
            this.liNamespaces = new ArrayUtil<XmlNode>();
        }
        String string3 = string != null && string.length() > 0 ? "xmlns:" + string : "xmlns";
        this.liNamespaces.add(new XmlNode(2, string3, string2));
    }

    public XmlNode read(File file) throws SAXException, IOException, ParserConfigurationException {
        return this.readAndClose(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode readAndClose(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        XmlNode xmlNode;
        try {
            xmlNode = this.read(inputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CommonUtil.close(inputStream);
            throw throwable;
        }
        CommonUtil.close(inputStream);
        return xmlNode;
    }

    public XmlNode read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        Object object;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        this.locator = null;
        this.xmnStart = null;
        this.auTags = null;
        this.auBreak = null;
        this.sbValueTrim = null;
        sAXParserFactory.setNamespaceAware(true);
        if (this.bValidation) {
            if (this.sSchema != null) {
                object = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource streamSource = new StreamSource(ResourceUtil.getResourceAsStream(this.sSchema));
                sAXParserFactory.setSchema(((SchemaFactory)object).newSchema(streamSource));
            } else {
                sAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
                try {
                    sAXParserFactory.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                    sAXParserFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            }
        } else {
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            try {
                sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        object = sAXParserFactory.newSAXParser();
        if (this.bValidation && this.sSchema == null) {
            ((SAXParser)object).setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        ((SAXParser)object).setProperty("http://xml.org/sax/properties/lexical-handler", this);
        ((SAXParser)object).parse(inputStream, (DefaultHandler)this);
        return this.decrypt(this.xmnStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, XmlNode xmlNode) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.write(fileOutputStream, xmlNode);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CommonUtil.close(fileOutputStream);
            throw throwable;
        }
        CommonUtil.close(fileOutputStream);
    }

    public void write(OutputStream outputStream, XmlNode xmlNode) throws IOException {
        XmlNode xmlNode2 = null;
        XmlNode xmlNode3 = this.liEncryptedNodes != null && !this.liEncryptedNodes.isEmpty() ? (XmlNode)xmlNode.clone() : xmlNode;
        if (xmlNode.getType() != -1) {
            xmlNode2 = XmlNode.createXmlDeclaration();
            xmlNode2.add(xmlNode3);
        } else {
            xmlNode2 = xmlNode3;
        }
        this.encrypt(xmlNode2);
        xmlNode2.createXml(outputStream, this.iIndentation, this.bInsertNewLines);
        if (xmlNode3.getType() != -1) {
            xmlNode2.remove(xmlNode3);
        }
    }

    public void setIndentation(int n) {
        this.iIndentation = n;
    }

    public int getIndentation() {
        return this.iIndentation;
    }

    private String trimValue(String string, boolean bl) {
        ArrayUtil<String> arrayUtil;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        if (bl && !(arrayUtil = StringUtil.separateList(string, "\n", true)).isEmpty()) {
            if (this.sbValueTrim == null) {
                this.sbValueTrim = new StringBuilder();
            } else {
                this.sbValueTrim.setLength(0);
            }
            int n = arrayUtil.size();
            for (int i = 0; i < n; ++i) {
                String string2 = arrayUtil.get(i);
                if (this.sbValueTrim.length() > 0) {
                    this.sbValueTrim.append("\n");
                }
                this.sbValueTrim.append(string2);
            }
            string = this.sbValueTrim.toString();
            this.sbValueTrim.setLength(0);
        }
        return string;
    }

    public void setSchema(String string) {
        this.sSchema = string;
    }

    public String getSchema() {
        return this.sSchema;
    }

    public void setValidationEnabled(boolean bl) {
        this.bValidation = bl;
    }

    public boolean isValidationEnabled() {
        return this.bValidation;
    }

    public void setInsertNewLines(boolean bl) {
        this.bInsertNewLines = bl;
    }

    public boolean isInsertNewLines() {
        return this.bInsertNewLines;
    }

    public void setEncrypted(String string, boolean bl) {
        if (bl) {
            if (this.liEncryptedNodes == null) {
                this.liEncryptedNodes = new ArrayUtil<String>();
            }
            if (this.liEncryptedNodes.indexOf(string) < 0) {
                this.liEncryptedNodes.add(string);
            }
        } else if (this.liEncryptedNodes != null) {
            this.liEncryptedNodes.remove(string);
            if (this.liEncryptedNodes.isEmpty()) {
                this.liEncryptedNodes = null;
            }
        }
    }

    public boolean isEncrypted(String string) {
        return this.liEncryptedNodes != null && this.liEncryptedNodes.contains(string);
    }

    public void setAutomaticDecrypt(boolean bl) {
        this.bAutoDecrypt = bl;
    }

    public boolean isAutomaticDecrypt() {
        return this.bAutoDecrypt;
    }

    private XmlNode encrypt(XmlNode xmlNode) {
        for (XmlNode xmlNode2 : xmlNode.getNodes()) {
            this.encrypt(xmlNode2);
        }
        if (this.liEncryptedNodes != null && xmlNode.getType() != -1 && this.liEncryptedNodes.contains(xmlNode.getFullName())) {
            XmlNode xmlNode3 = new XmlNode(1, xmlNode.getName(), this.encrypt(xmlNode.toString()));
            xmlNode3.add(new XmlNode(2, "encrypted", "true"));
            XmlNode.replace(xmlNode, xmlNode3);
            return xmlNode3;
        }
        return xmlNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlNode decrypt(XmlNode xmlNode) throws IOException, SAXException, ParserConfigurationException {
        Object object;
        Object object2 = xmlNode.getNodes().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            this.decrypt((XmlNode)object);
        }
        if (xmlNode.getType() != -1 && Boolean.parseBoolean(xmlNode.getNodeValue("encrypted")) && (this.bAutoDecrypt || this.liEncryptedNodes != null && this.liEncryptedNodes.contains(xmlNode.getFullName())) && (object2 = this.decrypt(xmlNode.getValue())) != null) {
            object = new ByteArrayInputStream(((String)object2).getBytes("UTF-8"));
            boolean bl = this.bCreateDeclaration;
            try {
                this.bCreateDeclaration = false;
                XmlNode xmlNode2 = this.read((InputStream)object);
                XmlNode.replace(xmlNode, xmlNode2);
                XmlNode xmlNode3 = xmlNode2;
                Object var8_7 = null;
                this.bCreateDeclaration = bl;
                return xmlNode3;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.bCreateDeclaration = bl;
                throw throwable;
            }
        }
        return xmlNode;
    }

    private String encrypt(String string) {
        if (string == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(string.getBytes("UTF-8"));
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return CodecUtil.encodeHex(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String decrypt(String string) {
        try {
            byte[] byArray = CodecUtil.decodeHexAsBytes(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            return new String(FileUtil.getContent(gZIPInputStream, true), "UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static XmlNode readNode(File file) throws Exception {
        XmlWorker xmlWorker = new XmlWorker();
        return xmlWorker.read(file);
    }

    public static XmlNode readNode(InputStream inputStream) throws Exception {
        XmlWorker xmlWorker = new XmlWorker();
        return xmlWorker.read(inputStream);
    }

    public void setFormatWhitespaces(boolean bl) {
        this.bFormatWhitespaces = bl;
    }

    public boolean isFormatWhitespaces() {
        return this.bFormatWhitespaces;
    }

    private static final class Element {
        private XmlNode node;
        private StringBuilder cdata = null;
        private StringBuilder value = null;

        private Element(XmlNode xmlNode) {
            this.node = xmlNode;
        }
    }
}

