/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MagicByteInputStream
extends FilterInputStream {
    private byte[] byMagic;
    private int iBytePos;
    private boolean bFound;
    private boolean bAutoEOF;

    public MagicByteInputStream(InputStream inputStream, byte[] byArray) {
        this(inputStream, byArray, false);
    }

    public MagicByteInputStream(InputStream inputStream, byte[] byArray, boolean bl) {
        super(inputStream);
        this.byMagic = byArray;
        this.bAutoEOF = bl;
    }

    public int read() throws IOException {
        if (this.bFound && this.bAutoEOF) {
            return -1;
        }
        int n = super.read();
        if (n != -1) {
            if (this.bFound) {
                this.bFound = false;
                this.iBytePos = 0;
            }
            this.iBytePos = this.byMagic[this.iBytePos] == (byte)n ? ++this.iBytePos : 0;
            this.bFound = this.iBytePos == this.byMagic.length;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bFound && this.bAutoEOF) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            int n4;
            if (this.bFound) {
                this.bFound = false;
                this.iBytePos = 0;
            }
            if ((n4 = n3 - this.byMagic.length - this.iBytePos - 1) < 0) {
                n4 = 0;
            }
            for (int i = n4; i < n3 && !this.bFound; ++i) {
                this.iBytePos = this.byMagic[this.iBytePos] == byArray[n + i] ? ++this.iBytePos : 0;
                this.bFound = this.iBytePos == this.byMagic.length;
            }
        }
        return n3;
    }

    public void close() throws IOException {
        this.readMagicByte();
        super.close();
    }

    public void readMagicByte() throws IOException {
        if (this.byMagic != null && !this.bFound) {
            int n = 0;
            while (!this.bFound && n >= 0) {
                n = this.read();
            }
            if (!this.bFound) {
                throw new IOException("Magic byte was not found!");
            }
        }
    }
}

