/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.remote.event.ICallBackResultListener;
import javax.rad.remote.event.IConnectionPropertyChangedListener;
import javax.rad.remote.event.PropertyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectObjectConnection
implements IConnection {
    private Map<String, Object> mpObjects;
    private ArrayUtil<IConnectionPropertyChangedListener> auPropertyChangedListeners;
    private boolean bCalling = false;

    public DirectObjectConnection() {
    }

    public DirectObjectConnection(Map<String, Object> map) {
        this.mpObjects = new HashMap<String, Object>(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object[] call(ConnectionInfo connectionInfo, String[] stringArray, String[] stringArray2, Object[][] objectArray, ICallBackListener[] iCallBackListenerArray) throws Throwable {
        try {
            this.bCalling = true;
            if (iCallBackListenerArray != null) {
                for (ICallBackListener arrayUtil : iCallBackListenerArray) {
                    if (arrayUtil == null) continue;
                    throw new RuntimeException("CallBacks are not supported!");
                }
            }
            if (stringArray == null || stringArray.length == 0) {
                throw new RuntimeException("Action calls are not supported!");
            }
            Object[] objectArray2 = new Object[stringArray.length];
            Object object = null;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (this.mpObjects == null) {
                    throw new RuntimeException("Unknown object '" + stringArray[i] + "'");
                }
                ArrayUtil<String> arrayUtil = StringUtil.separateList(stringArray[i], ".", true);
                object = this.mpObjects.get(arrayUtil.get(0));
                int n2 = arrayUtil.size();
                for (int j = 1; j < n2; ++j) {
                    String string = arrayUtil.get(j);
                    try {
                        object = Reflective.call(object, StringUtil.formatMethodName("get", string), new Object[0]);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (object instanceof Map) {
                            Object v = ((Map)object).get(string);
                            if (v == null && !((Map)object).containsKey(string)) {
                                throw new RuntimeException("Unknown object '" + string + "'");
                            }
                            object = v;
                            continue;
                        }
                        throw new RuntimeException("Unknown object '" + string + "'", noSuchMethodException);
                    }
                    finally {
                        connectionInfo.setLastCallTime(System.currentTimeMillis());
                    }
                }
                if (object == null) {
                    throw new RuntimeException("Unknown object '" + stringArray[i] + "'");
                }
                try {
                    objectArray2[i] = Reflective.call(object, stringArray2[i], objectArray != null ? objectArray[i] : NOPARAMETER);
                    continue;
                }
                finally {
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                }
            }
            Object[] objectArray3 = objectArray2;
            return objectArray3;
        }
        finally {
            this.bCalling = false;
        }
    }

    @Override
    public boolean isCalling() {
        return this.bCalling;
    }

    @Override
    public synchronized void close(ConnectionInfo connectionInfo) throws Throwable {
        connectionInfo.setConnectionId(null);
    }

    @Override
    public synchronized Hashtable<String, Object> getProperties(ConnectionInfo connectionInfo) throws Throwable {
        return connectionInfo.getProperties();
    }

    @Override
    public synchronized Object getProperty(ConnectionInfo connectionInfo, String string) throws Throwable {
        return connectionInfo.getProperties().get(string);
    }

    @Override
    public boolean isOpen(ConnectionInfo connectionInfo) {
        return connectionInfo.getConnectionId() != null;
    }

    @Override
    public synchronized void open(ConnectionInfo connectionInfo) {
        connectionInfo.setConnectionId(UUID.randomUUID().toString());
    }

    @Override
    public synchronized void openSub(ConnectionInfo connectionInfo, ConnectionInfo connectionInfo2) {
        connectionInfo2.setConnectionId(UUID.randomUUID().toString());
    }

    public synchronized void reopen(ConnectionInfo connectionInfo) {
    }

    @Override
    public synchronized ConnectionInfo[] setAndCheckAlive(ConnectionInfo connectionInfo, ConnectionInfo[] connectionInfoArray) {
        return null;
    }

    @Override
    public synchronized void setNewPassword(ConnectionInfo connectionInfo, String string, String string2) throws Throwable {
        connectionInfo.getProperties().put("client.password", string2);
    }

    @Override
    public synchronized void setProperty(ConnectionInfo connectionInfo, String string, Object object) throws Throwable {
        Object object2 = connectionInfo.getProperties().put(string, object);
        if (this.auPropertyChangedListeners != null && !CommonUtil.equals(object2, object)) {
            PropertyEvent propertyEvent = new PropertyEvent(string, object2, object);
            for (IConnectionPropertyChangedListener iConnectionPropertyChangedListener : this.auPropertyChangedListeners) {
                iConnectionPropertyChangedListener.propertyChanged(propertyEvent);
            }
        }
    }

    @Override
    public void addPropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.auPropertyChangedListeners == null) {
            this.auPropertyChangedListeners = new ArrayUtil();
        }
        this.auPropertyChangedListeners.add(iConnectionPropertyChangedListener);
    }

    @Override
    public void removePropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.auPropertyChangedListeners != null) {
            this.auPropertyChangedListeners.remove(iConnectionPropertyChangedListener);
        }
    }

    @Override
    public void addCallBackResultListener(ICallBackResultListener iCallBackResultListener) {
    }

    @Override
    public void removeCallBackResultListener(ICallBackResultListener iCallBackResultListener) {
    }

    public Object put(String string, Object object) {
        if (object == null) {
            return this.remove(string);
        }
        if (this.mpObjects == null) {
            this.mpObjects = new HashMap<String, Object>();
        }
        return this.mpObjects.put(string, object);
    }

    public Object get(String string) {
        if (this.mpObjects == null || string == null) {
            return null;
        }
        return this.mpObjects.get(string);
    }

    public Object remove(String string) {
        if (this.mpObjects != null) {
            return this.mpObjects.remove(string);
        }
        return null;
    }
}

