/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.ApplicationUtil;
import com.sibvisions.rad.ui.swing.ext.fonts.FontAwesome;
import com.sibvisions.util.IntHashMap;
import com.sibvisions.util.type.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class JVxFontAwesomeIcon
extends ImageIcon {
    private static final Font BASEFONT;
    private static final IntHashMap<Font> CACHED_SIZED_BASEFONT;
    private FontAwesome faIconDefinition;
    private Color color = null;
    private int size;

    public JVxFontAwesomeIcon(FontAwesome fontAwesome) {
        this.faIconDefinition = fontAwesome;
        this.size = 16;
    }

    public JVxFontAwesomeIcon(String string) {
        this.parse(string);
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Serializable serializable;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        Font font2 = CACHED_SIZED_BASEFONT.get(this.size);
        if (font2 == null) {
            font2 = BASEFONT.deriveFont(0, this.size);
            CACHED_SIZED_BASEFONT.put(this.size, font2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setFont(font2);
        if (this.color != null) {
            graphics2D.setColor(this.color);
        } else {
            serializable = null;
            if (component != null) {
                serializable = component.getForeground();
            }
            if (serializable == null) {
                serializable = Color.BLACK;
            }
            graphics2D.setColor((Color)serializable);
        }
        serializable = graphics2D.getFontMetrics(font2);
        int n3 = (this.getIconWidth() - ((FontMetrics)serializable).charWidth(this.faIconDefinition.getCode())) / 2;
        int n4 = (this.getIconHeight() - ((FontMetrics)serializable).getHeight()) / 2 + ((FontMetrics)serializable).getAscent();
        graphics2D.drawString(String.valueOf(this.faIconDefinition.getCode()), n + n3, n2 + n4);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public int getIconWidth() {
        return this.size;
    }

    public int getIconHeight() {
        return this.size;
    }

    public Image getImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        bufferedImage.getGraphics().dispose();
        return bufferedImage;
    }

    private void parse(String string) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Invalid icon definition: " + string);
        }
        HashMap<String, String> hashMap = ApplicationUtil.splitImageProperties(string);
        this.faIconDefinition = FontAwesome.resolve(hashMap.get("name"));
        String string2 = hashMap.get("size");
        if (string2 == null && (string2 = hashMap.get("font-size")) == null) {
            string2 = "16";
        }
        try {
            this.size = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string2 = StringUtil.getText(string2, '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ',', '.');
        }
        this.size = Integer.parseInt(string2);
        String string3 = hashMap.get("color");
        int[] nArray = StringUtil.parseColor(string3);
        if (nArray != null) {
            this.color = nArray.length == 3 ? new Color(nArray[0], nArray[1], nArray[2]) : new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        CACHED_SIZED_BASEFONT = new IntHashMap();
        try {
            InputStream inputStream = JVxFontAwesomeIcon.class.getResourceAsStream("/com/sibvisions/rad/ui/swing/ext/fonts/fontawesome-webfont.ttf");
            try {
                BASEFONT = Font.createFont(0, inputStream);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(BASEFONT);
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            {
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

