/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.celleditor;

import com.sibvisions.rad.ui.celleditor.AbstractComboCellEditor;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CommonUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rad.genui.celleditor.UICellEditor;
import javax.rad.model.ColumnView;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.condition.BaseCondition;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.IControl;
import javax.rad.model.ui.ITableControl;
import javax.rad.ui.IDimension;
import javax.rad.ui.celleditor.ILinkedCellEditor;
import javax.rad.ui.celleditor.IStyledCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkedCellEditor
extends AbstractComboCellEditor
implements ILinkedCellEditor {
    protected boolean autoTableHeaderVisibility = true;
    protected ICondition additionalCondition;
    protected ColumnView columnView;
    protected String displayReferencedColumnName = null;
    protected String displayConcatMask = null;
    protected ReferenceDefinition linkReference;
    protected IDimension popupSize;
    protected ColumnMapping searchColumnMapping;
    protected boolean searchTextAnywhere = true;
    protected boolean searchInAllTableColumns = false;
    protected boolean sortByColumnName;
    protected boolean tableHeaderVisible = false;
    protected boolean tableReadOnly = true;
    protected boolean validationEnabled = true;
    private Map<String, Integer> displayValueCache = new HashMap<String, Integer>();
    private String lastColumnForSearch = null;
    private String lastDisplayColumn = null;
    private WeakReference<IDataPage> lastPageForSearch = null;
    private int lastSearchRow = 0;

    protected AbstractLinkedCellEditor() {
    }

    @Override
    public ICondition getAdditionalCondition() {
        return this.additionalCondition;
    }

    @Override
    public ColumnView getColumnView() {
        return this.columnView;
    }

    @Override
    public String getDisplayReferencedColumnName() {
        return this.displayReferencedColumnName;
    }

    @Override
    public String getDisplayConcatMask() {
        return this.displayConcatMask;
    }

    @Override
    public ReferenceDefinition getLinkReference() {
        return this.linkReference;
    }

    @Override
    public IDimension getPopupSize() {
        return this.popupSize;
    }

    @Override
    public ColumnMapping getSearchColumnMapping() {
        return this.searchColumnMapping;
    }

    @Override
    public boolean isSearchTextAnywhere() {
        return this.searchTextAnywhere;
    }

    @Override
    public boolean isSearchInAllTableColumns() {
        return this.searchInAllTableColumns;
    }

    @Override
    public boolean isSortByColumnName() {
        return this.sortByColumnName;
    }

    @Override
    public boolean isTableHeaderVisible() {
        return this.tableHeaderVisible;
    }

    @Override
    public boolean isTableReadonly() {
        return this.tableReadOnly;
    }

    @Override
    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    @Override
    public void setAdditionalCondition(ICondition iCondition) {
        this.additionalCondition = iCondition;
    }

    @Override
    public void setColumnView(ColumnView columnView) {
        this.columnView = columnView;
    }

    @Override
    public void setDisplayReferencedColumnName(String string) {
        this.displayReferencedColumnName = string;
    }

    @Override
    public void setDisplayConcatMask(String string) {
        this.displayConcatMask = string;
    }

    @Override
    public void setLinkReference(ReferenceDefinition referenceDefinition) {
        this.linkReference = referenceDefinition;
    }

    @Override
    public void setPopupSize(IDimension iDimension) {
        this.popupSize = iDimension;
    }

    @Override
    public void setSearchColumnMapping(ColumnMapping columnMapping) {
        this.searchColumnMapping = columnMapping;
    }

    @Override
    public void setSearchTextAnywhere(boolean bl) {
        this.searchTextAnywhere = bl;
    }

    @Override
    public void setSearchInAllTableColumns(boolean bl) {
        this.searchInAllTableColumns = bl;
    }

    @Override
    public void setSortByColumnName(boolean bl) {
        this.sortByColumnName = bl;
    }

    @Override
    public void setTableHeaderVisible(boolean bl) {
        this.autoTableHeaderVisibility = false;
        this.tableHeaderVisible = bl;
    }

    @Override
    public void setTableReadonly(boolean bl) {
        this.tableReadOnly = bl;
    }

    @Override
    public void setValidationEnabled(boolean bl) {
        this.validationEnabled = bl;
    }

    @Override
    public boolean isDirectCellEditor() {
        return false;
    }

    public int getDefaultHorizontalAlignment(IDataRow iDataRow, String string) {
        int n = this.getHorizontalAlignment();
        if (n == -1) {
            try {
                IDataType iDataType = iDataRow.getRowDefinition().getColumnDefinition(string).getDataType();
                ICellEditor iCellEditor = iDataType.getCellEditor();
                if (iCellEditor != this && iCellEditor instanceof IStyledCellEditor) {
                    n = ((IStyledCellEditor)iCellEditor).getHorizontalAlignment();
                }
                if (n == -1 && this.displayReferencedColumnName == null && this.displayConcatMask == null && (iCellEditor = UICellEditor.getDefaultCellEditor(iDataType.getTypeClass())) != this && iCellEditor instanceof IStyledCellEditor) {
                    n = ((IStyledCellEditor)iCellEditor).getHorizontalAlignment();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == -1) {
                n = 0;
            }
        }
        return n;
    }

    protected String getDisplayValue(IDataRow iDataRow, String string) throws ModelException {
        IDataType iDataType = iDataRow.getRowDefinition().getColumnDefinition(string).getDataType();
        Object object = iDataRow.getValue(string);
        String string2 = iDataType.convertToString(object);
        if ((this.displayReferencedColumnName != null || this.displayConcatMask != null) && this.linkReference != null) {
            Object object2;
            int n;
            int n2;
            Object object3;
            Integer n3 = this.displayValueCache.get(string2);
            IDataBook iDataBook = this.linkReference.getReferencedDataBook();
            IDataPage iDataPage = iDataBook.getDataPage();
            String string3 = this.linkReference.getReferencedColumnName(string);
            IDataType iDataType2 = iDataBook.getRowDefinition().getColumnDefinition(string3).getDataType();
            Object object4 = null;
            String string4 = null;
            ICondition iCondition = iDataBook.getFilter();
            IControl[] iControlArray = null;
            int n4 = -1;
            if (iCondition != null) {
                iControlArray = iDataBook.getControls();
                object3 = iControlArray;
                n2 = ((IControl[])object3).length;
                for (n = 0; n < n2; ++n) {
                    object2 = object3[n];
                    iDataBook.removeControl((IControl)object2);
                }
                n4 = iDataBook.getSelectedRow();
                iDataBook.setFilter(null);
            }
            if (n3 != null && (object4 = iDataBook.getDataRow(n3)) != null) {
                object3 = object4.getValue(string3);
                try {
                    string4 = iDataType.convertToString(iDataType.convertToTypeClass(object3));
                }
                catch (Exception exception) {
                    string4 = iDataType2.convertToString(object3);
                }
            }
            if (!(this.lastPageForSearch != null && this.lastPageForSearch.get() == iDataPage && CommonUtil.equals(string3, this.lastColumnForSearch) && CommonUtil.equals(this.displayReferencedColumnName, this.lastDisplayColumn) && (n3 == null || object4 != null && CommonUtil.equals(string2, string4)))) {
                this.displayValueCache.clear();
                this.lastPageForSearch = new WeakReference<IDataPage>(iDataPage);
                this.lastColumnForSearch = string3;
                this.lastDisplayColumn = this.displayReferencedColumnName;
                this.lastSearchRow = 0;
                n3 = null;
            }
            if (n3 == null) {
                object3 = iDataBook.getDataRow(this.lastSearchRow);
                while (object3 != null && object4 == null) {
                    Object object5 = object3.getValue(string3);
                    try {
                        string4 = iDataType.convertToString(iDataType.convertToTypeClass(object5));
                    }
                    catch (Exception exception) {
                        string4 = iDataType2.convertToString(object5);
                    }
                    this.displayValueCache.put(string4, this.lastSearchRow);
                    if (CommonUtil.equals(string2, string4)) {
                        object4 = object3;
                        continue;
                    }
                    ++this.lastSearchRow;
                    object3 = iDataBook.getDataRow(this.lastSearchRow);
                }
            }
            if (iCondition != null) {
                iDataBook.setFilter(iCondition);
                iDataBook.setSelectedRow(n4);
                object3 = iControlArray;
                n2 = ((Object)object3).length;
                for (n = 0; n < n2; ++n) {
                    object2 = object3[n];
                    iDataBook.addControl((IControl)object2);
                }
            }
            if (object4 != null && (object3 = this.getDisplayValueFromRow((IDataRow)object4)) != null) {
                return object3;
            }
        }
        return string2;
    }

    protected String getDisplayValueFromRow(IDataRow iDataRow) throws ModelException {
        if (this.displayConcatMask != null) {
            ColumnView columnView = this.columnView;
            if (columnView == null) {
                columnView = this.linkReference.getReferencedDataBook().getRowDefinition().getColumnView(ITableControl.class);
            }
            int n = columnView.getColumnCount();
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = this.displayConcatMask.indexOf(42);
            if (n2 < 0) {
                if (n == 0) {
                    return null;
                }
                stringBuilder.append(CommonUtil.nvl(iDataRow.getValueAsString(columnView.getColumnName(0)), ""));
                for (int i = 1; i < n; ++i) {
                    stringBuilder.append(this.displayConcatMask);
                    stringBuilder.append(CommonUtil.nvl(iDataRow.getValueAsString(columnView.getColumnName(i)), ""));
                }
            } else {
                int n3 = 0;
                int n4 = 0;
                while (n2 >= 0) {
                    stringBuilder.append(this.displayConcatMask.substring(n4, n2));
                    if (n3 < n) {
                        stringBuilder.append(CommonUtil.nvl(iDataRow.getValueAsString(columnView.getColumnName(n3)), ""));
                        ++n3;
                    } else {
                        stringBuilder.append("");
                    }
                    n4 = n2 + 1;
                    n2 = this.displayConcatMask.indexOf(42, n4);
                }
                stringBuilder.append(this.displayConcatMask.substring(n4));
            }
            return stringBuilder.toString();
        }
        return iDataRow.getValueAsString(this.displayReferencedColumnName);
    }

    protected String[] getClearColunms(IDataRow iDataRow, String string) throws ModelException {
        IRowDefinition iRowDefinition = iDataRow.getRowDefinition();
        String[] stringArray = iRowDefinition.getColumnNames();
        String[] stringArray2 = this.getLinkReference().getColumnNames();
        String[] stringArray3 = this.getAllSearchColumns(this.getSearchColumnMapping(), iDataRow, this.getAdditionalCondition());
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        arrayUtil.addAll(stringArray2);
        for (String string2 : stringArray) {
            String[] stringArray4;
            ILinkedCellEditor iLinkedCellEditor;
            ReferenceDefinition referenceDefinition;
            ICellEditor iCellEditor = iRowDefinition.getColumnDefinition(string2).getDataType().getCellEditor();
            if (!(iCellEditor instanceof ILinkedCellEditor) || (referenceDefinition = (iLinkedCellEditor = (ILinkedCellEditor)iCellEditor).getLinkReference()) == null || ArrayUtil.intersect(stringArray4 = referenceDefinition.getColumnNames(), stringArray3).length <= 0 || ArrayUtil.contains(stringArray4, string)) continue;
            arrayUtil.removeAll(stringArray4);
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    protected String[] getAdditionalClearColumns(IDataRow iDataRow) throws ModelException {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        IRowDefinition iRowDefinition = iDataRow.getRowDefinition();
        String[] stringArray = iRowDefinition.getColumnNames();
        String[] stringArray2 = this.getLinkReference().getColumnNames();
        String[] stringArray3 = this.getAllSearchColumns(this.getSearchColumnMapping(), iDataRow, this.getAdditionalCondition());
        for (String string : stringArray) {
            String[] stringArray4;
            ICellEditor iCellEditor = iRowDefinition.getColumnDefinition(string).getDataType().getCellEditor();
            if (!(iCellEditor instanceof ILinkedCellEditor)) continue;
            ILinkedCellEditor iLinkedCellEditor = (ILinkedCellEditor)iCellEditor;
            ReferenceDefinition referenceDefinition = iLinkedCellEditor.getLinkReference();
            String[] stringArray5 = ArrayUtil.removeAll(this.getAllSearchColumns(iLinkedCellEditor.getSearchColumnMapping(), iDataRow, iLinkedCellEditor.getAdditionalCondition()), stringArray3);
            if (referenceDefinition == null || stringArray5 == null || ArrayUtil.intersect(stringArray2, stringArray5).length <= 0) continue;
            for (String string2 : stringArray4 = ArrayUtil.removeAll(referenceDefinition.getColumnNames(), stringArray2)) {
                if (arrayUtil.contains(string2)) continue;
                arrayUtil.add(string2);
            }
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    protected String[] getAllSearchColumns(ColumnMapping columnMapping, IDataRow iDataRow, ICondition iCondition) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        if (columnMapping != null) {
            arrayUtil.addAll(columnMapping.getColumnNames());
        }
        this.fillInConditionColumns(iCondition, iDataRow, arrayUtil);
        int n = arrayUtil.size();
        if (n == 0) {
            return null;
        }
        return arrayUtil.toArray(new String[n]);
    }

    private void fillInConditionColumns(ICondition iCondition, IDataRow iDataRow, List<String> list) {
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            String string = compareCondition.getDataRowColumnName();
            if (iDataRow == compareCondition.getDataRow() && !list.contains(string)) {
                list.add(string);
            }
        } else if (iCondition instanceof OperatorCondition) {
            ICondition[] iConditionArray = ((OperatorCondition)iCondition).getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                this.fillInConditionColumns(iConditionArray[i], iDataRow, list);
            }
        }
    }

    protected String getWildCardString(Object object) {
        if (this.isSearchTextAnywhere()) {
            return "*" + object + "*";
        }
        return object + "*";
    }

    protected ICondition getSearchCondition(IDataRow iDataRow, ICondition iCondition) {
        if (iCondition == null) {
            iCondition = this.additionalCondition;
        } else if (this.additionalCondition != null) {
            iCondition = iCondition.and(this.additionalCondition);
        }
        if (this.searchColumnMapping != null) {
            String[] stringArray = this.searchColumnMapping.getColumnNames();
            String[] stringArray2 = this.searchColumnMapping.getReferencedColumnNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Equals equals = new Equals(iDataRow, stringArray[i], stringArray2[i]);
                iCondition = iCondition == null ? equals : iCondition.and(equals);
            }
        }
        return iCondition;
    }

    protected ICondition getItemSearchCondition(boolean bl, String string, Object object) {
        Object object2 = bl ? this.getWildCardString(object) : object;
        String[] stringArray = null;
        if (this.searchInAllTableColumns || this.displayConcatMask != null) {
            stringArray = this.columnView == null ? this.linkReference.getReferencedDataBook().getRowDefinition().getColumnView(ITableControl.class).getColumnNames() : this.columnView.getColumnNames();
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{string};
        }
        BaseCondition baseCondition = bl ? new LikeIgnoreCase(stringArray[0], object2) : new Like(stringArray[0], object);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.or(bl ? new LikeIgnoreCase(stringArray[i], object2) : new Like(stringArray[i], object));
        }
        return baseCondition;
    }
}

