/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.http.rest.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sibvisions.rad.persist.bean.BeanConverter;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.server.DirectServerSession;
import com.sibvisions.rad.server.http.HttpContext;
import com.sibvisions.rad.server.http.rest.JSONUtil;
import com.sibvisions.rad.server.http.rest.LifeCycleConnector;
import com.sibvisions.rad.server.http.rest.service.RestServiceException;
import com.sibvisions.rad.server.http.rest.service.mixin.BeanConverterMixin;
import com.sibvisions.rad.server.http.rest.service.mixin.DBAccessMixin;
import com.sibvisions.util.SimpleJavaSource;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.ExceptionUtil;
import com.sibvisions.util.type.StringUtil;
import java.util.Iterator;
import java.util.List;
import javax.rad.persist.DataSourceException;
import javax.rad.server.InvalidPasswordException;
import javax.rad.server.UnknownObjectException;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.IBean;
import javax.rad.type.bean.IBeanType;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.ext.servlet.ServletUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ServerResource;
import org.restlet.util.Series;

abstract class AbstractService
extends ServerResource {
    private static ILogger logger;
    protected static final String JCODE_START = "{j:";
    protected static final String JCODE_END = "}";

    AbstractService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation handle() {
        HttpContext httpContext = new HttpContext(ServletUtils.getRequest((Request)this.getRequest()), ServletUtils.getResponse((Response)this.getResponse()));
        try {
            Representation representation = super.handle();
            Object var4_3 = null;
            httpContext.release();
            return representation;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            httpContext.release();
            throw throwable;
        }
    }

    protected Representation handleException(Throwable throwable) {
        String string;
        this.debug(throwable);
        String string2 = string = throwable != null ? throwable.getMessage() : "";
        if (throwable instanceof DataSourceException) {
            RestServiceException restServiceException = ExceptionUtil.getThrowable(throwable, RestServiceException.class);
            if (restServiceException != null) {
                this.setStatus(new Status(restServiceException.getStatus()), string);
                return this.createExceptionResponse(restServiceException, throwable);
            }
        } else {
            if (throwable instanceof RestServiceException) {
                this.setStatus(new Status(((RestServiceException)throwable).getStatus()), string);
                return this.createExceptionResponse((RestServiceException)throwable, null);
            }
            if (throwable instanceof SecurityException) {
                if (this.getStatus().equals((Object)Status.SUCCESS_OK)) {
                    if (throwable instanceof InvalidPasswordException) {
                        this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                    } else {
                        this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                    }
                }
                return null;
            }
            if (throwable instanceof UnknownObjectException) {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND, string);
                return null;
            }
        }
        if (this.getStatus().equals((Object)Status.SUCCESS_OK)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, string);
        }
        return null;
    }

    protected Representation createExceptionResponse(RestServiceException restServiceException, Throwable throwable) {
        if (restServiceException != null && restServiceException.getDetails() != null) {
            Iterator iterator;
            List list = this.getRequest().getClientInfo().getAcceptedMediaTypes();
            Bean bean = new Bean();
            bean.put("statusCode", (Object)restServiceException.getStatus());
            bean.put("details", (Object)restServiceException.getDetails());
            if (throwable != null) {
                iterator = new Bean();
                iterator.put("class", throwable.getClass().getName());
                iterator.put("message", throwable.getMessage());
                iterator.put("stack", ExceptionUtil.dump(throwable, true));
                bean.put("cause", (Object)iterator);
            } else if (restServiceException.getCause() != null) {
                iterator = restServiceException.getCause();
                Bean bean2 = new Bean();
                bean2.put("class", (Object)iterator.getClass().getName());
                bean2.put("message", (Object)((Throwable)((Object)iterator)).getMessage());
                bean2.put("stack", (Object)ExceptionUtil.dump(iterator, true));
                bean.put("cause", (Object)bean2);
            }
            for (Bean bean2 : list) {
                Metadata metadata = bean2.getMetadata();
                if (MediaType.APPLICATION_JSON.equals((Object)metadata)) {
                    return this.toInternalRepresentation(bean);
                }
                if (!MediaType.TEXT_HTML.equals((Object)metadata)) continue;
                return this.toHtmlErrorRepresentation(bean);
            }
        }
        return null;
    }

    protected boolean isDryRun() {
        Series series = (Series)this.getRequest().getAttributes().get("org.restlet.http.headers");
        return Boolean.parseBoolean(series.getFirstValue("x-dryrun"));
    }

    protected Representation toInternalRepresentation(Object object) {
        JacksonRepresentation jacksonRepresentation = new JacksonRepresentation(object);
        ObjectMapper objectMapper = jacksonRepresentation.getObjectMapper();
        JSONUtil.configureObjectMapper(objectMapper);
        objectMapper.addMixInAnnotations(DBAccess.class, DBAccessMixin.class);
        objectMapper.addMixInAnnotations(BeanConverter.class, BeanConverterMixin.class);
        return jacksonRepresentation;
    }

    protected Representation toHtmlErrorRepresentation(IBean iBean) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>\n");
        stringBuilder.append("<head>\n");
        stringBuilder.append("   <title>Error page</title>\n");
        stringBuilder.append("</head>\n");
        stringBuilder.append("<body style=\"font-family: sans-serif;\">\n");
        stringBuilder.append("<p style=\"font-size: 1.2em;font-weight: bold;margin: 1em 0px;\">");
        stringBuilder.append("Status Code: ");
        stringBuilder.append(StringUtils.htmlEscape((String)iBean.get("statusCode").toString()));
        stringBuilder.append("</p>\n");
        this.dumpAsHtml(stringBuilder, iBean, "details");
        if (iBean.get("cause") != null) {
            stringBuilder.append("<span style='display: none; visibility: hidden;'>\n");
            this.dumpAsHtml(stringBuilder, iBean, "cause");
            stringBuilder.append("</span>\n");
        }
        stringBuilder.append("</body>\n");
        stringBuilder.append("</html>\n");
        return new StringRepresentation((CharSequence)stringBuilder.toString(), MediaType.TEXT_HTML);
    }

    private void dumpAsHtml(StringBuilder stringBuilder, IBean iBean, String string) {
        IBean iBean2;
        if (iBean != null && (iBean2 = (IBean)iBean.get(string)) != null) {
            stringBuilder.append("<p>\n");
            stringBuilder.append("<p style='font-weight: bold;margin: 1em 0px;'>");
            stringBuilder.append(StringUtil.formatInitCap(string));
            stringBuilder.append("</p>\n");
            IBeanType iBeanType = iBean2.getBeanType();
            if (iBeanType.getPropertyCount() > 0) {
                stringBuilder.append("<table border='0' cellpading='0' cellspacing='0'>\n");
                stringBuilder.append("<tr><th style='text-align: left; padding-left: 0; font-size: 0.95em;'>Property</th><th style='text-align: left; padding-left: 10px; font-size: 0.95em;'>Value</th></tr>\n");
                for (String string2 : iBeanType.getPropertyNames()) {
                    stringBuilder.append("<tr><td style='padding-top: 5px; padding-left: 0;'>");
                    stringBuilder.append(StringUtils.htmlEscape((String)string2));
                    stringBuilder.append("</td><td style='padding-left: 10px; padding-top: 5px;>");
                    stringBuilder.append(StringUtils.htmlEscape((String)(iBean2.get(string2) != null ? iBean2.get(string2).toString() : "")));
                    stringBuilder.append("</td></tr>\n");
                }
                stringBuilder.append("</table>\n");
            }
            stringBuilder.append("</p>\n");
        }
    }

    public void debug(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(((Object)((Object)this)).getClass());
        }
        logger.debug(objectArray);
    }

    public void info(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(((Object)((Object)this)).getClass());
        }
        logger.info(objectArray);
    }

    public void error(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(((Object)((Object)this)).getClass());
        }
        logger.error(objectArray);
    }

    protected Object[] convertParameter(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = (Object[])objectArray.clone();
        SimpleJavaSource simpleJavaSource = new SimpleJavaSource();
        simpleJavaSource.addImport("javax.rad.model.condition.*");
        simpleJavaSource.addImport("javax.rad.model.*");
        simpleJavaSource.addImport("javax.rad.model.dataType.*");
        simpleJavaSource.addImport("javax.rad.model.reference.*");
        simpleJavaSource.addImport("javax.rad.type.*");
        simpleJavaSource.addImport("javax.rad.type.bean.*");
        simpleJavaSource.addImport("javax.rad.util.Parameter");
        simpleJavaSource.addImport("java.math.*");
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            if (!(objectArray[i] instanceof String) || !(string = (String)objectArray[i]).startsWith(JCODE_START) || !string.endsWith(JCODE_END)) continue;
            try {
                objectArray2[i] = simpleJavaSource.execute(((String)objectArray[i]).substring(JCODE_START.length(), ((String)objectArray[i]).length() - JCODE_END.length()));
                continue;
            }
            catch (Exception exception) {
                this.debug(exception);
            }
        }
        return objectArray2;
    }

    protected DirectServerSession getSession() {
        return ((LifeCycleConnector)this.getRequest().getClientInfo().getUser()).getSession();
    }
}

