/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DefaultObjectProvider;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.IMasterSession;
import com.sibvisions.rad.server.ISessionValidator;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.rad.server.security.ISecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.rad.remote.ChangePasswordException;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.IConfiguration;
import javax.rad.server.ResultObject;
import javax.rad.server.SessionContext;
import javax.rad.server.push.PushMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MasterSession
extends AbstractSession
implements IMasterSession {
    private ArrayUtil<WeakReference<SubSession>> auSubSessions = null;
    private Object oSyncSubSessions = new Object();
    private ApplicationZone zone;
    private IAccessController accessController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MasterSession(DefaultSessionManager defaultSessionManager, ChangedHashtable<String, Object> changedHashtable) throws Exception {
        super(defaultSessionManager, changedHashtable);
        try {
            String string;
            Object object;
            List<XmlNode> list;
            Object object2;
            Record record = ProtocolFactory.openRecord("SESSION", "CONFIGURATION", new Object[0]);
            try {
                object2 = (String)changedHashtable.get("client.application");
                this.zone = (ApplicationZone)Configuration.getApplicationZone((String)object2).clone();
                if (!Boolean.valueOf(this.zone.getProperty("/application/liveconfig")).booleanValue()) {
                    this.zone.setUpdateEnabled(false);
                }
                this.initMaxInactiveInterval(changedHashtable, this.zone, "mastersession", 0);
                this.initMaxAliveInterval(changedHashtable, this.zone);
                list = this.zone.getNodes("/application/connection/property");
                if (list != null) {
                    for (XmlNode xmlNode : list) {
                        object = xmlNode.getNode("name");
                        if (object != null && ((XmlNode)object).getValue() != null) {
                            this.setPropertyIntern(((XmlNode)object).getValue(), xmlNode.getValue());
                            continue;
                        }
                        this.log.debug("Invalid connection property: " + xmlNode);
                    }
                }
                object = this.getLifeCycleName();
                string = this.zone.getProperty("/application/lifecycle/mastersession");
                if (StringUtil.isEmpty((String)object)) {
                    object = string;
                    this.setLifeCycleName((String)object);
                }
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
            record = ProtocolFactory.openRecord("SESSION", "AUTHENTICATE", new Object[0]);
            try {
                object2 = defaultSessionManager.getSecurityManager(this);
                if (record != null) {
                    record.setParameter(object2.getClass().getSimpleName());
                }
                list = (String)changedHashtable.get("client.oldpassword");
                object = (String)changedHashtable.get("client.newpassword");
                this.preAuthentication((ISecurityManager)object2);
                try {
                    object2.validateAuthentication(this);
                    this.setPropertyIntern("client.oldpassword", null);
                    this.postAuthentication((ISecurityManager)object2);
                }
                catch (Exception exception) {
                    if (exception instanceof ChangePasswordException && object != null) {
                        this.setNewPasswordIntern((String)((Object)list), (String)object);
                        object = null;
                        this.postAuthentication((ISecurityManager)object2);
                    }
                    throw exception;
                }
                if (object != null) {
                    this.setNewPasswordIntern((String)((Object)list), (String)object);
                }
                Object var13_18 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
            record = ProtocolFactory.openRecord("SESSION", "CHECK_ACCESS", new Object[0]);
            try {
                this.accessController = object2.getAccessController(this);
                if (this.accessController != null) {
                    if (record != null) {
                        record.setParameter(this.accessController.getClass().getSimpleName());
                    }
                    if (string != null) {
                        this.accessController.addAccess(string);
                    }
                    if ((list = this.getApplicationZone().getNodes("/application/lifecycle/allow")) != null) {
                        for (XmlNode xmlNode : list) {
                            this.accessController.addAccess(xmlNode.getValue());
                        }
                    }
                }
                this.checkAccess();
                Object var15_21 = null;
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
            {
            }
        }
        catch (Exception exception) {
            this.uninit();
            throw exception;
        }
    }

    @Override
    protected ApplicationZone getApplicationZone() {
        return this.zone;
    }

    @Override
    public IAccessController getAccessController() {
        return this.accessController;
    }

    @Override
    public final void setNewPassword(String string, String string2) throws Exception {
        this.setLastAccessTime(System.currentTimeMillis());
        this.setNewPasswordIntern(string, string2);
    }

    @Override
    public IConfiguration getConfig() {
        return this.zone.getConfig();
    }

    @Override
    protected void addCallBackResult(ResultObject resultObject) {
        DefaultSessionManager defaultSessionManager = this.getSessionManager();
        if (defaultSessionManager.hasPushReceiver(this)) {
            defaultSessionManager.push(new PushMessage(this, PushMessage.MessageType.Callback, resultObject));
        } else {
            super.addCallBackResult(resultObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubSession(SubSession subSession) {
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions == null) {
                this.auSubSessions = new ArrayUtil();
            }
            this.auSubSessions.add(new WeakReference<SubSession>(subSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubSession(SubSession subSession) {
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions != null) {
                this.auSubSessions.remove(subSession);
                if (this.auSubSessions.size() == 0) {
                    this.auSubSessions = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayUtil<SubSession> removeSubSessions() {
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions != null) {
                ArrayUtil<SubSession> arrayUtil = null;
                int n = 0;
                int n2 = this.auSubSessions.size();
                while (n < n2) {
                    WeakReference<SubSession> weakReference = this.auSubSessions.get(n);
                    SubSession subSession = (SubSession)weakReference.get();
                    if (subSession == null) {
                        this.auSubSessions.remove(n);
                        --n2;
                        continue;
                    }
                    if (arrayUtil == null) {
                        arrayUtil = new ArrayUtil<SubSession>();
                    }
                    arrayUtil.add(subSession);
                    ++n;
                }
                this.auSubSessions = null;
                return arrayUtil;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayUtil<SubSession> getSubSessions() {
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions != null) {
                ArrayUtil<SubSession> arrayUtil = null;
                int n = 0;
                int n2 = this.auSubSessions.size();
                while (n < n2) {
                    WeakReference<SubSession> weakReference = this.auSubSessions.get(n);
                    SubSession subSession = (SubSession)weakReference.get();
                    if (subSession == null) {
                        this.auSubSessions.remove(n);
                        --n2;
                        continue;
                    }
                    if (arrayUtil == null) {
                        arrayUtil = new ArrayUtil<SubSession>();
                    }
                    arrayUtil.add(subSession);
                    ++n;
                }
                return arrayUtil;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setNewPasswordIntern(String string, String string2) throws Exception {
        this.setLastAliveTime(System.currentTimeMillis());
        this.chtProperties.put("client.oldpassword", string, false);
        this.chtProperties.put("client.newpassword", string2, false);
        this.getSessionManager().getSecurityManager(this).changePassword(this);
        this.setPropertyIntern("client.oldpassword", null);
        this.setPropertyIntern("client.newpassword", null);
        this.setPassword(string2);
        Object object = this.oSyncSubSessions;
        synchronized (object) {
            if (this.auSubSessions != null) {
                int n = 0;
                int n2 = this.auSubSessions.size();
                while (n < n2) {
                    WeakReference<SubSession> weakReference = this.auSubSessions.get(n);
                    SubSession subSession = (SubSession)weakReference.get();
                    if (subSession == null) {
                        this.auSubSessions.remove(n);
                        --n2;
                        continue;
                    }
                    subSession.setPassword(string2);
                    ++n;
                }
                this.auSubSessions = null;
            }
        }
    }

    protected void preAuthentication(ISecurityManager iSecurityManager) {
        this.validateSessionCreation(iSecurityManager, "preAuthClass");
    }

    protected void postAuthentication(ISecurityManager iSecurityManager) {
        this.validateSessionCreation(iSecurityManager, "postAuthClass");
    }

    private void validateSessionCreation(ISecurityManager iSecurityManager, String string) {
        Class<?> clazz;
        String string2;
        try {
            string2 = this.zone.getProperty("/application/lifecycle/mastersession/" + string);
        }
        catch (Exception exception) {
            this.log.error(exception);
            return;
        }
        if (StringUtil.isEmpty(string2)) {
            return;
        }
        AbstractObjectProvider abstractObjectProvider = this.getObjectProvider();
        ClassLoader classLoader = abstractObjectProvider instanceof DefaultObjectProvider ? ((DefaultObjectProvider)abstractObjectProvider).getClassLoader(this) : null;
        try {
            clazz = classLoader == null ? Class.forName(string2) : Class.forName(string2, true, classLoader);
        }
        catch (Throwable throwable) {
            this.log.error(throwable);
            return;
        }
        SessionContext sessionContext = this.createSessionContext(null, null);
        try {
            try {
                ISessionValidator iSessionValidator = (ISessionValidator)clazz.newInstance();
                iSessionValidator.validate(this, iSecurityManager);
            }
            catch (Exception exception) {
                this.log.info(exception);
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new SecurityException("Validation failed!", exception);
            }
            Object var10_12 = null;
            if (sessionContext != null) {
                sessionContext.release();
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (sessionContext != null) {
                sessionContext.release();
            }
            throw throwable;
        }
    }
}

