/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DirectServerConnection;
import com.sibvisions.rad.server.DirectServerSession;
import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.WrappedAccessChecker;
import com.sibvisions.rad.server.WrappedSession;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.util.ChangedHashtable;
import java.util.Map;
import javax.rad.remote.IConnection;
import javax.rad.server.ICloseableSession;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;
import javax.rad.server.InjectObject;
import javax.rad.server.SessionContext;
import javax.rad.server.security.IAccessChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionContext
extends SessionContext {
    private WrappedSession wsessMaster;
    private WrappedSession wsessCurrent;
    private WrappedAccessChecker wachecker;
    private String sObjectName = null;
    private String sMethodName = null;

    protected AbstractSessionContext(ISession iSession) {
        if (iSession instanceof AbstractSession) {
            this.wsessCurrent = new WrappedSession((AbstractSession)iSession);
        } else if (iSession instanceof WrappedSession) {
            this.wsessCurrent = (WrappedSession)iSession;
        } else if (iSession instanceof DirectServerSession) {
            this.wsessCurrent = new WrappedSession((AbstractSession)((DirectServerSession)iSession).getSession());
        } else {
            throw new IllegalArgumentException("Given session doesn't offer an 'AbstractSession'!");
        }
        this.setCurrentInstance(this);
    }

    @Override
    public void destroy() {
        this.setCurrentInstance(null);
        this.wsessMaster = null;
        this.wsessCurrent = null;
    }

    @Override
    public ISession getSession() {
        return this.wsessCurrent;
    }

    @Override
    public ISession getMasterSession() {
        if (this.wsessMaster != null) {
            return this.wsessMaster;
        }
        if (this.wsessCurrent == null) {
            return null;
        }
        AbstractSession abstractSession = this.wsessCurrent.session;
        if (abstractSession instanceof MasterSession) {
            this.wsessMaster = this.wsessCurrent;
            return this.wsessMaster;
        }
        if (abstractSession instanceof SubSession) {
            this.wsessMaster = new WrappedSession(((SubSession)abstractSession).getMasterSession());
            return this.wsessMaster;
        }
        return null;
    }

    @Override
    public IConfiguration getSessionConfig() {
        if (this.wsessCurrent == null) {
            return null;
        }
        return this.wsessCurrent.getConfig();
    }

    @Override
    public IConfiguration getServerConfig() {
        if (this.wsessCurrent == null) {
            return null;
        }
        ServerZone serverZone = this.wsessCurrent.session.getApplicationZone().getServerZone();
        if (serverZone != null) {
            return serverZone.getConfig();
        }
        return null;
    }

    @Override
    public IConnection getServerConnection() {
        if (this.wsessCurrent == null) {
            return null;
        }
        return new DirectServerConnection((IDirectServer)this.wsessCurrent.session.getSessionManager().getServer());
    }

    @Override
    public String getObjectName() {
        return this.sObjectName;
    }

    @Override
    public String getMethodName() {
        return this.sMethodName;
    }

    @Override
    public InjectObject putObject(InjectObject injectObject) {
        return this.wsessCurrent.session.putObject(injectObject);
    }

    @Override
    public InjectObject removeObject(InjectObject injectObject) {
        return this.wsessCurrent.session.removeObject(injectObject);
    }

    @Override
    public InjectObject getObject(String string) {
        return this.wsessCurrent.session.getObject(string);
    }

    @Override
    public ICloseableSession createSubSession(String string, Map<String, Object> map) throws Throwable {
        ChangedHashtable<String, Object> changedHashtable = DirectServerSession.createProperties(map);
        changedHashtable.put("client.lifecyclename", string);
        Object object = Server.getInstance().createSubSession(this.getMasterSession().getId(), changedHashtable);
        return new WrappedSession(Server.getInstance().getSessionManager().get(object), true);
    }

    @Override
    public IAccessChecker getAccessChecker() {
        if (this.wachecker == null) {
            this.wachecker = new WrappedAccessChecker(this.wsessCurrent.session.getAccessController());
        }
        return this.wachecker;
    }

    protected void setObjectName(String string) {
        this.sObjectName = string;
    }

    protected void setMethodName(String string) {
        this.sMethodName = string;
    }
}

