/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DirectServerSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.WrappedSession;
import com.sibvisions.rad.server.http.HttpContext;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.io.File;
import javax.rad.server.ICallHandler;
import javax.rad.server.IServer;
import javax.rad.server.ISession;
import javax.rad.server.ServerContext;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractServerContext
extends ServerContext {
    private Server server;
    private WrappedSession wsessCurrent;
    private String sIdentifier;

    AbstractServerContext(Server server) {
        this.server = server;
        this.sIdentifier = this.createSystemIdentifier();
        this.setInstance(this);
    }

    AbstractServerContext(Server server, String string) {
        this.server = server;
        this.sIdentifier = string;
        this.setInstance(this);
    }

    protected void destroy() {
        this.setInstance(null);
    }

    public ISession getSession() {
        return this.wsessCurrent;
    }

    public String getSystemIdentifier() {
        return this.sIdentifier;
    }

    public String getServerIdentifier() {
        return this.server.getInstanceKey();
    }

    public ICallHandler getCallHandler() {
        if (this.wsessCurrent != null) {
            AbstractSession abstractSession = this.wsessCurrent.session;
            if (abstractSession instanceof SubSession) {
                return ((SubSession)abstractSession).getMasterSession().getCallHandler();
            }
            return this.wsessCurrent.session.getCallHandler();
        }
        return null;
    }

    protected void setSession(ISession iSession) {
        if (iSession == null) {
            this.wsessCurrent = null;
        } else {
            Object object;
            if (iSession instanceof AbstractSession) {
                this.wsessCurrent = new WrappedSession((AbstractSession)iSession);
            } else if (iSession instanceof WrappedSession) {
                this.wsessCurrent = (WrappedSession)iSession;
            } else if (iSession instanceof DirectServerSession) {
                this.wsessCurrent = new WrappedSession((AbstractSession)((DirectServerSession)iSession).getSession());
            } else {
                throw new IllegalArgumentException("Given session doesn't offer an 'AbstractSession'!");
            }
            if (StringUtil.isEmpty(this.sIdentifier) && (object = this.wsessCurrent.getProperties().get("server.request.systemIdentifier")) != null) {
                this.sIdentifier = object.toString();
            }
        }
    }

    public IServer getServer() {
        return this.server;
    }

    private String createSystemIdentifier() {
        String string = System.getProperty("Server.systemIdentifier");
        if (!StringUtil.isEmpty(string)) {
            LoggerFactory.getInstance(ServerContext.class).debug("Using temporary server identifier: ", string);
            return string;
        }
        String string2 = "";
        HttpContext httpContext = HttpContext.getCurrentInstance();
        if (httpContext != null) {
            Object object = httpContext.getRequest();
            if (object instanceof HttpServletRequest) {
                string2 = ((HttpServletRequest)object).getRequestURL().toString();
            }
        } else {
            File file = new File("");
            string2 = file.getAbsolutePath();
        }
        LoggerFactory.getInstance(ServerContext.class).debug("Using server identifier: ", string2);
        return string2;
    }
}

