/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.BeanUtil;
import java.util.HashMap;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.persist.MetaData;

public class ServerMetaData {
    private MetaData metaData;
    private ArrayUtil<ServerColumnMetaData> auServerColumnMetaData = new ArrayUtil();
    private Map<String, Integer> hmServerColumnMetaDataMap = null;
    private PrimaryKeyType pktype = PrimaryKeyType.PrimaryKeyColumns;
    private transient String[] saWritableColumnNames;
    private transient int[] iaWritableColumnIndices;
    private transient int[] iaPrimaryKeyColumnIndices;
    private transient int[] iaAutoIncrementColumnIndices;

    public ServerMetaData() {
        this.setMetaData(null);
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData == null ? new MetaData() : metaData;
        this.auServerColumnMetaData.clear();
        this.iaWritableColumnIndices = null;
        this.iaPrimaryKeyColumnIndices = null;
        this.iaAutoIncrementColumnIndices = null;
        this.saWritableColumnNames = null;
        this.hmServerColumnMetaDataMap = null;
    }

    public void addServerColumnMetaData(ServerColumnMetaData serverColumnMetaData) {
        int n = this.metaData.getColumnMetaDataIndex(serverColumnMetaData.getName());
        if (n < 0) {
            if (this.auServerColumnMetaData.size() < this.metaData.getColumnMetaDataCount()) {
                this.auServerColumnMetaData.setSize(this.metaData.getColumnMetaDataCount());
            }
            this.metaData.addColumnMetaData(serverColumnMetaData.getColumnMetaData());
            this.auServerColumnMetaData.add(serverColumnMetaData);
        } else {
            if (n >= this.auServerColumnMetaData.size()) {
                this.auServerColumnMetaData.setSize(n + 1);
            }
            serverColumnMetaData.setColumnMetaData(this.metaData.getColumnMetaData(n));
            this.auServerColumnMetaData.set(n, serverColumnMetaData);
        }
        this.iaWritableColumnIndices = null;
        this.iaPrimaryKeyColumnIndices = null;
        this.iaAutoIncrementColumnIndices = null;
        this.saWritableColumnNames = null;
        this.hmServerColumnMetaDataMap = null;
    }

    public void setServerColumnMetaData(ServerColumnMetaData[] serverColumnMetaDataArray) {
        for (ServerColumnMetaData serverColumnMetaData : serverColumnMetaDataArray) {
            this.addServerColumnMetaData(serverColumnMetaData);
        }
    }

    public ServerColumnMetaData[] getServerColumnMetaData() {
        if (this.auServerColumnMetaData.size() < this.metaData.getColumnMetaDataCount()) {
            this.auServerColumnMetaData.setSize(this.metaData.getColumnMetaDataCount());
        }
        return this.auServerColumnMetaData.toArray(new ServerColumnMetaData[this.auServerColumnMetaData.size()]);
    }

    public ServerColumnMetaData getServerColumnMetaData(String string) throws ModelException {
        int n = this.getServerColumnMetaDataIndex(string);
        if (n >= 0) {
            return this.auServerColumnMetaData.get(n);
        }
        throw new ModelException("Column '" + string + "' doesn't exist in MetaData!");
    }

    public ServerColumnMetaData getServerColumnMetaData(int n) {
        if (this.auServerColumnMetaData.size() < this.metaData.getColumnMetaDataCount()) {
            this.auServerColumnMetaData.setSize(this.metaData.getColumnMetaDataCount());
        }
        return this.auServerColumnMetaData.get(n);
    }

    public int getServerColumnMetaDataIndex(String string) {
        Integer n;
        if (this.hmServerColumnMetaDataMap == null) {
            this.hmServerColumnMetaDataMap = new HashMap<String, Integer>();
            int n2 = this.auServerColumnMetaData.size();
            for (int i = 0; i < n2; ++i) {
                ServerColumnMetaData serverColumnMetaData = this.auServerColumnMetaData.get(i);
                if (serverColumnMetaData == null) continue;
                this.hmServerColumnMetaDataMap.put(serverColumnMetaData.getName(), i);
            }
        }
        if ((n = this.hmServerColumnMetaDataMap.get(string)) == null) {
            return -1;
        }
        return n;
    }

    public static int getServerColumnMetaDataIndex(ServerColumnMetaData[] serverColumnMetaDataArray, String string) {
        for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
            String string2;
            ServerColumnMetaData serverColumnMetaData = serverColumnMetaDataArray[i];
            if (serverColumnMetaData == null || (string2 = serverColumnMetaData.getName()) != string && !string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int[] getWritableColumnIndices() {
        if (this.iaWritableColumnIndices == null) {
            int[] nArray = new int[this.auServerColumnMetaData.size()];
            int[] nArray2 = new int[this.auServerColumnMetaData.size()];
            int n = 0;
            int n2 = 0;
            int n3 = this.auServerColumnMetaData.size();
            for (int i = 0; i < n3; ++i) {
                ServerColumnMetaData serverColumnMetaData = this.auServerColumnMetaData.get(i);
                if (serverColumnMetaData == null || !serverColumnMetaData.isWritable()) continue;
                if (serverColumnMetaData.getPrecision() > 4000) {
                    nArray2[n2] = i;
                    ++n2;
                    continue;
                }
                nArray[n] = i;
                ++n;
            }
            this.iaWritableColumnIndices = new int[n2 + n];
            System.arraycopy(nArray, 0, this.iaWritableColumnIndices, 0, n);
            System.arraycopy(nArray2, 0, this.iaWritableColumnIndices, n, n2);
        }
        return this.iaWritableColumnIndices;
    }

    public String[] getWritableColumnNames() {
        if (this.saWritableColumnNames == null) {
            int[] nArray = this.getWritableColumnIndices();
            this.saWritableColumnNames = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.saWritableColumnNames[i] = this.auServerColumnMetaData.get(nArray[i]).getName();
            }
        }
        return this.saWritableColumnNames;
    }

    public int[] getPrimaryKeyColumnIndices() {
        String[] stringArray = this.metaData.getPrimaryKeyColumnNames();
        if (stringArray != null && this.iaPrimaryKeyColumnIndices == null) {
            this.iaPrimaryKeyColumnIndices = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.iaPrimaryKeyColumnIndices[i] = this.getServerColumnMetaDataIndex(stringArray[i]);
            }
        }
        return this.iaPrimaryKeyColumnIndices;
    }

    public String[] getPrimaryKeyColumnNames() {
        return this.metaData.getPrimaryKeyColumnNames();
    }

    public void setPrimaryKeyColumnNames(String[] stringArray) {
        this.metaData.setPrimaryKeyColumnNames(stringArray);
        this.iaPrimaryKeyColumnIndices = null;
    }

    public void setPrimaryKeyColumnNames(Name[] nameArray) {
        this.metaData.setPrimaryKeyColumnNames(BeanUtil.toArray(nameArray, new String[nameArray.length], "name"));
        this.iaPrimaryKeyColumnIndices = null;
    }

    public String[] getRepresentationColumnNames() {
        return this.metaData.getRepresentationColumnNames();
    }

    public void setRepresentationColumnNames(String[] stringArray) {
        this.metaData.setRepresentationColumnNames(stringArray);
    }

    public void setRepresentationColumnNames(Name[] nameArray) {
        this.metaData.setRepresentationColumnNames(BeanUtil.toArray(nameArray, new String[nameArray.length], "name"));
    }

    public String[] getAutoIncrementColumnNames() {
        return this.metaData.getAutoIncrementColumnNames();
    }

    public int[] getAutoIncrementColumnIndices() {
        String[] stringArray = this.metaData.getAutoIncrementColumnNames();
        if (stringArray != null && this.iaAutoIncrementColumnIndices == null) {
            this.iaAutoIncrementColumnIndices = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.iaAutoIncrementColumnIndices[i] = this.getServerColumnMetaDataIndex(stringArray[i]);
            }
        }
        return this.iaAutoIncrementColumnIndices;
    }

    public void setAutoIncrementColumnNames(String[] stringArray) {
        this.metaData.setAutoIncrementColumnNames(stringArray);
        this.iaAutoIncrementColumnIndices = null;
    }

    public void setAutoIncrementColumnNames(Name[] nameArray) {
        this.metaData.setAutoIncrementColumnNames(BeanUtil.toArray(nameArray, new String[nameArray.length], "name"));
        this.iaAutoIncrementColumnIndices = null;
    }

    public String[] getColumnNames() {
        return this.metaData.getColumnNames();
    }

    public PrimaryKeyType getPrimaryKeyType() {
        return this.pktype;
    }

    public void setPrimaryKeyType(PrimaryKeyType primaryKeyType) {
        this.pktype = primaryKeyType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrimaryKeyType {
        PrimaryKeyColumns,
        UniqueKeyColumns,
        AllColumns;

    }
}

