/*
 * Copyright 2018 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 21.03.2018 - [JR] - creation
 */
package javax.rad.genui.component;

import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.menu.UIPopupMenu;
import javax.rad.ui.IImage;
import javax.rad.ui.component.IPopupMenuButton;
import javax.rad.ui.event.UIMouseEvent;
import javax.rad.ui.menu.IMenuItem;
import javax.rad.ui.menu.IPopupMenu;

/**
 * Platform and technology independent popup menu button.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Ren Jahn
 */
public class UIPopupMenuButton extends AbstractUILabeledIcon<IPopupMenuButton> 
                               implements IPopupMenuButton
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    /** the default menu item. */
    private IMenuItem miDefault;
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UIPopupMenuButton</code>.
     *
     * @see IPopupMenuButton
     */
	public UIPopupMenuButton()
	{
		super(UIFactoryManager.getFactory().createPopupMenuButton());
	}

    /**
     * Creates a new instance of <code>UIPopupMenuButton</code> with the given
     * button.
     *
     * @param pButton the button
     * @see IPopupMenuButton
     */
	protected UIPopupMenuButton(IPopupMenuButton pButton)
	{
		super(pButton);
	}	
	
    /**
     * Creates a new instance of <code>UIPopupMenuButton</code>.
     *
     * @param pText the label of the button.
     * @see IPopupMenuButton
     */
	public UIPopupMenuButton(String pText)
	{
		this();
		
		setText(pText);
	}

	/**
	 * Creates a new instance of <code>UIPopupMenuButton</code>.
	 *
	 * @param pText the {@link String text}.
	 * @param pImage the {@link IImage image}.
	 * @see #setImage(IImage)
	 * @see #setText(String)
	 */
	public UIPopupMenuButton(String pText, IImage pImage)
	{
		this();
		
		setText(pText);
		setImage(pImage);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface implementation
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
    public void setDefaultMenuItem(IMenuItem pItem)
    {
        miDefault = pItem;
        
        uiResource.setDefaultMenuItem(pItem);
    }

    /**
     * {@inheritDoc}
     */
    public IMenuItem getDefaultMenuItem()
    {
        return miDefault;
    }	
    
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Overwritten methods
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * {@inheritDoc}
     */
    @Override
    public void setPopupMenu(IPopupMenu pMenu)
    {
        if (popupMenu instanceof UIPopupMenu)
        {
            ((UIPopupMenu)popupMenu).setTranslation(null);
        }
        
        popupMenu = pMenu;
        
        if (popupMenu instanceof UIPopupMenu)
        {
            uiResource.setPopupMenu(((UIPopupMenu)popupMenu).getUIResource());
            
            ((UIPopupMenu)popupMenu).checkTranslation(this);
        }
        else
        {
            uiResource.setPopupMenu(popupMenu);
        }
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public void doTriggerPopMenu(UIMouseEvent pMouseEvent)
    {
        //won't work
    }
	
    /**
     * {@inheritDoc}
     */
    @Override
    public void addNotify()
    {
        super.addNotify();

        if (popupMenu instanceof UIPopupMenu)
        {
            ((UIPopupMenu)popupMenu).checkTranslation(this);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void removeNotify()
    {
        super.removeNotify();

        if (popupMenu instanceof UIPopupMenu)
        {
            ((UIPopupMenu)popupMenu).setTranslation(null);
        }
    }
    
}	// UIPopupMenuButton
