/*
 * Copyright 2015 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 11.11.2015 - [RZ] - creation
 */
package com.sibvisions.rad.ui.celleditor;

import javax.rad.model.ModelException;
import javax.rad.ui.celleditor.IStyledCellEditor;
import javax.rad.ui.control.IPlaceholder;

/**
 * The {@link AbstractStyledCellEditor} is an abstract implementation of
 * {@link IStyledCellEditor} which provides a base implementation.
 * 
 * @author Robert Zenz
 */
public abstract class AbstractStyledCellEditor implements IStyledCellEditor
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/** The horizontal alignment. */
	protected int horizontalAlignment = ALIGN_LEFT;
	
	/** The vertical alignment. */
	protected int verticalAlignment = ALIGN_CENTER;
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * Creates a new instance of {@link AbstractStyledCellEditor}.
	 */
	protected AbstractStyledCellEditor()
	{
		// Nothing to be done.
	}
	
	/**
	 * Creates a new instance of {@link AbstractStyledCellEditor}.
	 *
	 * @param pHorizontalAlignment the horizontal alignment.
	 * @param pVerticalAlignment the vertical alignment.
	 */
	public AbstractStyledCellEditor(int pHorizontalAlignment, int pVerticalAlignment)
	{
		setHorizontalAlignment(pHorizontalAlignment);
		setVerticalAlignment(pVerticalAlignment);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	public int getHorizontalAlignment()
	{
		return horizontalAlignment;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public int getVerticalAlignment()
	{
		return verticalAlignment;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public boolean isDirectCellEditor()
	{
		return true;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setHorizontalAlignment(int pHorizontalAlignment)
	{
		horizontalAlignment = pHorizontalAlignment;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setVerticalAlignment(int pVerticalAlignment)
	{
		verticalAlignment = pVerticalAlignment;
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// User-defined methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * Gets the placeholder text, that should be displayed, or null, if no placeholder text should be displayed.
	 * 
	 * @param pPlaceholder the editor
	 * @param pColumnLabel the column label
	 * @return the placeholder text, that should be displayed
	 * @throws ModelException pException
	 */
	public String getPlaceholderText(IPlaceholder pPlaceholder, String pColumnLabel) throws ModelException
	{
		if (pPlaceholder.isPlaceholderVisible())
		{
			String placeholder = pPlaceholder.getPlaceholder();
			
			if (placeholder == null)
			{
				placeholder = pColumnLabel;
			}
			
			return placeholder;
		}
		
		return null;
	}
	
}	// AbstractStyledCellEditor
