/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 05.10.2009 - [RH] - creation.
 * 27.03.2010 - [JR] - #92: default value support         
 * 28.04.2011 - [RH] - #341 -  LikeReverse Condition, LikeReverseIgnoreCase Condition               
 */
package com.sibvisions.rad.persist.jdbc;

import java.util.Map;

import javax.rad.persist.DataSourceException;

/**
 * The <code>DerbyDBAccess</code> is the implementation for Derby databases. Client driver version.<br>
 *  
 * @see com.sibvisions.rad.persist.jdbc.DBAccess
 * 
 * @author Roland Hrmann
 */
public class DerbyDBAccess extends DBAccess
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Constructs a new DerbyDBAccess Object.
	 */
	public DerbyDBAccess()
	{
		super();		

		setDriver("org.apache.derby.jdbc.ClientDriver");
		// [RH] [HM] integrate embedded. 
//		setDriverName("org.apache.derby.jdbc.EmbeddedDriver");	
	}
		
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Overwritten methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean supportsGetGeneratedKeys()
	{
		return true;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Map<String, Object> getDefaultValuesIntern(String pCatalog, String pSchema, String pTable) throws DataSourceException
	{
		return super.getDefaultValuesIntern(pCatalog, pSchema, pTable.toUpperCase());
	}
	
	/** 
	 * {@inheritDoc}
	 */
	@Override
	protected String createReplace(String pSource, String pOld, String pNew) 
	{
		// Derby doesn't support any replace command. -> LikeReverseXXX doesn't support *->% replacement in DB!!!
		return pSource;
	}
	
	/** 
	 * {@inheritDoc}
	 */
	@Override
	protected TableInfo getTableInfoIntern(String pWriteBackTable) throws DataSourceException
	{	
		TableInfo tableInfo = super.getTableInfoIntern(pWriteBackTable);
		
		String table = tableInfo.getTable();
		if (table != null && !table.startsWith(QUOTE) && !table.endsWith(QUOTE))
		{
			table = table.toUpperCase();
		}
		
		return new TableInfo(tableInfo.getCatalog(), tableInfo.getSchema(), table);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// User-defined methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
} 	// DerbyDBAccess
