/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtil {
    private static HashMap<Character, String> characterReplacements = new HashMap();
    private static HashMap<String, int[]> namesToColors = new HashMap();
    private static HashMap<String, Character> reverseCharacterReplacements = new HashMap();

    private StringUtil() {
    }

    public static String concat(String string, List<? extends Object> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(16 * list.size());
        for (Object object : list) {
            stringBuilder.append(object);
            stringBuilder.append(string);
        }
        stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
        return stringBuilder.toString();
    }

    public static String concat(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "";
        }
        return StringUtil.concat(string, Arrays.asList(objectArray));
    }

    public static String concat(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        return StringUtil.concat(string, Arrays.asList(stringArray));
    }

    public static boolean containsWhitespace(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    public static String convertMemberNameToText(String string) {
        return StringUtil.convertMemberNameToText(string, false);
    }

    public static String convertMemberNameToText(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return StringUtil.convertNameToText(string, bl, false);
    }

    public static String convertMethodNameToText(String string) {
        return StringUtil.convertMethodNameToText(string, false);
    }

    public static String convertMethodNameToText(String string, boolean bl) {
        return StringUtil.convertNameToText(StringUtil.removeMethodPrefix(string), bl, true);
    }

    public static String convertMethodNameToFieldName(String string) {
        return StringUtil.firstCharLower(StringUtil.removeMethodPrefix(string));
    }

    private static String removeMethodPrefix(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string;
        int n = -1;
        for (int i = 0; i < string2.length() && n == -1; ++i) {
            char c = string2.charAt(i);
            if (!Character.isUpperCase(c) && c != '_') continue;
            n = i;
        }
        if (n >= 0) {
            string2 = string2.substring(n);
        }
        return string2;
    }

    public static String convertToMemberName(String string) {
        return StringUtil.convertToMethodName(null, string);
    }

    public static String convertToMethodName(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        int n = 0;
        if (string != null && string.length() > 0) {
            n = string.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n + string2.length() + 16);
        boolean bl = false;
        if (string != null) {
            stringBuilder.append(string);
            bl = true;
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            String string3 = characterReplacements.get(Character.valueOf(c));
            if (string3 != null) {
                c = string3.charAt(0);
            }
            if (Character.isLetter(c)) {
                c = Character.toLowerCase(c);
                if (i > 0) {
                    char c2 = string2.charAt(i - 1);
                    if (Character.isWhitespace(c2) || c2 == '_') {
                        c = Character.toUpperCase(c);
                    }
                } else if (bl) {
                    c = Character.toUpperCase(c);
                }
                stringBuilder.append(c);
                if (string3 != null && string3.length() > 1) {
                    stringBuilder.append(string3.substring(1));
                }
                bl = true;
                continue;
            }
            if (!bl || !Character.isLetter(c) && !Character.isDigit(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String convertToName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = characterReplacements.get(Character.valueOf(c));
            if (string2 != null) {
                stringBuilder.append(string2);
                continue;
            }
            if (Character.isLetter(c)) {
                stringBuilder.append(c);
                bl = true;
                continue;
            }
            if (!bl || !Character.isLetter(c) && !Character.isDigit(c) && c != '_') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int countCharacter(String string, char c) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 0;
        for (char c2 : string.toCharArray()) {
            if (c2 != c) continue;
            ++n;
        }
        return n;
    }

    public static String firstCharLower(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String firstCharUpper(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String formatInitCap(String string) {
        return StringUtil.formatInitCap(string, false);
    }

    public static String formatInitCap(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.trim();
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 16);
        boolean bl2 = true;
        for (char c : string2.toCharArray()) {
            if (Character.isWhitespace(c) || c == '_') {
                bl2 = true;
                if (bl) continue;
                stringBuilder.append(" ");
                continue;
            }
            if (bl2) {
                stringBuilder.append(Character.toUpperCase(c));
                bl2 = false;
                continue;
            }
            stringBuilder.append(Character.toLowerCase(c));
        }
        Object object = stringBuilder.toString().trim();
        if (((String)object).length() == 0) {
            return stringBuilder.toString();
        }
        return object;
    }

    public static String formatMemberName(String string) {
        return StringUtil.formatMethodName(null, string);
    }

    public static String formatMethodName(String string, String string2) {
        if (string2 != null && string2.trim().length() > 0) {
            if (string == null) {
                return Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
            }
            return string + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
        }
        return null;
    }

    public static CaseSensitiveType getCaseSensitiveType(String string) {
        if (string == null || string.trim().length() == 0) {
            return CaseSensitiveType.NoLetter;
        }
        CaseSensitiveType caseSensitiveType = CaseSensitiveType.NoLetter;
        for (char c : string.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            if (Character.isUpperCase(c)) {
                if (caseSensitiveType == CaseSensitiveType.LowerCase) {
                    return CaseSensitiveType.MixedCase;
                }
                caseSensitiveType = CaseSensitiveType.UpperCase;
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            if (caseSensitiveType == CaseSensitiveType.UpperCase) {
                return CaseSensitiveType.MixedCase;
            }
            caseSensitiveType = CaseSensitiveType.LowerCase;
        }
        return caseSensitiveType;
    }

    public static CharacterType getCharacterType(String string) {
        if (string == null || string.length() == 0) {
            return CharacterType.None;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) {
                bl = true;
            } else if (Character.isDigit(c)) {
                bl2 = true;
            } else if (Character.isWhitespace(c)) {
                bl3 = true;
                bl6 = true;
                if (Character.isSpaceChar(c)) {
                    bl4 = true;
                } else {
                    bl5 = true;
                }
            } else {
                bl6 = true;
                bl7 = true;
            }
            if (!bl || !bl2 || !bl3 || !bl7) continue;
            return CharacterType.All;
        }
        if (bl && bl2 && bl3 && !bl7) {
            if (bl4 && !bl5) {
                return CharacterType.LettersDigitsSpace;
            }
            return CharacterType.LettersDigitsWhitespace;
        }
        if (bl && bl2 && !bl3 && !bl7) {
            return CharacterType.LettersDigits;
        }
        if (bl && !bl2 && !bl3 && !bl7) {
            return CharacterType.Letters;
        }
        if (bl && !bl2 && (bl3 || bl7)) {
            return CharacterType.LettersSpecial;
        }
        if (bl2 && !bl && !bl3 && !bl7) {
            return CharacterType.Digits;
        }
        if (bl2 && !bl && (bl3 || bl7)) {
            return CharacterType.DigitsSpecial;
        }
        if (bl3 && !bl7) {
            return CharacterType.OnlyWhitespace;
        }
        if (bl6) {
            return CharacterType.OnlySpecial;
        }
        return CharacterType.None;
    }

    public static String getFirstWord(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                return stringBuilder.toString();
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int[] getQuotedBoundaries(String string) {
        if (string == null || string.length() == 0) {
            return new int[0];
        }
        int[] nArray = new int[]{};
        int n = -1;
        boolean bl = false;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != '\"' || i != 0 && string.charAt(i - 1) == '\\') continue;
            boolean bl2 = bl = !bl;
            if (bl) {
                n = i;
                continue;
            }
            nArray = ArrayUtil.add(nArray, n);
            nArray = ArrayUtil.add(nArray, i);
        }
        return nArray;
    }

    public static String getShortenedWords(String string, int n) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        if (n <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (char c : string.toCharArray()) {
            if (Character.isUpperCase(c)) {
                stringBuilder.append(c);
                n2 = 1;
                continue;
            }
            if (!Character.isLetter(c)) {
                stringBuilder.append(c);
                n2 = 0;
                continue;
            }
            if (n2 >= n) continue;
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String getText(String string, char ... cArray) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (cArray == null || cArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (!ArrayUtil.contains(cArray, c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getText(String string, TextType textType) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (!bl) {
                bl = textType.isStartCharacter(c);
            }
            if (!bl || !textType.acceptCharacter(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static int levenshteinDistance(String string, String string2) {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("The first string can not be null!");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The second string can not be null!");
        }
        int[][] nArray = new int[string.length() + 1][string2.length() + 1];
        for (n = 0; n <= string.length(); ++n) {
            nArray[n][0] = n;
        }
        for (n = 0; n <= string2.length(); ++n) {
            nArray[0][n] = n;
        }
        for (n = 1; n <= string.length(); ++n) {
            for (int i = 1; i <= string2.length(); ++i) {
                int n2 = 0;
                if (string.charAt(n - 1) != string2.charAt(i - 1)) {
                    n2 = 1;
                }
                int n3 = nArray[n - 1][i] + 1;
                int n4 = nArray[n][i - 1] + 1;
                int n5 = nArray[n - 1][i - 1] + n2;
                nArray[n][i] = Math.min(Math.min(n3, n4), n5);
                if (n <= 1 || i <= 1 || string.charAt(n - 1) != string2.charAt(i - 2) || string.charAt(n - 2) != string2.charAt(i - 1)) continue;
                int n6 = nArray[n - 2][i - 2] + n2;
                nArray[n][i] = Math.min(nArray[n][i], n6);
            }
        }
        return nArray[string.length()][string2.length()];
    }

    public static boolean like(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return StringUtil.like(string, 0, string.length(), string2, 0, string2.length());
    }

    public static String lpad(String string, int n) {
        return StringUtil.lpad(string, n, ' ');
    }

    public static String lpad(String string, int n, char c) {
        if (string == null || string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String ltrim(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(i);
        }
        return "";
    }

    @Deprecated
    public static String padLeft(Object object, int n) {
        return StringUtil.lpad(StringUtil.toString(object), n);
    }

    @Deprecated
    public static String padRight(Object object, int n) {
        return StringUtil.rpad(StringUtil.toString(object), n);
    }

    public static int[] parseColor(String string) {
        if (string == null) {
            return null;
        }
        if (namesToColors.containsKey(string.toLowerCase())) {
            return namesToColors.get(string.toLowerCase());
        }
        if (string.startsWith("#")) {
            if (string.length() == 7) {
                return new int[]{Integer.valueOf(string.substring(1, 3), 16), Integer.valueOf(string.substring(3, 5), 16), Integer.valueOf(string.substring(5, 7), 16)};
            }
            if (string.length() == 4) {
                String string2 = string.substring(1, 2);
                string2 = string2 + string2;
                String string3 = string.substring(2, 3);
                string3 = string3 + string3;
                String string4 = string.substring(3, 4);
                string4 = string4 + string4;
                return new int[]{Integer.valueOf(string2, 16), Integer.valueOf(string3, 16), Integer.valueOf(string4, 16)};
            }
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            if (string.length() == 8) {
                return new int[]{Integer.valueOf(string.substring(2, 4), 16), Integer.valueOf(string.substring(4, 6), 16), Integer.valueOf(string.substring(6, 8), 16)};
            }
            return null;
        }
        int[] nArray = StringUtil.parseInteger(string, ",");
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 3) {
            return new int[]{nArray[0], nArray[1], nArray[2]};
        }
        if (nArray.length == 4) {
            return new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
        }
        return null;
    }

    public static int[] parseInteger(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            try {
                return new int[]{Integer.parseInt(string)};
            }
            catch (NumberFormatException numberFormatException) {
                return new int[0];
            }
        }
        ArrayUtil<String> arrayUtil = StringUtil.separateList(string, string2, true);
        int[] nArray = new int[arrayUtil.size()];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                nArray[i] = Integer.parseInt((String)arrayUtil.get(i));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = -1;
            }
        }
        return nArray;
    }

    public static String quote(String string, char c) {
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return String.valueOf(c) + String.valueOf(c);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        stringBuilder.append(c);
        for (char c2 : string.toCharArray()) {
            stringBuilder.append(c2);
            if (c2 != c) continue;
            stringBuilder.append(c2);
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    public static String removeCharacters(String string, char ... cArray) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (cArray == null || cArray.length == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (ArrayUtil.contains(cArray, c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String removeQuotes(String string, String string2) {
        return StringUtil.removeQuotes(string, string2, string2);
    }

    public static String removeQuotes(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        if (string2 != null && string2.length() > 0) {
            n = string.indexOf(string2) + string2.length();
        }
        if (string3 != null && string3.length() > 0) {
            n2 = string.lastIndexOf(string3);
        }
        if (n >= 0 && n2 > n) {
            return string.substring(n, n2);
        }
        return string;
    }

    public static String removeWhitespaces(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String removeWhiteSpaces(String string) {
        return StringUtil.removeWhitespaces(string);
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        if ((n = string.indexOf(string2)) < 0) {
            return string;
        }
        int n2 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(string.length() + Math.max(0, string3.length() - n2) * 10);
        int n3 = 0;
        do {
            stringBuilder.append(string.substring(n3, n));
            stringBuilder.append(string3);
        } while ((n = string.indexOf(string2, n3 = n + n2)) >= 0);
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static String replacePlaceholder(String string) {
        if (string != null) {
            int n = string.indexOf("${");
            if (n < 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            int n2 = 0;
            while (n >= 0 && n2 != -1) {
                String string2;
                n2 = stringBuilder.indexOf("}", n + 2);
                if (n2 > n && (string2 = stringBuilder.substring(n + 2, n2)).length() > 0) {
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    int n3 = string2.indexOf(58);
                    if (n3 >= 0) {
                        string3 = string2.substring(0, n3);
                        string4 = string2.substring(n3 + 1);
                    }
                    if ("sys".equalsIgnoreCase(string3)) {
                        string5 = System.getProperty(string4);
                    } else if ("env".equalsIgnoreCase(string3)) {
                        string5 = System.getenv(string4);
                    } else {
                        string5 = System.getProperty(string2);
                        if (string5 == null) {
                            string5 = System.getenv(string2);
                        }
                    }
                    if (string5 != null) {
                        stringBuilder = stringBuilder.replace(n, n2 + 1, string5);
                        n2 = n + string5.length() - 1;
                    }
                }
                n = stringBuilder.indexOf("${", n2 + 1);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static String rpad(String string, int n) {
        return StringUtil.rpad(string, n, ' ');
    }

    public static String rpad(String string, int n, char c) {
        if (string == null || string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String rtrim(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(0, i + 1);
        }
        return "";
    }

    public static String sanitizeId(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && (!Character.isDigit(c) && c != '-' && c != ':' && c != '.' && c != '_' || !bl)) continue;
            bl = true;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static ArrayUtil<String> separate(String string, String string2, String string3, boolean bl) {
        if (string == null || string.length() == 0) {
            return new ArrayUtil<String>();
        }
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            return new ArrayUtil<String>(string);
        }
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        int n = string.indexOf(string2, 0);
        int n2 = 0;
        while (n >= 0 && n2 >= 0) {
            n2 = string.indexOf(string3, n);
            if (n2 >= 0) {
                if (bl) {
                    arrayUtil.add(string.substring(n, n2 + 1));
                } else {
                    arrayUtil.add(string.substring(n + 1, n2));
                }
                n = n2 + string3.length();
            }
            n = string.indexOf(string2, n);
        }
        if (n >= 0 && n2 == -1) {
            if (bl) {
                arrayUtil.add(string.substring(n) + string3);
            } else {
                arrayUtil.add(string.substring(n + 1));
            }
        }
        return arrayUtil;
    }

    public static ArrayUtil<String> separateList(String string, String string2, boolean bl) {
        String string3;
        if (string == null) {
            return new ArrayUtil<String>();
        }
        if (string.length() == 0) {
            return new ArrayUtil<String>(string);
        }
        if (string2 == null || string2.length() == 0) {
            if (bl) {
                return new ArrayUtil<String>(string.trim());
            }
            return new ArrayUtil<String>(string);
        }
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        int n = 0;
        int n2 = string.indexOf(string2, n);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            if (bl) {
                string3 = string3.trim();
            }
            arrayUtil.add(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        if (n >= 0 && n < string.length() && n2 == -1) {
            string3 = string.substring(n);
            if (bl) {
                string3 = string3.trim();
            }
            arrayUtil.add(string3);
        }
        return arrayUtil;
    }

    public static String stripTags(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                if (!bl) {
                    bl = true;
                } else {
                    i = n;
                    stringBuilder.append('<');
                    bl = false;
                }
                n = i;
                continue;
            }
            if (c == '>' && bl) {
                bl = false;
                continue;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toString(Object object) {
        return StringUtil.toString(object, -1);
    }

    public static String toString(Object object, int n) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringUtil.deepToString(object, stringBuilder, new IdentityHashMap<Object, Object>(), n);
        return stringBuilder.toString();
    }

    private static String convertNameToText(String string, boolean bl, boolean bl2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        boolean bl3 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            char c = string.charAt(i);
            boolean bl4 = true;
            if (bl) {
                Character c2 = reverseCharacterReplacements.get(String.valueOf(c));
                if (c2 != null) {
                    c = c2.charValue();
                } else if (i < string.length() - 1 && (c2 = reverseCharacterReplacements.get(string.substring(i, i + 2))) != null) {
                    c = c2.charValue();
                    ++i;
                }
            }
            if (!bl3 && Character.isLetter(c)) {
                c = Character.toUpperCase(c);
                bl3 = true;
            } else if (Character.isUpperCase(c) && i > 0) {
                char c3 = string.charAt(n2 - 1);
                if (Character.isUpperCase(c3) && !bl2 || Character.isLowerCase(c3) || Character.isDigit(c3)) {
                    stringBuilder.append(" ");
                }
            } else if (c == '_') {
                bl4 = false;
                if (bl3) {
                    stringBuilder.append(" ");
                } else if (i + 1 < n) {
                    c = string.charAt(i + 1);
                    bl3 = Character.isLetter(c);
                }
            }
            if (!bl4) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static void deepToString(Object object, StringBuilder stringBuilder, IdentityHashMap<Object, Object> identityHashMap, int n) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (identityHashMap.containsKey(object)) {
            stringBuilder.append("#REF#");
            return;
        }
        identityHashMap.put(object, Boolean.TRUE);
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            stringBuilder.append('[');
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    StringUtil.deepToString(iterator.next(), stringBuilder, identityHashMap, n);
                    stringBuilder.append(", ");
                }
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            stringBuilder.append(']');
        } else if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            stringBuilder.append('[');
            if (enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    StringUtil.deepToString(enumeration.nextElement(), stringBuilder, identityHashMap, n);
                    stringBuilder.append(", ");
                }
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            stringBuilder.append(']');
        } else if (object instanceof Iterable) {
            stringBuilder.append('[');
            boolean bl = false;
            for (Object t : (Iterable)object) {
                bl = true;
                StringUtil.deepToString(t, stringBuilder, identityHashMap, n);
                stringBuilder.append(", ");
            }
            if (bl) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            stringBuilder.append(']');
        } else if (object instanceof Map) {
            Map map = (Map)object;
            stringBuilder.append('{');
            int n2 = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (n2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('[');
                StringUtil.deepToString(entry.getKey(), stringBuilder, identityHashMap, n);
                stringBuilder.append(", ");
                StringUtil.deepToString(entry.getValue(), stringBuilder, identityHashMap, n);
                stringBuilder.append(']');
                ++n2;
            }
            stringBuilder.append('}');
        } else if (object instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)object;
            stringBuilder.append('{');
            int n3 = 0;
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (n3 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('[');
                StringUtil.deepToString(k, stringBuilder, identityHashMap, n);
                stringBuilder.append(", ");
                StringUtil.deepToString(dictionary.get(k), stringBuilder, identityHashMap, n);
                stringBuilder.append(']');
                ++n3;
            }
            stringBuilder.append('}');
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                stringBuilder.append('[');
                if (clazz == byte[].class) {
                    if (n >= 0 && ((byte[])object).length > n) {
                        stringBuilder.append("#byte[");
                        stringBuilder.append(((byte[])object).length);
                        stringBuilder.append("]#");
                    } else {
                        stringBuilder.append(Arrays.toString((byte[])object));
                    }
                } else if (clazz == short[].class) {
                    if (n >= 0 && ((short[])object).length > n) {
                        stringBuilder.append("#short[");
                        stringBuilder.append(((short[])object).length);
                        stringBuilder.append("]#");
                    } else {
                        stringBuilder.append(Arrays.toString((short[])object));
                    }
                } else if (clazz == int[].class) {
                    if (n >= 0 && ((int[])object).length > n) {
                        stringBuilder.append("#int[");
                        stringBuilder.append(((int[])object).length);
                        stringBuilder.append("]#");
                    } else {
                        stringBuilder.append(Arrays.toString((int[])object));
                    }
                } else if (clazz == long[].class) {
                    if (n >= 0 && ((long[])object).length > n) {
                        stringBuilder.append("#long[");
                        stringBuilder.append(((long[])object).length);
                        stringBuilder.append("]#");
                    } else {
                        stringBuilder.append(Arrays.toString((long[])object));
                    }
                } else if (clazz == char[].class) {
                    if (n >= 0 && ((char[])object).length > n) {
                        stringBuilder.append("#char[");
                        stringBuilder.append(((char[])object).length);
                        stringBuilder.append("]#");
                    } else {
                        stringBuilder.append(Arrays.toString((char[])object));
                    }
                } else if (clazz == float[].class) {
                    if (n >= 0 && ((float[])object).length > n) {
                        stringBuilder.append("#float[");
                        stringBuilder.append(((float[])object).length);
                        stringBuilder.append("]#");
                    } else {
                        stringBuilder.append(Arrays.toString((float[])object));
                    }
                } else if (clazz == double[].class) {
                    if (n >= 0 && ((short[])object).length > n) {
                        stringBuilder.append("#double[");
                        stringBuilder.append(((double[])object).length);
                        stringBuilder.append("]#");
                    } else {
                        stringBuilder.append(Arrays.toString((double[])object));
                    }
                } else if (clazz == boolean[].class) {
                    if (n >= 0 && ((boolean[])object).length > n) {
                        stringBuilder.append("#boolean[");
                        stringBuilder.append(((boolean[])object).length);
                        stringBuilder.append("]#");
                    } else {
                        stringBuilder.append(Arrays.toString((boolean[])object));
                    }
                } else {
                    Object[] objectArray = (Object[])object;
                    if (n >= 0 && objectArray.length > n) {
                        stringBuilder.append("#Object[");
                        stringBuilder.append(objectArray.length);
                        stringBuilder.append("]#");
                    } else {
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (i != 0) {
                                stringBuilder.append(", ");
                            }
                            StringUtil.deepToString(objectArray[i], stringBuilder, identityHashMap, n);
                        }
                    }
                }
                stringBuilder.append(']');
            } else {
                stringBuilder.append(object.toString());
            }
        }
        identityHashMap.remove(object);
    }

    private static boolean like(String string, int n, int n2, String string2, int n3, int n4) {
        int n5 = n;
        for (int i = n3; i < n4; ++i) {
            char c = string2.charAt(i);
            if (c == '*') {
                if (i == n4 - 1) {
                    return true;
                }
                int n6 = i + 1;
                while (n5 < n2) {
                    if (StringUtil.like(string, n5, n2, string2, n6, n4)) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            if (n5 == n2) {
                return false;
            }
            if (c != '?' && c != string.charAt(n5)) {
                return false;
            }
            ++n5;
        }
        return n5 == n2;
    }

    static {
        reverseCharacterReplacements.put("ue", Character.valueOf('\u00fc'));
        reverseCharacterReplacements.put("Ue", Character.valueOf('\u00dc'));
        reverseCharacterReplacements.put("UE", Character.valueOf('\u00dc'));
        reverseCharacterReplacements.put("ae", Character.valueOf('\u00e4'));
        reverseCharacterReplacements.put("Ae", Character.valueOf('\u00c4'));
        reverseCharacterReplacements.put("AE", Character.valueOf('\u00c4'));
        reverseCharacterReplacements.put("oe", Character.valueOf('\u00f6'));
        reverseCharacterReplacements.put("Oe", Character.valueOf('\u00d6'));
        reverseCharacterReplacements.put("OE", Character.valueOf('\u00d6'));
        reverseCharacterReplacements.put("ss", Character.valueOf('\u00df'));
        characterReplacements.put(Character.valueOf('\u00a2'), "c");
        characterReplacements.put(Character.valueOf('\u00a5'), "Y");
        characterReplacements.put(Character.valueOf('\u00a9'), "c");
        characterReplacements.put(Character.valueOf('\u00aa'), "a");
        characterReplacements.put(Character.valueOf('\u00ae'), "R");
        characterReplacements.put(Character.valueOf('\u00c0'), "A");
        characterReplacements.put(Character.valueOf('\u00c1'), "A");
        characterReplacements.put(Character.valueOf('\u00c2'), "A");
        characterReplacements.put(Character.valueOf('\u00c3'), "A");
        characterReplacements.put(Character.valueOf('\u00c4'), "AE");
        characterReplacements.put(Character.valueOf('\u00c5'), "A");
        characterReplacements.put(Character.valueOf('\u00c6'), "AE");
        characterReplacements.put(Character.valueOf('\u00c7'), "C");
        characterReplacements.put(Character.valueOf('\u00c8'), "E");
        characterReplacements.put(Character.valueOf('\u00c9'), "E");
        characterReplacements.put(Character.valueOf('\u00ca'), "E");
        characterReplacements.put(Character.valueOf('\u00cb'), "E");
        characterReplacements.put(Character.valueOf('\u00cc'), "I");
        characterReplacements.put(Character.valueOf('\u00cd'), "I");
        characterReplacements.put(Character.valueOf('\u00ce'), "I");
        characterReplacements.put(Character.valueOf('\u00cf'), "I");
        characterReplacements.put(Character.valueOf('\u00d0'), "D");
        characterReplacements.put(Character.valueOf('\u00d1'), "N");
        characterReplacements.put(Character.valueOf('\u00d2'), "O");
        characterReplacements.put(Character.valueOf('\u00d3'), "O");
        characterReplacements.put(Character.valueOf('\u00d4'), "O");
        characterReplacements.put(Character.valueOf('\u00d5'), "O");
        characterReplacements.put(Character.valueOf('\u00d6'), "OE");
        characterReplacements.put(Character.valueOf('\u00d7'), "x");
        characterReplacements.put(Character.valueOf('\u00d8'), "O");
        characterReplacements.put(Character.valueOf('\u00d9'), "U");
        characterReplacements.put(Character.valueOf('\u00da'), "U");
        characterReplacements.put(Character.valueOf('\u00db'), "U");
        characterReplacements.put(Character.valueOf('\u00dc'), "UE");
        characterReplacements.put(Character.valueOf('\u00dd'), "Y");
        characterReplacements.put(Character.valueOf('\u00df'), "ss");
        characterReplacements.put(Character.valueOf('\u00e0'), "a");
        characterReplacements.put(Character.valueOf('\u00e1'), "a");
        characterReplacements.put(Character.valueOf('\u00e2'), "a");
        characterReplacements.put(Character.valueOf('\u00e3'), "a");
        characterReplacements.put(Character.valueOf('\u00e4'), "ae");
        characterReplacements.put(Character.valueOf('\u00e5'), "a");
        characterReplacements.put(Character.valueOf('\u00e6'), "ae");
        characterReplacements.put(Character.valueOf('\u00e7'), "c");
        characterReplacements.put(Character.valueOf('\u00e8'), "e");
        characterReplacements.put(Character.valueOf('\u00e9'), "e");
        characterReplacements.put(Character.valueOf('\u00ea'), "e");
        characterReplacements.put(Character.valueOf('\u00eb'), "ae");
        characterReplacements.put(Character.valueOf('\u00ec'), "i");
        characterReplacements.put(Character.valueOf('\u00ed'), "i");
        characterReplacements.put(Character.valueOf('\u00ee'), "i");
        characterReplacements.put(Character.valueOf('\u00ef'), "i");
        characterReplacements.put(Character.valueOf('\u00f0'), "o");
        characterReplacements.put(Character.valueOf('\u00f1'), "n");
        characterReplacements.put(Character.valueOf('\u00f2'), "o");
        characterReplacements.put(Character.valueOf('\u00f3'), "o");
        characterReplacements.put(Character.valueOf('\u00f4'), "o");
        characterReplacements.put(Character.valueOf('\u00f5'), "o");
        characterReplacements.put(Character.valueOf('\u00f6'), "oe");
        characterReplacements.put(Character.valueOf('\u00f8'), "o");
        characterReplacements.put(Character.valueOf('\u00f9'), "u");
        characterReplacements.put(Character.valueOf('\u00fa'), "u");
        characterReplacements.put(Character.valueOf('\u00fb'), "u");
        characterReplacements.put(Character.valueOf('\u00fc'), "ue");
        characterReplacements.put(Character.valueOf('\u00fd'), "y");
        characterReplacements.put(Character.valueOf('\u00fe'), "b");
        characterReplacements.put(Character.valueOf('\u00ff'), "y");
        characterReplacements.put(Character.valueOf('\u0100'), "A");
        characterReplacements.put(Character.valueOf('\u0101'), "a");
        characterReplacements.put(Character.valueOf('\u0102'), "A");
        characterReplacements.put(Character.valueOf('\u0103'), "a");
        characterReplacements.put(Character.valueOf('\u0104'), "A");
        characterReplacements.put(Character.valueOf('\u0105'), "a");
        characterReplacements.put(Character.valueOf('\u0106'), "C");
        characterReplacements.put(Character.valueOf('\u0107'), "c");
        characterReplacements.put(Character.valueOf('\u0108'), "C");
        characterReplacements.put(Character.valueOf('\u0109'), "c");
        characterReplacements.put(Character.valueOf('\u010a'), "C");
        characterReplacements.put(Character.valueOf('\u010b'), "c");
        characterReplacements.put(Character.valueOf('\u010c'), "C");
        characterReplacements.put(Character.valueOf('\u010d'), "c");
        characterReplacements.put(Character.valueOf('\u010e'), "D");
        characterReplacements.put(Character.valueOf('\u010f'), "d");
        characterReplacements.put(Character.valueOf('\u0110'), "D");
        characterReplacements.put(Character.valueOf('\u0111'), "d");
        characterReplacements.put(Character.valueOf('\u0112'), "E");
        characterReplacements.put(Character.valueOf('\u0113'), "e");
        characterReplacements.put(Character.valueOf('\u0114'), "E");
        characterReplacements.put(Character.valueOf('\u0115'), "e");
        characterReplacements.put(Character.valueOf('\u0116'), "E");
        characterReplacements.put(Character.valueOf('\u0117'), "e");
        characterReplacements.put(Character.valueOf('\u0118'), "E");
        characterReplacements.put(Character.valueOf('\u0119'), "e");
        characterReplacements.put(Character.valueOf('\u011a'), "E");
        characterReplacements.put(Character.valueOf('\u011b'), "e");
        characterReplacements.put(Character.valueOf('\u011c'), "G");
        characterReplacements.put(Character.valueOf('\u011d'), "g");
        characterReplacements.put(Character.valueOf('\u011e'), "G");
        characterReplacements.put(Character.valueOf('\u011f'), "g");
        characterReplacements.put(Character.valueOf('\u0120'), "G");
        characterReplacements.put(Character.valueOf('\u0121'), "g");
        characterReplacements.put(Character.valueOf('\u0122'), "G");
        characterReplacements.put(Character.valueOf('\u0123'), "g");
        characterReplacements.put(Character.valueOf('\u0124'), "H");
        characterReplacements.put(Character.valueOf('\u0125'), "h");
        characterReplacements.put(Character.valueOf('\u0126'), "H");
        characterReplacements.put(Character.valueOf('\u0127'), "h");
        characterReplacements.put(Character.valueOf('\u0128'), "I");
        characterReplacements.put(Character.valueOf('\u0129'), "i");
        characterReplacements.put(Character.valueOf('\u012a'), "I");
        characterReplacements.put(Character.valueOf('\u012b'), "i");
        characterReplacements.put(Character.valueOf('\u012c'), "I");
        characterReplacements.put(Character.valueOf('\u012d'), "i");
        characterReplacements.put(Character.valueOf('\u012e'), "I");
        characterReplacements.put(Character.valueOf('\u012f'), "i");
        characterReplacements.put(Character.valueOf('\u0130'), "i");
        characterReplacements.put(Character.valueOf('\u0131'), "I");
        characterReplacements.put(Character.valueOf('\u0132'), "IJ");
        characterReplacements.put(Character.valueOf('\u0133'), "ij");
        characterReplacements.put(Character.valueOf('\u0134'), "J");
        characterReplacements.put(Character.valueOf('\u0135'), "j");
        characterReplacements.put(Character.valueOf('\u0136'), "K");
        characterReplacements.put(Character.valueOf('\u0137'), "k");
        characterReplacements.put(Character.valueOf('\u0138'), "K");
        characterReplacements.put(Character.valueOf('\u0139'), "L");
        characterReplacements.put(Character.valueOf('\u013a'), "I");
        characterReplacements.put(Character.valueOf('\u013b'), "L");
        characterReplacements.put(Character.valueOf('\u013c'), "I");
        characterReplacements.put(Character.valueOf('\u013d'), "L");
        characterReplacements.put(Character.valueOf('\u013e'), "I");
        characterReplacements.put(Character.valueOf('\u013f'), "L");
        characterReplacements.put(Character.valueOf('\u0140'), "I");
        characterReplacements.put(Character.valueOf('\u0141'), "L");
        characterReplacements.put(Character.valueOf('\u0142'), "I");
        characterReplacements.put(Character.valueOf('\u0143'), "N");
        characterReplacements.put(Character.valueOf('\u0144'), "n");
        characterReplacements.put(Character.valueOf('\u0145'), "N");
        characterReplacements.put(Character.valueOf('\u0146'), "n");
        characterReplacements.put(Character.valueOf('\u0147'), "N");
        characterReplacements.put(Character.valueOf('\u0148'), "n");
        characterReplacements.put(Character.valueOf('\u0149'), "n");
        characterReplacements.put(Character.valueOf('\u014a'), "n");
        characterReplacements.put(Character.valueOf('\u014b'), "n");
        characterReplacements.put(Character.valueOf('\u014c'), "O");
        characterReplacements.put(Character.valueOf('\u014d'), "o");
        characterReplacements.put(Character.valueOf('\u014e'), "O");
        characterReplacements.put(Character.valueOf('\u014f'), "o");
        characterReplacements.put(Character.valueOf('\u0150'), "OE");
        characterReplacements.put(Character.valueOf('\u0151'), "oe");
        characterReplacements.put(Character.valueOf('\u0152'), "OE");
        characterReplacements.put(Character.valueOf('\u0153'), "oe");
        characterReplacements.put(Character.valueOf('\u0154'), "R");
        characterReplacements.put(Character.valueOf('\u0155'), "r");
        characterReplacements.put(Character.valueOf('\u0156'), "R");
        characterReplacements.put(Character.valueOf('\u0157'), "r");
        characterReplacements.put(Character.valueOf('\u0158'), "R");
        characterReplacements.put(Character.valueOf('\u0159'), "r");
        characterReplacements.put(Character.valueOf('\u015a'), "S");
        characterReplacements.put(Character.valueOf('\u015b'), "s");
        characterReplacements.put(Character.valueOf('\u015c'), "S");
        characterReplacements.put(Character.valueOf('\u015d'), "s");
        characterReplacements.put(Character.valueOf('\u015e'), "S");
        characterReplacements.put(Character.valueOf('\u015f'), "s");
        characterReplacements.put(Character.valueOf('\u0160'), "S");
        characterReplacements.put(Character.valueOf('\u0161'), "s");
        characterReplacements.put(Character.valueOf('\u0162'), "T");
        characterReplacements.put(Character.valueOf('\u0163'), "t");
        characterReplacements.put(Character.valueOf('\u0164'), "T");
        characterReplacements.put(Character.valueOf('\u0165'), "t");
        characterReplacements.put(Character.valueOf('\u0166'), "F");
        characterReplacements.put(Character.valueOf('\u0167'), "f");
        characterReplacements.put(Character.valueOf('\u0168'), "U");
        characterReplacements.put(Character.valueOf('\u0169'), "u");
        characterReplacements.put(Character.valueOf('\u016a'), "U");
        characterReplacements.put(Character.valueOf('\u016b'), "u");
        characterReplacements.put(Character.valueOf('\u016c'), "U");
        characterReplacements.put(Character.valueOf('\u016d'), "u");
        characterReplacements.put(Character.valueOf('\u016e'), "U");
        characterReplacements.put(Character.valueOf('\u016f'), "u");
        characterReplacements.put(Character.valueOf('\u0170'), "UE");
        characterReplacements.put(Character.valueOf('\u0171'), "ue");
        characterReplacements.put(Character.valueOf('\u0172'), "U");
        characterReplacements.put(Character.valueOf('\u0173'), "u");
        characterReplacements.put(Character.valueOf('\u0174'), "W");
        characterReplacements.put(Character.valueOf('\u0175'), "w");
        characterReplacements.put(Character.valueOf('\u0176'), "Y");
        characterReplacements.put(Character.valueOf('\u0177'), "y");
        characterReplacements.put(Character.valueOf('\u0178'), "Y");
        characterReplacements.put(Character.valueOf('\u0179'), "Z");
        characterReplacements.put(Character.valueOf('\u017a'), "z");
        characterReplacements.put(Character.valueOf('\u017b'), "Z");
        characterReplacements.put(Character.valueOf('\u017c'), "z");
        characterReplacements.put(Character.valueOf('\u017d'), "Z");
        characterReplacements.put(Character.valueOf('\u017e'), "z");
        characterReplacements.put(Character.valueOf('\u0180'), "b");
        characterReplacements.put(Character.valueOf('\u0181'), "B");
        characterReplacements.put(Character.valueOf('\u0182'), "b");
        characterReplacements.put(Character.valueOf('\u0183'), "b");
        characterReplacements.put(Character.valueOf('\u0184'), "b");
        characterReplacements.put(Character.valueOf('\u0185'), "b");
        characterReplacements.put(Character.valueOf('\u0186'), "C");
        characterReplacements.put(Character.valueOf('\u0187'), "C");
        characterReplacements.put(Character.valueOf('\u0188'), "c");
        characterReplacements.put(Character.valueOf('\u0189'), "D");
        characterReplacements.put(Character.valueOf('\u018a'), "D");
        characterReplacements.put(Character.valueOf('\u018e'), "E");
        characterReplacements.put(Character.valueOf('\u018f'), "e");
        characterReplacements.put(Character.valueOf('\u0191'), "F");
        characterReplacements.put(Character.valueOf('\u0192'), "f");
        characterReplacements.put(Character.valueOf('\u0193'), "G");
        characterReplacements.put(Character.valueOf('\u0194'), "Y");
        characterReplacements.put(Character.valueOf('\u0196'), "I");
        characterReplacements.put(Character.valueOf('\u0197'), "I");
        characterReplacements.put(Character.valueOf('\u0198'), "K");
        characterReplacements.put(Character.valueOf('\u0199'), "k");
        characterReplacements.put(Character.valueOf('\u019a'), "I");
        characterReplacements.put(Character.valueOf('\u019d'), "N");
        characterReplacements.put(Character.valueOf('\u019e'), "n");
        characterReplacements.put(Character.valueOf('\u01a0'), "O");
        characterReplacements.put(Character.valueOf('\u01a1'), "o");
        characterReplacements.put(Character.valueOf('\u01a4'), "P");
        characterReplacements.put(Character.valueOf('\u01a6'), "R");
        characterReplacements.put(Character.valueOf('\u01a7'), "S");
        characterReplacements.put(Character.valueOf('\u01a8'), "s");
        characterReplacements.put(Character.valueOf('\u01aa'), "l");
        characterReplacements.put(Character.valueOf('\u01ab'), "t");
        characterReplacements.put(Character.valueOf('\u01ac'), "T");
        characterReplacements.put(Character.valueOf('\u01ad'), "f");
        characterReplacements.put(Character.valueOf('\u01ae'), "T");
        characterReplacements.put(Character.valueOf('\u01af'), "U");
        characterReplacements.put(Character.valueOf('\u01b0'), "u");
        characterReplacements.put(Character.valueOf('\u01b2'), "U");
        characterReplacements.put(Character.valueOf('\u01b3'), "Y");
        characterReplacements.put(Character.valueOf('\u01b4'), "y");
        characterReplacements.put(Character.valueOf('\u01b5'), "Z");
        characterReplacements.put(Character.valueOf('\u01b6'), "z");
        characterReplacements.put(Character.valueOf('\u01bc'), "5");
        characterReplacements.put(Character.valueOf('\u01bf'), "P");
        characterReplacements.put(Character.valueOf('\u01c0'), "I");
        characterReplacements.put(Character.valueOf('\u01c4'), "DZ");
        characterReplacements.put(Character.valueOf('\u01c5'), "Dz");
        characterReplacements.put(Character.valueOf('\u01c6'), "dz");
        characterReplacements.put(Character.valueOf('\u01c7'), "LJ");
        characterReplacements.put(Character.valueOf('\u01c8'), "Lj");
        characterReplacements.put(Character.valueOf('\u01c9'), "lj");
        characterReplacements.put(Character.valueOf('\u01ca'), "NJ");
        characterReplacements.put(Character.valueOf('\u01cb'), "Nj");
        characterReplacements.put(Character.valueOf('\u01cc'), "nj");
        characterReplacements.put(Character.valueOf('\u01cd'), "A");
        characterReplacements.put(Character.valueOf('\u01ce'), "a");
        characterReplacements.put(Character.valueOf('\u01cf'), "I");
        characterReplacements.put(Character.valueOf('\u01d0'), "I");
        characterReplacements.put(Character.valueOf('\u01d1'), "O");
        characterReplacements.put(Character.valueOf('\u01d2'), "o");
        characterReplacements.put(Character.valueOf('\u01d3'), "U");
        characterReplacements.put(Character.valueOf('\u01d4'), "u");
        characterReplacements.put(Character.valueOf('\u01d5'), "U");
        characterReplacements.put(Character.valueOf('\u01d6'), "u");
        characterReplacements.put(Character.valueOf('\u01d7'), "U");
        characterReplacements.put(Character.valueOf('\u01d8'), "u");
        characterReplacements.put(Character.valueOf('\u01d9'), "U");
        characterReplacements.put(Character.valueOf('\u01da'), "u");
        characterReplacements.put(Character.valueOf('\u01db'), "U");
        characterReplacements.put(Character.valueOf('\u01dc'), "u");
        characterReplacements.put(Character.valueOf('\u01dd'), "e");
        characterReplacements.put(Character.valueOf('\u01de'), "A");
        characterReplacements.put(Character.valueOf('\u01df'), "a");
        characterReplacements.put(Character.valueOf('\u01e0'), "A");
        characterReplacements.put(Character.valueOf('\u01e1'), "a");
        characterReplacements.put(Character.valueOf('\u01e3'), "AE");
        characterReplacements.put(Character.valueOf('\u01e4'), "ae");
        characterReplacements.put(Character.valueOf('\u01e4'), "G");
        characterReplacements.put(Character.valueOf('\u01e5'), "g");
        characterReplacements.put(Character.valueOf('\u01e6'), "G");
        characterReplacements.put(Character.valueOf('\u01e7'), "g");
        characterReplacements.put(Character.valueOf('\u01e8'), "K");
        characterReplacements.put(Character.valueOf('\u01e9'), "k");
        characterReplacements.put(Character.valueOf('\u01ea'), "O");
        characterReplacements.put(Character.valueOf('\u01eb'), "o");
        characterReplacements.put(Character.valueOf('\u01ec'), "O");
        characterReplacements.put(Character.valueOf('\u01ed'), "o");
        characterReplacements.put(Character.valueOf('\u01f0'), "J");
        characterReplacements.put(Character.valueOf('\u01f1'), "DZ");
        characterReplacements.put(Character.valueOf('\u01f2'), "Dz");
        characterReplacements.put(Character.valueOf('\u01f3'), "dz");
        characterReplacements.put(Character.valueOf('\u01f4'), "G");
        characterReplacements.put(Character.valueOf('\u01f5'), "g");
        characterReplacements.put(Character.valueOf('\u01f6'), "Hu");
        characterReplacements.put(Character.valueOf('\u01f7'), "D");
        characterReplacements.put(Character.valueOf('\u01f8'), "N");
        characterReplacements.put(Character.valueOf('\u01f9'), "n");
        characterReplacements.put(Character.valueOf('\u01fa'), "A");
        characterReplacements.put(Character.valueOf('\u01fb'), "a");
        characterReplacements.put(Character.valueOf('\u01fc'), "AE");
        characterReplacements.put(Character.valueOf('\u01fd'), "ae");
        characterReplacements.put(Character.valueOf('\u01fe'), "O");
        characterReplacements.put(Character.valueOf('\u01ff'), "o");
        characterReplacements.put(Character.valueOf('\u01f8'), "N");
        characterReplacements.put(Character.valueOf('\u0200'), "A");
        characterReplacements.put(Character.valueOf('\u0201'), "a");
        characterReplacements.put(Character.valueOf('\u0202'), "A");
        characterReplacements.put(Character.valueOf('\u0203'), "a");
        characterReplacements.put(Character.valueOf('\u0204'), "E");
        characterReplacements.put(Character.valueOf('\u0205'), "e");
        characterReplacements.put(Character.valueOf('\u0206'), "E");
        characterReplacements.put(Character.valueOf('\u0207'), "e");
        characterReplacements.put(Character.valueOf('\u0208'), "I");
        characterReplacements.put(Character.valueOf('\u0209'), "i");
        characterReplacements.put(Character.valueOf('\u020a'), "I");
        characterReplacements.put(Character.valueOf('\u020b'), "i");
        characterReplacements.put(Character.valueOf('\u020c'), "OE");
        characterReplacements.put(Character.valueOf('\u020d'), "oe");
        characterReplacements.put(Character.valueOf('\u020e'), "O");
        characterReplacements.put(Character.valueOf('\u0210'), "R");
        characterReplacements.put(Character.valueOf('\u0211'), "r");
        characterReplacements.put(Character.valueOf('\u0212'), "R");
        characterReplacements.put(Character.valueOf('\u0213'), "r");
        characterReplacements.put(Character.valueOf('\u0214'), "UE");
        characterReplacements.put(Character.valueOf('\u0215'), "ue");
        characterReplacements.put(Character.valueOf('\u0216'), "U");
        characterReplacements.put(Character.valueOf('\u0217'), "u");
        characterReplacements.put(Character.valueOf('\u0218'), "S");
        characterReplacements.put(Character.valueOf('\u0219'), "s");
        characterReplacements.put(Character.valueOf('\u021a'), "T");
        characterReplacements.put(Character.valueOf('\u021e'), "H");
        characterReplacements.put(Character.valueOf('\u021f'), "h");
        characterReplacements.put(Character.valueOf('\u0220'), "n");
        characterReplacements.put(Character.valueOf('\u0221'), "d");
        characterReplacements.put(Character.valueOf('\u0224'), "Z");
        characterReplacements.put(Character.valueOf('\u0225'), "z");
        characterReplacements.put(Character.valueOf('\u0226'), "A");
        characterReplacements.put(Character.valueOf('\u0227'), "a");
        characterReplacements.put(Character.valueOf('\u0228'), "E");
        characterReplacements.put(Character.valueOf('\u0229'), "e");
        characterReplacements.put(Character.valueOf('\u022a'), "O");
        characterReplacements.put(Character.valueOf('\u022b'), "o");
        characterReplacements.put(Character.valueOf('\u022c'), "O");
        characterReplacements.put(Character.valueOf('\u022d'), "o");
        characterReplacements.put(Character.valueOf('\u022e'), "O");
        characterReplacements.put(Character.valueOf('\u022f'), "o");
        characterReplacements.put(Character.valueOf('\u0230'), "O");
        characterReplacements.put(Character.valueOf('\u0231'), "o");
        characterReplacements.put(Character.valueOf('\u0232'), "Y");
        characterReplacements.put(Character.valueOf('\u0233'), "y");
        characterReplacements.put(Character.valueOf('\u0234'), "I");
        characterReplacements.put(Character.valueOf('\u0235'), "n");
        characterReplacements.put(Character.valueOf('\u0236'), "t");
        characterReplacements.put(Character.valueOf('\u0237'), "J");
        characterReplacements.put(Character.valueOf('\u023a'), "A");
        characterReplacements.put(Character.valueOf('\u023b'), "C");
        characterReplacements.put(Character.valueOf('\u023c'), "c");
        characterReplacements.put(Character.valueOf('\u023d'), "t");
        characterReplacements.put(Character.valueOf('\u023e'), "T");
        characterReplacements.put(Character.valueOf('\u023f'), "s");
        characterReplacements.put(Character.valueOf('\u0240'), "Z");
        characterReplacements.put(Character.valueOf('\u0243'), "B");
        characterReplacements.put(Character.valueOf('\u0244'), "U");
        characterReplacements.put(Character.valueOf('\u0246'), "E");
        characterReplacements.put(Character.valueOf('\u0247'), "e");
        characterReplacements.put(Character.valueOf('\u0248'), "J");
        characterReplacements.put(Character.valueOf('\u0249'), "j");
        characterReplacements.put(Character.valueOf('\u024a'), "q");
        characterReplacements.put(Character.valueOf('\u024b'), "q");
        characterReplacements.put(Character.valueOf('\u024c'), "R");
        characterReplacements.put(Character.valueOf('\u024d'), "r");
        characterReplacements.put(Character.valueOf('\u024e'), "Y");
        characterReplacements.put(Character.valueOf('\u024f'), "y");
        namesToColors.put("aliceblue", new int[]{240, 248, 255});
        namesToColors.put("antiquewhite", new int[]{250, 235, 215});
        namesToColors.put("aqua", new int[]{0, 255, 255});
        namesToColors.put("aquamarine", new int[]{127, 255, 212});
        namesToColors.put("azure", new int[]{240, 255, 255});
        namesToColors.put("beige", new int[]{245, 245, 220});
        namesToColors.put("bisque", new int[]{255, 228, 196});
        namesToColors.put("black", new int[]{0, 0, 0});
        namesToColors.put("blanchedalmond", new int[]{255, 235, 205});
        namesToColors.put("blue", new int[]{0, 0, 255});
        namesToColors.put("blueviolet", new int[]{138, 43, 226});
        namesToColors.put("brown", new int[]{165, 42, 42});
        namesToColors.put("burlywood", new int[]{222, 184, 135});
        namesToColors.put("cadetblue", new int[]{95, 158, 160});
        namesToColors.put("chartreuse", new int[]{127, 255, 0});
        namesToColors.put("chocolate", new int[]{210, 105, 30});
        namesToColors.put("coral", new int[]{255, 127, 80});
        namesToColors.put("cornflowerblue", new int[]{100, 149, 237});
        namesToColors.put("cornsilk", new int[]{255, 248, 220});
        namesToColors.put("crimson", new int[]{220, 20, 60});
        namesToColors.put("cyan", new int[]{0, 255, 255});
        namesToColors.put("darkblue", new int[]{0, 0, 139});
        namesToColors.put("darkcyan", new int[]{0, 139, 139});
        namesToColors.put("darkgoldenrod", new int[]{184, 134, 11});
        namesToColors.put("darkgray", new int[]{169, 169, 169});
        namesToColors.put("darkgreen", new int[]{0, 100, 0});
        namesToColors.put("darkkhaki", new int[]{189, 183, 107});
        namesToColors.put("darkmagenta", new int[]{139, 0, 139});
        namesToColors.put("darkolivegreen", new int[]{85, 107, 47});
        namesToColors.put("darkorange", new int[]{255, 140, 0});
        namesToColors.put("darkorchid", new int[]{153, 50, 204});
        namesToColors.put("darkred", new int[]{139, 0, 0});
        namesToColors.put("darksalmon", new int[]{233, 150, 122});
        namesToColors.put("darkseagreen", new int[]{143, 188, 143});
        namesToColors.put("darkslateblue", new int[]{72, 61, 139});
        namesToColors.put("darkslategray", new int[]{47, 79, 79});
        namesToColors.put("darkturquoise", new int[]{0, 206, 209});
        namesToColors.put("darkviolet", new int[]{148, 0, 211});
        namesToColors.put("deeppink", new int[]{255, 20, 147});
        namesToColors.put("deepskyblue", new int[]{0, 191, 255});
        namesToColors.put("dimgray", new int[]{105, 105, 105});
        namesToColors.put("dodgerblue", new int[]{30, 144, 255});
        namesToColors.put("firebrick", new int[]{178, 34, 34});
        namesToColors.put("floralwhite", new int[]{255, 250, 240});
        namesToColors.put("forestgreen", new int[]{34, 139, 34});
        namesToColors.put("fuchsia", new int[]{255, 0, 255});
        namesToColors.put("gainsboro", new int[]{220, 220, 220});
        namesToColors.put("ghostwhite", new int[]{248, 248, 255});
        namesToColors.put("gold", new int[]{255, 215, 0});
        namesToColors.put("goldenrod", new int[]{218, 165, 32});
        namesToColors.put("gray", new int[]{128, 128, 128});
        namesToColors.put("green", new int[]{0, 128, 0});
        namesToColors.put("greenyellow", new int[]{173, 255, 47});
        namesToColors.put("honeydew", new int[]{240, 255, 240});
        namesToColors.put("hotpink", new int[]{255, 105, 180});
        namesToColors.put("indianred", new int[]{205, 92, 92});
        namesToColors.put("indigo", new int[]{75, 0, 130});
        namesToColors.put("ivory", new int[]{255, 255, 240});
        namesToColors.put("khaki", new int[]{240, 230, 140});
        namesToColors.put("lavender", new int[]{230, 230, 250});
        namesToColors.put("lavenderblush", new int[]{255, 240, 245});
        namesToColors.put("lawngreen", new int[]{124, 252, 0});
        namesToColors.put("lemonchiffon", new int[]{255, 250, 205});
        namesToColors.put("lightblue", new int[]{173, 216, 230});
        namesToColors.put("lightcoral", new int[]{240, 128, 128});
        namesToColors.put("lightcyan", new int[]{224, 255, 255});
        namesToColors.put("lightgoldenrodyellow", new int[]{250, 250, 210});
        namesToColors.put("lightgray", new int[]{211, 211, 211});
        namesToColors.put("lightgreen", new int[]{144, 238, 144});
        namesToColors.put("lightpink", new int[]{255, 182, 193});
        namesToColors.put("lightsalmon", new int[]{255, 160, 122});
        namesToColors.put("lightseagreen", new int[]{32, 178, 170});
        namesToColors.put("lightskyblue", new int[]{135, 206, 250});
        namesToColors.put("lightslategray", new int[]{119, 136, 153});
        namesToColors.put("lightsteelblue", new int[]{176, 196, 222});
        namesToColors.put("lightyellow", new int[]{255, 255, 224});
        namesToColors.put("lime", new int[]{0, 255, 0});
        namesToColors.put("limegreen", new int[]{50, 205, 50});
        namesToColors.put("linen", new int[]{250, 240, 230});
        namesToColors.put("magenta", new int[]{255, 0, 255});
        namesToColors.put("maroon", new int[]{128, 0, 0});
        namesToColors.put("mediumaquamarine", new int[]{102, 205, 170});
        namesToColors.put("mediumblue", new int[]{0, 0, 205});
        namesToColors.put("mediumorchid", new int[]{186, 85, 211});
        namesToColors.put("mediumpurple", new int[]{147, 112, 219});
        namesToColors.put("mediumseagreen", new int[]{60, 179, 113});
        namesToColors.put("mediumslateblue", new int[]{123, 104, 238});
        namesToColors.put("mediumspringgreen", new int[]{0, 250, 154});
        namesToColors.put("mediumturquoise", new int[]{72, 209, 204});
        namesToColors.put("mediumvioletred", new int[]{199, 21, 133});
        namesToColors.put("midnightblue", new int[]{25, 25, 112});
        namesToColors.put("mintcream", new int[]{245, 255, 250});
        namesToColors.put("mistyrose", new int[]{255, 228, 225});
        namesToColors.put("moccasin", new int[]{255, 228, 181});
        namesToColors.put("navajowhite", new int[]{255, 222, 173});
        namesToColors.put("navy", new int[]{0, 0, 128});
        namesToColors.put("oldlace", new int[]{253, 245, 230});
        namesToColors.put("olive", new int[]{128, 128, 0});
        namesToColors.put("olivedrab", new int[]{107, 142, 35});
        namesToColors.put("orange", new int[]{255, 165, 0});
        namesToColors.put("orangered", new int[]{255, 69, 0});
        namesToColors.put("orchid", new int[]{218, 112, 214});
        namesToColors.put("palegoldenrod", new int[]{238, 232, 170});
        namesToColors.put("palegreen", new int[]{152, 251, 152});
        namesToColors.put("paleturquoise", new int[]{175, 238, 238});
        namesToColors.put("palevioletred", new int[]{219, 112, 147});
        namesToColors.put("papayawhip", new int[]{255, 239, 213});
        namesToColors.put("peachpuff", new int[]{255, 218, 185});
        namesToColors.put("peru", new int[]{205, 133, 63});
        namesToColors.put("pink", new int[]{255, 192, 203});
        namesToColors.put("plum", new int[]{221, 160, 221});
        namesToColors.put("powderblue", new int[]{176, 224, 230});
        namesToColors.put("purple", new int[]{128, 0, 128});
        namesToColors.put("rebeccapurple", new int[]{102, 51, 153});
        namesToColors.put("red", new int[]{255, 0, 0});
        namesToColors.put("rosybrown", new int[]{188, 143, 143});
        namesToColors.put("royalblue", new int[]{65, 105, 225});
        namesToColors.put("saddlebrown", new int[]{139, 69, 19});
        namesToColors.put("salmon", new int[]{250, 128, 114});
        namesToColors.put("sandybrown", new int[]{244, 164, 96});
        namesToColors.put("seagreen", new int[]{46, 139, 87});
        namesToColors.put("seashell", new int[]{255, 245, 238});
        namesToColors.put("sienna", new int[]{160, 82, 45});
        namesToColors.put("silver", new int[]{192, 192, 192});
        namesToColors.put("skyblue", new int[]{135, 206, 235});
        namesToColors.put("slateblue", new int[]{106, 90, 205});
        namesToColors.put("slategray", new int[]{112, 128, 144});
        namesToColors.put("snow", new int[]{255, 250, 250});
        namesToColors.put("springgreen", new int[]{0, 255, 127});
        namesToColors.put("steelblue", new int[]{70, 130, 180});
        namesToColors.put("tan", new int[]{210, 180, 140});
        namesToColors.put("teal", new int[]{0, 128, 128});
        namesToColors.put("thistle", new int[]{216, 191, 216});
        namesToColors.put("tomato", new int[]{255, 99, 71});
        namesToColors.put("turquoise", new int[]{64, 224, 208});
        namesToColors.put("violet", new int[]{238, 130, 238});
        namesToColors.put("wheat", new int[]{245, 222, 179});
        namesToColors.put("white", new int[]{255, 255, 255});
        namesToColors.put("whitesmoke", new int[]{245, 245, 245});
        namesToColors.put("yellow", new int[]{255, 255, 0});
        namesToColors.put("yellowgreen", new int[]{154, 205, 50});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextType {
        AZLetters{

            public boolean acceptCharacter(char c) {
                return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
            }
        }
        ,
        AZLettersDigits{

            public boolean acceptCharacter(char c) {
                return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c);
            }
        }
        ,
        Digits{

            public boolean acceptCharacter(char c) {
                return Character.isDigit(c);
            }
        }
        ,
        FromFirstLetter{

            public boolean isStartCharacter(char c) {
                return Character.isLetter(c);
            }
        }
        ,
        Letters{

            public boolean acceptCharacter(char c) {
                return Character.isLetter(c);
            }
        }
        ,
        LettersDigits{

            public boolean acceptCharacter(char c) {
                return Character.isLetter(c) || Character.isDigit(c);
            }
        }
        ,
        LettersDigitsSpace{

            public boolean acceptCharacter(char c) {
                return Character.isLetter(c) || Character.isDigit(c) || Character.isSpaceChar(c);
            }
        }
        ,
        LettersDigitsWhitespace{

            public boolean acceptCharacter(char c) {
                return Character.isLetter(c) || Character.isDigit(c) || Character.isWhitespace(c);
            }
        }
        ,
        LowerCase{

            public boolean acceptCharacter(char c) {
                return Character.isLowerCase(c);
            }
        }
        ,
        UpperCase{

            public boolean acceptCharacter(char c) {
                return Character.isUpperCase(c);
            }
        }
        ,
        WithoutLeadingDigits{

            public boolean isStartCharacter(char c) {
                return !Character.isDigit(c);
            }
        };


        public boolean acceptCharacter(char c) {
            return true;
        }

        public boolean isStartCharacter(char c) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterType {
        All,
        Digits,
        DigitsSpecial,
        Letters,
        LettersDigits,
        LettersDigitsSpace,
        LettersDigitsWhitespace,
        LettersSpecial,
        None,
        OnlySpecial,
        OnlyWhitespace;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CaseSensitiveType {
        LowerCase,
        MixedCase,
        NoLetter,
        UpperCase;

    }
}

