/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.log.log4j;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.jdk.JdkLineFormatter;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLogger
implements ILogger {
    private String sLoggerName;
    private Logger log;

    public Log4jLogger(String string) {
        this.sLoggerName = string;
    }

    public String getName() {
        return this.sLoggerName;
    }

    public void setLevel(ILogger.LogLevel logLevel) {
        this.init();
        Level level = this.translate(logLevel);
        this.log.setLevel(level);
        String string = this.sLoggerName + ".";
        Enumeration enumeration = LogManager.getCurrentLoggers();
        while (enumeration.hasMoreElements()) {
            Logger logger = (Logger)enumeration.nextElement();
            if (logger.getName().equals(this.sLoggerName) || !logger.getName().startsWith(string) || logger.getLevel() == null) continue;
            logger.setLevel(level);
        }
    }

    public boolean isLevelSet() {
        this.init();
        return this.log.getLevel() != null;
    }

    public ILogger.LogLevel getLevel() {
        this.init();
        Level level = this.log.getLevel();
        for (Category category = this.log.getParent(); level == null && category != null; category = category.getParent()) {
            level = category.getLevel();
        }
        if (level == null) {
            return ILogger.LogLevel.OFF;
        }
        if (level.equals((Object)Level.OFF)) {
            return ILogger.LogLevel.OFF;
        }
        if (level.equals((Object)Level.ALL)) {
            return ILogger.LogLevel.ALL;
        }
        if (level.equals((Object)Level.TRACE) || level.equals((Object)Level.DEBUG)) {
            return ILogger.LogLevel.DEBUG;
        }
        if (level.equals((Object)Level.INFO) || level.equals((Object)Level.WARN)) {
            return ILogger.LogLevel.INFO;
        }
        if (level.equals((Object)Level.ERROR) || level.equals((Object)Level.FATAL)) {
            return ILogger.LogLevel.ERROR;
        }
        return ILogger.LogLevel.OFF;
    }

    public void debug(Object ... objectArray) {
        this.logWithCaller(Level.DEBUG, objectArray);
    }

    public void info(Object ... objectArray) {
        this.logWithCaller(Level.INFO, objectArray);
    }

    public void error(Object ... objectArray) {
        this.logWithCaller(Level.ERROR, objectArray);
    }

    public boolean isEnabled(ILogger.LogLevel logLevel) {
        this.init();
        return logLevel != ILogger.LogLevel.OFF && this.log.isEnabledFor((Priority)this.translate(logLevel));
    }

    private final void logWithCaller(Level level, Object ... objectArray) {
        this.init();
        this.log.log((Priority)level, (Object)JdkLineFormatter.concat(objectArray));
    }

    private Level translate(ILogger.LogLevel logLevel) {
        if (logLevel == null) {
            return Level.OFF;
        }
        switch (logLevel) {
            case ALL: {
                return Level.ALL;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        return Level.OFF;
    }

    private void init() {
        if (this.log == null) {
            this.log = Logger.getLogger((String)this.sLoggerName);
        }
    }
}

