/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl;

import com.sibvisions.rad.ui.ApplicationUtil;
import com.sibvisions.rad.ui.Webstart;
import com.sibvisions.rad.ui.awt.impl.AwtFactory;
import com.sibvisions.rad.ui.swing.impl.FileChooser;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import com.sibvisions.rad.ui.swing.impl.container.SwingFrame;
import com.sibvisions.util.FileViewer;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.ExceptionUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.xml.XmlNode;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.rad.application.IApplication;
import javax.rad.application.IFileHandleReceiver;
import javax.rad.application.ILauncher;
import javax.rad.application.genui.UILauncher;
import javax.rad.genui.UIFactoryManager;
import javax.rad.io.FileHandle;
import javax.rad.io.IFileHandle;
import javax.rad.ui.IComponent;
import javax.rad.ui.IRectangle;
import javax.rad.ui.UIException;
import javax.rad.ui.event.UIWindowEvent;
import javax.rad.util.ExceptionHandler;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SwingApplication
extends SwingFrame
implements ILauncher {
    public static final String PROPERTY_APPLICATION = "application";
    private static final String CONFIG_ROOT_NODE = "application";
    private UILauncher uilauncher;
    private IApplication application = null;
    private XmlNode xmnAppConfig = null;
    private Hashtable<String, Object> htCachedObjects = null;
    private FileChooser fileChooser = null;
    private JFrame jfMax;
    private boolean bSystemExitOnDispose = true;

    public static void main(String[] stringArray) {
        String[] stringArray2;
        String string;
        if (stringArray.length == 0) {
            throw new UIException("No class name parameter found!");
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith("\"") || !stringArray[i].endsWith("\"")) continue;
            stringArray[i] = stringArray[i].substring(1, stringArray[i].length() - 1);
        }
        String string2 = stringArray[0];
        if (stringArray.length >= 2) {
            string = stringArray[1];
            stringArray2 = new String[stringArray.length - 2];
            System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
        } else {
            string = "application.xml";
            stringArray2 = null;
        }
        SwingApplication.createSwingApplication(string2, string, stringArray2);
    }

    public static SwingApplication createSwingApplication() {
        final SwingApplication[] swingApplicationArray = new SwingApplication[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    swingApplicationArray[0] = new SwingApplication();
                }
            });
        }
        catch (Exception exception) {
            throw new IllegalStateException("SwingApplication cannot be created!", ExceptionUtil.getRootCause(exception));
        }
        return swingApplicationArray[0];
    }

    public static SwingApplication createSwingApplication(final String string, final String string2, final String[] stringArray) {
        final SwingApplication[] swingApplicationArray = new SwingApplication[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    swingApplicationArray[0] = new SwingApplication(string, string2, stringArray);
                }
            });
        }
        catch (Exception exception) {
            throw new IllegalStateException("SwingApplication cannot be created!", ExceptionUtil.getRootCause(exception));
        }
        return swingApplicationArray[0];
    }

    public SwingApplication() {
    }

    public SwingApplication(String string, String string2, String[] stringArray) {
        this.startup(string, string2, stringArray);
    }

    public void startup(final String string, final String string2, final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingApplication.this.startupInternal(string, string2, stringArray);
            }
        });
    }

    private void startupInternal(String string, String string2, String[] stringArray) {
        int n;
        Class clazz;
        this.loadConfiguration(string2);
        Locale locale = Locale.getDefault();
        this.setParameter("client.locale.language", locale.getLanguage());
        this.setParameter("client.locale.country", locale.getCountry());
        this.setParameter("client.locale.variant", locale.getVariant());
        try {
            this.setParameter("client.file.encoding", System.getProperty("file.encoding"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateConfiguration(stringArray);
        LoggerFactory.init(this.getParameter("Launcher.logfactory"));
        try {
            clazz = Class.forName(this.getParameter("Launcher.uifactory"));
        }
        catch (Exception exception) {
            clazz = SwingFactory.class;
            LoggerFactory.getInstance(SwingApplication.class).debug("Fallback to SwingFactory", exception);
        }
        this.setFactory(UIFactoryManager.getFactoryInstance(clazz));
        SwingFactory.setLookAndFeel(this, this.getParameter("Application.LookAndFeel"));
        this.uilauncher = new UILauncher(this);
        if (this.htCachedObjects != null) {
            for (Map.Entry<String, Object> entry : this.htCachedObjects.entrySet()) {
                this.uilauncher.putObject(entry.getKey(), entry.getValue());
            }
            this.htCachedObjects = null;
        }
        try {
            this.application = ApplicationUtil.createApplication(this.uilauncher, string);
            this.uilauncher.setTitle(this.application.getName());
            this.uilauncher.add((IComponent)this.application, "Center");
            ((JFrame)this.resource).getRootPane().putClientProperty("application", this.application);
            this.uilauncher.pack();
        }
        catch (Throwable throwable) {
            this.getModalDesktopPane().setPreferredSize(new Dimension(800, 600));
            this.uilauncher.pack();
            this.uilauncher.handleException(throwable);
        }
        if (this.eventWindowClosing == null || this.eventWindowClosing.getDefaultListener() == null) {
            this.eventWindowClosing().setDefaultListener(this, "dispose");
        }
        if ((n = this.getState()) == 6 || n == 2 || n == 4) {
            this.setState(n);
        }
        if (!ApplicationUtil.configureFrameBounds(this, (Frame)this.resource)) {
            ((JFrame)this.resource).setLocationRelativeTo(null);
        }
        this.uilauncher.setVisible(true);
        if (this.application != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingApplication.this.application.notifyVisible();
                }
            });
        }
    }

    public void dispose() {
        if (this.application != null) {
            try {
                this.application.notifyDestroy();
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(this.getClass()).info("Forced application destroy failed", exception);
            }
        }
        Rectangle rectangle = ((JFrame)this.resource).getBounds();
        int n = ((JFrame)this.resource).getExtendedState();
        this.setRegistryKey("framebounds", rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
        this.setRegistryKey("maximized", "" + (n == 6 || n == 2 || n == 4));
        super.dispose();
        if (this.bSystemExitOnDispose) {
            if (this.eventWindowClosed != null) {
                this.eventWindowClosed.dispatchEvent(new UIWindowEvent(this.eventSource, 202, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
            }
            System.exit(0);
        }
    }

    public String getParameter(String string) {
        XmlNode xmlNode = this.xmnAppConfig.getNode(string);
        if (xmlNode != null) {
            String string2 = ApplicationUtil.replaceParameter(xmlNode.getValue(), this);
            if (string2 != null) {
                string2 = string2.replace("\\n", "\n");
                string2 = string2.replace("<br>", "\n");
            }
            return string2;
        }
        return null;
    }

    public void setParameter(String string, String string2) {
        this.xmnAppConfig.setNode(string, string2);
    }

    public void showDocument(String string, IRectangle iRectangle, String string2) throws Throwable {
        try {
            FileViewer.open(string);
        }
        catch (Exception exception) {
            if (Webstart.isJnlp()) {
                Webstart.showDocument(string);
            }
            throw exception;
        }
    }

    public void showFileHandle(IFileHandle iFileHandle, IRectangle iRectangle, String string) throws Throwable {
        try {
            File file = null;
            if (iFileHandle instanceof FileHandle) {
                file = ((FileHandle)iFileHandle).getFile();
            }
            if (file == null) {
                file = FileUtil.getNotExistingFile(new File(System.getProperty("java.io.tmpdir"), iFileHandle.getFileName()));
                file.deleteOnExit();
                FileUtil.copy(iFileHandle.getInputStream(), true, new FileOutputStream(file), true);
            }
            FileViewer.open(file);
        }
        catch (Throwable throwable) {
            if (Webstart.isJnlp()) {
                Webstart.showSaveDialog(iFileHandle);
            }
            throw throwable;
        }
    }

    public void showFileHandle(IFileHandle iFileHandle) throws Throwable {
        this.showFileHandle(iFileHandle, null, "_blank");
    }

    public void saveFileHandle(IFileHandle iFileHandle, String string) throws Throwable {
        try {
            if (this.fileChooser == null) {
                this.fileChooser = new FileChooser();
            }
            this.fileChooser.saveAs(this.uilauncher, (Frame)this.resource, iFileHandle, string);
        }
        catch (SecurityException securityException) {
            if (Webstart.isJnlp()) {
                Webstart.showSaveDialog(iFileHandle);
            }
            throw securityException;
        }
    }

    public void getFileHandle(final IFileHandleReceiver iFileHandleReceiver, String string) throws Throwable {
        IFileHandle[] iFileHandleArray = null;
        try {
            if (this.fileChooser == null) {
                this.fileChooser = new FileChooser();
            }
            iFileHandleArray = this.fileChooser.open(this.uilauncher, (Frame)this.resource, string);
        }
        catch (SecurityException securityException) {
            if (Webstart.isJnlp()) {
                iFileHandleArray = Webstart.showOpenDialog(true);
            }
            throw securityException;
        }
        if (iFileHandleArray != null) {
            final IFileHandle[] iFileHandleArray2 = iFileHandleArray;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        for (int i = 0; i < iFileHandleArray2.length; ++i) {
                            iFileHandleReceiver.receiveFileHandle(iFileHandleArray2[i]);
                        }
                    }
                    catch (Throwable throwable) {
                        ExceptionHandler.show(throwable);
                    }
                }
            });
        }
    }

    public void cancelPendingThreads() {
    }

    public void setRegistryKey(String string, String string2) {
        block2: {
            try {
                ApplicationUtil.setRegistryKey(ApplicationUtil.getRegistryApplicationName(this), string, string2);
            }
            catch (SecurityException securityException) {
                if (!Webstart.isJnlp()) break block2;
                Webstart.setProperty(string, string2);
            }
        }
    }

    public String getRegistryKey(String string) {
        try {
            return ApplicationUtil.getRegistryKey(ApplicationUtil.getRegistryApplicationName(this), string);
        }
        catch (SecurityException securityException) {
            if (Webstart.isJnlp()) {
                return Webstart.getProperty(string);
            }
            return null;
        }
    }

    public String getEnvironmentName() {
        return "DESKTOP";
    }

    public void handleException(Throwable throwable) {
        SwingFactory.showError(throwable, this.getModalDesktopPane());
    }

    private void loadConfiguration(String string) {
        if (string != null && string.trim().length() > 0) {
            try {
                this.xmnAppConfig = ApplicationUtil.getConfig(string);
                if (this.xmnAppConfig != null) {
                    this.xmnAppConfig = this.xmnAppConfig.getNode("application");
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(this.getClass()).error("Configuration load error!", exception);
            }
        }
        if (this.xmnAppConfig == null) {
            this.xmnAppConfig = new XmlNode("application");
            LoggerFactory.getInstance(this.getClass()).error("Configuration was not found -> empty configuration was created!");
        }
    }

    private void updateConfiguration(String[] stringArray) {
        Object object;
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object = new StringTokenizer(stringArray[i], "=");
                if (((StringTokenizer)object).countTokens() != 2) continue;
                this.xmnAppConfig.setNode(((StringTokenizer)object).nextToken(), ((StringTokenizer)object).nextToken());
            }
        }
        if (Webstart.isJnlp()) {
            try {
                object = Webstart.getCodeBase();
                if (object != null) {
                    this.xmnAppConfig.setNode("Launcher.codebase", object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public IApplication getApplication() {
        return this.application;
    }

    public Object putObject(String string, Object object) {
        if (this.uilauncher != null) {
            return this.uilauncher.putObject(string, object);
        }
        if (object != null) {
            if (this.htCachedObjects == null) {
                this.htCachedObjects = new Hashtable();
            }
            this.htCachedObjects.put(string, object);
        } else if (this.htCachedObjects != null) {
            Object object2 = this.htCachedObjects.remove(string);
            if (this.htCachedObjects.isEmpty()) {
                this.htCachedObjects = null;
            }
            return object2;
        }
        return null;
    }

    public Object getObject(String string) {
        if (this.uilauncher != null) {
            return this.uilauncher.getObject(string);
        }
        if (this.htCachedObjects != null) {
            return this.htCachedObjects.get(string);
        }
        return null;
    }

    public void setSystemExitOnDispose(boolean bl) {
        this.bSystemExitOnDispose = bl;
    }

    public boolean isSystemExitOnDispose() {
        return this.bSystemExitOnDispose;
    }

    public void setFullScreen(boolean bl) {
        if (bl) {
            if (this.jfMax == null) {
                this.jfMax = new JFrame();
                this.jfMax.setDefaultCloseOperation(0);
                this.jfMax.setUndecorated(true);
                this.jfMax.setExtendedState(6);
                this.jfMax.setContentPane(((JFrame)this.resource).getContentPane());
                this.jfMax.setIconImage(((JFrame)this.resource).getIconImage());
                this.jfMax.setTitle(((JFrame)this.resource).getTitle());
                ((JFrame)this.resource).setVisible(false);
                this.jfMax.setVisible(true);
            }
        } else {
            ((JFrame)this.resource).setContentPane(this.jfMax.getContentPane());
            this.jfMax.setVisible(false);
            this.jfMax.dispose();
            this.jfMax = null;
            ((JFrame)this.resource).setVisible(true);
        }
    }

    public boolean isFullScreen() {
        return this.jfMax != null;
    }

    static {
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            System.setProperty("sun.java2d.d3d", "false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

