/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.ApplicationUtil;
import com.sibvisions.rad.ui.swing.ext.fonts.FontAwesome;
import com.sibvisions.util.type.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class JVxFontAwesomeIcon
extends ImageIcon {
    private static final Font BASEFONT;
    private BufferedImage buffer;
    private FontAwesome faIconDefinition;
    private Font font;
    private Color color;
    private int size;
    private int width;
    private int height;

    public JVxFontAwesomeIcon(FontAwesome fontAwesome) {
        this.size = 16;
        this.init();
    }

    public JVxFontAwesomeIcon(String string) {
        this.parse(string);
        this.init();
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.buffer == null) {
            this.buffer = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setFont(this.font);
            graphics2D.setPaint(this.color);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
            int n3 = (this.buffer.getWidth() - fontMetrics.stringWidth(String.valueOf(this.faIconDefinition.getCode()))) / 2;
            int n4 = (this.buffer.getHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics2D.drawString(String.valueOf(this.faIconDefinition.getCode()), n3, n4);
            graphics2D.dispose();
        }
        graphics.drawImage(this.buffer, n, n2, null);
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public Image getImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void init() {
        this.font = BASEFONT.deriveFont(0, this.size);
        BufferedImage bufferedImage = new BufferedImage(this.size, this.size, 2);
        Graphics2D graphics2D = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(bufferedImage);
        graphics2D.setFont(this.font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout("" + this.faIconDefinition.getCode(), this.font, fontRenderContext);
        Rectangle rectangle = textLayout.getPixelBounds(fontRenderContext, 0.0f, 0.0f);
        this.width = Math.max(this.size, rectangle.width);
        this.height = Math.max(this.size, rectangle.height + 1);
        graphics2D.dispose();
        this.buffer = null;
    }

    private void parse(String string) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Invalid icon definition: " + string);
        }
        HashMap<String, String> hashMap = ApplicationUtil.splitImageProperties(string);
        this.faIconDefinition = FontAwesome.resolve(hashMap.get("name"));
        String string2 = hashMap.get("size");
        if (string2 == null && (string2 = hashMap.get("font-size")) == null) {
            string2 = "16";
        }
        try {
            this.size = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string2 = StringUtil.getText(string2, '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ',', '.');
        }
        this.size = Integer.parseInt(string2);
        String string3 = hashMap.get("color");
        int[] nArray = StringUtil.parseColor(string3);
        if (nArray != null) {
            this.color = nArray.length == 3 ? new Color(nArray[0], nArray[1], nArray[2]) : new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        if (this.color == null) {
            this.color = Color.BLACK;
        }
    }

    public void setSize(int n) {
        this.size = n;
        this.init();
    }

    public int getSize() {
        return this.size;
    }

    public void setColor(Color color) {
        this.color = color;
        this.buffer = null;
    }

    public Color getColor() {
        return this.color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            InputStream inputStream = JVxFontAwesomeIcon.class.getResourceAsStream("/com/sibvisions/rad/ui/swing/ext/fonts/fontawesome-webfont.ttf");
            try {
                BASEFONT = Font.createFont(0, inputStream);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(BASEFONT);
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            {
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

