/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.celleditor;

import com.sibvisions.rad.ui.celleditor.AbstractComboCellEditor;
import com.sibvisions.util.type.CommonUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.rad.model.ColumnView;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.ui.IDimension;
import javax.rad.ui.celleditor.ILinkedCellEditor;

public abstract class AbstractLinkedCellEditor
extends AbstractComboCellEditor
implements ILinkedCellEditor {
    protected boolean autoTableHeaderVisibility = true;
    protected ICondition additionalCondition;
    protected ColumnView columnView;
    protected String displayReferencedColumnName = null;
    protected ReferenceDefinition linkReference;
    protected IDimension popupSize;
    protected ColumnMapping searchColumnMapping;
    protected boolean searchTextAnywhere = true;
    protected boolean sortByColumnName;
    protected boolean tableHeaderVisible = false;
    protected boolean tableReadOnly = true;
    protected boolean validationEnabled = true;
    private Map<String, Integer> displayValueCache = new HashMap<String, Integer>();
    private String lastColumnForSearch = null;
    private String lastDisplayColumn = null;
    private WeakReference<IDataPage> lastPageForSearch = null;
    private int lastSearchRow = 0;

    protected AbstractLinkedCellEditor() {
    }

    public ICondition getAdditionalCondition() {
        return this.additionalCondition;
    }

    public ColumnView getColumnView() {
        return this.columnView;
    }

    public String getDisplayReferencedColumnName() {
        return this.displayReferencedColumnName;
    }

    public ReferenceDefinition getLinkReference() {
        return this.linkReference;
    }

    public IDimension getPopupSize() {
        return this.popupSize;
    }

    public ColumnMapping getSearchColumnMapping() {
        return this.searchColumnMapping;
    }

    public boolean isSearchTextAnywhere() {
        return this.searchTextAnywhere;
    }

    public boolean isSortByColumnName() {
        return this.sortByColumnName;
    }

    public boolean isTableHeaderVisible() {
        return this.tableHeaderVisible;
    }

    public boolean isTableReadonly() {
        return this.tableReadOnly;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setAdditionalCondition(ICondition iCondition) {
        this.additionalCondition = iCondition;
    }

    public void setColumnView(ColumnView columnView) {
        this.columnView = columnView;
    }

    public void setDisplayReferencedColumnName(String string) {
        this.displayReferencedColumnName = string;
    }

    public void setLinkReference(ReferenceDefinition referenceDefinition) {
        this.linkReference = referenceDefinition;
    }

    public void setPopupSize(IDimension iDimension) {
        this.popupSize = iDimension;
    }

    public void setSearchColumnMapping(ColumnMapping columnMapping) {
        this.searchColumnMapping = columnMapping;
    }

    public void setSearchTextAnywhere(boolean bl) {
        this.searchTextAnywhere = bl;
    }

    public void setSortByColumnName(boolean bl) {
        this.sortByColumnName = bl;
    }

    public void setTableHeaderVisible(boolean bl) {
        this.autoTableHeaderVisibility = false;
        this.tableHeaderVisible = bl;
    }

    public void setTableReadonly(boolean bl) {
        this.tableReadOnly = bl;
    }

    public void setValidationEnabled(boolean bl) {
        this.validationEnabled = bl;
    }

    public boolean isDirectCellEditor() {
        return false;
    }

    protected String getDisplayValue(IDataRow iDataRow, String string) throws ModelException {
        IDataType iDataType = iDataRow.getRowDefinition().getColumnDefinition(string).getDataType();
        Object object = iDataRow.getValue(string);
        String string2 = iDataType.convertToString(object);
        if (this.displayReferencedColumnName != null && this.linkReference != null) {
            Object object2;
            Integer n = this.displayValueCache.get(string2);
            IDataBook iDataBook = this.linkReference.getReferencedDataBook();
            IDataPage iDataPage = iDataBook.getDataPage();
            String string3 = this.linkReference.getReferencedColumnName(string);
            IDataType iDataType2 = iDataBook.getRowDefinition().getColumnDefinition(string3).getDataType();
            IChangeableDataRow iChangeableDataRow = null;
            String string4 = null;
            if (iDataBook.getFilter() != null) {
                iDataBook.setFilter(null);
            }
            if (n != null && (iChangeableDataRow = iDataBook.getDataRow(n)) != null) {
                object2 = iChangeableDataRow.getValue(string3);
                try {
                    string4 = iDataType.convertToString(iDataType.convertToTypeClass(object2));
                }
                catch (Exception exception) {
                    string4 = iDataType2.convertToString(object2);
                }
            }
            if (!(this.lastPageForSearch != null && this.lastPageForSearch.get() == iDataPage && CommonUtil.equals(string3, this.lastColumnForSearch) && CommonUtil.equals(this.displayReferencedColumnName, this.lastDisplayColumn) && (n == null || iChangeableDataRow != null && CommonUtil.equals(string2, string4)))) {
                this.displayValueCache.clear();
                this.lastPageForSearch = new WeakReference<IDataPage>(iDataPage);
                this.lastColumnForSearch = string3;
                this.lastDisplayColumn = this.displayReferencedColumnName;
                this.lastSearchRow = 0;
                n = null;
            }
            if (n == null) {
                if (iDataBook.getFilter() != null) {
                    iDataBook.setFilter(null);
                }
                iChangeableDataRow = iDataBook.getDataRow(this.lastSearchRow);
                while (iChangeableDataRow != null) {
                    object2 = iChangeableDataRow.getValue(string3);
                    try {
                        string4 = iDataType.convertToString(iDataType.convertToTypeClass(object2));
                    }
                    catch (Exception exception) {
                        string4 = iDataType2.convertToString(object2);
                    }
                    String string5 = iChangeableDataRow.getValueAsString(this.displayReferencedColumnName);
                    this.displayValueCache.put(string4, this.lastSearchRow);
                    if (CommonUtil.equals(string2, string4)) {
                        if (string5 != null) {
                            return string5;
                        }
                        return string2;
                    }
                    ++this.lastSearchRow;
                    iChangeableDataRow = iDataBook.getDataRow(this.lastSearchRow);
                }
            } else if (iChangeableDataRow != null && (object2 = iChangeableDataRow.getValueAsString(this.displayReferencedColumnName)) != null) {
                return object2;
            }
        }
        return string2;
    }
}

