/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.naming.InitialContext;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

public class XmlSecurityManager
extends AbstractSecurityManager {
    private XmlNode xmnUsers = null;
    private File fiUsers = null;
    private boolean bVirtual = false;

    public synchronized void validateAuthentication(ISession iSession) throws Exception {
        this.getAuthenticatedUserNode(iSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void changePassword(ISession iSession) throws Exception {
        if (this.bVirtual) {
            throw new SecurityException("Can't change password because the user file was loaded as virtual resource!");
        }
        String string = (String)iSession.getProperty("client.oldpassword");
        String string2 = (String)iSession.getProperty("client.newpassword");
        IConfiguration iConfiguration = iSession.getConfig();
        this.validatePassword(iSession, string, string2);
        XmlNode xmlNode = this.getAuthenticatedUserNode(iSession);
        if (!this.comparePassword(iConfiguration, string, xmlNode.getNode("/password").getValue())) throw new SecurityException("Invalid password for '" + iSession.getUserName() + "' and application '" + iSession.getApplicationName() + "'");
        xmlNode.setNode("/password", XmlSecurityManager.getEncryptedPassword(iConfiguration, string2));
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(this.fiUsers);
        XmlWorker xmlWorker = new XmlWorker();
        xmlWorker.write(fileOutputStream, this.xmnUsers);
        Object var9_9 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Throwable throwable) {
                xmlNode.setNode("/password", XmlSecurityManager.getEncryptedPassword(iConfiguration, string));
                Object var9_10 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized void logout(ISession iSession) {
    }

    public synchronized IAccessController getAccessController(ISession iSession) {
        return null;
    }

    public synchronized void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsers(ISession iSession) throws Exception {
        if (this.xmnUsers == null) {
            Object object;
            IConfiguration iConfiguration = iSession.getConfig();
            String string = iConfiguration.getProperty("/application/securitymanager/userfile");
            if (string == null) {
                throw new SecurityException("Parameter 'userfile' is missing for application '" + iSession.getApplicationName() + "'");
            }
            File file = new File(string);
            InputStream inputStream = null;
            if (!file.exists()) {
                object = Configuration.getApplicationZone(iSession.getApplicationName());
                file = new File(((Zone)object).getDirectory(), string);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                } else {
                    try {
                        InitialContext initialContext = new InitialContext();
                        try {
                            Object object2 = initialContext.lookup(string);
                            if (object2 instanceof String) {
                                inputStream = ResourceUtil.getResourceAsStream((String)object2);
                                if (inputStream == null) {
                                    try {
                                        inputStream = new URL((String)object2).openStream();
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        // empty catch block
                                    }
                                }
                                if (inputStream == null) {
                                    inputStream = new ByteArrayInputStream(((String)object2).getBytes("UTF-8"));
                                    XmlWorker.readNode(inputStream);
                                    inputStream.reset();
                                }
                            } else if (object2 instanceof URL) {
                                inputStream = ((URL)object2).openStream();
                            } else if (object2 instanceof InputStream) {
                                inputStream = (InputStream)object2;
                            }
                            Object var11_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_12 = null;
                            initialContext.close();
                            throw throwable;
                        }
                        initialContext.close();
                        {
                        }
                    }
                    catch (Exception exception) {
                        LoggerFactory.getInstance(Configuration.class).debug("Couldn't load user file '", string, "' via JNDI!", exception);
                    }
                    if (inputStream == null && Configuration.isSearchClassPath()) {
                        inputStream = ResourceUtil.getResourceAsStream("/rad/apps/" + iSession.getApplicationName() + "/" + string);
                    }
                    this.bVirtual = inputStream != null;
                }
            } else {
                inputStream = new FileInputStream(file);
            }
            if (inputStream == null) {
                throw new SecurityException("Userfile '" + string + "' doesn't exist!");
            }
            object = new XmlWorker();
            try {
                this.xmnUsers = ((XmlWorker)object).read(inputStream);
                this.fiUsers = file;
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private XmlNode getAuthenticatedUserNode(ISession iSession) throws Exception {
        String string = iSession.getUserName();
        if (string != null) {
            this.loadUsers(iSession);
            List<XmlNode> list = this.xmnUsers.getNodes("/users/user");
            IConfiguration iConfiguration = iSession.getConfig();
            for (XmlNode xmlNode : list) {
                if (!string.equals(xmlNode.getNode("/name").getValue())) continue;
                if (this.comparePassword(iConfiguration, iSession.getPassword(), xmlNode.getNode("/password").getValue())) {
                    return xmlNode;
                }
                throw new SecurityException("Invalid password for '" + iSession.getUserName() + "' and application '" + iSession.getApplicationName() + "'");
            }
        }
        throw new SecurityException("User '" + CommonUtil.nvl(string, "<undefined>") + "' was not found for application '" + iSession.getApplicationName() + "'");
    }
}

