/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.DefaultObjectProvider;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.IResponse;
import com.sibvisions.rad.server.Monitoring;
import com.sibvisions.rad.server.ServerContextImpl;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.rad.server.plugin.IServerPlugin;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.io.MagicByteInputStream;
import com.sibvisions.util.io.NonClosingInputStream;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.rad.remote.IConnectionConstants;
import javax.rad.remote.SessionCancelException;
import javax.rad.remote.SessionExpiredException;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.ResultObject;
import javax.rad.server.ServerContext;
import javax.rad.server.event.ISessionListener;
import javax.rad.server.push.IPushReceiver;
import javax.rad.server.push.PushMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IDirectServer {
    private static final Exception EXCEPTION_CONTENT;
    private static final byte[] MAGIC_BYTES;
    private static AtomicInteger aiSequence;
    private ILogger log;
    private static Server instance;
    private DefaultSessionManager sessman = null;
    private AbstractObjectProvider objectprov = null;
    private Monitoring monitoring = null;
    private WeakHashMap<ISession, CachedResponse> whmResponse = new WeakHashMap();
    private HashMap<Object, SerializerInfo> hmpSerializer = new HashMap();
    private String sInitialSystemIdentifier;
    private String sInstanceKey;
    private long lStartupTime = System.currentTimeMillis();

    public Server() {
        Object object;
        this.sInstanceKey = System.getProperty("Server.instanceKey");
        if (StringUtil.isEmpty(this.sInstanceKey)) {
            this.sInstanceKey = Long.toString(this.lStartupTime, 36) + "#" + aiSequence.incrementAndGet();
        }
        Server.initLogging();
        ServerZone serverZone = Configuration.getServerZone();
        this.log = LoggerFactory.getInstance(Server.class);
        try {
            object = serverZone.getProperty("/server/sessionmanager/class");
            this.sessman = (DefaultSessionManager)Reflective.construct((String)object, this);
            this.log.debug("Use ", object, " as SessionManager");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default SessionManager", throwable);
            this.sessman = new DefaultSessionManager(this);
        }
        this.hmpSerializer.put(null, new SerializerInfo(UniversalSerializer.class));
        this.sessman.addSessionListener(new SessionListener(this));
        try {
            object = serverZone.getProperty("/server/sessionmanager/controllerInterval");
            if (!StringUtil.isEmpty((String)object)) {
                DefaultSessionManager.setControllerInterval(Long.parseLong((String)object));
            }
        }
        catch (Throwable throwable) {
            this.log.debug(throwable);
        }
        try {
            object = serverZone.getProperty("/server/objectprovider/class");
            this.objectprov = (AbstractObjectProvider)Reflective.construct((String)object, this);
            this.log.debug("Use ", object, " as ObjectProvider");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default ObjectProvider", throwable);
            this.objectprov = new DefaultObjectProvider(this);
        }
        this.monitoring = new Monitoring(this);
        object = new HashMap();
        try {
            List<XmlNode> list = serverZone.getNodes("/server/plugin");
            if (list != null) {
                Iterator<XmlNode> object2 = list.iterator();
                while (object2.hasNext()) {
                    XmlNode xmlNode = object2.next();
                    String string = xmlNode.getNodeValue("/class");
                    String string2 = xmlNode.getNodeValue("enabled");
                    boolean bl = string2 == null || Boolean.parseBoolean(string2);
                    ((HashMap)object).put(string, bl);
                    if (!bl) continue;
                    try {
                        IServerPlugin iServerPlugin = (IServerPlugin)Reflective.construct(string, new Object[0]);
                        iServerPlugin.install(this);
                    }
                    catch (Throwable throwable) {
                        this.log.error("Can't install plugin '", string, "'", throwable);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.log.debug("Can't access plugin configuration!", exception);
        }
        try {
            for (IServerPlugin iServerPlugin : ServiceLoader.load(IServerPlugin.class)) {
                if (((HashMap)object).containsKey(iServerPlugin.getClass().getName())) continue;
                try {
                    iServerPlugin.install(this);
                }
                catch (Throwable throwable) {
                    this.log.error("Can't install plugin '", iServerPlugin.getClass(), "'", throwable);
                }
            }
        }
        catch (Exception exception) {
            this.log.debug("Loading plugin with ServiceLoader failed!", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Server getInstance() {
        if (instance == null) {
            Server.initLogging();
            try {
                InitialContext initialContext = new InitialContext();
                try {
                    instance = (Server)initialContext.lookup("java:/comp/env/jvx/server");
                }
                finally {
                    initialContext.close();
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(Server.class).debug("Server is not configured as JNDI resource", exception);
            }
            if (instance == null) {
                instance = new Server();
            }
        }
        return instance;
    }

    @Override
    public final DefaultSessionManager getSessionManager() {
        return this.sessman;
    }

    @Override
    public final AbstractObjectProvider getObjectProvider() {
        return this.objectprov;
    }

    /*
     * Loose catch block
     */
    @Override
    public Object createSession(ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Object object;
            long l;
            Object object2;
            Throwable throwable;
            Record record;
            block13: {
                record = ProtocolFactory.openRecord("SERVER", "createSession", new Object[0]);
                throwable = null;
                object2 = null;
                l = System.currentTimeMillis();
                object = object2 = this.createSessionIntern(null, null, changedHashtable);
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block13;
                this.log(null, "direct", "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
            }
            CommonUtil.close(record);
            return object;
            {
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (record != null) {
                                record.setException(throwable2);
                            }
                            throwable = AbstractSecurityManager.prepareException(throwable2);
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                                this.log(null, "direct", "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        CommonUtil.close(record);
                        throw throwable4;
                    }
                }
            }
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object createSubSession(Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Object object2;
            long l;
            Object object3;
            Throwable throwable;
            Record record;
            block13: {
                record = ProtocolFactory.openRecord("SERVER", "createSubSession", new Object[0]);
                throwable = null;
                object3 = null;
                l = System.currentTimeMillis();
                object2 = object3 = this.createSubSessionIntern(null, this.sessman.get(object), changedHashtable);
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block13;
                this.log(object, "direct", "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
            }
            CommonUtil.close(record);
            return object2;
            {
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (record != null) {
                                record.setException(throwable2);
                            }
                            throwable = AbstractSecurityManager.prepareException(throwable2);
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                                this.log(object, "direct", "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        CommonUtil.close(record);
                        throw throwable4;
                    }
                }
            }
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySession(Object object) {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "destroySession", new Object[0]);
            try {
                long l = System.currentTimeMillis();
                try {
                    this.destroySessionIntern(object);
                }
                catch (RuntimeException runtimeException) {
                    if (record != null) {
                        record.setException(runtimeException);
                    }
                    throw runtimeException;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", "Session!", "destroySession", null, null, null, null, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object execute(Object var1_1, String var2_2, String var3_3, Object ... var4_4) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCallBack(Object object, Object object2, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "executeCallBack", string, string2, objectArray);
            try {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, string);
                    Call call = new Call(object2, string, string2, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    if (record != null) {
                        record.setException(throwable2);
                    }
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", string, string2, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCallBack(Object object, ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "executeCallBack", string, string2, objectArray);
            try {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, string);
                    Call call = new Call(iCallBackListener, string, string2, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    if (record != null) {
                        record.setException(throwable2);
                    }
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", string, string2, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object executeAction(Object var1_1, String var2_2, Object ... var3_3) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionCallBack(Object object, Object object2, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "executeActionCallBack", string, objectArray);
            try {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, null);
                    Call call = new Call(object2, null, string, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    if (record != null) {
                        record.setException(throwable2);
                    }
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", null, string, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeActionCallBack(Object object, ICallBackListener iCallBackListener, String string, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record = ProtocolFactory.openRecord("SERVER", "executeActionCallBack", string, objectArray);
            try {
                Throwable throwable = null;
                long l = System.currentTimeMillis();
                try {
                    AbstractSession abstractSession = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession(abstractSession);
                    this.validateCallBack(abstractSession, null);
                    Call call = new Call(iCallBackListener, null, string, objectArray);
                    call.setForceCallBack(true);
                    this.executeIntern(abstractSession, call);
                }
                catch (Throwable throwable2) {
                    if (record != null) {
                        record.setException(throwable2);
                    }
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                finally {
                    if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                        this.log(object, "direct", null, string, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
                    }
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperty(Object object, String string, Object object2) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Throwable throwable = null;
            long l = System.currentTimeMillis();
            try {
                AbstractSession abstractSession = this.sessman.get(object);
                ((ServerContextImpl)serverContext).setSession(abstractSession);
                this.setPropertyIntern(abstractSession, string, object2);
                if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = AbstractSecurityManager.prepareException(throwable2);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                    this.log(object, "direct", "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
                    throw throwable3;
                }
            }
            this.log(object, "direct", "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
            return;
        }
        finally {
            serverContext.release();
        }
    }

    @Override
    public Object getProperty(Object object, String string) throws Throwable {
        Throwable throwable = null;
        Object object2 = null;
        long l = System.currentTimeMillis();
        try {
            object2 = this.getPropertyIntern(this.sessman.get(object), string);
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "getProperty", null, null, object2, throwable, System.currentTimeMillis() - l);
            }
        }
        return object2;
    }

    @Override
    public ChangedHashtable<String, Object> getProperties(Object object) throws Throwable {
        Throwable throwable = null;
        ChangedHashtable<String, Object> changedHashtable = null;
        long l = System.currentTimeMillis();
        try {
            changedHashtable = this.getPropertiesIntern(this.sessman.get(object));
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.log(object, "direct", "Session!", "getProperties", null, null, changedHashtable, throwable, System.currentTimeMillis() - l);
            }
        }
        return changedHashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ResultObject> getCallBackResults(Object object) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Object object2;
            ArrayUtil<ResultObject> arrayUtil;
            block7: {
                Throwable throwable = null;
                arrayUtil = null;
                long l = System.currentTimeMillis();
                try {
                    object2 = this.sessman.get(object);
                    ((ServerContextImpl)serverContext).setSession((ISession)object2);
                    arrayUtil = this.getCallBackResultsIntern((AbstractSession)object2);
                    if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block7;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = AbstractSecurityManager.prepareException(throwable2);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                        this.log(object, "direct", "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
                        throw throwable3;
                    }
                }
                this.log(object, "direct", "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
            }
            object2 = arrayUtil;
            return object2;
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] setAndCheckAlive(Object object, Object ... objectArray) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Object[] objectArray2;
            Throwable throwable = null;
            Object[] objectArray3 = null;
            long l = System.currentTimeMillis();
            try {
                objectArray2 = this.sessman.get(object);
                ((ServerContextImpl)serverContext).setSession((ISession)objectArray2);
                objectArray3 = this.setAndCheckAliveIntern((AbstractSession)objectArray2, objectArray);
            }
            catch (Throwable throwable2) {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            finally {
                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                    this.log(object, "direct", "Session!", "setAndCheckAlive", objectArray, null, objectArray3, throwable, System.currentTimeMillis() - l);
                }
            }
            objectArray2 = objectArray3;
            return objectArray2;
        }
        finally {
            serverContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setNewPassword(Object object, String string, String string2) throws Throwable {
        ServerContext serverContext = this.createServerContextIntern();
        try {
            Record record;
            block10: {
                record = ProtocolFactory.openRecord("SERVER", "setNewPassword", new Object[0]);
                try {
                    Throwable throwable = null;
                    long l = System.currentTimeMillis();
                    try {
                        AbstractSession abstractSession = this.sessman.get(object);
                        ((ServerContextImpl)serverContext).setSession(abstractSession);
                        this.setNewPasswordInternal(abstractSession, string, string2);
                        if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) break block10;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (record != null) {
                                record.setException(throwable2);
                            }
                            throwable = AbstractSecurityManager.prepareException(throwable2);
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (!this.log.isEnabled(ILogger.LogLevel.DEBUG)) throw throwable3;
                            this.log(object, "direct", "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
                            throw throwable3;
                        }
                    }
                    this.log(object, "direct", "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
            }
            CommonUtil.close(record);
            return;
        }
        finally {
            serverContext.release();
        }
    }

    @Override
    public void beforeFirstCall(Object object) {
        if (object != null) {
            AbstractSession abstractSession = object instanceof AbstractSession ? (AbstractSession)object : this.sessman.get(object);
            abstractSession.getCallHandler().fireBeforeFirstCall();
        }
    }

    @Override
    public void afterLastCall(Object object, boolean bl) {
        if (object != null) {
            AbstractSession abstractSession = object instanceof AbstractSession ? (AbstractSession)object : this.sessman.get(object);
            abstractSession.getCallHandler().fireAfterLastCall(bl);
        }
    }

    @Override
    public void registerPushReceiver(Object object, IPushReceiver iPushReceiver) {
        this.sessman.registerPushReceiver(object, iPushReceiver);
    }

    @Override
    public void unregisterPushReceiver(Object object) {
        this.sessman.unregisterPushReceiver(object);
    }

    @Override
    public void push(PushMessage pushMessage) {
        this.sessman.push(pushMessage);
    }

    public String getInstanceKey() {
        return this.sInstanceKey;
    }

    public long getStartupTime() {
        return this.lStartupTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISession process(IRequest var1_1, IResponse var2_2) throws Exception {
        var3_3 = this.createServerContextIntern();
        try {
            block178: {
                block203: {
                    block204: {
                        block201: {
                            block202: {
                                block200: {
                                    block185: {
                                        block194: {
                                            block197: {
                                                block198: {
                                                    block195: {
                                                        block196: {
                                                            block193: {
                                                                block175: {
                                                                    block176: {
                                                                        var4_4 = ProtocolFactory.openRecord("SERVER", "process", new Object[0]);
                                                                        var5_5 = null;
                                                                        try {
                                                                            var8_6 = null;
                                                                            var9_7 = null;
                                                                            var10_8 = null;
                                                                            var12_9 = null;
                                                                            var13_10 = null;
                                                                            var14_11 = null;
                                                                            var15_12 = null;
                                                                            try {
                                                                                var6_13 = var1_1.getInputStream();
                                                                                if (!(var6_13 instanceof BufferedInputStream)) {
                                                                                    var6_13 = new BufferedInputStream(var6_13);
                                                                                }
                                                                                try {
                                                                                    var16_15 = var6_13.read();
                                                                                }
                                                                                catch (SocketException var17_18) {
                                                                                    var2_2.close();
                                                                                    throw var17_18;
                                                                                }
                                                                                if (var16_15 < 0) {
                                                                                    var2_2.close();
                                                                                    throw new SocketException("Client stream is closed!");
                                                                                }
                                                                                var17_19 = (char)var16_15;
                                                                                if (var17_19 != 'A' && var17_19 != 'E') {
                                                                                    throw new IOException("Invalid stream identifier '" + var17_19 + "'");
                                                                                }
                                                                                var18_20 = var6_13.read();
                                                                                if (var18_20 == 2) {
                                                                                    var14_11 = new MagicByteInputStream(new NonClosingInputStream(var6_13), Server.MAGIC_BYTES);
                                                                                    var19_21 = new GZIPInputStream(var14_11);
                                                                                } else {
                                                                                    var19_21 = var6_13;
                                                                                }
                                                                                var20_22 = new DataInputStream(var19_21);
                                                                                var21_23 = null;
                                                                                if (var17_19 == 'A') {
                                                                                    var21_23 = var20_22.readUTF();
                                                                                    var8_6 = (ISerializer)Class.forName(var21_23).newInstance();
                                                                                }
                                                                                if ((var15_12 = var20_22.readUTF()).trim().length() == 0) {
                                                                                    var15_12 = null;
                                                                                }
                                                                                if (var15_12 != null) {
                                                                                    try {
                                                                                        var5_5 = this.sessman.get(var15_12);
                                                                                    }
                                                                                    catch (SessionExpiredException var22_24) {
                                                                                        var23_26 = new SessionCancelException(var22_24.getMessage(), var22_24.getCause());
                                                                                        var23_26.setStackTrace(var22_24.getStackTrace());
                                                                                        this.clearBuffer(var20_22, var15_12);
                                                                                        throw var23_26;
                                                                                    }
                                                                                    var5_5.lock();
                                                                                    ((ServerContextImpl)var3_3).setSession(var5_5);
                                                                                    var8_6 = var5_5.getSerializer();
                                                                                }
                                                                                if (var8_6 == null) {
                                                                                    this.clearBuffer(var20_22, var15_12);
                                                                                    throw new SecurityException("Invalid serializer '" + var21_23 + "'");
                                                                                }
                                                                                var22_25 = var8_6.read(var20_22);
                                                                                if (!(var22_25 instanceof String)) ** GOTO lbl539
                                                                                var10_8 = Long.valueOf((String)var22_25);
                                                                                if (var4_4 != null) {
                                                                                    var4_4.setParameter(new Object[]{var15_12, var10_8});
                                                                                }
                                                                                if (var5_5 == null) ** GOTO lbl537
                                                                                var23_27 = this.sessman.getMasterSession(var5_5);
                                                                                var13_10 = this.whmResponse.get(var23_27);
                                                                                if (var13_10 == null) ** GOTO lbl534
                                                                                if (!var13_10.id.equals(var10_8)) ** GOTO lbl515
                                                                                if (var13_10.content == null) {
                                                                                    var24_28 = var13_10;
                                                                                    synchronized (var24_28) {
                                                                                        var13_10.wait(10000L);
                                                                                    }
                                                                                }
                                                                                if (var13_10.content != null) {
                                                                                    this.sendContent(var2_2, var13_10.content);
                                                                                    var24_28 = var5_5;
                                                                                    var38_31 = null;
                                                                                    if (var14_11 == null) break block175;
                                                                                    break block176;
                                                                                }
                                                                                ** GOTO lbl-1000
                                                                            }
                                                                            catch (Throwable var16_16) {
                                                                                if (var16_16 == Server.EXCEPTION_CONTENT) {
                                                                                    throw Server.EXCEPTION_CONTENT;
                                                                                }
                                                                                if (var2_2.isClosed()) {
                                                                                    if (var16_16 instanceof Exception == false) throw new IOException("Unexpected server exception!", var16_16);
                                                                                    throw (Exception)var16_16;
                                                                                }
                                                                                if (var4_4 != null) {
                                                                                    var4_4.setException(var16_16);
                                                                                }
                                                                                this.log.error(new Object[]{var16_16});
                                                                                if (var9_7 == null) {
                                                                                    var9_7 = new ArrayUtil<ResultObject>(1);
                                                                                }
                                                                                var9_7.add(new ResultObject(4, AbstractSecurityManager.prepareException(var16_16)));
                                                                                var38_33 = null;
                                                                                if (var14_11 != null) {
                                                                                    var14_11.close();
                                                                                }
                                                                                try {
                                                                                    var1_1.close();
                                                                                }
                                                                                catch (Throwable var39_37) {
                                                                                    this.log.error(new Object[]{var39_37});
                                                                                }
                                                                                if (var2_2.isClosed()) break block178;
                                                                                var7_41 = new ByteArrayOutputStream();
                                                                                if (var8_6 == null) {
                                                                                    var7_41.write(66);
                                                                                    var7_41.write(1);
                                                                                    var39_37 = new DataOutputStream(var7_41);
                                                                                    try {
                                                                                        var42_55 = var9_7.size();
                                                                                        var43_65 = 0;
                                                                                        for (var41_47 = 0; var41_47 < var42_55 && var43_65 == 0; ++var41_47) {
                                                                                            if (((ResultObject)var9_7.get(var41_47)).getType() != 4) continue;
                                                                                            var40_75 = (Throwable)((ResultObject)var9_7.get(var41_47)).getObject();
                                                                                            if (var40_75 != null) {
                                                                                                var44_87 = var40_75.getStackTrace();
                                                                                                var39_37.writeUTF(var40_75.getClass().getName());
                                                                                                var39_37.writeUTF(CommonUtil.nvl(var40_75.getMessage(), ""));
                                                                                                if (var44_87 != null) {
                                                                                                    var39_37.write(var44_87.length);
                                                                                                    var46_105 = var44_87.length;
                                                                                                    for (var45_99 = 0; var45_99 < var46_105; ++var45_99) {
                                                                                                        var39_37.writeUTF(CommonUtil.nvl(var44_87[var45_99].getClassName(), ""));
                                                                                                        var39_37.writeUTF(CommonUtil.nvl(var44_87[var45_99].getMethodName(), ""));
                                                                                                        var39_37.writeUTF(CommonUtil.nvl(var44_87[var45_99].getFileName(), ""));
                                                                                                        var39_37.writeInt(var44_87[var45_99].getLineNumber());
                                                                                                    }
                                                                                                } else {
                                                                                                    var39_37.write(0);
                                                                                                }
                                                                                            } else {
                                                                                                var39_37.writeUTF("");
                                                                                            }
                                                                                            ++var43_65;
                                                                                        }
                                                                                        var48_111 = null;
                                                                                    }
                                                                                    catch (Throwable var47_117) {
                                                                                        var48_112 = null;
                                                                                        var39_37.flush();
                                                                                        throw var47_117;
                                                                                    }
                                                                                    var39_37.flush();
                                                                                } else {
                                                                                    var39_37 = null;
                                                                                    var40_76 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                                                                    if (var40_76 != null && var40_76.size() > 0) {
                                                                                        var41_48 = new ArrayUtil<E>(var40_76.size());
                                                                                        for (Object var43_66 : var40_76) {
                                                                                            var41_48.add(new Object[]{var43_66.getKey(), var43_66.getValue()});
                                                                                            var2_2.setProperty((String)var43_66.getKey(), var43_66.getValue());
                                                                                        }
                                                                                        if (var39_37 == null) {
                                                                                            var39_37 = new ArrayUtil<E>();
                                                                                        }
                                                                                        var39_37.add(new ResultObject(5, var41_48));
                                                                                    }
                                                                                    if (var5_5 != null) {
                                                                                        if (var39_37 == null) {
                                                                                            var39_37 = new ArrayUtil<ResultObject>();
                                                                                        }
                                                                                        if ((var41_48 = this.getCallBackResultsIntern(var5_5)) != null) {
                                                                                            var39_37.addAll(var41_48);
                                                                                        }
                                                                                    }
                                                                                    if (var9_7 != null) {
                                                                                        if (var39_37 == null) {
                                                                                            var39_37 = new ArrayUtil<E>();
                                                                                        }
                                                                                        var39_37.addAll(var9_7);
                                                                                    }
                                                                                    var11_122 = var39_37 != null ? var39_37.size() : 0;
                                                                                    var41_48 = new ByteArrayOutputStream();
                                                                                    var42_56 = new DataOutputStream((OutputStream)var41_48);
                                                                                    try {
                                                                                        var8_6.write((DataOutputStream)var42_56, var11_122);
                                                                                        if (var39_37 != null) {
                                                                                            try {
                                                                                                var45_100 = var39_37.size();
                                                                                                for (var44_88 = 0; var44_88 < var45_100; ++var44_88) {
                                                                                                    var43_66 = (ResultObject)var39_37.get(var44_88);
                                                                                                    var8_6.write((DataOutputStream)var42_56, var43_66.getType());
                                                                                                    var8_6.write((DataOutputStream)var42_56, var43_66.getObject());
                                                                                                    if (var43_66.getType() != 2 && var43_66.getType() != 1 && var43_66.getType() != 6) continue;
                                                                                                    var8_6.write((DataOutputStream)var42_56, var43_66.getCallBackId());
                                                                                                }
                                                                                            }
                                                                                            catch (Exception var44_89) {
                                                                                                var42_56.close();
                                                                                                var41_48 = new ByteArrayOutputStream();
                                                                                                var42_56 = new DataOutputStream((OutputStream)var41_48);
                                                                                                var8_6.write((DataOutputStream)var42_56, var11_122);
                                                                                                var8_6.write((DataOutputStream)var42_56, (byte)4);
                                                                                                var8_6.write((DataOutputStream)var42_56, var44_89);
                                                                                            }
                                                                                        }
                                                                                        var50_128 = null;
                                                                                    }
                                                                                    catch (Throwable var49_134) {
                                                                                        var50_129 = null;
                                                                                        var42_56.close();
                                                                                        throw var49_134;
                                                                                    }
                                                                                    var42_56.close();
                                                                                    var7_41.write(69);
                                                                                    v0 = var43_67 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                                                                    if (var43_67 && var41_48.size() > 256) {
                                                                                        var7_41.write(2);
                                                                                        var44_90 = new GZIPOutputStream(var7_41);
                                                                                        var41_48.writeTo(var44_90);
                                                                                        var44_90.close();
                                                                                        var7_41.write(Server.MAGIC_BYTES);
                                                                                    } else {
                                                                                        var7_41.write(1);
                                                                                        var41_48.writeTo(var7_41);
                                                                                    }
                                                                                }
                                                                                if (var13_10 != null) {
                                                                                    var13_10.content = var7_41;
                                                                                    var39_37 = var13_10;
                                                                                    synchronized (var39_37) {
                                                                                        var13_10.notifyAll();
                                                                                    }
                                                                                } else if (var5_5 != null && var15_12 == null) {
                                                                                    this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_41));
                                                                                }
                                                                                this.sendContent(var2_2, var7_41);
                                                                                break block178;
                                                                            }
                                                                            catch (Throwable var37_163) {
                                                                                block191: {
                                                                                    block192: {
                                                                                        block189: {
                                                                                            block190: {
                                                                                                block188: {
                                                                                                    var38_34 = null;
                                                                                                    if (var14_11 != null) {
                                                                                                        var14_11.close();
                                                                                                    }
                                                                                                    ** try [egrp 15[TRYBLOCK] [19 : 1595->1604)] { 
lbl229:
                                                                                                    // 1 sources

                                                                                                    var1_1.close();
                                                                                                    break block188;
lbl231:
                                                                                                    // 1 sources

                                                                                                    catch (Throwable var39_38 /* !! */ ) {
                                                                                                        this.log.error(new Object[]{var39_38 /* !! */ });
                                                                                                    }
                                                                                                }
                                                                                                if (var2_2.isClosed() != false) throw var37_163;
                                                                                                var7_42 = new ByteArrayOutputStream();
                                                                                                if (var8_6 != null) break block189;
                                                                                                var7_42.write(66);
                                                                                                var7_42.write(1);
                                                                                                var39_38 /* !! */  = new DataOutputStream(var7_42);
                                                                                                ** try [egrp 16[TRYBLOCK] [20 : 1671->1918)] { 
lbl241:
                                                                                                // 1 sources

                                                                                                var42_57 = var9_7.size();
                                                                                                var43_68 = 0;
                                                                                                for (var41_49 = 0; var41_49 < var42_57 && var43_68 == 0; ++var41_49) {
                                                                                                    if (((ResultObject)var9_7.get(var41_49)).getType() != 4) continue;
                                                                                                    var40_77 = (Throwable)((ResultObject)var9_7.get(var41_49)).getObject();
                                                                                                    if (var40_77 != null) {
                                                                                                        var44_91 = var40_77.getStackTrace();
                                                                                                        var39_38 /* !! */ .writeUTF(var40_77.getClass().getName());
                                                                                                        var39_38 /* !! */ .writeUTF(CommonUtil.nvl(var40_77.getMessage(), ""));
                                                                                                        if (var44_91 != null) {
                                                                                                            var39_38 /* !! */ .write(var44_91.length);
                                                                                                            var46_106 = var44_91.length;
                                                                                                            for (var45_101 = 0; var45_101 < var46_106; ++var45_101) {
                                                                                                                var39_38 /* !! */ .writeUTF(CommonUtil.nvl(var44_91[var45_101].getClassName(), ""));
                                                                                                                var39_38 /* !! */ .writeUTF(CommonUtil.nvl(var44_91[var45_101].getMethodName(), ""));
                                                                                                                var39_38 /* !! */ .writeUTF(CommonUtil.nvl(var44_91[var45_101].getFileName(), ""));
                                                                                                                var39_38 /* !! */ .writeInt(var44_91[var45_101].getLineNumber());
                                                                                                            }
                                                                                                        } else {
                                                                                                            var39_38 /* !! */ .write(0);
                                                                                                        }
                                                                                                    } else {
                                                                                                        var39_38 /* !! */ .writeUTF("");
                                                                                                    }
                                                                                                    ++var43_68;
                                                                                                }
                                                                                                break block190;
lbl267:
                                                                                                // 1 sources

                                                                                                catch (Throwable var47_118) {
                                                                                                    var48_114 = null;
                                                                                                    var39_38 /* !! */ .flush();
                                                                                                    throw var47_118;
                                                                                                }
                                                                                            }
                                                                                            var48_113 = null;
                                                                                            var39_38 /* !! */ .flush();
                                                                                            break block191;
                                                                                        }
                                                                                        var39_38 /* !! */  = null;
                                                                                        var40_78 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                                                                        if (var40_78 != null && var40_78.size() > 0) {
                                                                                            var41_50 = new ArrayUtil<E>(var40_78.size());
                                                                                            for (Object var43_69 : var40_78) {
                                                                                                var41_50.add(new Object[]{var43_69.getKey(), var43_69.getValue()});
                                                                                                var2_2.setProperty((String)var43_69.getKey(), var43_69.getValue());
                                                                                            }
                                                                                            if (var39_38 /* !! */  == null) {
                                                                                                var39_38 /* !! */  = new ArrayUtil<E>();
                                                                                            }
                                                                                            var39_38 /* !! */ .add(new ResultObject(5, var41_50));
                                                                                        }
                                                                                        if (var5_5 != null) {
                                                                                            if (var39_38 /* !! */  == null) {
                                                                                                var39_38 /* !! */  = new ArrayUtil<ResultObject>();
                                                                                            }
                                                                                            if ((var41_50 = this.getCallBackResultsIntern(var5_5)) != null) {
                                                                                                var39_38 /* !! */ .addAll((Collection<ResultObject>)var41_50);
                                                                                            }
                                                                                        }
                                                                                        if (var9_7 != null) {
                                                                                            if (var39_38 /* !! */  == null) {
                                                                                                var39_38 /* !! */  = new ArrayUtil<E>();
                                                                                            }
                                                                                            var39_38 /* !! */ .addAll(var9_7);
                                                                                        }
                                                                                        var11_123 = var39_38 /* !! */  != null ? var39_38 /* !! */ .size() : 0;
                                                                                        var41_50 = new ByteArrayOutputStream();
                                                                                        var42_58 = new DataOutputStream((OutputStream)var41_50);
                                                                                        ** try [egrp 17[TRYBLOCK] [23 : 2236->2437)] { 
lbl305:
                                                                                        // 1 sources

                                                                                        var8_6.write((DataOutputStream)var42_58, var11_123);
                                                                                        if (var39_38 /* !! */  == null) break block192;
                                                                                        ** try [egrp 18[TRYBLOCK] [22 : 2255->2366)] { 
lbl308:
                                                                                        // 1 sources

                                                                                        var45_102 = var39_38 /* !! */ .size();
                                                                                        for (var44_92 = 0; var44_92 < var45_102; ++var44_92) {
                                                                                            var43_69 = (ResultObject)var39_38 /* !! */ .get(var44_92);
                                                                                            var8_6.write((DataOutputStream)var42_58, var43_69.getType());
                                                                                            var8_6.write((DataOutputStream)var42_58, var43_69.getObject());
                                                                                            if (var43_69.getType() != 2 && var43_69.getType() != 1 && var43_69.getType() != 6) continue;
                                                                                            var8_6.write((DataOutputStream)var42_58, var43_69.getCallBackId());
                                                                                        }
                                                                                        break block192;
lbl317:
                                                                                        // 1 sources

                                                                                        catch (Exception var44_93) {
                                                                                            var42_58.close();
                                                                                            var41_50 = new ByteArrayOutputStream();
                                                                                            var42_58 = new DataOutputStream((OutputStream)var41_50);
                                                                                            var8_6.write((DataOutputStream)var42_58, var11_123);
                                                                                            var8_6.write((DataOutputStream)var42_58, (byte)4);
                                                                                            var8_6.write((DataOutputStream)var42_58, var44_93);
                                                                                        }
                                                                                        break block192;
lbl327:
                                                                                        // 1 sources

                                                                                        catch (Throwable var49_135) {
                                                                                            var50_131 = null;
                                                                                            var42_58.close();
                                                                                            throw var49_135;
                                                                                        }
                                                                                    }
                                                                                    var50_130 = null;
                                                                                    var42_58.close();
                                                                                    var7_42.write(69);
                                                                                    v1 = var43_70 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                                                                    if (var43_70 && var41_50.size() > 256) {
                                                                                        var7_42.write(2);
                                                                                        var44_94 = new GZIPOutputStream(var7_42);
                                                                                        var41_50.writeTo(var44_94);
                                                                                        var44_94.close();
                                                                                        var7_42.write(Server.MAGIC_BYTES);
                                                                                    } else {
                                                                                        var7_42.write(1);
                                                                                        var41_50.writeTo(var7_42);
                                                                                    }
                                                                                }
                                                                                if (var13_10 != null) {
                                                                                    var13_10.content = var7_42;
                                                                                    var39_38 /* !! */  = var13_10;
                                                                                    synchronized (var39_38 /* !! */ ) {
                                                                                        var13_10.notifyAll();
                                                                                    }
                                                                                } else if (var5_5 != null && var15_12 == null) {
                                                                                    this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_42));
                                                                                }
                                                                                this.sendContent(var2_2, var7_42);
                                                                                throw var37_163;
                                                                            }
                                                                        }
                                                                        catch (Exception var6_14) {
                                                                            try {
                                                                                if (var4_4 == null) throw var6_14;
                                                                                var4_4.setException(var6_14);
                                                                                throw var6_14;
                                                                            }
                                                                            catch (Throwable var52_164) {
                                                                                var53_138 = null;
                                                                                if (var5_5 != null) {
                                                                                    var5_5.unlock();
                                                                                }
                                                                                CommonUtil.close(new Object[]{var4_4});
                                                                                throw var52_164;
                                                                            }
                                                                        }
                                                                    }
                                                                    var14_11.close();
                                                                }
                                                                ** try [egrp 15[TRYBLOCK] [19 : 1595->1604)] { 
lbl375:
                                                                // 1 sources

                                                                var1_1.close();
                                                                break block193;
lbl377:
                                                                // 1 sources

                                                                catch (Throwable var39_35) {
                                                                    this.log.error(new Object[]{var39_35});
                                                                }
                                                            }
                                                            if (var2_2.isClosed()) break block194;
                                                            var7_39 = new ByteArrayOutputStream();
                                                            if (var8_6 != null) break block195;
                                                            var7_39.write(66);
                                                            var7_39.write(1);
                                                            var39_35 = new DataOutputStream(var7_39);
                                                            ** try [egrp 16[TRYBLOCK] [20 : 1671->1918)] { 
lbl387:
                                                            // 1 sources

                                                            var42_51 = var9_7.size();
                                                            var43_59 = 0;
                                                            for (var41_43 = 0; var41_43 < var42_51 && var43_59 == 0; ++var41_43) {
                                                                if (((ResultObject)var9_7.get(var41_43)).getType() != 4) continue;
                                                                var40_71 = (Throwable)((ResultObject)var9_7.get(var41_43)).getObject();
                                                                if (var40_71 != null) {
                                                                    var44_79 = var40_71.getStackTrace();
                                                                    var39_35.writeUTF(var40_71.getClass().getName());
                                                                    var39_35.writeUTF(CommonUtil.nvl(var40_71.getMessage(), ""));
                                                                    if (var44_79 != null) {
                                                                        var39_35.write(var44_79.length);
                                                                        var46_103 = var44_79.length;
                                                                        for (var45_95 = 0; var45_95 < var46_103; ++var45_95) {
                                                                            var39_35.writeUTF(CommonUtil.nvl(var44_79[var45_95].getClassName(), ""));
                                                                            var39_35.writeUTF(CommonUtil.nvl(var44_79[var45_95].getMethodName(), ""));
                                                                            var39_35.writeUTF(CommonUtil.nvl(var44_79[var45_95].getFileName(), ""));
                                                                            var39_35.writeInt(var44_79[var45_95].getLineNumber());
                                                                        }
                                                                    } else {
                                                                        var39_35.write(0);
                                                                    }
                                                                } else {
                                                                    var39_35.writeUTF("");
                                                                }
                                                                ++var43_59;
                                                            }
                                                            break block196;
lbl413:
                                                            // 1 sources

                                                            catch (Throwable var47_115) {
                                                                var48_108 = null;
                                                                var39_35.flush();
                                                                throw var47_115;
                                                            }
                                                        }
                                                        var48_107 = null;
                                                        var39_35.flush();
                                                        break block197;
                                                    }
                                                    var39_35 = null;
                                                    var40_72 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                                                    if (var40_72 != null && var40_72.size() > 0) {
                                                        var41_44 = new ArrayUtil<E>(var40_72.size());
                                                        for (Object var43_60 : var40_72) {
                                                            var41_44.add(new Object[]{var43_60.getKey(), var43_60.getValue()});
                                                            var2_2.setProperty((String)var43_60.getKey(), var43_60.getValue());
                                                        }
                                                        if (var39_35 == null) {
                                                            var39_35 = new ArrayUtil<E>();
                                                        }
                                                        var39_35.add(new ResultObject(5, var41_44));
                                                    }
                                                    if (var5_5 != null) {
                                                        if (var39_35 == null) {
                                                            var39_35 = new ArrayUtil<ResultObject>();
                                                        }
                                                        if ((var41_44 = this.getCallBackResultsIntern(var5_5)) != null) {
                                                            var39_35.addAll(var41_44);
                                                        }
                                                    }
                                                    if (var9_7 != null) {
                                                        if (var39_35 == null) {
                                                            var39_35 = new ArrayUtil<E>();
                                                        }
                                                        var39_35.addAll(var9_7);
                                                    }
                                                    var11_119 = var39_35 != null ? var39_35.size() : 0;
                                                    var41_44 = new ByteArrayOutputStream();
                                                    var42_52 = new DataOutputStream((OutputStream)var41_44);
                                                    ** try [egrp 17[TRYBLOCK] [23 : 2236->2437)] { 
lbl451:
                                                    // 1 sources

                                                    var8_6.write((DataOutputStream)var42_52, var11_119);
                                                    if (var39_35 == null) break block198;
                                                    ** try [egrp 18[TRYBLOCK] [22 : 2255->2366)] { 
lbl454:
                                                    // 1 sources

                                                    var45_96 = var39_35.size();
                                                    for (var44_80 = 0; var44_80 < var45_96; ++var44_80) {
                                                        var43_60 = (ResultObject)var39_35.get(var44_80);
                                                        var8_6.write((DataOutputStream)var42_52, var43_60.getType());
                                                        var8_6.write((DataOutputStream)var42_52, var43_60.getObject());
                                                        if (var43_60.getType() != 2 && var43_60.getType() != 1 && var43_60.getType() != 6) continue;
                                                        var8_6.write((DataOutputStream)var42_52, var43_60.getCallBackId());
                                                    }
                                                    break block198;
lbl463:
                                                    // 1 sources

                                                    catch (Exception var44_81) {
                                                        var42_52.close();
                                                        var41_44 = new ByteArrayOutputStream();
                                                        var42_52 = new DataOutputStream((OutputStream)var41_44);
                                                        var8_6.write((DataOutputStream)var42_52, var11_119);
                                                        var8_6.write((DataOutputStream)var42_52, (byte)4);
                                                        var8_6.write((DataOutputStream)var42_52, var44_81);
                                                    }
                                                    break block198;
lbl473:
                                                    // 1 sources

                                                    catch (Throwable var49_132) {
                                                        var50_125 = null;
                                                        var42_52.close();
                                                        throw var49_132;
                                                    }
                                                }
                                                var50_124 = null;
                                                var42_52.close();
                                                var7_39.write(69);
                                                v2 = var43_61 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                                                if (var43_61 && var41_44.size() > 256) {
                                                    var7_39.write(2);
                                                    var44_82 = new GZIPOutputStream(var7_39);
                                                    var41_44.writeTo(var44_82);
                                                    var44_82.close();
                                                    var7_39.write(Server.MAGIC_BYTES);
                                                } else {
                                                    var7_39.write(1);
                                                    var41_44.writeTo(var7_39);
                                                }
                                            }
                                            if (var13_10 != null) {
                                                var13_10.content = var7_39;
                                                var39_35 = var13_10;
                                                synchronized (var39_35) {
                                                    var13_10.notifyAll();
                                                }
                                            } else if (var5_5 != null && var15_12 == null) {
                                                this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_39));
                                            }
                                            this.sendContent(var2_2, var7_39);
                                        }
                                        var53_136 = null;
                                        if (var5_5 != null) {
                                            var5_5.unlock();
                                        }
                                        CommonUtil.close(new Object[]{var4_4});
                                        var55_139 = null;
                                        var3_3.release();
                                        return var24_28;
lbl-1000:
                                        // 1 sources

                                        {
                                            block199: {
                                                var2_2.close();
                                                throw Server.EXCEPTION_CONTENT;
lbl515:
                                                // 1 sources

                                                if (var13_10.id + 1L != var10_8) {
                                                    var11_120 = (Integer)var8_6.read(var20_22);
                                                    var25_142 = null;
                                                    var26_144 = 0;
                                                    while (true) {
                                                        if (var26_144 >= var11_120) {
                                                            if (var4_4 == null) throw new IOException("Invalid communication state! " + (var13_10.id + 1L) + " <> " + var10_8);
                                                            if (var25_142 == null) throw new IOException("Invalid communication state! " + (var13_10.id + 1L) + " <> " + var10_8);
                                                            var4_4.setParameter(var25_142.toArray(new Object[var25_142.size()]));
                                                            throw new IOException("Invalid communication state! " + (var13_10.id + 1L) + " <> " + var10_8);
                                                        }
                                                        var24_29 = (Object[])var8_6.read(var20_22);
                                                        if (var4_4 != null) {
                                                            if (var25_142 == null) {
                                                                var25_142 = new ArrayUtil<Object[]>((E[])new Object[][]{var4_4.getParameter()});
                                                            }
                                                            var25_142.add(var24_29);
                                                        }
                                                        this.error(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var24_29[0], (String)var24_29[1], (Object[])var24_29[2], var24_29[3], null, null, -1L);
                                                        ++var26_144;
                                                    }
                                                }
lbl534:
                                                // 3 sources

                                                var13_10 = new CachedResponse(var10_8);
                                                this.whmResponse.put((ISession)var23_27, (CachedResponse)var13_10);
lbl537:
                                                // 2 sources

                                                var22_25 = var8_6.read(var20_22);
                                                break block199;
lbl539:
                                                // 1 sources

                                                if (var22_25 == null) {
                                                    var22_25 = var8_6.read(var20_22);
                                                }
                                            }
                                            var11_121 = (Integer)var22_25;
                                            var9_7 = new ArrayUtil<E>(var11_121);
                                            var28_146 = false;
                                            var29_147 = false;
                                            try {
                                                for (var30_148 = 0; var30_148 < var11_121; ++var30_148) {
                                                    var26_145 = System.currentTimeMillis();
                                                    var25_143 = (Object[])var8_6.read(var20_22);
                                                    if (!var28_146 && var5_5 != null) {
                                                        try {
                                                            this.beforeFirstCall(var5_5);
                                                            var32_153 = null;
                                                            var28_146 = true;
                                                        }
                                                        catch (Throwable var31_150) {
                                                            var32_153 = null;
                                                            var28_146 = true;
                                                            throw var31_150;
                                                        }
                                                    }
                                                    try {
                                                        if (!(var25_143.length != 4 || var25_143[0] != null && var25_143[0].getClass() != String.class || var25_143[1].getClass() != String.class || var25_143[2] != null && !(var25_143[2] instanceof Object[]))) {
                                                            var23_27 = null;
                                                            var24_30 = null;
                                                            try {
                                                                try {
                                                                    var24_30 = this.process(var1_1, var8_6, var5_5, (String)var25_143[0], (String)var25_143[1], (Object[])var25_143[2], var25_143[3], (ChangedHashtable<String, Object>)var12_9);
                                                                }
                                                                catch (Throwable var31_151) {
                                                                    var23_27 = var31_151;
                                                                    throw var31_151;
                                                                }
                                                                var34_158 = null;
                                                                if (this.log.isEnabled(ILogger.LogLevel.DEBUG)) {
                                                                    this.log(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var25_143[0], (String)var25_143[1], (Object[])var25_143[2], var25_143[3], var24_30, (Throwable)var23_27, System.currentTimeMillis() - var26_145);
                                                                }
                                                            }
                                                            catch (Throwable var33_157) {
                                                                var34_158 = null;
                                                                if (this.log.isEnabled(ILogger.LogLevel.DEBUG) == false) throw var33_157;
                                                                this.log(var5_5 != null ? var5_5.getId() : null, var10_8, (String)var25_143[0], (String)var25_143[1], (Object[])var25_143[2], var25_143[3], var24_30, (Throwable)var23_27, System.currentTimeMillis() - var26_145);
                                                                throw var33_157;
                                                            }
                                                            if ("Session!".equals((String)var25_143[0]) && "setProperty".equals((String)var25_143[1])) {
                                                                var31_149 = (List)var24_30;
                                                                if (var31_149 == null) continue;
                                                                var12_9 = new ChangedHashtable<String, ?>();
                                                                var34_159 = var31_149.size();
                                                                for (var33_156 = 0; var33_156 < var34_159; ++var33_156) {
                                                                    var32_153 = (Object[])var31_149.get(var33_156);
                                                                    var12_9.put((String)var32_153[0], var32_153[1], false);
                                                                }
                                                                continue;
                                                            }
                                                            if (var5_5 == null) {
                                                                var5_5 = this.sessman.get(var24_30);
                                                                var5_5.lock();
                                                            }
                                                            var9_7.add(new ResultObject(3, var24_30));
                                                            continue;
                                                        }
                                                        this.log.debug(new Object[]{"Invalid request parameters!", var25_143});
                                                        throw new SecurityException("Invalid request parameters!");
                                                    }
                                                    catch (Throwable var31_152) {
                                                        try {
                                                            for (var32_154 = var30_148 + 1; var32_154 < var11_121; ++var32_154) {
                                                                var8_6.read(var20_22);
                                                            }
                                                        }
                                                        catch (Throwable var32_155) {
                                                            // empty catch block
                                                        }
                                                        var29_147 = true;
                                                        throw var31_152;
                                                    }
                                                }
                                                var36_160 = null;
                                                if (var28_146) {
                                                    this.afterLastCall(var5_5, var29_147);
                                                }
                                            }
                                            catch (Throwable var35_162) {
                                                var36_161 = null;
                                                if (var28_146 == false) throw var35_162;
                                                this.afterLastCall(var5_5, var29_147);
                                                throw var35_162;
                                            }
                                            var38_32 = null;
                                            if (var14_11 == null) break block185;
                                        }
                                        var14_11.close();
                                    }
                                    ** try [egrp 15[TRYBLOCK] [19 : 1595->1604)] { 
lbl628:
                                    // 1 sources

                                    var1_1.close();
                                    break block200;
lbl630:
                                    // 1 sources

                                    catch (Throwable var39_36) {
                                        this.log.error(new Object[]{var39_36});
                                    }
                                }
                                if (var2_2.isClosed()) break block178;
                                var7_40 = new ByteArrayOutputStream();
                                if (var8_6 != null) break block201;
                                var7_40.write(66);
                                var7_40.write(1);
                                var39_36 = new DataOutputStream(var7_40);
                                ** try [egrp 16[TRYBLOCK] [20 : 1671->1918)] { 
lbl640:
                                // 1 sources

                                var42_53 = var9_7.size();
                                var43_62 = 0;
                                for (var41_45 = 0; var41_45 < var42_53 && var43_62 == 0; ++var41_45) {
                                    if (((ResultObject)var9_7.get(var41_45)).getType() != 4) continue;
                                    var40_73 = (Throwable)((ResultObject)var9_7.get(var41_45)).getObject();
                                    if (var40_73 != null) {
                                        var44_83 = var40_73.getStackTrace();
                                        var39_36.writeUTF(var40_73.getClass().getName());
                                        var39_36.writeUTF(CommonUtil.nvl(var40_73.getMessage(), ""));
                                        if (var44_83 != null) {
                                            var39_36.write(var44_83.length);
                                            var46_104 = var44_83.length;
                                            for (var45_97 = 0; var45_97 < var46_104; ++var45_97) {
                                                var39_36.writeUTF(CommonUtil.nvl(var44_83[var45_97].getClassName(), ""));
                                                var39_36.writeUTF(CommonUtil.nvl(var44_83[var45_97].getMethodName(), ""));
                                                var39_36.writeUTF(CommonUtil.nvl(var44_83[var45_97].getFileName(), ""));
                                                var39_36.writeInt(var44_83[var45_97].getLineNumber());
                                            }
                                        } else {
                                            var39_36.write(0);
                                        }
                                    } else {
                                        var39_36.writeUTF("");
                                    }
                                    ++var43_62;
                                }
                                break block202;
lbl666:
                                // 1 sources

                                catch (Throwable var47_116) {
                                    var48_110 = null;
                                    var39_36.flush();
                                    throw var47_116;
                                }
                            }
                            var48_109 = null;
                            var39_36.flush();
                            break block203;
                        }
                        var39_36 = null;
                        var40_74 = var5_5 != null ? var5_5.getProperties().getChanges(IConnectionConstants.PROPERTY_CLASSES) : (var12_9 != null ? var12_9.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                        if (var40_74 != null && var40_74.size() > 0) {
                            var41_46 = new ArrayUtil<E>(var40_74.size());
                            for (Object var43_63 : var40_74) {
                                var41_46.add(new Object[]{var43_63.getKey(), var43_63.getValue()});
                                var2_2.setProperty((String)var43_63.getKey(), var43_63.getValue());
                            }
                            if (var39_36 == null) {
                                var39_36 = new ArrayUtil<E>();
                            }
                            var39_36.add(new ResultObject(5, var41_46));
                        }
                        if (var5_5 != null) {
                            if (var39_36 == null) {
                                var39_36 = new ArrayUtil<ResultObject>();
                            }
                            if ((var41_46 = this.getCallBackResultsIntern(var5_5)) != null) {
                                var39_36.addAll(var41_46);
                            }
                        }
                        if (var9_7 != null) {
                            if (var39_36 == null) {
                                var39_36 = new ArrayUtil<E>();
                            }
                            var39_36.addAll(var9_7);
                        }
                        var11_121 = var39_36 != null ? var39_36.size() : 0;
                        var41_46 = new ByteArrayOutputStream();
                        var42_54 = new DataOutputStream((OutputStream)var41_46);
                        ** try [egrp 17[TRYBLOCK] [23 : 2236->2437)] { 
lbl704:
                        // 1 sources

                        var8_6.write((DataOutputStream)var42_54, var11_121);
                        if (var39_36 == null) break block204;
                        ** try [egrp 18[TRYBLOCK] [22 : 2255->2366)] { 
lbl707:
                        // 1 sources

                        var45_98 = var39_36.size();
                        for (var44_84 = 0; var44_84 < var45_98; ++var44_84) {
                            var43_63 = (ResultObject)var39_36.get(var44_84);
                            var8_6.write((DataOutputStream)var42_54, var43_63.getType());
                            var8_6.write((DataOutputStream)var42_54, var43_63.getObject());
                            if (var43_63.getType() != 2 && var43_63.getType() != 1 && var43_63.getType() != 6) continue;
                            var8_6.write((DataOutputStream)var42_54, var43_63.getCallBackId());
                        }
                        break block204;
lbl716:
                        // 1 sources

                        catch (Exception var44_85) {
                            var42_54.close();
                            var41_46 = new ByteArrayOutputStream();
                            var42_54 = new DataOutputStream((OutputStream)var41_46);
                            var8_6.write((DataOutputStream)var42_54, var11_121);
                            var8_6.write((DataOutputStream)var42_54, (byte)4);
                            var8_6.write((DataOutputStream)var42_54, var44_85);
                        }
                        break block204;
lbl726:
                        // 1 sources

                        catch (Throwable var49_133) {
                            var50_127 = null;
                            var42_54.close();
                            throw var49_133;
                        }
                    }
                    var50_126 = null;
                    var42_54.close();
                    var7_40.write(69);
                    v3 = var43_64 = var5_5 != null && Boolean.parseBoolean((String)var5_5.getProperties().get("client.session.compression")) != false;
                    if (var43_64 && var41_46.size() > 256) {
                        var7_40.write(2);
                        var44_86 = new GZIPOutputStream(var7_40);
                        var41_46.writeTo(var44_86);
                        var44_86.close();
                        var7_40.write(Server.MAGIC_BYTES);
                    } else {
                        var7_40.write(1);
                        var41_46.writeTo(var7_40);
                    }
                }
                if (var13_10 != null) {
                    var13_10.content = var7_40;
                    var39_36 = var13_10;
                    synchronized (var39_36) {
                        var13_10.notifyAll();
                    }
                } else if (var5_5 != null && var15_12 == null) {
                    this.whmResponse.put(this.sessman.getMasterSession(var5_5), new CachedResponse(var10_8, var7_40));
                }
                this.sendContent(var2_2, var7_40);
            }
            var16_17 = var5_5;
            var53_137 = null;
            if (var5_5 != null) {
                var5_5.unlock();
            }
            CommonUtil.close(new Object[]{var4_4});
        }
        catch (Throwable var54_165) {
            var55_141 = null;
            var3_3.release();
            throw var54_165;
        }
        var55_140 = null;
        var3_3.release();
        return var16_17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContent(IResponse iResponse, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        try {
            OutputStream outputStream = iResponse.getOutputStream();
            byteArrayOutputStream.writeTo(outputStream);
            outputStream.flush();
            Object var5_4 = null;
            iResponse.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            iResponse.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object process(IRequest iRequest, ISerializer iSerializer, AbstractSession abstractSession, String string, String string2, Object[] objectArray, Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        if (object != null) {
            this.validateCallBack(abstractSession, string);
        }
        if (string != null && "Session!".equals(string)) {
            if ("createSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSessionIntern(iRequest, iSerializer, changedHashtable);
            }
            if ("createSubSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSubSessionIntern(iRequest, this.sessman.get(objectArray[0]), changedHashtable);
            }
            if ("setProperty".equals(string2) && abstractSession == null) {
                return (List)objectArray[0];
            }
            if (abstractSession != null) {
                if ("setAndCheckAlive".equals(string2)) {
                    Object[] objectArray2;
                    Record record = ProtocolFactory.openRecord("SERVER", "process", new Object[0]);
                    try {
                        if (record != null) {
                            record.addIdentifier(abstractSession.getId());
                            record.setParameter(objectArray);
                        }
                        objectArray2 = this.setAndCheckAliveIntern(abstractSession, objectArray);
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        CommonUtil.close(record);
                        throw throwable;
                    }
                    CommonUtil.close(record);
                    return objectArray2;
                }
                if ("destroySession".equals(string2)) {
                    this.destroySessionIntern(abstractSession.getId());
                    return null;
                }
                if ("getProperty".equals(string2)) {
                    return this.getPropertyIntern(abstractSession, (String)objectArray[0]);
                }
                if ("getProperties".equals(string2)) {
                    return this.getPropertiesIntern(abstractSession);
                }
                if ("setProperty".equals(string2)) {
                    this.setPropertiesIntern(abstractSession, (List)objectArray[0]);
                    return null;
                }
                if ("setNewPassword".equals(string2)) {
                    this.setNewPasswordInternal(abstractSession, (String)objectArray[0], (String)objectArray[1]);
                    return null;
                }
            }
        }
        return this.executeIntern(abstractSession, new Call(object, string, string2, objectArray));
    }

    private Object executeIntern(AbstractSession abstractSession, Call call) throws Throwable {
        if (abstractSession != null) {
            return abstractSession.execute(call);
        }
        throw new SecurityException("No session for call '" + call.formatMethod() + "'");
    }

    private void validateCallBack(AbstractSession abstractSession, String string) {
        if (abstractSession == null) {
            throw new SecurityException("Call back is not allowed!");
        }
        if (string != null && "Session!".equals(string)) {
            throw new SecurityException("Call back is not allowed!");
        }
    }

    private Object createSessionIntern(IRequest iRequest, ISerializer iSerializer, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSession(iRequest, iSerializer, changedHashtable);
    }

    private Object createSubSessionIntern(IRequest iRequest, AbstractSession abstractSession, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSubSession(iRequest, abstractSession, changedHashtable);
    }

    private void destroySessionIntern(Object object) {
        this.sessman.destroy(object);
    }

    private void setPropertyIntern(AbstractSession abstractSession, String string, Object object) {
        abstractSession.setProperty(string, object);
    }

    private void setPropertiesIntern(AbstractSession abstractSession, List<Object[]> list) {
        abstractSession.setProperties(list);
    }

    private Object getPropertyIntern(AbstractSession abstractSession, String string) {
        Object object = abstractSession.getProperty(string);
        if (object != null) {
            for (int i = 0; i < IConnectionConstants.PROPERTY_CLASSES.length; ++i) {
                if (!IConnectionConstants.PROPERTY_CLASSES[i].isAssignableFrom(object.getClass())) continue;
                return object;
            }
        }
        return null;
    }

    private ChangedHashtable<String, Object> getPropertiesIntern(AbstractSession abstractSession) {
        List list = ((ChangedHashtable)abstractSession.getProperties()).getMapping(IConnectionConstants.PROPERTY_CLASSES);
        ChangedHashtable<String, Object> changedHashtable = new ChangedHashtable<String, Object>();
        for (Map.Entry entry : list) {
            Object obj = entry.getValue();
            if (obj == null) continue;
            changedHashtable.put((String)entry.getKey(), obj, false);
        }
        return changedHashtable;
    }

    private ArrayUtil<ResultObject> getCallBackResultsIntern(AbstractSession abstractSession) {
        if (abstractSession != null) {
            return abstractSession.removeCallBackResults();
        }
        return null;
    }

    private Object[] setAndCheckAliveIntern(AbstractSession abstractSession, Object[] objectArray) {
        abstractSession.setLastAliveTime(System.currentTimeMillis());
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.sessman.get(objectArray[i]);
                continue;
            }
            catch (RuntimeException runtimeException) {
                arrayUtil.add(objectArray[i]);
            }
        }
        if (arrayUtil.size() > 0) {
            Object[] objectArray2 = new Object[arrayUtil.size()];
            arrayUtil.toArray(objectArray2);
            return objectArray2;
        }
        return null;
    }

    private void setNewPasswordInternal(AbstractSession abstractSession, String string, String string2) throws Throwable {
        abstractSession.setNewPassword(string, string2);
    }

    public final Monitoring getMonitoring() {
        return this.monitoring;
    }

    private final void log(Object object, Object object2, String string, String string2, Object[] objectArray, Object object3, Object object4, Throwable throwable, long l) {
        this.log.debug("SESSION-ID: ", object, "\nCOMMUNICATION-ID: ", object2, "\nOBJECTNAME: ", string, "\nMETHOD:     ", string2, "\nPARAMS:     ", objectArray, "\nCALLBACK:   ", object3, "\nRESULT:     ", object4, "\nEXCEPTION:  ", throwable, throwable != null ? "DURATION:   " : "\nDURATION:   ", l, " ms");
    }

    private final void error(Object object, Object object2, String string, String string2, Object[] objectArray, Object object3, Object object4, Throwable throwable, long l) {
        this.log.error("SESSION-ID: ", object, "\nCOMMUNICATION-ID: ", object2, "\nOBJECTNAME: ", string, "\nMETHOD:     ", string2, "\nPARAMS:     ", objectArray, "\nCALLBACK:   ", object3, "\nRESULT:     ", object4, "\nEXCEPTION:  ", throwable, throwable != null ? "DURATION:   " : "\nDURATION:   ", l, " ms");
    }

    private final ServerContext createServerContextIntern() {
        ServerContextImpl serverContextImpl = new ServerContextImpl(this);
        if (this.sInitialSystemIdentifier == null) {
            this.sInitialSystemIdentifier = serverContextImpl.getSystemIdentifier();
        }
        return serverContextImpl;
    }

    final ServerContext createServerContext() {
        ServerContextImpl serverContextImpl = new ServerContextImpl(this, this.sInitialSystemIdentifier);
        return serverContextImpl;
    }

    public static final void initLogging() {
        String string;
        try {
            string = Configuration.getServerZone().getProperty("/server/logfactory");
        }
        catch (Exception exception) {
            string = null;
        }
        if (!LoggerFactory.isInitialized() || !StringUtil.isEmpty(string)) {
            LoggerFactory.init(string);
        }
    }

    private void clearBuffer(DataInputStream dataInputStream, Object object) {
        SerializerInfo serializerInfo = this.hmpSerializer.get(object);
        if (serializerInfo == null) {
            serializerInfo = this.hmpSerializer.get(null);
        }
        try {
            ISerializer iSerializer = (ISerializer)serializerInfo.clsSerializer.newInstance();
            Object object2 = iSerializer.read(dataInputStream);
            if (object2 instanceof String) {
                object2 = iSerializer.read(dataInputStream);
            }
            int n = (Integer)object2;
            for (int i = 0; i < n; ++i) {
                iSerializer.read(dataInputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        MAGIC_BYTES = new byte[]{-128, 23, -1, -1, -1, -1};
        aiSequence = new AtomicInteger(0);
        instance = null;
        EXCEPTION_CONTENT = new Exception("Response content is not available!");
        EXCEPTION_CONTENT.setStackTrace(new StackTraceElement[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SerializerInfo {
        private Class<? extends ISerializer> clsSerializer;
        private long lCreation = System.currentTimeMillis();

        private SerializerInfo(Class<? extends ISerializer> clazz) {
            this.clsSerializer = clazz;
        }
    }

    private static final class SessionListener
    implements ISessionListener {
        private Server server;

        private SessionListener(Server server) {
            this.server = server;
        }

        public void sessionCreated(ISession iSession) {
        }

        public void sessionDestroyed(ISession iSession) {
            ISerializer iSerializer;
            this.server.whmResponse.remove(iSession);
            if (iSession instanceof AbstractSession && (iSerializer = ((AbstractSession)iSession).getSerializer()) != null) {
                Object object;
                if (this.server.hmpSerializer.size() > 1) {
                    object = (HashMap)this.server.hmpSerializer.clone();
                    long l = System.currentTimeMillis();
                    for (Map.Entry entry : ((HashMap)object).entrySet()) {
                        long l2;
                        if (entry.getKey() == null || (l2 = ((SerializerInfo)entry.getValue()).lCreation) <= 0L || l2 + 3600000L >= l) continue;
                        this.server.hmpSerializer.remove(entry.getKey());
                    }
                }
                if (((SerializerInfo)(object = (SerializerInfo)this.server.hmpSerializer.get(null))).clsSerializer != iSerializer.getClass()) {
                    this.server.hmpSerializer.put(iSession.getId(), new SerializerInfo(iSerializer.getClass()));
                }
            }
        }
    }

    private static final class CachedResponse {
        protected Long id;
        protected ByteArrayOutputStream content;

        private CachedResponse(Long l) {
            this.id = l;
        }

        private CachedResponse(Long l, ByteArrayOutputStream byteArrayOutputStream) {
            this.id = l;
            this.content = byteArrayOutputStream;
        }
    }
}

