/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.ILifeCycleObject;
import com.sibvisions.rad.server.annotation.Inherit;
import com.sibvisions.rad.server.annotation.NotAccessible;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import javax.rad.type.AbstractType;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.BeanType;
import javax.rad.type.bean.PropertyDefinition;
import javax.rad.util.INamedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericBean
extends Bean
implements ILifeCycleObject {
    private Bean parent = null;
    private Hashtable<PropertyDefinition, Class<?>> htProperties = new Hashtable();
    private boolean[] bPropertyAccess;
    private boolean bInitialized = false;
    private boolean bIgnoreInitialization = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBeanType() {
        if (this.bInitialized) {
            return;
        }
        GenericBean genericBean = this;
        synchronized (genericBean) {
            for (Class<?> clazz = this.getClass(); clazz != null && clazz != GenericBean.class && (this.parent == null || clazz != this.parent.getClass()); clazz = clazz.getSuperclass()) {
                Method[] methodArray;
                for (Method method : methodArray = clazz.getDeclaredMethods()) {
                    String string;
                    boolean bl;
                    if (!this.checkMethod(method) || (!(bl = (string = method.getName()).startsWith("get")) || string.length() <= 3) && (!string.startsWith("init") || string.length() <= 4)) continue;
                    string = bl ? string.substring(3) : string.substring(4);
                    if (((BeanType)this.beanType).getPropertyIndex(string = StringUtil.formatMemberName(string)) >= 0) continue;
                    PropertyDefinition propertyDefinition = new PropertyDefinition(string, AbstractType.getTypeFromClass(method.getReturnType()), method.getReturnType());
                    ((BeanType)this.beanType).addPropertyDefinition(propertyDefinition);
                    this.htProperties.put(propertyDefinition, clazz);
                }
            }
            this.bInitialized = true;
        }
    }

    @Override
    public void destroy() {
        Object object;
        int n = ((BeanType)this.beanType).getPropertyCount();
        for (int i = 0; i < n; ++i) {
            try {
                object = super.get(i);
                CommonUtil.close(object);
                super.put(i, (Object)null);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Field[] fieldArray = this.getClass().getFields();
        if (fieldArray != null) {
            int n2 = fieldArray.length;
            for (n = 0; n < n2; ++n) {
                try {
                    object = fieldArray[n].get(this);
                    CommonUtil.close(object);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        this.initBeanType();
        boolean bl = super.containsKey(object);
        if (!bl && this.parent != null) {
            return this.parent.containsKey(object);
        }
        return bl;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        this.initBeanType();
        boolean bl = super.containsValue(object);
        if (!bl && this.parent != null) {
            return this.parent.containsValue(object);
        }
        return bl;
    }

    @Override
    public Object get(String string) {
        this.initBeanType();
        int n = ((BeanType)this.beanType).getPropertyIndex(string);
        if (n < 0) {
            if (this.parent != null) {
                Object object = this.parent.get(string);
                if (this.parent.containsKey(string)) {
                    return object;
                }
                return null;
            }
            return super.get(string);
        }
        return this.getIntern(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String string, Object object) {
        this.initBeanType();
        if (object instanceof INamedObject) {
            try {
                ((INamedObject)object).setName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bIgnoreInitialization = true;
        try {
            Object object2 = super.put(string, object);
            Object var5_5 = null;
            this.bIgnoreInitialization = false;
            return object2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.bIgnoreInitialization = false;
            throw throwable;
        }
    }

    @Override
    public Object get(int n) {
        this.initBeanType();
        if (this.bIgnoreInitialization) {
            return super.get(n);
        }
        return this.getIntern(n);
    }

    @Override
    public BeanType getBeanType() {
        this.initBeanType();
        return (BeanType)super.getBeanType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(Bean bean) {
        this.parent = bean;
        GenericBean genericBean = this;
        synchronized (genericBean) {
            ((BeanType)this.beanType).removeAllPropertyDefinitions();
            this.bInitialized = false;
            this.initBeanType();
        }
    }

    public Bean getParent() {
        return this.parent;
    }

    public Object invoke(String string, Object ... objectArray) throws Throwable {
        try {
            return this.invoke(this.getClass(), this.parent != null, string, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.parent != null) {
                Class<?> clazz = this.getClass().getSuperclass();
                Class<?> clazz2 = this.parent.getClass();
                boolean bl = false;
                while (clazz != Object.class) {
                    boolean bl2 = bl = bl || clazz == clazz2;
                    if (!bl) {
                        try {
                            return this.invoke(clazz, true, string, objectArray);
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            clazz = clazz.getSuperclass();
                            continue;
                        }
                    }
                    Method method = Reflective.getMethodForCall(clazz, true, string, objectArray);
                    if (method != null) {
                        if (method.isAnnotationPresent(NotAccessible.class)) {
                            throw new SecurityException("Access to " + string + " denied!");
                        }
                        if (method.isAnnotationPresent(Inherit.class)) {
                            return Reflective.call((Object)this, method, objectArray);
                        }
                    }
                    clazz = clazz.getSuperclass();
                }
                if (this.parent instanceof GenericBean) {
                    return ((GenericBean)this.parent).invoke(string, objectArray);
                }
            }
            throw noSuchMethodException;
        }
    }

    private Object invoke(Class<?> clazz, boolean bl, String string, Object ... objectArray) throws Throwable {
        Method method = Reflective.getMethodForCall(clazz, bl, string, objectArray);
        if (method != null) {
            if (method.isAnnotationPresent(NotAccessible.class)) {
                throw new SecurityException("Access to " + string + " denied!");
            }
            return Reflective.call((Object)this, method, objectArray);
        }
        throw new NoSuchMethodException(Reflective.getMethodDeclaration(clazz, string, objectArray));
    }

    private Object getIntern(int n) {
        block16: {
            String string;
            block15: {
                Method method;
                Class<?> clazz;
                Object object;
                block14: {
                    if (this.bPropertyAccess == null) {
                        this.bPropertyAccess = new boolean[n + 1];
                    } else if (n >= this.bPropertyAccess.length) {
                        object = new boolean[Math.max(((BeanType)this.beanType).getPropertyCount(), n + 1)];
                        System.arraycopy(this.bPropertyAccess, 0, object, 0, this.bPropertyAccess.length);
                        this.bPropertyAccess = (boolean[])object;
                    }
                    if (this.bPropertyAccess[n]) {
                        return null;
                    }
                    object = super.get(n);
                    if (object != null) {
                        return object;
                    }
                    this.bPropertyAccess[n] = true;
                    PropertyDefinition propertyDefinition = ((BeanType)this.beanType).getPropertyDefinition(n);
                    string = propertyDefinition.getName();
                    clazz = this.htProperties.get(propertyDefinition);
                    method = this.getMethod(clazz, "init", string);
                    if (!this.checkMethod(method)) break block14;
                    object = Reflective.invoke(this, method, new Object[0]);
                    this.put(string, object);
                    Object object2 = object;
                    Object var9_13 = null;
                    this.bPropertyAccess[n] = false;
                    return object2;
                }
                method = this.getMethod(clazz, "get", string);
                if (!this.checkMethod(method)) break block15;
                object = Reflective.invoke(this, method, new Object[0]);
                this.put(string, object);
                Object object3 = object;
                Object var9_14 = null;
                this.bPropertyAccess[n] = false;
                return object3;
            }
            if (this.parent == null) break block16;
            Object object = this.parent.get(string);
            Object var9_15 = null;
            this.bPropertyAccess[n] = false;
            return object;
        }
        try {
            Object var7_12 = null;
            Object var9_16 = null;
            this.bPropertyAccess[n] = false;
            return var7_12;
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2;
                if (throwable instanceof InvocationTargetException) {
                    throwable2 = ((InvocationTargetException)throwable).getCause();
                }
                if (throwable2 instanceof RuntimeException) {
                    throw (RuntimeException)throwable2;
                }
                throw new RuntimeException(throwable2 != null ? throwable2.getMessage() : null, throwable2);
            }
            catch (Throwable throwable3) {
                Object var9_17 = null;
                this.bPropertyAccess[n] = false;
                throw throwable3;
            }
        }
    }

    private Method getMethod(Class<?> clazz, String string, String string2) {
        try {
            Class<?> clazz2 = clazz;
            if (clazz2 == null) {
                clazz2 = this.getClass();
            }
            return clazz2.getDeclaredMethod(StringUtil.formatMethodName(string, string2), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private boolean checkMethod(Method method) {
        if (method == null) {
            return false;
        }
        int n = method.getModifiers();
        return !Modifier.isStatic(n) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0);
    }
}

