/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.Server;
import com.sibvisions.util.ChangedHashtable;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.server.ICloseableSession;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectServerSession
implements ICloseableSession {
    private final ISession session;

    DirectServerSession(Object object) {
        this.session = Server.getInstance().getSessionManager().get(object);
    }

    @Override
    public Object getId() {
        return this.session.getId();
    }

    @Override
    public String getApplicationName() {
        return this.session.getApplicationName();
    }

    @Override
    public String getLifeCycleName() {
        return this.session.getLifeCycleName();
    }

    @Override
    public String getUserName() {
        return this.session.getUserName();
    }

    @Override
    public String getPassword() {
        return this.session.getPassword();
    }

    @Override
    public Object get(String string) throws Throwable {
        return this.session.get(string);
    }

    @Override
    public Object put(String string, Object object) throws Throwable {
        return this.session.put(string, object);
    }

    @Override
    public Object call(String string, String string2, Object ... objectArray) throws Throwable {
        return this.session.call(string, string2, objectArray);
    }

    @Override
    public Object callAction(String string, Object ... objectArray) throws Throwable {
        return this.session.callAction(string, objectArray);
    }

    @Override
    public IConfiguration getConfig() {
        return this.session.getConfig();
    }

    @Override
    public long getLastAccessTime() {
        return this.session.getLastAccessTime();
    }

    @Override
    public long getLastAliveTime() {
        return this.session.getLastAliveTime();
    }

    @Override
    public void setProperty(String string, Object object) {
        this.session.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) {
        return this.session.getProperty(string);
    }

    @Override
    public Hashtable<String, Object> getProperties() {
        return this.session.getProperties();
    }

    @Override
    public long getStartTime() {
        return this.session.getStartTime();
    }

    @Override
    public boolean isAlive(long l) {
        return this.session.isAlive(l);
    }

    @Override
    public boolean isInactive(long l) {
        return this.session.isInactive(l);
    }

    @Override
    public long getAliveInterval() {
        return this.session.getAliveInterval();
    }

    @Override
    public void setAliveInterval(long l) {
        this.session.setAliveInterval(l);
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        this.session.setMaxInactiveInterval(n);
    }

    @Override
    public void close() throws Throwable {
        this.destroy();
    }

    public void destroy() {
        Server.getInstance().destroySession(this.session.getId());
    }

    public static DirectServerSession createMasterSession(String string, Map<String, Object> map) throws Throwable {
        return DirectServerSession.createMasterSession(string, null, null, map);
    }

    public static DirectServerSession createMasterSession(String string, String string2, String string3) throws Throwable {
        return DirectServerSession.createMasterSession(string, string2, string3, null);
    }

    public static DirectServerSession createMasterSession(String string, String string2, String string3, Map<String, Object> map) throws Throwable {
        ChangedHashtable<String, Object> changedHashtable = DirectServerSession.createProperties(map);
        changedHashtable.put("client.application", string);
        if (string2 != null) {
            changedHashtable.put("client.username", string2);
        }
        if (string3 != null) {
            changedHashtable.put("client.password", string3);
        }
        Object object = Server.getInstance().createSession(changedHashtable);
        return new DirectServerSession(object);
    }

    public DirectServerSession createSubSession(String string) throws Throwable {
        return this.createSubSession(string, null);
    }

    public DirectServerSession createSubSession(String string, Map<String, Object> map) throws Throwable {
        ChangedHashtable<String, Object> changedHashtable = DirectServerSession.createProperties(map);
        changedHashtable.put("client.lifecyclename", string);
        Object object = Server.getInstance().createSubSession(this.session.getId(), changedHashtable);
        return new DirectServerSession(object);
    }

    protected static ChangedHashtable<String, Object> createProperties(Map<String, Object> map) {
        if (map != null) {
            return new ChangedHashtable<String, Object>(map);
        }
        return new ChangedHashtable<String, Object>();
    }
}

