/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.AbstractOracleDBAccess;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.param.AbstractParam;
import com.sibvisions.util.type.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.rad.persist.DataSourceException;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.BeanType;
import javax.rad.type.bean.IBean;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleDBAccess
extends AbstractOracleDBAccess {
    private static String sSynonymSelect = "select s.table_owner, s.table_name, s.db_link FROM user_synonyms s WHERE s.synonym_name = ?";

    public OracleDBAccess() {
        this.setDriver("oracle.jdbc.OracleDriver");
        this.configureTnsAdmin();
    }

    protected Object convertToArray(AbstractParam abstractParam) throws SQLException {
        Object object = abstractParam.getValue();
        if (abstractParam.getSqlType() == 2003 && object != null) {
            Object[] objectArray;
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)abstractParam.getTypeName(), (Connection)this.getConnection());
            if (object instanceof List) {
                objectArray = ((List)object).toArray();
            } else if (object instanceof Object[]) {
                objectArray = (Object[])((Object[])object).clone();
            } else {
                throw new SQLException("Unsupported array value,only List and Object[] are supported!");
            }
            if (arrayDescriptor.getBaseType() == 2002) {
                int n;
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)arrayDescriptor.getBaseName(), (Connection)this.getConnection());
                ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
                String[] stringArray = new String[resultSetMetaData.getColumnCount()];
                String[] stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = resultSetMetaData.getColumnName(n + 1);
                    stringArray2[n] = StringUtil.convertToMemberName(stringArray[n]);
                }
                for (n = 0; n < objectArray.length; ++n) {
                    String[] stringArray3;
                    IBean iBean;
                    Object object2 = objectArray[n];
                    if (object2 instanceof Object[]) continue;
                    Object[] objectArray2 = new Object[stringArray.length];
                    if (object2 instanceof IBean) {
                        iBean = (IBean)object2;
                        stringArray3 = stringArray;
                    } else {
                        iBean = new Bean(object2);
                        stringArray3 = stringArray2;
                    }
                    for (int i = 0; i < stringArray3.length; ++i) {
                        objectArray2[i] = iBean.get(stringArray3[i]);
                    }
                    objectArray[n] = objectArray2;
                }
            }
            return ((OracleConnection)this.getConnection()).createARRAY(abstractParam.getTypeName(), (Object)objectArray);
        }
        if (abstractParam.getSqlType() == 2002 && object != null) {
            Object[] objectArray;
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)abstractParam.getTypeName(), (Connection)this.getConnection());
            ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
            String[] stringArray = new String[resultSetMetaData.getColumnCount()];
            String[] stringArray4 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = resultSetMetaData.getColumnName(i + 1);
                stringArray4[i] = StringUtil.convertToMemberName(stringArray[i]);
            }
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                String[] stringArray5;
                IBean iBean;
                objectArray = new Object[stringArray.length];
                if (object instanceof IBean) {
                    iBean = (IBean)object;
                    stringArray5 = stringArray;
                } else {
                    iBean = new Bean(object);
                    stringArray5 = stringArray4;
                }
                for (int i = 0; i < stringArray5.length; ++i) {
                    objectArray[i] = iBean.get(stringArray5[i]);
                }
            }
            return ((OracleConnection)this.getConnection()).createStruct(abstractParam.getTypeName(), objectArray);
        }
        return object;
    }

    protected Object convertArrayToList(Object object) throws SQLException {
        if (object instanceof ARRAY) {
            ARRAY aRRAY = (ARRAY)object;
            BeanType beanType = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray = (Object[])aRRAY.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 instanceof STRUCT) {
                    int n;
                    String[] stringArray;
                    Object object3;
                    STRUCT sTRUCT = (STRUCT)object2;
                    if (beanType == null) {
                        object3 = sTRUCT.getDescriptor().getMetaData();
                        stringArray = new String[object3.getColumnCount()];
                        for (n = 0; n < stringArray.length; ++n) {
                            stringArray[n] = object3.getColumnName(n + 1);
                        }
                        beanType = new BeanType(stringArray);
                    }
                    object3 = sTRUCT.getAttributes();
                    stringArray = new Bean(beanType);
                    for (n = 0; n < ((Object)object3).length; ++n) {
                        stringArray.put(n, object3[n]);
                    }
                    arrayList.add(stringArray);
                    continue;
                }
                arrayList.add(object2);
            }
            return arrayList;
        }
        if (object instanceof STRUCT) {
            STRUCT sTRUCT = (STRUCT)object;
            ResultSetMetaData resultSetMetaData = sTRUCT.getDescriptor().getMetaData();
            String[] stringArray = new String[resultSetMetaData.getColumnCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = resultSetMetaData.getColumnName(i + 1);
            }
            BeanType beanType = new BeanType(stringArray);
            Object[] objectArray = sTRUCT.getAttributes();
            Bean bean = new Bean(beanType);
            for (int i = 0; i < objectArray.length; ++i) {
                bean.put(i, objectArray[i]);
            }
            return bean;
        }
        return object;
    }

    protected Object getObjectFromResultSet(ResultSet resultSet, int n) throws SQLException {
        Object object = super.getObjectFromResultSet(resultSet, n);
        if (object instanceof BFILE) {
            object = new BlobFromBFILE((BFILE)object);
        }
        return object;
    }

    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        return this.getTableForSynonymIntern(sSynonymSelect, string);
    }

    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) throws SQLException {
        if (object instanceof TIMESTAMPLTZ) {
            return ((TIMESTAMPLTZ)object).timestampValue(this.getConnectionIntern());
        }
        if (object instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)object).timestampValue(this.getConnectionIntern());
        }
        if (object instanceof Datum && serverColumnMetaData.getTypeIdentifier() == 93) {
            return ((Datum)object).timestampValue();
        }
        return object;
    }

    private void configureTnsAdmin() {
        try {
            if (System.getProperty("oracle.net.tns_admin") == null) {
                String string = System.getenv("TNS_ADMIN");
                if (string == null) {
                    String string2 = System.getenv("ORACLE_HOME");
                    if (string2 != null) {
                        string = string2 + "/network/admin";
                    } else {
                        String string3 = System.getenv("PATH");
                        if (string3 != null) {
                            String[] stringArray = string3.split(File.pathSeparator);
                            for (int i = 0; string == null && i < stringArray.length; ++i) {
                                String string4 = stringArray[i].toLowerCase().replace('\\', '/');
                                if (!string4.contains("oracle") || !string4.endsWith("/bin") || !new File(string4 = stringArray[i].substring(0, string4.length() - 4) + "/network/admin").exists()) continue;
                                string = string4;
                            }
                        }
                    }
                }
                if (string != null) {
                    System.setProperty("oracle.net.tns_admin", string);
                }
            }
        }
        catch (Exception exception) {
            OracleDBAccess.debug("Configure tns admin failed!" + exception);
        }
    }

    public static class BlobFromBFILE
    implements Blob {
        private BFILE bFile;

        public BlobFromBFILE(BFILE bFILE) {
            this.bFile = bFILE;
        }

        public long length() throws SQLException {
            return this.bFile.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getBytes(long l, int n) throws SQLException {
            byte[] byArray;
            try {
                this.bFile.openFile();
                byArray = this.bFile.getBytes(l, n);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.bFile.closeFile();
                throw throwable;
            }
            this.bFile.closeFile();
            return byArray;
        }

        public InputStream getBinaryStream() throws SQLException {
            return new ByteArrayInputStream(this.getBytes(1L, (int)this.length()));
        }

        public InputStream getBinaryStream(long l, long l2) throws SQLException {
            return this.bFile.getBinaryStream(l);
        }

        public long position(byte[] byArray, long l) throws SQLException {
            return this.bFile.position(byArray, l);
        }

        public long position(Blob blob, long l) throws SQLException {
            return this.bFile.position(((BlobFromBFILE)blob).bFile, l);
        }

        public int setBytes(long l, byte[] byArray) throws SQLException {
            throw new UnsupportedOperationException("Changing BFILE is not supported.");
        }

        public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
            throw new UnsupportedOperationException("Changing BFILE is not supported.");
        }

        public OutputStream setBinaryStream(long l) throws SQLException {
            throw new UnsupportedOperationException("Changing BFILE is not supported.");
        }

        public void truncate(long l) throws SQLException {
            throw new UnsupportedOperationException("Changing BFILE is not supported.");
        }

        public void free() throws SQLException {
            throw new UnsupportedOperationException("Changing BFILE is not supported.");
        }
    }
}

