/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDBAccess
extends DBAccess {
    private static String sCheckSelect = "SELECT cu.TABLE_NAME, cu.COLUMN_NAME, c.CHECK_CLAUSE FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS t, INFORMATION_SCHEMA.CHECK_CONSTRAINTS c, INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE cu WHERE t.CONSTRAINT_TYPE = 'CHECK' AND t.CONSTRAINT_SCHEMA = c.CONSTRAINT_SCHEMA AND t.CONSTRAINT_CATALOG = c.CONSTRAINT_CATALOG AND t.CONSTRAINT_NAME = c.CONSTRAINT_NAME AND t.TABLE_NAME = ? AND t.TABLE_NAME = cu.TABLE_NAME AND t.TABLE_CATALOG = cu.TABLE_CATALOG AND t.TABLE_SCHEMA = cu.TABLE_SCHEMA AND t.CONSTRAINT_SCHEMA = cu.CONSTRAINT_SCHEMA AND t.CONSTRAINT_CATALOG = cu.CONSTRAINT_CATALOG AND t.CONSTRAINT_NAME = cu.CONSTRAINT_NAME";
    private static String sSynonymSelect = "SELECT name, base_object_name FROM sys.synonyms t WHERE t.name = ?";

    public MSSQLDBAccess() {
        this.setDriver("net.sourceforge.jtds.jdbc.Driver");
        this.setQuoteCharacters("[", "]");
    }

    private String addMSSQLSpecificAutoIncSupport(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2) {
        int[] nArray = serverMetaData.getAutoIncrementColumnIndices();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if ((objectArray != null || objectArray2[nArray[i]] == null) && (objectArray == null || objectArray2[nArray[i]] == null || objectArray2[nArray[i]].equals(objectArray[nArray[i]]))) continue;
            return "SET IDENTITY_INSERT " + this.translateQuotes(string) + " ON " + string2 + " SET IDENTITY_INSERT " + this.translateQuotes(string) + " OFF";
        }
        return string2;
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        string2 = this.addMSSQLSpecificAutoIncSupport(string, string2, serverMetaData, null, objectArray);
        return this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
    }

    @Override
    protected Map<String, Object[]> getAllowedValuesIntern(String string, String string2, String string3) throws DataSourceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, Object[]> hashtable = new Hashtable();
        Hashtable<String, List<String>> hashtable2 = null;
        try {
            preparedStatement = this.getPreparedStatement(sCheckSelect);
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashtable2 = CheckConstraintSupport.parseCondition(resultSet.getString(3), hashtable2, false);
            }
            hashtable = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable2);
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return hashtable;
    }

    @Override
    public boolean isAutoQuote(String string) {
        return false;
    }

    @Override
    public void setUsername(String string) {
        super.setUsername(DBAccess.removeQuotes(string));
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        TableInfo tableInfo;
        long l;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        TableInfo tableInfo2;
        block13: {
            block12: {
                List<Object[]> list;
                String[] stringArray;
                tableInfo2 = super.getTableInfoIntern(string);
                String string2 = DBAccess.removeQuotes(tableInfo2.getTable());
                Object object = tableInfo2.getSchema();
                if (object != null) {
                    stringArray = DBAccess.removeQuotes((String)object);
                    object = stringArray.equals(object) ? object.toLowerCase() : stringArray;
                }
                if ((list = this.checkTablesAndViews((String)object, string2 = (stringArray = this.splitSchemaTable(string2))[1])).size() == 1) {
                    return new TableInfo(tableInfo2.getCatalog(), ((Name)list.get(0)[0]).getRealName(), tableInfo2.getTable());
                }
                preparedStatement = null;
                resultSet = null;
                l = System.currentTimeMillis();
                if (this.getConnectionIntern().getMetaData().getDatabaseMajorVersion() <= 8 || !(resultSet = (preparedStatement = this.getPreparedStatement("SELECT default_schema_name FROM sys.database_principals WHERE type = 'S' AND name = USER_NAME(DATABASE_PRINCIPAL_ID())")).executeQuery()).next() || (object = resultSet.getString(1)) == null || (list = this.checkTablesAndViews((String)object, string2)).size() != 1) break block12;
                TableInfo tableInfo3 = new TableInfo(tableInfo2.getCatalog(), ((Name)list.get(0)[0]).getRealName(), tableInfo2.getTable());
                CommonUtil.close(resultSet, preparedStatement);
                if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                    MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
                }
                return tableInfo3;
            }
            String string3 = this.getDefaultSchema();
            if (string3 == null) break block13;
            TableInfo tableInfo4 = new TableInfo(tableInfo2.getCatalog(), string3, tableInfo2.getTable());
            CommonUtil.close(resultSet, preparedStatement);
            if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
            }
            return tableInfo4;
        }
        try {
            tableInfo = new TableInfo(tableInfo2.getCatalog(), "dbo", tableInfo2.getTable());
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                    MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
                }
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            MSSQLDBAccess.debug("getColumnMetaData() - getDefaultSchema in time=", System.currentTimeMillis() - l);
        }
        return tableInfo;
    }

    @Override
    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        String string2;
        long l;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            resultSet = null;
            l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sSynonymSelect);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block6;
            CommonUtil.close(resultSet, preparedStatement);
            String string3 = string;
            CommonUtil.close(resultSet, preparedStatement);
            return string3;
        }
        try {
            String string4 = resultSet.getString("BASE_OBJECT_NAME");
            if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                MSSQLDBAccess.debug("getTableForSynonym(", string, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string2 = string4;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Synonyms couldn't determined from database! - " + string, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string2;
    }

    private List<Object[]> checkTablesAndViews(String string, String string2) throws DataSourceException {
        Object object;
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnectionIntern().getMetaData().getTables(this.getConnectionIntern().getCatalog(), string, string2, new String[]{"TABLE", "VIEW"});
            ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>();
            while (resultSet.next()) {
                object = resultSet.getString("TABLE_SCHEM");
                if (((String)object).equals("sys") || ((String)object).equals("INFORMATION_SCHEMA")) continue;
                arrayUtil.add(new Object[]{new Name(resultSet.getString("TABLE_SCHEM"), this.quote(resultSet.getString("TABLE_SCHEM"))), new Name(resultSet.getString("TABLE_NAME"), this.quote(resultSet.getString("TABLE_NAME")))});
            }
            object = arrayUtil;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet);
                if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                    MSSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
                }
                throw throwable;
            }
        }
        CommonUtil.close(resultSet);
        if (MSSQLDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            MSSQLDBAccess.debug("getTables() time=", System.currentTimeMillis() - l);
        }
        return object;
    }
}

