/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.GroupHashtable;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HanaDBAccess
extends DBAccess {
    private static GroupHashtable<String, String, String> ghtSequenceCache = new GroupHashtable();
    private static HashMap<String, Integer> hmpDataTypes = new HashMap();

    public HanaDBAccess() {
        this.setDriver("com.sap.db.jdbc.Driver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] insert(String string, ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        int n;
        ServerColumnMetaData[] serverColumnMetaDataArray;
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        String string2 = null;
        String string3 = null;
        BigDecimal bigDecimal = null;
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
        stringBuilder.append(string);
        stringBuilder.append(" (");
        int n2 = 0;
        String string4 = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        ResultSet resultSet3 = null;
        try {
            String[] stringArray;
            preparedStatement = this.getPreparedStatement("select column_id from table_columns where table_name = ? and column_name = ?");
            preparedStatement2 = this.getPreparedStatement("select sequence_name from sequences where sequence_name like ?");
            serverColumnMetaDataArray = this.getTableInfoIntern(string);
            String[] objectArray2 = stringArray = this.getAutoIncrementColumns(serverColumnMetaDataArray.getSchema(), string);
            n = objectArray2.length;
            for (int nArray = 0; nArray < n; ++nArray) {
                String string5;
                String i = objectArray2[nArray];
                int n3 = serverMetaData.getServerColumnMetaDataIndex(i);
                if (objectArray[n3] != null) continue;
                String string6 = this.getIdentifier();
                string3 = ghtSequenceCache.get(string6, string5 = HanaDBAccess.createIdentifier(serverColumnMetaDataArray.getSchema(), serverColumnMetaDataArray.getTable()));
                if (string3 == null) {
                    preparedStatement.setString(1, HanaDBAccess.removeQuotes(string));
                    preparedStatement.setString(2, i);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string2 = resultSet.getString(1);
                    }
                    preparedStatement2.setString(1, "%" + string2 + "%");
                    resultSet2 = preparedStatement2.executeQuery();
                    if (resultSet2.next()) {
                        string3 = resultSet2.getString(1);
                    }
                    if (string3 != null) {
                        ghtSequenceCache.put(string6, string5, string3);
                    }
                }
                if ((resultSet3 = (preparedStatement3 = this.getPreparedStatement("select " + string3 + ".nextval from dummy")).executeQuery()).next()) {
                    bigDecimal = resultSet3.getBigDecimal(1);
                }
                objectArray[n3] = bigDecimal;
            }
        }
        catch (Exception exception) {
            try {
                HanaDBAccess.debug("Can't find sequence for ", string, exception);
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2, resultSet3, preparedStatement3);
                throw throwable;
            }
            CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2, resultSet3, preparedStatement3);
        }
        CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2, resultSet3, preparedStatement3);
        serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
        int[] nArray = serverMetaData.getWritableColumnIndices();
        for (n = 0; n < nArray.length; ++n) {
            if (objectArray[nArray[n]] == null) continue;
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(serverColumnMetaDataArray[nArray[n]].getColumnName().getQuotedName());
            ++n2;
        }
        if (n2 == 0) {
            for (n = 0; n2 == 0 && n < nArray.length; ++n) {
                if (serverColumnMetaDataArray[nArray[n]].isAutoIncrement()) continue;
                string4 = serverColumnMetaDataArray[nArray[n]].getColumnName().getQuotedName();
                stringBuilder.append(string4);
                ++n2;
            }
        }
        stringBuilder.append(") VALUES (");
        if (n2 > 0) {
            stringBuilder.append("?");
            for (n = 1; n < n2; ++n) {
                stringBuilder.append(",?");
            }
        }
        stringBuilder.append(")");
        objectArray = this.insertDatabaseSpecific(string, stringBuilder.toString(), serverMetaData, objectArray, string4);
        this.setModified(Boolean.TRUE);
        if (HanaDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
            HanaDBAccess.debug(stringBuilder, "[", objectArray, "]");
        }
        if (serverMetaData.getPrimaryKeyType() != ServerMetaData.PrimaryKeyType.AllColumns) {
            n = 1;
            int[] nArray2 = serverMetaData.getPrimaryKeyColumnIndices();
            if (nArray2 != null) {
                for (int i = 0; i < nArray2.length && n != 0; ++i) {
                    if (objectArray[nArray2[i]] == null) continue;
                    n = 0;
                }
            }
            if (n != 0) {
                throw new DataSourceException("Primary key column empty after insert! " + string);
            }
        }
        return objectArray;
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertHana(string, string2, serverMetaData, objectArray, string3);
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        Object object;
        TableInfo tableInfo = super.getTableInfoIntern(string);
        String string2 = tableInfo.getSchema();
        if (string2 == null) {
            ResultSet resultSet;
            block6: {
                object = null;
                resultSet = null;
                try {
                    object = this.getPreparedStatement("select CURRENT_SCHEMA from dummy");
                    resultSet = object.executeQuery();
                    if (!resultSet.next()) break block6;
                    string2 = resultSet.getString(1);
                }
                catch (SQLException sQLException) {
                    try {
                        throw new DataSourceException("Can't select the current Schema!", this.formatSQLException(sQLException));
                    }
                    catch (Throwable throwable) {
                        CommonUtil.close(resultSet, object);
                        throw throwable;
                    }
                }
            }
            CommonUtil.close(resultSet, object);
        }
        if ((object = tableInfo.getTable()) != null && !((String)object).startsWith("`") && !((String)object).endsWith("`")) {
            object = ((String)object).toUpperCase();
        }
        return new TableInfo(tableInfo.getCatalog(), string2, (String)object);
    }

    @Override
    protected String getColumnName(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return resultSetMetaData.getColumnLabel(n);
    }

    @Override
    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getPreparedStatement("SELECT COLUMN_NAME, DATA_TYPE_NAME, DEFAULT_VALUE FROM SYS.TABLE_COLUMNS WHERE SCHEMA_NAME = ? AND TABLE_NAME= ?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            resultSet = preparedStatement.executeQuery();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            while (resultSet.next()) {
                object = resultSet.getString("DEFAULT_VALUE");
                if (StringUtil.isEmpty((String)object)) continue;
                String string4 = resultSet.getString("COLUMN_NAME");
                try {
                    Object object2 = this.translateDefaultValue(string4, this.convertType(resultSet.getString("DATA_TYPE_NAME")), ((String)object).trim());
                    if (object2 == null) continue;
                    hashtable.put(new Name(string4, this.quote(string4)).getName(), object2);
                }
                catch (Exception exception) {}
            }
            object = hashtable;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Get default values failed!", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
            preparedStatement = this.getPreparedStatement("SELECT CONSTRAINT_NAME, COLUMN_NAME FROM SYS.CONSTRAINTS WHERE SCHEMA_NAME = ? AND TABLE_NAME = ? ORDER BY CONSTRAINT_NAME, POSITION");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            resultSet = preparedStatement.executeQuery();
            ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
            String string4 = null;
            while (resultSet.next()) {
                if (string4 != null && !resultSet.getString("CONSTRAINT_NAME").equals(string4)) {
                    object = new Key(string4, arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                    arrayUtil.add(object);
                    arrayUtil2.clear();
                }
                String string5 = resultSet.getString("COLUMN_NAME");
                arrayUtil2.add(new Name(string5, this.quote(string5)));
                string4 = resultSet.getString("CONSTRAINT_NAME");
            }
            if (arrayUtil2.size() > 0) {
                arrayUtil.add(new Key(string4, arrayUtil2.toArray(new Name[arrayUtil2.size()])));
            }
            if (HanaDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                HanaDBAccess.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil;
        }
        catch (SQLException sQLException) {
            List<Key> list;
            try {
                HanaDBAccess.error("Unique Keys couldn't determined from database! - ", string3, sQLException);
                list = null;
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
            CommonUtil.close(resultSet, preparedStatement);
            return list;
        }
        CommonUtil.close(resultSet, preparedStatement);
        return object;
    }

    @Override
    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        ArrayUtil<ForeignKey> arrayUtil;
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ForeignKey foreignKey;
            ArrayUtil<ForeignKey> arrayUtil2 = new ArrayUtil<ForeignKey>();
            preparedStatement = this.getPreparedStatement("SELECT CONSTRAINT_NAME, COLUMN_NAME, REFERENCED_SCHEMA_NAME, REFERENCED_TABLE_NAME, REFERENCED_COLUMN_NAME FROM SYS.REFERENTIAL_CONSTRAINTS WHERE SCHEMA_NAME = ? AND TABLE_NAME = ? ORDER BY CONSTRAINT_NAME, POSITION");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            resultSet = preparedStatement.executeQuery();
            ArrayUtil<Name> arrayUtil3 = new ArrayUtil<Name>();
            ArrayUtil<Name> arrayUtil4 = new ArrayUtil<Name>();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            while (resultSet.next()) {
                if (string6 != null && !resultSet.getString("CONSTRAINT_NAME").equals(string6)) {
                    foreignKey = new ForeignKey(new Name(string5, this.quote(string5)), null, new Name(string4, this.quote(string4)));
                    foreignKey.setFKName(string6);
                    foreignKey.setFKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
                    foreignKey.setPKColumns(arrayUtil3.toArray(new Name[arrayUtil3.size()]));
                    arrayUtil2.add(foreignKey);
                    arrayUtil3.clear();
                    arrayUtil4.clear();
                }
                arrayUtil3.add(new Name(resultSet.getString("REFERENCED_COLUMN_NAME"), this.quote(resultSet.getString("REFERENCED_COLUMN_NAME"))));
                arrayUtil4.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
                string4 = resultSet.getString("REFERENCED_SCHEMA_NAME");
                string5 = resultSet.getString("REFERENCED_TABLE_NAME");
                string6 = resultSet.getString("CONSTRAINT_NAME");
            }
            if (arrayUtil3.size() > 0) {
                foreignKey = new ForeignKey(new Name(string5, this.quote(string5)), null, new Name(string4, this.quote(string4)));
                foreignKey.setFKName(string6);
                foreignKey.setFKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
                foreignKey.setPKColumns(arrayUtil3.toArray(new Name[arrayUtil3.size()]));
                arrayUtil2.add(foreignKey);
            }
            if (HanaDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                HanaDBAccess.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            arrayUtil = arrayUtil2;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return arrayUtil;
    }

    @Override
    protected void commitOrRollbackBeforeClose() {
        try {
            Connection connection = this.getConnectionIntern();
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            HanaDBAccess.debug(sQLException);
        }
    }

    protected Object[] insertHana(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        PreparedStatement preparedStatement;
        block11: {
            preparedStatement = null;
            preparedStatement = this.getPreparedStatement(string2);
            if (this.getTransactionTimeout() >= 0) {
                try {
                    preparedStatement.setQueryTimeout(this.getTransactionTimeout());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray = serverMetaData.getWritableColumnIndices();
            if (string3 == null) {
                this.setColumnsToStore(preparedStatement, serverColumnMetaDataArray, nArray, objectArray, null);
            } else {
                for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                    if (!serverColumnMetaDataArray[i].getColumnName().getQuotedName().equals(string3)) continue;
                    preparedStatement.setObject(1, null, serverColumnMetaDataArray[i].getSQLType());
                    break;
                }
            }
            if (preparedStatement.executeUpdate() != 1) break block11;
            Object[] objectArray2 = objectArray;
            CommonUtil.close(preparedStatement);
            return objectArray2;
        }
        try {
            try {
                throw new DataSourceException("Insert failed! - Result row count != 1" + string2);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Insert failed! - " + string2, this.formatSQLException(sQLException));
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(preparedStatement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAutoIncrementColumns(String string, String string2) throws Exception {
        String[] stringArray;
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            stringArray = DBAccess.removeQuotes(string2);
            preparedStatement = this.getPreparedStatement("select column_name from table_columns where generation_type = 'BY DEFAULT AS IDENTITY' and table_name = ? and schema_name = ?");
            preparedStatement.setString(1, (String)stringArray);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (string3 == null) continue;
                arrayUtil.add(string3);
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(resultSet, preparedStatement);
            throw throwable;
        }
        CommonUtil.close(resultSet, preparedStatement);
        stringArray = new String[arrayUtil.size()];
        return arrayUtil.toArray(stringArray);
    }

    private int convertType(String string) {
        Integer n = hmpDataTypes.get(string);
        if (n == null) {
            return 1111;
        }
        return n;
    }

    static {
        hmpDataTypes.put("ALPHANUM", 12);
        hmpDataTypes.put("BIGINT", -5);
        hmpDataTypes.put("BINARY", -2);
        hmpDataTypes.put("BINTEXT", -2);
        hmpDataTypes.put("BLOB", 2004);
        hmpDataTypes.put("CHAR", 1);
        hmpDataTypes.put("CLOB", 2005);
        hmpDataTypes.put("DATE", 91);
        hmpDataTypes.put("DECIMAL", 3);
        hmpDataTypes.put("DOUBLE", 8);
        hmpDataTypes.put("INTEGER", 4);
        hmpDataTypes.put("NCHAR", 1111);
        hmpDataTypes.put("NCLOB", 1111);
        hmpDataTypes.put("NVARCHAR", 1111);
        hmpDataTypes.put("REAL", 7);
        hmpDataTypes.put("SECONDDATE", 1111);
        hmpDataTypes.put("SHORTTEXT", 12);
        hmpDataTypes.put("SMALLDECIMAL", 3);
        hmpDataTypes.put("SMALLINT", 5);
        hmpDataTypes.put("ST_GEOMETRY", 1111);
        hmpDataTypes.put("ST_POINT", 1111);
        hmpDataTypes.put("ST_POINTZ", 1111);
        hmpDataTypes.put("TEXT", 12);
        hmpDataTypes.put("TIME", 92);
        hmpDataTypes.put("TIMESTAMP", 93);
        hmpDataTypes.put("TINYINT", -6);
        hmpDataTypes.put("VARBINARY", -3);
        hmpDataTypes.put("VARCHAR", 12);
    }
}

