/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.model.Filter;
import com.sibvisions.rad.persist.AbstractCachedStorage;
import com.sibvisions.rad.persist.jdbc.DB2DBAccess;
import com.sibvisions.rad.persist.jdbc.DBCredentials;
import com.sibvisions.rad.persist.jdbc.DBStorage;
import com.sibvisions.rad.persist.jdbc.DataSourceConnectionPool;
import com.sibvisions.rad.persist.jdbc.DerbyDBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.H2DBAccess;
import com.sibvisions.rad.persist.jdbc.HSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.HanaDBAccess;
import com.sibvisions.rad.persist.jdbc.IColumnMetaDataCreator;
import com.sibvisions.rad.persist.jdbc.IConnectionPool;
import com.sibvisions.rad.persist.jdbc.IDBAccess;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.MSSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.MySQLDBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.OracleDBAccess;
import com.sibvisions.rad.persist.jdbc.PostgreSQLDBAccess;
import com.sibvisions.rad.persist.jdbc.SQLiteDBAccess;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.rad.persist.jdbc.TiberoDBAccess;
import com.sibvisions.rad.persist.jdbc.event.ConnectionEvent;
import com.sibvisions.rad.persist.jdbc.event.type.IConfigureConnectionListener;
import com.sibvisions.rad.persist.jdbc.event.type.IUnconfigureConnectionListener;
import com.sibvisions.rad.persist.jdbc.param.AbstractParam;
import com.sibvisions.rad.persist.jdbc.param.OutParam;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.GroupHashtable;
import com.sibvisions.util.ICloseable;
import com.sibvisions.util.IValidatable;
import com.sibvisions.util.KeyValueList;
import com.sibvisions.util.ObjectCache;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.DateUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.rad.io.IFileHandle;
import javax.rad.io.RemoteFileHandle;
import javax.rad.model.MetaDataCacheOption;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.And;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.Greater;
import javax.rad.model.condition.GreaterEquals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Less;
import javax.rad.model.condition.LessEquals;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.LikeReverse;
import javax.rad.model.condition.LikeReverseIgnoreCase;
import javax.rad.model.condition.Not;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.condition.Or;
import javax.rad.model.datatype.IDataType;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.server.ISession;
import javax.rad.server.SessionContext;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.BeanType;
import javax.rad.util.EventHandler;
import javax.rad.util.TranslationMap;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAccess
implements IDBAccess,
ICloseable {
    public static final int NCHAR = -15;
    public static final int NVARCHAR = -9;
    public static final int LONGNVARCHAR = -16;
    public static final int BFILE = -13;
    public static final int TIMESTAMPWITHTIMEZONE = -101;
    public static final int TIMESTAMPWITHLOCALTIMEZONE = -102;
    public static final int SQLXML = 2009;
    public static final int NCLOB = 2011;
    public static final String QUOTE = "`";
    private static TranslationMap tmpAutoLinkColumnNames = new TranslationMap();
    private static Hashtable<String, Class<? extends DBAccess>> dbAccessClasses = new Hashtable();
    private static KeyValueList<String, String> kvlApplicationGroups = new KeyValueList();
    private static GroupHashtable<String, String, List<ForeignKey>> ghtFKsCache = new GroupHashtable();
    private static GroupHashtable<String, String, Key> ghtPKCache = new GroupHashtable();
    private static GroupHashtable<String, String, List<Key>> ghtUKsCache = new GroupHashtable();
    private static GroupHashtable<String, String, Map<String, Object[]>> ghtAllowedValuesCache = new GroupHashtable();
    private static GroupHashtable<String, String, Map<String, Object>> ghtDefaultValuesCache = new GroupHashtable();
    private static GroupHashtable<String, String, ServerColumnMetaData[]> ghtColumnMetaDataCache = new GroupHashtable();
    private static GroupHashtable<String, String, TableInfo> ghtTableInfoCache = new GroupHashtable();
    private static GroupHashtable<String, String, String> ghtTableNameCache = new GroupHashtable();
    private static final List<ForeignKey> FKS_NULL = new ArrayUtil<ForeignKey>();
    private static final Key PKS_NULL = new Key(null, null);
    private static final List<Key> UKS_NULL = new ArrayUtil<Key>();
    private static final Map<String, Object[]> ALLOWED_VALUES_NULL = new Hashtable<String, Object[]>();
    private static final Map<String, Object> DEFAULT_VALUES_NULL = new Hashtable<String, Object>();
    private static final ServerColumnMetaData[] COLUMNMETADATA_NULL = new ServerColumnMetaData[0];
    private static final TableInfo TABLEINFO_NULL = new TableInfo(null, null, null);
    private static final String TABLENAME_NULL = new String("TABLENAME_NULL");
    private static ILogger logger = null;
    private static boolean lastGlobalMetaDataCache = false;
    private static long lDefaultLargeObjectLimit = 16384L;
    private static long lDefaultCursorCacheTimeout = 900000L;
    private EventHandler<IColumnMetaDataCreator> columnMetaDataCreatorProvider = null;
    private EventHandler<IConfigureConnectionListener> eventConfigureConnection = null;
    private EventHandler<IUnconfigureConnectionListener> eventUnconfigureConnection = null;
    private IConnectionPool connectionPool;
    private Connection connection;
    private IColumnMetaDataCreator columnMetaDataCreator = null;
    private MetaDataCacheOption mdcCacheOption = MetaDataCacheOption.Default;
    private Properties properties = new Properties();
    private Hashtable<String, Cursor> htFetchResultSetCache = new Hashtable();
    private DateUtil dateUtil = new DateUtil(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private String sUrl;
    private String sDriver;
    private String sUsername;
    private String sPassword;
    private String sOpenQuote;
    private String sCloseQuote;
    private String sDefaultSchema;
    private String sApplicationName = "";
    private String sIdentifier = null;
    private int iMaxTime = 100;
    private int iQueryTimeout = -1;
    private int iTransactionTimeout = -1;
    private int iMaxColumnLength;
    private long lLargeObjectLimit = lDefaultLargeObjectLimit;
    private boolean bAutoClose = true;
    private boolean bExternalConnection = false;
    private Boolean bModified = Boolean.FALSE;
    private boolean bConnectionPoolEnabled = false;
    private boolean bReleaseConnectionPending = false;
    private boolean bAutoCommit = true;
    private boolean bOpen = false;

    public DBAccess() {
        ObjectCache.put(new DBAccessObserver(this));
        this.setQuoteCharacters("\"", "\"");
    }

    public static DBAccess getDBAccess(String string) throws DataSourceException {
        return DBAccess.getDBAccess(string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DBAccess getDBAccess(String string, String string2, String string3) throws DataSourceException {
        Object object;
        Object object2;
        if (string == null) {
            return null;
        }
        if (!DBAccess.isJdbc(string)) {
            try {
                object2 = new InitialContext();
                try {
                    object = ((InitialContext)object2).lookup(string);
                    if (object instanceof DBAccess) {
                        DBAccess dBAccess = (DBAccess)object;
                        return dBAccess;
                    }
                    if (object instanceof Connection) {
                        DBAccess dBAccess = DBAccess.getDBAccess((Connection)object, true);
                        dBAccess.setUrl(string);
                        DBAccess dBAccess2 = dBAccess;
                        return dBAccess2;
                    }
                    if (object instanceof DataSource) {
                        DBAccess dBAccess = DBAccess.getDBAccess(new DataSourceConnectionPool((DataSource)object, string2, string3));
                        return dBAccess;
                    }
                    if (object instanceof IConnectionPool) {
                        DBAccess dBAccess = DBAccess.getDBAccess((IConnectionPool)object);
                        return dBAccess;
                    }
                }
                finally {
                    ((InitialContext)object2).close();
                }
            }
            catch (Exception exception) {
                throw new DataSourceException("JNDI URL used, but resource was not found!", exception);
            }
        }
        object2 = DBAccess.getDBAccessClass(string);
        try {
            object = (DBAccess)((Class)object2).newInstance();
            ((DBAccess)object).setUrl(string);
            ((DBAccess)object).setUsername(string2);
            ((DBAccess)object).setPassword(string3);
            return object;
        }
        catch (Exception exception) {
            throw new DataSourceException("Instantion of '" + object2 + "' failed!", exception);
        }
    }

    public static DBAccess getDBAccess(DBCredentials dBCredentials) throws DataSourceException {
        if (dBCredentials == null) {
            return null;
        }
        DBAccess dBAccess = DBAccess.getDBAccess(dBCredentials.getUrl(), dBCredentials.getUserName(), dBCredentials.getPassword());
        if (dBAccess == null) {
            return null;
        }
        String string = dBCredentials.getDriver();
        if (!StringUtil.isEmpty(string)) {
            dBAccess.setDriver(string);
        }
        return dBAccess;
    }

    public static DBAccess getDBAccess(Connection connection) throws DataSourceException {
        try {
            DBAccess dBAccess = DBAccess.getDBAccess(connection, false);
            return dBAccess;
        }
        catch (Exception exception) {
            throw new DataSourceException("Create DBAccess failed!", exception);
        }
    }

    private static DBAccess getDBAccess(Connection connection, boolean bl) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getURL();
        Class<? extends DBAccess> clazz = DBAccess.getDBAccessClass(string);
        DBAccess dBAccess = clazz.newInstance();
        dBAccess.setUrl(string);
        dBAccess.setUsername(databaseMetaData.getUserName());
        dBAccess.setConnection(connection);
        dBAccess.bAutoClose = bl;
        dBAccess.bOpen = true;
        dBAccess.bExternalConnection = true;
        dBAccess.initializeMaxColumnLength();
        return dBAccess;
    }

    public static DBAccess getDBAccess(IConnectionPool iConnectionPool) throws DataSourceException {
        try {
            DBAccess dBAccess = DBAccess.getDBAccess(iConnectionPool.getConnection(), true);
            dBAccess.setConnectionPool(iConnectionPool);
            return dBAccess;
        }
        catch (Exception exception) {
            throw new DataSourceException("Create DBAccess failed!", exception);
        }
    }

    private static Class<? extends DBAccess> getDBAccessClass(String string) {
        for (String string2 : dbAccessClasses.keySet()) {
            if (!string.startsWith(string2)) continue;
            return dbAccessClasses.get(string2);
        }
        return DBAccess.class;
    }

    public static void registerDBAccessClass(String string, Class<? extends DBAccess> clazz) {
        dbAccessClasses.put(string, clazz);
    }

    public static void setAutomaticLinkColumnNameTranslation(TranslationMap translationMap) {
        tmpAutoLinkColumnNames = translationMap;
    }

    public static TranslationMap getAutomaticLinkColumnNameTranslation() {
        return tmpAutoLinkColumnNames;
    }

    public static long getDefaultCursorCacheTimeout() {
        return lDefaultCursorCacheTimeout;
    }

    public static void setDefaultCursorCacheTimeout(long l) {
        lDefaultCursorCacheTimeout = l;
    }

    public static long getDefaultLargeObjectLimit() {
        return lDefaultLargeObjectLimit;
    }

    public static void setDefaultLargeObjectLimit(long l) {
        lDefaultLargeObjectLimit = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        long l;
        ArrayUtil<Key> arrayUtil;
        ArrayUtil<Key> arrayUtil2;
        ResultSet resultSet;
        block11: {
            resultSet = null;
            arrayUtil2 = new ArrayUtil<Key>();
            arrayUtil = new ArrayUtil<Key>();
            l = System.currentTimeMillis();
            DatabaseMetaData databaseMetaData = this.getConnectionIntern().getMetaData();
            resultSet = databaseMetaData.getIndexInfo(DBAccess.removeQuotes(string), DBAccess.removeQuotes(string2), DBAccess.removeQuotes(string3), true, false);
            if (resultSet.next()) break block11;
            CommonUtil.close(resultSet);
            ArrayUtil<Key> arrayUtil3 = arrayUtil2;
            CommonUtil.close(resultSet);
            return arrayUtil3;
        }
        try {
            String string4 = null;
            do {
                if (resultSet.getString("COLUMN_NAME") == null) continue;
                if (string4 != null && !resultSet.getString("INDEX_NAME").equals(string4)) {
                    object = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                    arrayUtil2.add((Key)object);
                    arrayUtil.clear();
                }
                string4 = resultSet.getString("INDEX_NAME");
                object = this.removeDBSpecificQuotes(resultSet.getString("COLUMN_NAME"));
                arrayUtil.add((Key)((Object)new Name((String)object, this.quote((String)object))));
            } while (resultSet.next());
            if (arrayUtil.size() > 0) {
                object = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                arrayUtil2.add((Key)object);
            }
            if (arrayUtil2.size() > 0 && (object = this.getPrimaryKey(string, string2, string3)) != null) {
                for (int i = arrayUtil2.size() - 1; i >= 0; --i) {
                    Name[] nameArray = arrayUtil2.get(i).getColumns();
                    if (!ArrayUtil.containsAll(nameArray, ((Key)object).getColumns()) || nameArray.length != ((Key)object).getColumns().length) continue;
                    arrayUtil2.remove(i);
                }
            }
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil2;
        }
        catch (SQLException sQLException) {
            try {
                DBAccess.error("Unique Keys couldn't determined from database! - ", string3, sQLException);
                arrayUtil = null;
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet);
                throw throwable;
            }
            CommonUtil.close(resultSet);
            return arrayUtil;
        }
        CommonUtil.close(resultSet);
        return object;
    }

    public long getLargeObjectLimit() {
        return this.lLargeObjectLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Key getPrimaryKeyIntern(String string, String string2, String string3) throws DataSourceException {
        Key key;
        String string4;
        ArrayUtil<Name> arrayUtil;
        long l;
        ResultSet resultSet;
        block8: {
            resultSet = null;
            l = System.currentTimeMillis();
            arrayUtil = new ArrayUtil<Name>();
            string4 = null;
            DatabaseMetaData databaseMetaData = this.getConnectionIntern().getMetaData();
            resultSet = databaseMetaData.getPrimaryKeys(DBAccess.removeQuotes(string), DBAccess.removeQuotes(string2), DBAccess.removeQuotes(string3));
            if (resultSet.next()) break block8;
            Key key2 = null;
            CommonUtil.close(resultSet);
            return key2;
        }
        try {
            Key key3;
            do {
                if (string4 == null) {
                    string4 = resultSet.getString("PK_NAME");
                }
                arrayUtil.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
            } while (resultSet.next());
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getPK(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            key = key3 = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
        }
        catch (SQLException sQLException) {
            Key key4;
            try {
                DBAccess.error("PrimaryKey couldn't determined from database! - ", string3, sQLException);
                key4 = null;
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet);
                throw throwable;
            }
            CommonUtil.close(resultSet);
            return key4;
        }
        CommonUtil.close(resultSet);
        return key;
    }

    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        ArrayUtil<ForeignKey> arrayUtil;
        long l;
        ArrayUtil<ForeignKey> arrayUtil2;
        ResultSet resultSet;
        block8: {
            resultSet = null;
            arrayUtil2 = new ArrayUtil<ForeignKey>();
            l = System.currentTimeMillis();
            DatabaseMetaData databaseMetaData = this.getConnectionIntern().getMetaData();
            resultSet = databaseMetaData.getImportedKeys(DBAccess.removeQuotes(string), DBAccess.removeQuotes(string2), DBAccess.removeQuotes(string3));
            if (resultSet.next()) break block8;
            ArrayUtil<ForeignKey> arrayUtil3 = arrayUtil2;
            CommonUtil.close(resultSet);
            return arrayUtil3;
        }
        try {
            ArrayUtil<Name> arrayUtil4 = new ArrayUtil<Name>();
            ArrayUtil<Name> arrayUtil5 = new ArrayUtil<Name>();
            ForeignKey foreignKey = new ForeignKey(new Name(resultSet.getString("PKTABLE_NAME"), this.quote(resultSet.getString("PKTABLE_NAME"))), new Name(resultSet.getString("PKTABLE_CAT"), this.quote(resultSet.getString("PKTABLE_CAT"))), new Name(resultSet.getString("PKTABLE_SCHEM"), this.quote(resultSet.getString("PKTABLE_SCHEM"))));
            do {
                if (resultSet.getInt("KEY_SEQ") == 1 && !arrayUtil4.isEmpty()) {
                    foreignKey.setFKColumns(arrayUtil5.toArray(new Name[arrayUtil5.size()]));
                    foreignKey.setPKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
                    arrayUtil2.add(foreignKey);
                    arrayUtil4.clear();
                    arrayUtil5.clear();
                    foreignKey = new ForeignKey(new Name(resultSet.getString("PKTABLE_NAME"), this.quote(resultSet.getString("PKTABLE_NAME"))), new Name(resultSet.getString("PKTABLE_CAT"), this.quote(resultSet.getString("PKTABLE_CAT"))), new Name(resultSet.getString("PKTABLE_SCHEM"), this.quote(resultSet.getString("PKTABLE_SCHEM"))));
                }
                arrayUtil4.add(new Name(resultSet.getString("PKCOLUMN_NAME"), this.quote(resultSet.getString("PKCOLUMN_NAME"))));
                arrayUtil5.add(new Name(resultSet.getString("FKCOLUMN_NAME"), this.quote(resultSet.getString("FKCOLUMN_NAME"))));
                foreignKey.setFKName(resultSet.getString("FK_NAME"));
            } while (resultSet.next());
            foreignKey.setFKColumns(arrayUtil5.toArray(new Name[arrayUtil5.size()]));
            foreignKey.setPKColumns(arrayUtil4.toArray(new Name[arrayUtil4.size()]));
            arrayUtil2.add(foreignKey);
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            arrayUtil = arrayUtil2;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet);
        return arrayUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Key> getUniqueKeys(String string, String string2, String string3) throws DataSourceException {
        String string4;
        String string5;
        List<Key> list;
        block7: {
            List<Key> list2;
            block8: {
                String string6;
                if (!this.isMetaDataCacheEnabled()) break block7;
                String string7 = this.getIdentifier();
                list2 = ghtUKsCache.get(string7, string6 = DBAccess.createIdentifier(string, string2, string3));
                if (list2 != null) break block8;
                Record record = ProtocolFactory.openRecord("DB", "GET_UKS", string, string2, string3);
                try {
                    list2 = this.getUniqueKeysIntern(string, string2, string3);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                if (list2 == null) {
                    list2 = UKS_NULL;
                }
                ghtUKsCache.put(string7, string6, list2);
            }
            if (list2 == UKS_NULL) {
                return null;
            }
            return list2;
        }
        Record record = ProtocolFactory.openRecord("DB", "GET_UKS", string, string2, string3);
        try {
            list = this.getUniqueKeysIntern(string, string2, string3);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        if (DBStorage.isGlobalMetaDataCacheEnabled() && ghtUKsCache.get(string5 = this.getIdentifier(), string4 = DBAccess.createIdentifier(string, string2, string3)) != null) {
            ghtUKsCache.put(string5, string4, list != null ? list : UKS_NULL);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Key getPrimaryKey(String string, String string2, String string3) throws DataSourceException {
        String string4;
        String string5;
        Key key;
        block7: {
            Key key2;
            block8: {
                String string6;
                if (!this.isMetaDataCacheEnabled()) break block7;
                String string7 = this.getIdentifier();
                key2 = ghtPKCache.get(string7, string6 = DBAccess.createIdentifier(string, string2, string3));
                if (key2 != null) break block8;
                Record record = ProtocolFactory.openRecord("DB", "GET_PK", string, string2, string3);
                try {
                    key2 = this.getPrimaryKeyIntern(string, string2, string3);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                if (key2 == null) {
                    key2 = PKS_NULL;
                }
                ghtPKCache.put(string7, string6, key2);
            }
            if (key2 == PKS_NULL) {
                return null;
            }
            return key2;
        }
        Record record = ProtocolFactory.openRecord("DB", "GET_PK", string, string2, string3);
        try {
            key = this.getPrimaryKeyIntern(string, string2, string3);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        if (DBStorage.isGlobalMetaDataCacheEnabled() && ghtPKCache.get(string5 = this.getIdentifier(), string4 = DBAccess.createIdentifier(string, string2, string3)) != null) {
            ghtPKCache.put(string5, string4, key != null ? key : PKS_NULL);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ForeignKey> getForeignKeys(String string, String string2, String string3) throws DataSourceException {
        String string4;
        String string5;
        List<ForeignKey> list;
        block7: {
            List<ForeignKey> list2;
            block8: {
                String string6;
                if (!this.isMetaDataCacheEnabled()) break block7;
                String string7 = this.getIdentifier();
                list2 = ghtFKsCache.get(string7, string6 = DBAccess.createIdentifier(string, string2, string3));
                if (list2 != null) break block8;
                Record record = ProtocolFactory.openRecord("DB", "GET_FKS", string, string2, string3);
                try {
                    list2 = this.getForeignKeysIntern(string, string2, string3);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                if (list2 == null) {
                    list2 = FKS_NULL;
                }
                ghtFKsCache.put(string7, string6, list2);
            }
            if (list2 == FKS_NULL) {
                return null;
            }
            return list2;
        }
        Record record = ProtocolFactory.openRecord("DB", "GET_FKS", string, string2, string3);
        try {
            list = this.getForeignKeysIntern(string, string2, string3);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        if (DBStorage.isGlobalMetaDataCacheEnabled() && ghtFKsCache.get(string5 = this.getIdentifier(), string4 = DBAccess.createIdentifier(string, string2, string3)) != null) {
            ghtFKsCache.put(string5, string4, list != null ? list : FKS_NULL);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getTableForSynonym(String string) throws DataSourceException {
        String string2;
        String string3;
        String string4;
        block7: {
            String string5;
            block8: {
                String string6;
                if (!this.isMetaDataCacheEnabled()) break block7;
                String string7 = this.getIdentifier();
                string5 = ghtTableNameCache.get(string7, string6 = DBAccess.createIdentifier(string));
                if (string5 != null) break block8;
                Record record = ProtocolFactory.openRecord("DB", "GET_TABLESYNONYM", string);
                try {
                    string5 = this.getTableForSynonymIntern(string);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                if (string5 == null) {
                    string5 = TABLENAME_NULL;
                }
                ghtTableNameCache.put(string7, string6, string5);
            }
            if (string5 == TABLENAME_NULL) {
                return null;
            }
            return string5;
        }
        Record record = ProtocolFactory.openRecord("DB", "GET_TABLESYNONYM", string);
        try {
            string4 = this.getTableForSynonymIntern(string);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        if (DBStorage.isGlobalMetaDataCacheEnabled() && ghtTableNameCache.get(string3 = this.getIdentifier(), string2 = DBAccess.createIdentifier(string)) != null) {
            ghtTableNameCache.put(string3, string2, string4 != null ? string4 : TABLENAME_NULL);
        }
        return string4;
    }

    protected String getTableForSynonymIntern(String string) throws DataSourceException {
        return string;
    }

    @Override
    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, int n, int n2, boolean bl) throws DataSourceException {
        return this.fetch(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, null, n, n2, bl);
    }

    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        return this.fetch(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, null, n, n2, false);
    }

    public List<Object[]> fetch(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5, int n, int n2) throws DataSourceException {
        return this.fetch(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, string5, n, n2, false);
    }

    /*
     * Exception decompiling
     */
    public List<Object[]> fetch(ServerMetaData var1_1, String var2_2, String[] var3_3, String var4_4, ICondition var5_5, String var6_6, String var7_7, SortDefinition var8_8, String var9_9, int var10_10, int var11_11, boolean var12_12) throws DataSourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 12[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void lockRow(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        try {
            if (!this.isAutoCommit() && this.getConnectionIntern().getMetaData().supportsSelectForUpdate()) {
                this.lockRowInternal(string, serverMetaData, iCondition);
            }
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Execute locking failed!", this.formatSQLException(sQLException));
        }
    }

    protected int lockRowInternal(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        int n = this.getRowCount(this.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition), iCondition, 1);
        this.setModified(Boolean.TRUE);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] insert(String string, ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        Object[] objectArray2;
        Record record = ProtocolFactory.openRecord("DB", "INSERT", string);
        try {
            int n;
            if (!this.isOpen()) {
                throw new DataSourceException("DBAccess is not open!");
            }
            if (string == null) {
                throw new DataSourceException("Missing WriteBackTable!");
            }
            StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
            stringBuilder.append(string);
            stringBuilder.append(" (");
            int n2 = 0;
            String string2 = null;
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray = serverMetaData.getWritableColumnIndices();
            for (n = 0; n < nArray.length; ++n) {
                if (objectArray[nArray[n]] == null) continue;
                if (n2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(serverColumnMetaDataArray[nArray[n]].getColumnName().getQuotedName());
                ++n2;
            }
            if (n2 == 0) {
                for (n = 0; n2 == 0 && n < nArray.length; ++n) {
                    if (serverColumnMetaDataArray[nArray[n]].isAutoIncrement()) continue;
                    string2 = serverColumnMetaDataArray[nArray[n]].getColumnName().getQuotedName();
                    stringBuilder.append(string2);
                    ++n2;
                }
            }
            stringBuilder.append(") VALUES (");
            if (n2 > 0) {
                stringBuilder.append("?");
                for (n = 1; n < n2; ++n) {
                    stringBuilder.append(",?");
                }
            }
            stringBuilder.append(")");
            if (record != null) {
                if (objectArray != null && objectArray.length > 0) {
                    record.setParameter(stringBuilder, this.formatParameter(objectArray));
                } else {
                    record.setParameter(stringBuilder);
                }
            }
            objectArray = this.insertDatabaseSpecific(string, stringBuilder.toString(), serverMetaData, objectArray, string2);
            this.setModified(Boolean.TRUE);
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug(stringBuilder, "[", objectArray, "]");
            }
            if (serverMetaData.getPrimaryKeyType() != ServerMetaData.PrimaryKeyType.AllColumns) {
                n = 1;
                int[] nArray2 = serverMetaData.getPrimaryKeyColumnIndices();
                if (nArray2 != null) {
                    for (int i = 0; i < nArray2.length && n != 0; ++i) {
                        if (objectArray[nArray2[i]] == null) continue;
                        n = 0;
                    }
                }
                if (n != 0) {
                    throw new DataSourceException("Primary key column empty after insert! " + string);
                }
            }
            objectArray2 = objectArray;
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return objectArray2;
    }

    public void setLargeObjectLimit(long l) {
        this.lLargeObjectLimit = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] update(String string, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        Object[] objectArray3;
        Object[] objectArray4;
        Record record;
        block28: {
            int n;
            int n2;
            StringBuilder stringBuilder;
            block27: {
                record = ProtocolFactory.openRecord("DB", "UPDATE", string);
                try {
                    objectArray4 = (Object[])objectArray2.clone();
                    if (!this.isOpen()) {
                        throw new DataSourceException("DBAccess is not open!");
                    }
                    if (string == null) {
                        throw new DataSourceException("Missing WriteBackTable!");
                    }
                    if (serverMetaData.getPrimaryKeyColumnNames() == null || serverMetaData.getPrimaryKeyColumnNames().length == 0) {
                        throw new DataSourceException("PK Columns empty! - update not possible!");
                    }
                    stringBuilder = new StringBuilder("UPDATE ");
                    stringBuilder.append(string);
                    stringBuilder.append(" SET ");
                    n2 = 0;
                    ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
                    int[] nArray = serverMetaData.getWritableColumnIndices();
                    Object[] objectArray5 = null;
                    if (record != null) {
                        objectArray5 = new Object[]{};
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        IDataType iDataType = serverColumnMetaDataArray[nArray[i]].getDataType();
                        objectArray3 = objectArray2[nArray[i]];
                        Object object = objectArray[nArray[i]];
                        if (!(objectArray3 instanceof RemoteFileHandle && object instanceof RemoteFileHandle && CommonUtil.equals(((RemoteFileHandle)objectArray3).getObjectCacheKey(), ((RemoteFileHandle)object).getObjectCacheKey()))) {
                            if (objectArray3 instanceof IFileHandle) {
                                try {
                                    objectArray3 = FileUtil.getContent(((IFileHandle)objectArray3).getInputStream());
                                    objectArray2[nArray[i]] = objectArray3;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (object instanceof IFileHandle) {
                                try {
                                    objectArray[nArray[i]] = object = (Object)FileUtil.getContent(((IFileHandle)object).getInputStream());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (iDataType.compareTo(objectArray3, object) == 0) continue;
                        if (n2 > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(serverColumnMetaDataArray[nArray[i]].getColumnName().getQuotedName());
                        stringBuilder.append(" = ? ");
                        ++n2;
                        if (record == null) continue;
                        objectArray5 = ArrayUtil.add(objectArray5, objectArray3);
                    }
                    ICondition iCondition = Filter.createEqualsFilter(serverMetaData.getPrimaryKeyColumnNames(), objectArray, serverMetaData.getMetaData().getColumnMetaData());
                    n = 0;
                    if (n2 == 0) {
                        try {
                            if (!this.isAutoCommit() && this.getConnectionIntern().getMetaData().supportsSelectForUpdate()) {
                                n = this.lockRowInternal(string, serverMetaData, iCondition);
                            }
                            objectArray3 = new StringBuilder("SELECT * FROM ");
                            objectArray3.append(string);
                            objectArray3.append(this.getWhereClause(serverMetaData, iCondition, null, false));
                            n = this.getRowCount(objectArray3.toString(), iCondition, 1);
                        }
                        catch (SQLException sQLException) {
                            throw new DataSourceException("Connection access failed!", this.formatSQLException(sQLException));
                        }
                    } else {
                        stringBuilder.append(this.getWhereClause(serverMetaData, iCondition, null, false));
                        n = this.updateDatabaseSpecific(string, stringBuilder.toString(), serverMetaData, objectArray, objectArray2, iCondition);
                        this.setModified(Boolean.TRUE);
                        if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                            DBAccess.debug(stringBuilder, "[", objectArray2, "]");
                        }
                    }
                    if (record != null) {
                        record.setCount(n);
                        objectArray5 = ArrayUtil.addAll(objectArray5, this.getParameter(iCondition));
                        if (objectArray5 != null && objectArray5.length > 0) {
                            record.setParameter(stringBuilder, this.formatParameter(objectArray5));
                        } else {
                            record.setParameter(stringBuilder);
                        }
                    }
                    if (n != 0) break block27;
                    objectArray3 = this.insert(string, serverMetaData, objectArray4);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                return objectArray3;
            }
            if (n != 1) {
                throw new DataSourceException("Update failed ! - Result row count != 1 ! - " + stringBuilder);
            }
            if (n2 != 0) break block28;
            objectArray3 = objectArray;
            CommonUtil.close(record);
            return objectArray3;
        }
        objectArray3 = objectArray4;
        CommonUtil.close(record);
        return objectArray3;
    }

    public int updateDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2, ICondition iCondition) throws DataSourceException {
        return this.updateAnsiSQL(string, string2, serverMetaData, objectArray, objectArray2, iCondition);
    }

    public int updateAnsiSQL(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2, ICondition iCondition) throws DataSourceException {
        int n;
        ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
        int[] nArray = serverMetaData.getWritableColumnIndices();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getPreparedStatement(string2);
            if (this.iTransactionTimeout >= 0) {
                try {
                    preparedStatement.setQueryTimeout(this.iTransactionTimeout);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            int n2 = this.setColumnsToStore(preparedStatement, serverColumnMetaDataArray, nArray, objectArray2, objectArray) + 1;
            this.setFilterParameter(n2, preparedStatement, this.getParameter(iCondition));
            n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Update AnsiSQL failed! - " + string2, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string, ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        Record record = ProtocolFactory.openRecord("DB", "DELETE", string);
        try {
            PreparedStatement preparedStatement;
            block17: {
                if (!this.isOpen()) {
                    throw new DataSourceException("DBAccess is not open!");
                }
                if (string == null) {
                    throw new DataSourceException("Missing WriteBackTable!");
                }
                if (serverMetaData.getPrimaryKeyColumnNames() == null || serverMetaData.getPrimaryKeyColumnNames().length == 0) {
                    throw new DataSourceException("PK Columns empty! - delete not possible!");
                }
                ICondition iCondition = null;
                ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
                String[] stringArray = serverMetaData.getPrimaryKeyColumnNames();
                if (serverColumnMetaDataArray != null) {
                    iCondition = Filter.createEqualsFilter(stringArray, objectArray, serverMetaData.getMetaData().getColumnMetaData());
                } else {
                    iCondition = new Equals(stringArray[0], objectArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        iCondition = iCondition.and(new Equals(stringArray[i], objectArray[i]));
                    }
                }
                StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
                stringBuilder.append(string);
                String string2 = this.getWhereClause(serverMetaData, iCondition, null, false);
                stringBuilder.append(string2);
                DBAccess.debug("delete(", stringBuilder, ")", stringArray, objectArray);
                preparedStatement = null;
                try {
                    preparedStatement = this.getPreparedStatement(stringBuilder.toString());
                    if (this.iTransactionTimeout >= 0) {
                        try {
                            preparedStatement.setQueryTimeout(this.iTransactionTimeout);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    Object[] objectArray2 = this.getParameter(iCondition);
                    this.setFilterParameter(1, preparedStatement, objectArray2);
                    int n = preparedStatement.executeUpdate();
                    this.setModified(Boolean.TRUE);
                    if (n > 1) {
                        throw new DataSourceException("Delete failed ! - Result row count > 1 ! - " + n + "," + stringBuilder);
                    }
                    if (record == null) break block17;
                    if (objectArray2 != null && objectArray2.length > 0) {
                        record.setParameter(stringBuilder, this.formatParameter(objectArray2));
                        break block17;
                    }
                    record.setParameter(stringBuilder);
                }
                catch (SQLException sQLException) {
                    try {
                        throw new DataSourceException("Delete failed! - " + stringBuilder, this.formatSQLException(sQLException));
                    }
                    catch (Throwable throwable) {
                        CommonUtil.close(preparedStatement);
                        throw throwable;
                    }
                }
            }
            CommonUtil.close(preparedStatement);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        try {
            bl = this.isOpen();
        }
        catch (DataSourceException dataSourceException) {
            stringBuilder.append("::");
            stringBuilder.append(dataSourceException.getMessage());
            return stringBuilder.toString();
        }
        String string = this.sPassword != null ? ",Password set" : ",Password not set";
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        properties.remove("user");
        properties.remove("password");
        stringBuilder.append("DBAccess :: Connected=");
        stringBuilder.append(bl);
        stringBuilder.append(", ConnectionString=");
        stringBuilder.append(this.sUrl);
        stringBuilder.append(", DriverName=");
        stringBuilder.append(this.sDriver);
        stringBuilder.append(", UserName=");
        stringBuilder.append(this.sUsername);
        stringBuilder.append(string);
        stringBuilder.append(",Properties=");
        stringBuilder.append(properties);
        stringBuilder.append("\n");
        stringBuilder.append("ResultSet Cache:\n");
        for (Map.Entry<String, Cursor> entry : this.htFetchResultSetCache.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("\n");
        }
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    public String getOpenQuoteCharacter() {
        return this.sOpenQuote;
    }

    public String getCloseQuoteCharacter() {
        return this.sCloseQuote;
    }

    protected void setQuoteCharacters(String string, String string2) {
        this.sOpenQuote = string;
        this.sCloseQuote = string2;
    }

    public boolean isAutoQuote(String string) {
        StringUtil.CaseSensitiveType caseSensitiveType = StringUtil.getCaseSensitiveType(string);
        return caseSensitiveType != StringUtil.CaseSensitiveType.UpperCase;
    }

    public String quote(String string) {
        if (string == null) {
            return null;
        }
        if (this.isAutoQuote(string)) {
            return this.quoteAllways(string);
        }
        return string;
    }

    public String quoteAllways(String string) {
        StringBuilder stringBuilder = new StringBuilder(QUOTE);
        stringBuilder.append(StringUtil.replace(string, QUOTE, "\\`"));
        stringBuilder.append(QUOTE);
        return stringBuilder.toString();
    }

    public static String removeQuotes(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = QUOTE.charAt(0);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c == c2) {
                if (i == 0 || string.charAt(i - 1) != '\\') continue;
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public String removeDBSpecificQuotes(String string) {
        return StringUtil.removeQuotes(string, this.sOpenQuote, this.sCloseQuote);
    }

    public String translateQuotes(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = QUOTE.charAt(0);
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c == c2) {
                if (i != 0 && string.charAt(i - 1) == '\\') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    stringBuilder.append(c2);
                    continue;
                }
                if (bl) {
                    stringBuilder.append(this.sOpenQuote);
                    bl = false;
                    continue;
                }
                stringBuilder.append(this.sCloseQuote);
                bl = true;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open() throws DataSourceException {
        if (!this.isOpen()) {
            ISession iSession = SessionContext.getCurrentSession();
            if (iSession != null) {
                this.sApplicationName = iSession.getApplicationName();
            }
            if (this.sApplicationName == null) {
                this.sApplicationName = "";
            }
            long l = System.currentTimeMillis();
            try {
                if (!this.bExternalConnection) {
                    Connection connection;
                    block22: {
                        if (this.sUrl == null) {
                            throw new DataSourceException("Connection String is null!");
                        }
                        String string = this.translateQuotes(this.sUsername);
                        connection = null;
                        if (!DBAccess.isJdbc(this.sUrl)) {
                            try {
                                InitialContext initialContext = new InitialContext();
                                try {
                                    Object object = initialContext.lookup(this.sUrl);
                                    if (object instanceof Connection) {
                                        connection = (Connection)object;
                                        this.bAutoClose = true;
                                        this.bExternalConnection = true;
                                    } else if (object instanceof DataSource) {
                                        this.connectionPool = new DataSourceConnectionPool((DataSource)object, string, this.sPassword);
                                        connection = this.connectionPool.getConnection();
                                        this.bAutoClose = true;
                                        this.bExternalConnection = true;
                                    } else {
                                        if (!(object instanceof IConnectionPool)) throw new DataSourceException("Configured JNDI resource '" + this.sUrl + "' has to be a Connection, but is " + (object != null ? object.getClass().getName() : "null"));
                                        this.connectionPool = (IConnectionPool)object;
                                        connection = this.connectionPool.getConnection();
                                        this.bAutoClose = true;
                                        this.bExternalConnection = true;
                                    }
                                    break block22;
                                }
                                finally {
                                    initialContext.close();
                                }
                            }
                            catch (Exception exception) {
                                if (!(exception instanceof DataSourceException)) throw new DataSourceException("JNDI URL used, but resource was not found!", exception);
                                throw (DataSourceException)exception;
                            }
                        }
                        if (this.sDriver == null) {
                            throw new DataSourceException("Jdbc Driver is null!");
                        }
                        try {
                            Class.forName(this.sDriver);
                        }
                        catch (Exception exception) {
                            throw new DataSourceException("Jdbc driver not found!", exception);
                        }
                        Properties properties = new Properties();
                        properties.putAll((Map<?, ?>)this.properties);
                        if (this.sUsername != null) {
                            properties.setProperty("user", this.sUsername);
                        }
                        if (this.sPassword != null) {
                            properties.setProperty("password", this.sPassword);
                        }
                        connection = DriverManager.getConnection(this.sUrl, properties);
                    }
                    this.prepareConnection(connection);
                    this.setConnection(connection);
                }
                this.initializeMaxColumnLength();
                this.setModified(Boolean.FALSE);
                this.bOpen = true;
                this.connection.setAutoCommit(this.bAutoCommit);
                this.fireEventConfigureConnection();
                if (!DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) return;
                DBAccess.debug("open(", this.sUrl, ",", this.translateQuotes(this.sUsername), ") in ", System.currentTimeMillis() - l, "ms");
                return;
            }
            catch (SQLException sQLException) {
                String string = this.sPassword != null ? "Password set" : "Password not set";
                throw new DataSourceException("Connection failed! - " + this.sUrl + "; Username=" + this.sUsername + "; " + string, this.formatSQLException(sQLException));
            }
        }
        DBAccess.debug("connection is already open!");
    }

    private void initializeMaxColumnLength() {
        try {
            this.iMaxColumnLength = this.getConnectionIntern().getMetaData().getMaxColumnNameLength();
            if (this.iMaxColumnLength == 0) {
                this.iMaxColumnLength = Integer.MAX_VALUE;
            }
        }
        catch (SQLException sQLException) {
            this.iMaxColumnLength = 30;
            DBAccess.debug(sQLException);
        }
    }

    public boolean isOpen() throws DataSourceException {
        try {
            if (this.bOpen && this.connection != null && this.connection.isClosed()) {
                this.close();
            }
            return this.bOpen;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Open failed!", this.formatSQLException(sQLException));
        }
    }

    @Override
    public void close() throws DataSourceException {
        if (this.connection != null && this.bOpen) {
            this.commitOrRollbackBeforeClose();
            this.bOpen = false;
            this.releaseConnection();
            if (this.bAutoClose && this.connection != null) {
                this.clearFetchResultSetCache();
                this.fireEventUnconfigureConnection();
                CommonUtil.close(this.connection);
                this.setConnection(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFetchResultSetCache() {
        Hashtable<String, Cursor> hashtable = this.htFetchResultSetCache;
        synchronized (hashtable) {
            for (Map.Entry<String, Cursor> entry : this.htFetchResultSetCache.entrySet()) {
                CommonUtil.close(entry.getValue());
            }
            this.htFetchResultSetCache.clear();
        }
    }

    protected void commitOrRollbackBeforeClose() {
        try {
            if (!this.isAutoCommit()) {
                this.rollback();
            }
        }
        catch (DataSourceException dataSourceException) {
            DBAccess.debug(dataSourceException);
        }
    }

    public void setAutoCommit(boolean bl) throws DataSourceException {
        this.bAutoCommit = bl;
        this.setModified(Boolean.FALSE);
        if (this.isOpen()) {
            try {
                this.getConnectionIntern().setAutoCommit(this.bAutoCommit);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Setting autocommit state failed!", this.formatSQLException(sQLException));
            }
        }
    }

    public boolean isAutoCommit() {
        return this.bAutoCommit;
    }

    public void rollback() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        try {
            this.getConnectionIntern().rollback();
            this.setModified(Boolean.FALSE);
            this.releaseConnectionIntern();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Rollback failed!", this.formatSQLException(sQLException));
        }
    }

    public void commit() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBAccess is not open!");
        }
        try {
            this.getConnectionIntern().commit();
            this.setModified(Boolean.FALSE);
            this.releaseConnectionIntern();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Commit failed!", this.formatSQLException(sQLException));
        }
    }

    public int getQueryTimeout() {
        return this.iQueryTimeout;
    }

    public void setQueryTimeout(int n) {
        this.iQueryTimeout = n;
    }

    public int getTransactionTimeout() {
        return this.iTransactionTimeout;
    }

    public void setTransactionTimeout(int n) {
        this.iTransactionTimeout = n;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.getConnectionIntern();
        this.setModified(null);
        return connection;
    }

    protected Connection getConnectionIntern() throws SQLException {
        if (this.connection == null && this.connectionPool != null) {
            Connection connection = this.connectionPool.getConnection();
            this.prepareConnection(connection);
            this.setConnection(connection);
            this.connection.setAutoCommit(this.bAutoCommit);
            this.fireEventConfigureConnection();
            this.releaseConnectionIntern();
        }
        return this.connection;
    }

    public void releaseConnection() throws DataSourceException {
        if (this.isModified()) {
            throw new DataSourceException("Connection is modified and cannot be released!");
        }
        if (this.connectionPool != null && this.connection != null) {
            this.clearFetchResultSetCache();
            this.fireEventUnconfigureConnection();
            this.connectionPool.releaseConnection(this.connection);
            this.setConnection(null);
        }
    }

    public boolean isReleaseConnectionPending() {
        return this.bReleaseConnectionPending;
    }

    protected void releaseConnectionIntern() {
        SessionContext sessionContext;
        if (this.connectionPool != null && this.connection != null && this.isConnectionPoolEnabled() && !this.isReleaseConnectionPending() && (sessionContext = SessionContext.getCurrentInstance()) != null) {
            this.bReleaseConnectionPending = true;
            sessionContext.getCallHandler().invokeFinally(new Runnable(){

                public void run() {
                    DBAccess.this.bReleaseConnectionPending = false;
                    if (DBAccess.this.isConnectionPoolEnabled() && !DBAccess.this.isModified()) {
                        try {
                            DBAccess.this.releaseConnection();
                        }
                        catch (DataSourceException dataSourceException) {
                            DBAccess.debug(dataSourceException);
                        }
                    }
                }
            });
        }
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
        this.setModified(Boolean.FALSE);
    }

    public IConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    protected void setConnectionPool(IConnectionPool iConnectionPool) {
        this.connectionPool = iConnectionPool;
        this.releaseConnectionIntern();
    }

    public boolean isConnectionPoolEnabled() {
        return this.bConnectionPoolEnabled;
    }

    public void setConnectionPoolEnabled(boolean bl) {
        this.bConnectionPoolEnabled = bl;
        this.releaseConnectionIntern();
    }

    public EventHandler<IConfigureConnectionListener> eventConfigureConnection() {
        if (this.eventConfigureConnection == null) {
            this.eventConfigureConnection = new EventHandler<IConfigureConnectionListener>(IConfigureConnectionListener.class, new Class[0]);
        }
        return this.eventConfigureConnection;
    }

    public EventHandler<IUnconfigureConnectionListener> eventUnconfigureConnection() {
        if (this.eventUnconfigureConnection == null) {
            this.eventUnconfigureConnection = new EventHandler<IUnconfigureConnectionListener>(IUnconfigureConnectionListener.class, new Class[0]);
        }
        return this.eventUnconfigureConnection;
    }

    protected void fireEventConfigureConnection() throws SQLException {
        if (this.eventConfigureConnection != null && this.eventConfigureConnection.isDispatchable()) {
            try {
                this.eventConfigureConnection.dispatchEvent(new ConnectionEvent(this, this.connection));
            }
            catch (Throwable throwable) {
                throw new SQLException("Configure connection failed!", throwable);
            }
        }
    }

    protected void fireEventUnconfigureConnection() {
        if (this.eventUnconfigureConnection != null && this.eventUnconfigureConnection.isDispatchable()) {
            try {
                this.eventUnconfigureConnection.dispatchEvent(new ConnectionEvent(this, this.connection));
            }
            catch (Throwable throwable) {
                DBAccess.info(throwable);
            }
        }
    }

    public String getDriver() {
        return this.sDriver;
    }

    public void setDriver(String string) {
        this.sDriver = string;
    }

    public String getUrl() {
        return this.sUrl;
    }

    public void setUrl(String string) {
        this.sUrl = string;
    }

    public String getUsername() {
        return this.sUsername;
    }

    public void setUsername(String string) {
        this.sUsername = string;
    }

    public String getPassword() {
        return this.sPassword;
    }

    public void setPassword(String string) {
        this.sPassword = string;
    }

    public void setDBProperty(String string, String string2) {
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.setProperty(string, string2);
        }
    }

    public String getDBProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setDBProperties(Properties properties) {
        this.properties = properties;
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            if (!(object instanceof String)) {
                this.properties.remove(object);
                object = object.toString();
                object2 = object2 != null ? object2.toString() : "";
                this.properties.put(object, object2);
            }
            if (object2 instanceof String) continue;
            this.properties.put(object, object2 != null ? object2.toString() : "");
        }
    }

    public Properties getDBProperties() {
        return this.properties;
    }

    public int getMaxTime() {
        return this.iMaxTime;
    }

    public void setMaxTime(int n) {
        this.iMaxTime = n;
    }

    public int getMaxColumnLength() {
        return this.iMaxColumnLength;
    }

    public IColumnMetaDataCreator getColumnMetaDataCreator() {
        return this.columnMetaDataCreator;
    }

    public void setColumnMetaDataCreator(IColumnMetaDataCreator iColumnMetaDataCreator) {
        this.columnMetaDataCreator = iColumnMetaDataCreator;
    }

    public void setColumnMetaDataCreator(Object object, String string) {
        if (this.columnMetaDataCreatorProvider == null) {
            this.columnMetaDataCreatorProvider = new EventHandler<IColumnMetaDataCreator>(IColumnMetaDataCreator.class, new Class[0]);
        }
        this.columnMetaDataCreator = this.columnMetaDataCreatorProvider.createListener(object, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcedure(String string, Object ... objectArray) throws SQLException {
        Record record = ProtocolFactory.openRecord("DB", "EXECUTE_PROCEDURE", new Object[0]);
        try {
            if (record != null) {
                if (objectArray != null && objectArray.length > 0) {
                    record.setParameter(string, this.formatParameter(objectArray));
                } else {
                    record.setParameter(string);
                }
            }
            StringBuilder stringBuilder = new StringBuilder("{ call ");
            stringBuilder.append(string);
            if (objectArray != null && objectArray.length > 0) {
                stringBuilder.append("(");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("?");
                }
                stringBuilder.append(")");
            }
            stringBuilder.append(" }");
            CallableStatement callableStatement = null;
            try {
                AbstractParam.ParameterType parameterType;
                AbstractParam abstractParam;
                int n;
                DBAccess.debug("executeProcedure -> ", stringBuilder, objectArray);
                callableStatement = this.getConnection().prepareCall(this.translateQuotes(stringBuilder.toString()));
                for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                    if (objectArray[n] == null) {
                        callableStatement.setNull(n + 1, 12);
                        continue;
                    }
                    if (objectArray[n] instanceof AbstractParam) {
                        abstractParam = (AbstractParam)objectArray[n];
                        parameterType = abstractParam.getType();
                        if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                            callableStatement.registerOutParameter(n + 1, abstractParam.getSqlType());
                        }
                        if (abstractParam.getValue() == null) {
                            callableStatement.setNull(n + 1, abstractParam.getSqlType());
                            continue;
                        }
                        callableStatement.setObject(n + 1, this.convertValueToDatabaseSpecificObject(abstractParam.getValue()), abstractParam.getSqlType());
                        continue;
                    }
                    callableStatement.setObject(n + 1, this.convertValueToDatabaseSpecificObject(objectArray[n]));
                }
                callableStatement.execute();
                for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                    if (!(objectArray[n] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[n]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
                    abstractParam.setValue(callableStatement.getObject(n + 1));
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(callableStatement);
                throw throwable;
            }
            CommonUtil.close(callableStatement);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    public Object executeFunction(String string, int n, Object ... objectArray) throws SQLException {
        return this.executeFunction(string, new OutParam(n), objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object executeFunction(String string, OutParam outParam, Object ... objectArray) throws SQLException {
        AbstractParam.ParameterType parameterType;
        AbstractParam abstractParam;
        Record record = ProtocolFactory.openRecord("DB", "EXECUTE_FUNCTION", new Object[0]);
        if (record != null) {
            if (objectArray != null && objectArray.length > 0) {
                record.setParameter(string, this.formatParameter(objectArray));
            } else {
                record.setParameter(string);
            }
        }
        StringBuilder stringBuilder = new StringBuilder("{ ? = call ");
        stringBuilder.append(string);
        if (objectArray != null && objectArray.length > 0) {
            stringBuilder.append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" }");
        CallableStatement callableStatement = null;
        DBAccess.debug("executeFunction -> ", stringBuilder, objectArray);
        callableStatement = this.getConnection().prepareCall(this.translateQuotes(stringBuilder.toString()));
        callableStatement.registerOutParameter(1, outParam.getSqlType());
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                callableStatement.setNull(i + 2, 12);
                continue;
            }
            if (objectArray[i] instanceof AbstractParam) {
                abstractParam = (AbstractParam)objectArray[i];
                parameterType = abstractParam.getType();
                if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                    callableStatement.registerOutParameter(i + 2, abstractParam.getSqlType());
                }
                if (abstractParam.getValue() == null) {
                    callableStatement.setNull(i + 2, abstractParam.getSqlType());
                    continue;
                }
                callableStatement.setObject(i + 2, this.convertValueToDatabaseSpecificObject(abstractParam.getValue()), abstractParam.getSqlType());
                continue;
            }
            callableStatement.setObject(i + 2, this.convertValueToDatabaseSpecificObject(objectArray[i]));
        }
        if (callableStatement.execute()) {
            CommonUtil.close(callableStatement.getResultSet());
        }
        Object object = callableStatement.getObject(1);
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[i]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
            abstractParam.setValue(callableStatement.getObject(i + 2));
        }
        outParam.setValue(object);
        Object object2 = object;
        CommonUtil.close(callableStatement);
        CommonUtil.close(record);
        return object2;
        {
            catch (Throwable throwable) {
                try {
                    CommonUtil.close(callableStatement);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CommonUtil.close(record);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public int executeStatement(String var1_1, Object ... var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<Bean> executeQuery(String string, Object ... objectArray) throws SQLException {
        Object object;
        Record record = ProtocolFactory.openRecord("DB", "EXECUTE_QUERY", new Object[0]);
        if (record != null) {
            if (objectArray != null && objectArray.length > 0) {
                record.setParameter(string, this.formatParameter(objectArray));
            } else {
                record.setParameter(string);
            }
        }
        PreparedStatement preparedStatement = null;
        String string2 = this.translateQuotes(string);
        preparedStatement = this.getConnection().prepareStatement(string2);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    preparedStatement.setNull(i + 1, 12);
                    continue;
                }
                preparedStatement.setObject(i + 1, this.convertValueToDatabaseSpecificObject(objectArray[i]));
            }
        }
        DBAccess.debug("executeQuery -> ", string, objectArray);
        ArrayUtil<Bean> arrayUtil = new ArrayUtil<Bean>();
        if (preparedStatement.execute()) {
            object = preparedStatement.getResultSet();
            ResultSetMetaData resultSetMetaData = object.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            BeanType beanType = new BeanType();
            for (int i = 1; i <= n; ++i) {
                beanType.addPropertyDefinition(resultSetMetaData.getColumnName(i));
            }
            try {
                while (object.next()) {
                    Bean bean = new Bean(beanType);
                    for (int i = 0; i < n; ++i) {
                        bean.put(i, this.getObjectFromResultSet((ResultSet)object, i + 1));
                    }
                    arrayUtil.add(bean);
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(object);
                throw throwable;
            }
            CommonUtil.close(object);
        }
        if (record != null) {
            record.setCount(arrayUtil.size());
        }
        object = arrayUtil;
        CommonUtil.close(preparedStatement);
        CommonUtil.close(record);
        return object;
        {
            catch (Throwable throwable) {
                try {
                    CommonUtil.close(preparedStatement);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CommonUtil.close(record);
                    throw throwable2;
                }
            }
        }
    }

    public List<Object> executeSql(String string, Object ... objectArray) throws SQLException {
        return this.executeSqlMulti(string, 0, objectArray);
    }

    /*
     * Exception decompiling
     */
    protected List<Object> executeSqlMulti(String var1_1, int var2_2, Object ... var3_3) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PreparedStatement getPreparedStatement(String string) throws SQLException {
        return this.getPreparedStatement(string, false);
    }

    protected PreparedStatement getPreparedStatement(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement;
        string = this.translateQuotes(string);
        if (bl) {
            try {
                preparedStatement = this.getConnectionIntern().prepareStatement(string, 1);
            }
            catch (SQLException sQLException) {
                preparedStatement = this.getConnectionIntern().prepareStatement(string);
            }
        } else {
            preparedStatement = this.getConnectionIntern().prepareStatement(string);
        }
        return preparedStatement;
    }

    protected SQLException formatSQLException(SQLException sQLException) {
        return this.formatSQLException(sQLException, sQLException.getMessage(), "" + sQLException.getErrorCode());
    }

    protected SQLException formatSQLException(SQLException sQLException, String string, String string2) {
        if (string.indexOf(string2) < 0) {
            String string3 = this.getClass().getSimpleName();
            int n = string3.indexOf("DBAccess");
            if (n >= 0) {
                string3 = string3.substring(0, n);
            }
            SQLException sQLException2 = new SQLException(string3 + "-" + string2 + ": " + string);
            sQLException2.setStackTrace(sQLException.getStackTrace());
            sQLException2.initCause(sQLException.getCause());
            return sQLException2;
        }
        return sQLException;
    }

    public ParameterizedStatement getParameterizedSelectStatement(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5, int n, int n2) throws DataSourceException {
        Object object;
        int n3;
        int n4;
        Object object2;
        if (string2 == null) {
            throw new DataSourceException("Missing FROM clause!");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n5 = 0;
        this.findNamedParameters(string, arrayList);
        this.findNamedParameters(stringArray, arrayList);
        this.findNamedParameters(string2, arrayList);
        n5 = arrayList.size();
        this.findNamedParameters(string3, arrayList);
        this.findNamedParameters(string4, arrayList);
        this.findNamedParameters(string5, arrayList);
        HashSet<String> hashSet = new HashSet<String>(arrayList);
        HashMap<String, CompareCondition> hashMap = new HashMap<String, CompareCondition>();
        ICondition iCondition2 = this.findAndCreateReducedCondition(iCondition, hashSet, hashMap);
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append("\n       ");
        }
        if (stringArray != null && stringArray.length > 0 && stringArray[0].length() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",\n       ");
                }
                stringBuilder.append(stringArray[i]);
            }
        } else {
            stringBuilder.append("*");
        }
        stringBuilder.append("\n  FROM ");
        stringBuilder.append(string2);
        stringBuilder.append("\n");
        stringBuilder.append(this.getWhereClause(serverMetaData, iCondition2, string3, true));
        if (string4 != null) {
            stringBuilder.append("\n");
            stringBuilder.append(string4);
            stringBuilder.append("\n");
        }
        if (sortDefinition != null) {
            stringBuilder.append("\nORDER BY ");
            String[] stringArray2 = sortDefinition.getColumns();
            object2 = sortDefinition.isAscending();
            for (n4 = 0; n4 < stringArray2.length; ++n4) {
                n3 = serverMetaData.getServerColumnMetaDataIndex(stringArray2[n4]);
                if (n3 < 0) {
                    stringBuilder.append(stringArray2[n4]);
                } else {
                    stringBuilder.append(serverMetaData.getServerColumnMetaData(n3).getColumnName().getQuotedName());
                }
                if (object2[n4] != false) {
                    stringBuilder.append(" ASC");
                } else {
                    stringBuilder.append(" DESC");
                }
                if (n4 + 1 >= stringArray2.length) continue;
                stringBuilder.append(", ");
            }
        } else if (!StringUtil.isEmpty(string5)) {
            stringBuilder.append("\nORDER BY ");
            stringBuilder.append(string5);
        }
        String string6 = stringBuilder.toString();
        object2 = new ArrayList();
        n3 = arrayList.size();
        for (n4 = 0; n4 < n3; ++n4) {
            String string7 = (String)arrayList.get(n4);
            CompareCondition object3 = (CompareCondition)hashMap.get(string7);
            if (object3 != null) {
                object = object3.getValue();
                if ((object3 instanceof Like || object3 instanceof LikeIgnoreCase) && object instanceof String) {
                    object2.add(((String)object).replace('*', '%').replace('?', '_'));
                    continue;
                }
                object2.add(object);
                continue;
            }
            object2.add(null);
        }
        if (!arrayList.isEmpty()) {
            n4 = 0;
            StringBuilder stringBuilder2 = new StringBuilder(string6.length());
            for (String string7 : arrayList) {
                object = (CompareCondition)hashMap.get(string7);
                int n6 = string6.indexOf(":" + string7, n4);
                if (n6 < 0) continue;
                stringBuilder2.append(string6.substring(n4, n6));
                stringBuilder2.append(this.createWhereParam(serverMetaData, (CompareCondition)object));
                n4 = n6 + string7.length() + 1;
            }
            stringBuilder2.append(string6.substring(n4));
            string6 = stringBuilder2.toString();
        }
        if (iCondition2 != null) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            this.getParameter(iCondition2, arrayList2, arrayList3, hashMap);
            object2.addAll(n5, arrayList2);
            arrayList.addAll(n5, arrayList3);
        }
        return new ParameterizedStatement(string6, arrayList, (List<Object>)object2, hashMap);
    }

    public String getSelectStatement(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5, int n, int n2) throws DataSourceException {
        return this.getSelectStatement(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, string5);
    }

    public String getSelectStatement(ServerMetaData serverMetaData, String string, String[] stringArray, String string2, ICondition iCondition, String string3, String string4, SortDefinition sortDefinition, String string5) throws DataSourceException {
        return this.getParameterizedSelectStatement(serverMetaData, string, stringArray, string2, iCondition, string3, string4, sortDefinition, string5, -1, -1).getStatement();
    }

    protected String getWhereClause(ServerMetaData serverMetaData, ICondition iCondition, String string, boolean bl) throws DataSourceException {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getSQL(serverMetaData, iCondition, bl);
        boolean bl3 = bl2 = !StringUtil.isEmpty(string);
        if (string2 != null && string2.length() > 0) {
            boolean bl4 = bl2 && iCondition instanceof Or;
            stringBuilder.append(" WHERE ");
            if (bl4) {
                stringBuilder.append("(");
            }
            stringBuilder.append(string2);
            if (bl4) {
                stringBuilder.append(")");
            }
        }
        if (bl2) {
            if (string2 == null || string2.length() == 0) {
                stringBuilder.append(" WHERE ");
            } else {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    protected String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        if (string == null) {
            throw new DataSourceException("Missing WriteBackTable!");
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM ");
        stringBuilder.append(string);
        stringBuilder.append(this.getWhereClause(serverMetaData, iCondition, null, false));
        stringBuilder.append(" FOR UPDATE");
        return stringBuilder.toString();
    }

    protected Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
    }

    public boolean supportsGetGeneratedKeys() {
        try {
            return this.getConnectionIntern().getMetaData().supportsGetGeneratedKeys();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    protected Object[] insertAnsiSQL(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block16: {
            boolean bl = this.supportsGetGeneratedKeys();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getPreparedStatement(string2, bl);
            if (this.iTransactionTimeout >= 0) {
                try {
                    preparedStatement.setQueryTimeout(this.iTransactionTimeout);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray = serverMetaData.getWritableColumnIndices();
            if (string3 == null) {
                this.setColumnsToStore(preparedStatement, serverColumnMetaDataArray, nArray, objectArray, null);
            } else {
                for (int i = 0; i < serverColumnMetaDataArray.length; ++i) {
                    if (!serverColumnMetaDataArray[i].getColumnName().getQuotedName().equals(string3)) continue;
                    preparedStatement.setObject(1, null, serverColumnMetaDataArray[i].getSQLType());
                    break;
                }
            }
            if (preparedStatement.executeUpdate() != 1) break block16;
            if (bl) {
                try {
                    resultSet = preparedStatement.getGeneratedKeys();
                    if (resultSet.next()) {
                        String[] stringArray = serverMetaData.getPrimaryKeyColumnNames();
                        int n = resultSet.getMetaData().getColumnCount();
                        for (int i = 0; i < n && stringArray != null && i < stringArray.length; ++i) {
                            Object object;
                            int n2 = serverMetaData.getServerColumnMetaDataIndex(stringArray[i]);
                            if (n2 < 0 || (object = resultSet.getObject(i + 1)) == null) continue;
                            objectArray[n2] = object;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataSourceException("The generated keys couldn't read! - " + string2, this.formatSQLException(sQLException));
                }
            }
            Object[] objectArray2 = objectArray;
            CommonUtil.close(resultSet, preparedStatement);
            return objectArray2;
        }
        try {
            try {
                throw new DataSourceException("Insert failed! - Result row count != 1" + string2);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Insert failed! - " + string2, this.formatSQLException(sQLException));
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(resultSet, preparedStatement);
            throw throwable;
        }
    }

    protected ServerColumnMetaData[] getColumnMetaDataIntern(String string, String[] stringArray, String string2, String string3, String string4) throws DataSourceException {
        ServerColumnMetaData[] serverColumnMetaDataArray;
        long l = System.currentTimeMillis();
        string3 = string3 == null ? this.getMetaDataWhereClause() : string3 + " AND " + this.getMetaDataWhereClause();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ParameterizedStatement parameterizedStatement = this.getParameterizedSelectStatement(null, string2, stringArray, string, null, string3, string4, null, null, -1, -1);
        try {
            preparedStatement = this.getPreparedStatement(parameterizedStatement.getStatement());
            if (!parameterizedStatement.getValues().isEmpty()) {
                this.setFilterParameter(1, preparedStatement, parameterizedStatement.getValuesAsArray());
            }
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
            ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
            String string5 = null;
            int n = 0;
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                Object object;
                String string6 = null;
                if (stringArray != null && n < stringArray.length) {
                    object = this.getColumnName(resultSetMetaData, i);
                    String string7 = stringArray[n].toLowerCase();
                    if (string7.endsWith(((String)object).toLowerCase()) && (string7.length() == ((String)object).length() || !Character.isLetter(string7.charAt(string7.length() - ((String)object).length() - 1)))) {
                        if (!string7.startsWith("null ")) {
                            string6 = stringArray[n];
                        }
                        string5 = null;
                        ++n;
                    } else if (string7.endsWith(".*")) {
                        string5 = string7.substring(0, string7.length() - 1);
                        ++n;
                    }
                    if (string6 == null && string5 != null) {
                        string6 = string5 + (String)object;
                    }
                }
                if (arrayUtil2.indexOf(((ServerColumnMetaData)(object = this.createServerColumnMetaData(resultSetMetaData, i, string6))).getName()) >= 0) {
                    throw new DataSourceException("Duplicate definition of '" + ((ServerColumnMetaData)object).getName() + "' in DBStorage " + parameterizedStatement.getStatement() + "!");
                }
                arrayUtil.add(object);
                arrayUtil2.add(((ServerColumnMetaData)object).getName());
            }
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getMetaData(", parameterizedStatement.getStatement(), ") in ", System.currentTimeMillis() - l, "ms");
            }
            serverColumnMetaDataArray = arrayUtil.toArray(new ServerColumnMetaData[arrayUtil.size()]);
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Meta data couldn't load from database! - " + parameterizedStatement.getStatement(), this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return serverColumnMetaDataArray;
    }

    protected String getRealQueryColumnName(String string) {
        String string2 = string.trim();
        int n = -1;
        if (string2.endsWith("\"") && string2.length() > 2) {
            n = string2.lastIndexOf(34, string2.length() - 2) - 1;
        } else if (string2.length() > 0 && string2.charAt(string2.length() - 1) != ')') {
            n = string2.lastIndexOf(32);
        }
        if (n >= 0) {
            string2 = string2.substring(0, n).trim();
        }
        if (string2.length() > 3 && string2.regionMatches(true, string2.length() - 2, "as", 0, 2) && Character.isWhitespace(string2.charAt(string2.length() - 3))) {
            string2 = string2.substring(0, string2.length() - 3).trim();
        }
        return string2;
    }

    protected ServerColumnMetaData createServerColumnMetaData(ResultSetMetaData resultSetMetaData, int n, String string) throws SQLException, DataSourceException {
        ColumnMetaData columnMetaData;
        String string2 = this.getColumnName(resultSetMetaData, n);
        Name name = new Name(string2, this.quote(string2));
        if (this.columnMetaDataCreator == null) {
            columnMetaData = new ColumnMetaData();
            this.initializeColumnMetaData(resultSetMetaData, n, columnMetaData);
        } else {
            columnMetaData = this.columnMetaDataCreator.createColumnMetaData(this, resultSetMetaData, n);
        }
        return this.initializeServerColumnMetaData(resultSetMetaData, n, string, new ServerColumnMetaData(name, columnMetaData));
    }

    protected ServerColumnMetaData initializeServerColumnMetaData(ResultSetMetaData resultSetMetaData, int n, String string, ServerColumnMetaData serverColumnMetaData) throws SQLException, DataSourceException {
        if (string == null) {
            serverColumnMetaData.setRealQueryColumnName(serverColumnMetaData.getColumnName().getQuotedName());
        } else {
            serverColumnMetaData.setRealQueryColumnName(this.getRealQueryColumnName(string));
        }
        serverColumnMetaData.setSQLType(resultSetMetaData.getColumnType(n));
        serverColumnMetaData.setSQLTypeName(resultSetMetaData.getColumnTypeName(n));
        return serverColumnMetaData;
    }

    public void initializeColumnMetaData(ResultSetMetaData resultSetMetaData, int n, ColumnMetaData columnMetaData) throws SQLException, DataSourceException {
        columnMetaData.setNullable(resultSetMetaData.isNullable(n) != 0);
        columnMetaData.setAutoIncrement(resultSetMetaData.isAutoIncrement(n));
        this.initializeDataType(resultSetMetaData, n, columnMetaData);
    }

    protected void initializeDataType(ResultSetMetaData resultSetMetaData, int n, ColumnMetaData columnMetaData) throws SQLException, DataSourceException {
        switch (resultSetMetaData.getColumnType(n)) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                columnMetaData.setTypeIdentifier(12);
                if (resultSetMetaData.getPrecision(n) > 0) {
                    columnMetaData.setPrecision(resultSetMetaData.getPrecision(n));
                    break;
                }
                columnMetaData.setPrecision(Integer.MAX_VALUE);
                break;
            }
            case -7: 
            case 16: {
                columnMetaData.setTypeIdentifier(16);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                columnMetaData.setTypeIdentifier(3);
                columnMetaData.setPrecision(0);
                columnMetaData.setScale(-1);
                columnMetaData.setSigned(resultSetMetaData.isSigned(n));
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                columnMetaData.setTypeIdentifier(3);
                if (resultSetMetaData.getPrecision(n) <= 0 || resultSetMetaData.getPrecision(n) > 30) {
                    columnMetaData.setPrecision(0);
                    columnMetaData.setScale(-1);
                } else {
                    columnMetaData.setPrecision(resultSetMetaData.getPrecision(n));
                    columnMetaData.setScale(resultSetMetaData.getScale(n));
                }
                columnMetaData.setSigned(resultSetMetaData.isSigned(n));
                break;
            }
            case -102: 
            case -101: 
            case 91: 
            case 92: 
            case 93: {
                columnMetaData.setTypeIdentifier(93);
                break;
            }
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                columnMetaData.setTypeIdentifier(-2);
                if (resultSetMetaData.getPrecision(n) > 0) {
                    columnMetaData.setPrecision(resultSetMetaData.getPrecision(n));
                    break;
                }
                columnMetaData.setPrecision(Integer.MAX_VALUE);
                break;
            }
            default: {
                throw new DataSourceException(columnMetaData.getName() + " :: SQL Type '" + resultSetMetaData.getColumnType(n) + "' is not supported!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServerColumnMetaData[] getColumnMetaData(String string, String[] stringArray, String string2, String string3, String string4) throws DataSourceException {
        String string5;
        String string6;
        ServerColumnMetaData[] serverColumnMetaDataArray;
        block8: {
            ServerColumnMetaData[] serverColumnMetaDataArray2;
            ServerColumnMetaData[] serverColumnMetaDataArray3;
            block9: {
                String string7;
                if (!this.isMetaDataCacheEnabled()) break block8;
                String string8 = this.getIdentifier();
                serverColumnMetaDataArray3 = ghtColumnMetaDataCache.get(string8, string7 = DBAccess.createIdentifier(string, stringArray, string2));
                if (serverColumnMetaDataArray3 != null) break block9;
                serverColumnMetaDataArray2 = ProtocolFactory.openRecord("DB", "GET_COLUMNMETADATA", string);
                try {
                    serverColumnMetaDataArray3 = this.getColumnMetaDataIntern(string, stringArray, string2, string3, string4);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(new Object[]{serverColumnMetaDataArray2});
                    throw throwable;
                }
                CommonUtil.close(new Object[]{serverColumnMetaDataArray2});
                if (serverColumnMetaDataArray3 == null) {
                    serverColumnMetaDataArray3 = COLUMNMETADATA_NULL;
                }
                ghtColumnMetaDataCache.put(string8, string7, serverColumnMetaDataArray3);
            }
            if (serverColumnMetaDataArray3 == COLUMNMETADATA_NULL) {
                return null;
            }
            serverColumnMetaDataArray2 = new ServerColumnMetaData[serverColumnMetaDataArray3.length];
            for (int i = 0; i < serverColumnMetaDataArray3.length; ++i) {
                serverColumnMetaDataArray2[i] = serverColumnMetaDataArray3[i].clone();
            }
            return serverColumnMetaDataArray2;
        }
        Record record = ProtocolFactory.openRecord("DB", "GET_COLUMNMETADATA", string);
        try {
            serverColumnMetaDataArray = this.getColumnMetaDataIntern(string, stringArray, string2, string3, string4);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        if (DBStorage.isGlobalMetaDataCacheEnabled() && ghtColumnMetaDataCache.get(string6 = this.getIdentifier(), string5 = DBAccess.createIdentifier(string, stringArray, string2)) != null) {
            ghtColumnMetaDataCache.put(string6, string5, serverColumnMetaDataArray != null ? serverColumnMetaDataArray : COLUMNMETADATA_NULL);
        }
        return serverColumnMetaDataArray;
    }

    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        TableInfo tableInfo;
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = this.getSelectStatement(null, null, null, string, null, this.getMetaDataWhereClause(), null, null, null);
        try {
            String string3;
            preparedStatement = this.getPreparedStatement(string2);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string4 = resultSetMetaData.getCatalogName(1);
            String string5 = resultSetMetaData.getSchemaName(1);
            if (StringUtil.isEmpty(string4)) {
                string4 = null;
            }
            if (StringUtil.isEmpty(string5)) {
                string5 = null;
            }
            String[] stringArray = this.splitSchemaTable(string);
            if (string5 == null) {
                string5 = stringArray[0];
            }
            if ((string3 = stringArray[1]) != null) {
                if ((string3 = string3.trim()).endsWith(" m")) {
                    string3 = string3.substring(0, string3.length() - 2);
                }
                string3 = string3.trim();
            }
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getTableInfo(", string2, ") in ", System.currentTimeMillis() - l, "ms");
            }
            tableInfo = new TableInfo(string4, string5, string3);
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Meta data couldn't load from database! - " + string2, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return tableInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TableInfo getTableInfo(String string) throws DataSourceException {
        String string2;
        String string3;
        TableInfo tableInfo;
        block7: {
            TableInfo tableInfo2;
            block8: {
                String string4;
                if (!this.isMetaDataCacheEnabled()) break block7;
                String string5 = this.getIdentifier();
                tableInfo2 = ghtTableInfoCache.get(string5, string4 = DBAccess.createIdentifier(string));
                if (tableInfo2 != null) break block8;
                Record record = ProtocolFactory.openRecord("DB", "GET_TABLEINFO", string);
                try {
                    tableInfo2 = this.getTableInfoIntern(string);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                if (tableInfo2 == null) {
                    tableInfo2 = TABLEINFO_NULL;
                }
                ghtTableInfoCache.put(string5, string4, tableInfo2);
            }
            if (tableInfo2 == TABLEINFO_NULL) {
                return null;
            }
            return tableInfo2;
        }
        Record record = ProtocolFactory.openRecord("DB", "GET_TABLEINFO", string);
        try {
            tableInfo = this.getTableInfoIntern(string);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        if (DBStorage.isGlobalMetaDataCacheEnabled() && ghtTableInfoCache.get(string3 = this.getIdentifier(), string2 = DBAccess.createIdentifier(string)) != null) {
            ghtTableInfoCache.put(string3, string2, tableInfo != null ? tableInfo : TABLEINFO_NULL);
        }
        return tableInfo;
    }

    private void setFilterParameter(int n, PreparedStatement preparedStatement, Object[] objectArray) throws DataSourceException {
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (objectArray[i] != null) {
                    preparedStatement.setObject(n + i, this.convertValueToDatabaseSpecificObject(objectArray[i]));
                    continue;
                }
                preparedStatement.setNull(n + i, 12);
                continue;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Set value into PreparedStatement failed!", this.formatSQLException(sQLException));
            }
        }
    }

    protected int setColumnsToStore(PreparedStatement preparedStatement, ServerColumnMetaData[] serverColumnMetaDataArray, int[] nArray, Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (serverColumnMetaDataArray[n2].getDataType().compareTo(objectArray[n2], objectArray2 == null ? null : objectArray2[n2]) == 0) continue;
            try {
                if (objectArray[n2] == null) {
                    preparedStatement.setNull(n, serverColumnMetaDataArray[n2].getSQLType());
                } else {
                    Object object = this.convertValueToDatabaseSpecificObject(objectArray[n2]);
                    if (object instanceof IFileHandle) {
                        IFileHandle iFileHandle = (IFileHandle)object;
                        preparedStatement.setObject(n, FileUtil.getContent(iFileHandle.getInputStream()));
                    } else {
                        preparedStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[n2]));
                    }
                }
                ++n;
                continue;
            }
            catch (Exception exception) {
                SQLException sQLException;
                if (exception instanceof SQLException) {
                    sQLException = this.formatSQLException((SQLException)exception);
                }
                throw new DataSourceException("Set value into PreparedStatement failed!", sQLException);
            }
        }
        return --n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        String string4;
        String string5;
        Map<String, Object> map;
        block7: {
            Map<String, Object> map2;
            block8: {
                String string6;
                if (!this.isMetaDataCacheEnabled()) break block7;
                String string7 = this.getIdentifier();
                map2 = ghtDefaultValuesCache.get(string7, string6 = DBAccess.createIdentifier(string, string2, string3));
                if (map2 != null) break block8;
                Record record = ProtocolFactory.openRecord("DB", "GET_DEFAULTVALUES", string, string2, string3);
                try {
                    map2 = this.getDefaultValuesIntern(string, string2, string3);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                if (map2 == null) {
                    map2 = DEFAULT_VALUES_NULL;
                }
                ghtDefaultValuesCache.put(string7, string6, map2);
            }
            if (map2 == DEFAULT_VALUES_NULL) {
                return null;
            }
            return map2;
        }
        Record record = ProtocolFactory.openRecord("DB", "GET_DEFAULTVALUES", string, string2, string3);
        try {
            map = this.getDefaultValuesIntern(string, string2, string3);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        if (DBStorage.isGlobalMetaDataCacheEnabled() && ghtDefaultValuesCache.get(string5 = this.getIdentifier(), string4 = DBAccess.createIdentifier(string, string2, string3)) != null) {
            ghtDefaultValuesCache.put(string5, string4, map != null ? map : DEFAULT_VALUES_NULL);
        }
        return map;
    }

    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ResultSet resultSet = null;
        try {
            long l = System.currentTimeMillis();
            resultSet = this.getConnectionIntern().getMetaData().getColumns(string, string2, string3, null);
            while (resultSet.next()) {
                object = resultSet.getString("COLUMN_DEF");
                if (StringUtil.isEmpty((String)object)) continue;
                String string4 = resultSet.getString("COLUMN_NAME");
                try {
                    Object object2 = this.translateDefaultValue(string4, resultSet.getInt("DATA_TYPE"), ((String)object).trim());
                    if (object2 == null) continue;
                    hashtable.put(new Name(string4, this.quote(string4)).getName(), object2);
                }
                catch (Exception exception) {}
            }
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("getDefaultValuesIntern(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = hashtable;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Get default values failed!", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet);
        return object;
    }

    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        string2 = StringUtil.removeQuotes(string2, "(", ")");
        string2 = StringUtil.removeQuotes(string2, "(", ")");
        string2 = StringUtil.removeQuotes(string2, "'");
        return this.translateValue(n, string2);
    }

    protected Object translateValue(int n, String string) throws Exception {
        if (StringUtil.isEmpty(string) || string.equalsIgnoreCase("null")) {
            return null;
        }
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return string;
            }
            case -7: 
            case 16: {
                try {
                    return Integer.parseInt(string) == 0 ? Boolean.FALSE : Boolean.TRUE;
                }
                catch (Exception exception) {
                    return Boolean.valueOf(string);
                }
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if ("true".equalsIgnoreCase(string)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(string)) {
                    return Boolean.FALSE;
                }
                return new BigDecimal(string);
            }
            case 91: 
            case 92: 
            case 93: {
                if (string.startsWith("0000-00-00")) {
                    return null;
                }
                return new Timestamp(this.dateUtil.parse(string).getTime());
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return null;
            }
        }
        throw new DataSourceException("SQL Type '" + n + "' is not support!");
    }

    protected Map<String, Object[]> getAllowedValuesIntern(String string, String string2, String string3) throws DataSourceException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Object[]> getAllowedValues(String string, String string2, String string3) throws DataSourceException {
        String string4;
        String string5;
        Map<String, Object[]> map;
        block7: {
            Map<String, Object[]> map2;
            block8: {
                String string6;
                if (!this.isMetaDataCacheEnabled()) break block7;
                String string7 = this.getIdentifier();
                map2 = ghtAllowedValuesCache.get(string7, string6 = DBAccess.createIdentifier(string, string2, string3));
                if (map2 != null) break block8;
                Record record = ProtocolFactory.openRecord("DB", "GET_ALLOWEDVALUES", string, string2, string3);
                try {
                    map2 = this.getAllowedValuesIntern(string, string2, string3);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    throw throwable;
                }
                CommonUtil.close(record);
                if (map2 == null) {
                    map2 = ALLOWED_VALUES_NULL;
                }
                ghtAllowedValuesCache.put(string7, string6, map2);
            }
            if (map2 == ALLOWED_VALUES_NULL) {
                return null;
            }
            return map2;
        }
        Record record = ProtocolFactory.openRecord("DB", "GET_ALLOWEDVALUES", string, string2, string3);
        try {
            map = this.getAllowedValuesIntern(string, string2, string3);
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        if (DBStorage.isGlobalMetaDataCacheEnabled() && ghtAllowedValuesCache.get(string5 = this.getIdentifier(), string4 = DBAccess.createIdentifier(string, string2, string3)) != null) {
            ghtAllowedValuesCache.put(string5, string4, map != null ? map : ALLOWED_VALUES_NULL);
        }
        return map;
    }

    public Object[] getDefaultAllowedValues(String string, String string2, String string3, ServerColumnMetaData serverColumnMetaData) {
        if (serverColumnMetaData.getTypeIdentifier() == 16) {
            return new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        }
        return null;
    }

    private int getRowCount(String string, ICondition iCondition, int n) throws DataSourceException {
        int n2;
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getPreparedStatement(string);
            this.setFilterParameter(1, preparedStatement, this.getParameter(iCondition));
            resultSet = preparedStatement.executeQuery();
            if (DBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                DBAccess.debug("select (", string, ",...) in ", System.currentTimeMillis() - l, "ms");
            }
            int n3 = 0;
            while (resultSet.next()) {
                if (n < 0 || ++n3 <= n) continue;
                throw new DataSourceException("Too many rows found! " + string);
            }
            n2 = n3;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Get row count failed! " + string, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return n2;
    }

    protected String getSQL(ServerMetaData serverMetaData, ICondition iCondition, boolean bl) throws DataSourceException {
        StringBuilder stringBuilder = new StringBuilder();
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            Object object = compareCondition.getValue();
            if (!compareCondition.isIgnoreNull() || object != null) {
                String string = null;
                if (serverMetaData != null) {
                    try {
                        string = bl ? serverMetaData.getServerColumnMetaData(compareCondition.getColumnName()).getRealQueryColumnName() : serverMetaData.getServerColumnMetaData(compareCondition.getColumnName()).getColumnName().getQuotedName();
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = compareCondition.getColumnName();
                }
                if ((compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) && compareCondition.getValue() != null) {
                    if (compareCondition instanceof LikeReverse) {
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                    } else if (compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("UPPER(");
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                        stringBuilder.append(")");
                    }
                } else if (compareCondition instanceof LikeIgnoreCase) {
                    stringBuilder.append("UPPER(");
                    stringBuilder.append(this.createWhereColumn(serverMetaData, compareCondition, string));
                    stringBuilder.append(")");
                } else {
                    stringBuilder.append(this.createWhereColumn(serverMetaData, compareCondition, string));
                }
                stringBuilder.append(' ');
                if (compareCondition.getValue() == null) {
                    stringBuilder.append("IS NULL");
                } else {
                    if (compareCondition instanceof Equals) {
                        stringBuilder.append("= ");
                    } else if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("LIKE UPPER(");
                    } else if (compareCondition instanceof Like || compareCondition instanceof LikeReverse) {
                        stringBuilder.append("LIKE ");
                    } else if (compareCondition instanceof Greater) {
                        stringBuilder.append("> ");
                    } else if (compareCondition instanceof GreaterEquals) {
                        stringBuilder.append(">= ");
                    } else if (compareCondition instanceof Less) {
                        stringBuilder.append("< ");
                    } else if (compareCondition instanceof LessEquals) {
                        stringBuilder.append("<= ");
                    } else {
                        stringBuilder.append(' ');
                    }
                    if (compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(this.createReplace(this.createReplace(this.createWhereColumn(serverMetaData, compareCondition, string), "*", "%"), "?", "_"));
                    } else {
                        stringBuilder.append(this.createWhereParam(serverMetaData, compareCondition));
                    }
                    if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(")");
                    }
                }
            }
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                String string = this.getSQL(serverMetaData, iConditionArray[i], bl);
                if (string == null || string.length() <= 0) continue;
                if (i > 0 && stringBuilder.length() > 0) {
                    if (operatorCondition instanceof And) {
                        stringBuilder.append(" AND ");
                    } else if (operatorCondition instanceof Or) {
                        stringBuilder.append(" OR ");
                    }
                }
                if (iConditionArray[i] instanceof OperatorCondition) {
                    stringBuilder.append("(");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                    continue;
                }
                stringBuilder.append(string);
            }
        } else if (iCondition instanceof Not) {
            ICondition iCondition2 = ((Not)iCondition).getCondition();
            String string = this.getSQL(serverMetaData, iCondition2, bl);
            stringBuilder.append("NOT ");
            if (iCondition2 instanceof OperatorCondition) {
                stringBuilder.append("(");
                stringBuilder.append(string);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected String createReplace(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("REPLACE(");
        stringBuilder.append(string);
        stringBuilder.append(",'");
        stringBuilder.append(string2);
        stringBuilder.append("','");
        stringBuilder.append(string3);
        stringBuilder.append("')");
        return stringBuilder.toString();
    }

    protected String createWhereParam(ServerMetaData serverMetaData, CompareCondition compareCondition) {
        return "?";
    }

    protected String createWhereColumn(ServerMetaData serverMetaData, CompareCondition compareCondition, String string) {
        return string;
    }

    public boolean isTypeEqual(ServerColumnMetaData serverColumnMetaData, CompareCondition compareCondition) {
        if (compareCondition instanceof Equals) {
            Object object = compareCondition.getValue();
            int n = serverColumnMetaData.getTypeIdentifier();
            if (object instanceof String && n != 12 || object instanceof Timestamp && n != 93 || object instanceof BigDecimal && n != 3 || object instanceof Boolean && n != 16) {
                return false;
            }
        }
        return true;
    }

    protected Object[] getParameter(ICondition iCondition, int n, int n2) {
        return this.getParameter(iCondition);
    }

    protected Object[] getParameter(ICondition iCondition) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getParameter(iCondition, arrayList, new ArrayList<String>(), new HashMap<String, CompareCondition>());
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    protected String[] splitSchemaTable(String string) {
        int n;
        int n2;
        boolean bl = false;
        if (string.indexOf(44) >= 0) {
            bl = true;
        }
        if (this.sOpenQuote != null && this.sOpenQuote.length() > 0 && string.indexOf(this.sOpenQuote) >= 0) {
            bl = true;
        }
        if ((n2 = string.indexOf(32)) > 0 && (n = string.indexOf(32, n2 + 1)) > n2) {
            bl = true;
        }
        String[] stringArray = new String[2];
        if (!bl) {
            int n3;
            if (n2 < 0) {
                n2 = string.length();
            }
            if ((n3 = string.indexOf(46)) > 0) {
                stringArray[0] = string.substring(0, n3);
                stringArray[1] = string.substring(n3 + 1, n2);
            } else {
                stringArray[1] = string.substring(0, n2);
            }
        } else {
            stringArray[1] = string;
        }
        return stringArray;
    }

    public void setDefaultSchema(String string) {
        this.sDefaultSchema = string;
    }

    public String getDefaultSchema() {
        return this.sDefaultSchema;
    }

    protected Object getObjectFromResultSet(ResultSet resultSet, int n, ServerColumnMetaData serverColumnMetaData) throws SQLException {
        if (serverColumnMetaData.getColumnMetaData().getTypeIdentifier() == 16) {
            Object object = resultSet.getObject(n);
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                return ((Number)object).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (object instanceof String) {
                String string = ((String)object).trim();
                if (string.length() == 0) {
                    return null;
                }
                try {
                    return Integer.parseInt(string) == 0 ? Boolean.FALSE : Boolean.TRUE;
                }
                catch (Exception exception) {
                    return Boolean.valueOf(string);
                }
            }
            return object;
        }
        return this.getObjectFromResultSet(resultSet, n);
    }

    protected Object getObjectFromResultSet(ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        if (object instanceof Number && !(object instanceof BigDecimal)) {
            object = resultSet.getBigDecimal(n);
        } else if (object instanceof Date && !(object instanceof Timestamp)) {
            object = resultSet.getTimestamp(n);
        }
        return object;
    }

    protected Object convertDatabaseSpecificObjectToValue(ServerColumnMetaData serverColumnMetaData, Object object) throws SQLException {
        return object;
    }

    protected Object convertValueToDatabaseSpecificObject(Object object) {
        if (object instanceof Date && !(object instanceof Timestamp)) {
            return new Timestamp(((Date)object).getTime());
        }
        return object;
    }

    protected String getIdentifier() {
        if (this.sIdentifier == null) {
            this.sIdentifier = DBAccess.createIdentifier(this.sUrl, this.sUsername);
        }
        kvlApplicationGroups.put(this.sApplicationName, this.sIdentifier, true);
        return this.sIdentifier;
    }

    public static void clearMetaData() {
        AbstractCachedStorage.clearMetaData();
        kvlApplicationGroups.clear();
        ghtFKsCache.clear();
        ghtPKCache.clear();
        ghtUKsCache.clear();
        ghtDefaultValuesCache.clear();
        ghtAllowedValuesCache.clear();
        ghtColumnMetaDataCache.clear();
        ghtTableInfoCache.clear();
        ghtTableNameCache.clear();
    }

    public static void clearMetaData(String string) {
        String string2 = CommonUtil.nvl(string, "");
        AbstractCachedStorage.clearMetaData(string2);
        List<String> list = kvlApplicationGroups.remove(string2);
        if (list != null) {
            for (String string3 : list) {
                ghtFKsCache.remove(string3);
                ghtPKCache.remove(string3);
                ghtUKsCache.remove(string3);
                ghtDefaultValuesCache.remove(string3);
                ghtAllowedValuesCache.remove(string3);
                ghtColumnMetaDataCache.remove(string3);
                ghtTableInfoCache.remove(string3);
                ghtTableNameCache.remove(string3);
            }
        }
    }

    public static String createIdentifier(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append('/');
            Object object = objectArray[i];
            if (object == null) continue;
            if (object instanceof Object[]) {
                Object[] objectArray2 = (Object[])object;
                for (int j = 0; j < objectArray2.length; ++j) {
                    if (j > 0) {
                        stringBuilder.append(";");
                    }
                    if ((object = objectArray2[j]) == null) continue;
                    stringBuilder.append(object);
                }
                continue;
            }
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public void setMetaDataCacheOption(MetaDataCacheOption metaDataCacheOption) {
        this.mdcCacheOption = metaDataCacheOption == null ? MetaDataCacheOption.Default : metaDataCacheOption;
    }

    public MetaDataCacheOption getMetaDataCacheOption() {
        return this.mdcCacheOption;
    }

    protected boolean isMetaDataCacheEnabled() {
        String string;
        ISession iSession;
        if (lastGlobalMetaDataCache && !DBStorage.isGlobalMetaDataCacheEnabled()) {
            DBAccess.clearMetaData();
        }
        lastGlobalMetaDataCache = DBStorage.isGlobalMetaDataCacheEnabled();
        MetaDataCacheOption metaDataCacheOption = this.mdcCacheOption != MetaDataCacheOption.Default ? this.mdcCacheOption : ((iSession = SessionContext.getCurrentSession()) != null ? ((string = (String)iSession.getProperty("server.client.metadatacache_option")) == null ? MetaDataCacheOption.Default : MetaDataCacheOption.resolve(string)) : MetaDataCacheOption.Default);
        return metaDataCacheOption == MetaDataCacheOption.On || DBStorage.isGlobalMetaDataCacheEnabled() && metaDataCacheOption == MetaDataCacheOption.Default;
    }

    protected void prepareConnection(Connection connection) throws SQLException {
        if (connection.getTransactionIsolation() != 2) {
            connection.setTransactionIsolation(2);
        }
    }

    protected void setModified(Boolean bl) {
        this.bModified = this.isAutoCommit() ? Boolean.FALSE : bl;
    }

    public boolean isModified() {
        if (this.bModified == null) {
            if (this.connection == null) {
                this.bModified = Boolean.FALSE;
            } else if (this.detectModified()) {
                this.bModified = Boolean.TRUE;
            } else {
                return false;
            }
        }
        return this.bModified;
    }

    protected boolean detectModified() {
        return true;
    }

    protected static boolean isLogEnabled(ILogger.LogLevel logLevel) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(DBAccess.class);
        }
        return logger.isEnabled(logLevel);
    }

    protected static void debug(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(DBAccess.class);
        }
        logger.debug(objectArray);
    }

    protected static void info(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(DBAccess.class);
        }
        logger.info(objectArray);
    }

    protected static void error(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(DBAccess.class);
        }
        logger.error(objectArray);
    }

    public static boolean isJdbc(String string) {
        return string == null || string.toLowerCase().startsWith("jdbc:");
    }

    protected void findNamedParameters(String string, List<String> list) {
        String string2;
        if (string == null || string.length() == 0) {
            return;
        }
        String string3 = this.getOpenQuoteCharacter();
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if ((string2 = this.getCloseQuoteCharacter()) != null && string2.length() == 0) {
            string2 = null;
        }
        String string4 = null;
        for (int i = 0; i < string.length(); ++i) {
            int n;
            if (string4 != null) {
                if (!string.startsWith(string4, i)) continue;
                string4 = null;
                continue;
            }
            if (string.startsWith("'", i)) {
                string4 = "'";
                continue;
            }
            if (string3 != null && string.startsWith(string3, i)) {
                string4 = string2;
                continue;
            }
            if (string.startsWith("--", i)) {
                string4 = "\n";
                continue;
            }
            if (string.startsWith("/*", i)) {
                string4 = "*/";
                continue;
            }
            if (!string.startsWith(":", i)) continue;
            for (n = i + 1; n < string.length() && Character.isJavaIdentifierPart(string.charAt(n)); ++n) {
            }
            if (n - i > 0) {
                list.add(string.substring(i + 1, n));
            }
            i = n;
        }
    }

    protected String getColumnName(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return resultSetMetaData.getColumnName(n);
    }

    protected int getDiscardRowCount(int n, int n2) {
        return n;
    }

    private void getParameter(ICondition iCondition, List<Object> list, List<String> list2, Map<String, CompareCondition> map) {
        if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            Object object = compareCondition.getValue();
            if (object != null) {
                list2.add(compareCondition.getColumnName());
                map.put(compareCondition.getColumnName(), compareCondition);
                if ((compareCondition instanceof Like || compareCondition instanceof LikeIgnoreCase) && object instanceof String) {
                    list.add(((String)object).replace('*', '%').replace('?', '_'));
                } else {
                    list.add(object);
                }
            }
        } else if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                this.getParameter(iConditionArray[i], list, list2, map);
            }
        } else if (iCondition instanceof Not) {
            this.getParameter(((Not)iCondition).getCondition(), list, list2, map);
        }
    }

    private void findNamedParameters(String[] stringArray, List<String> list) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.findNamedParameters(stringArray[i], list);
            }
        }
    }

    protected ICondition findAndCreateReducedCondition(ICondition iCondition, Set<String> set, Map<String, CompareCondition> map) {
        if (iCondition instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)iCondition;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = iConditionArray.length - 1; i >= 0; --i) {
                ICondition iCondition2 = this.findAndCreateReducedCondition(iConditionArray[i], set, map);
                if (iCondition2 != null) {
                    iConditionArray[i] = iCondition2;
                    continue;
                }
                iConditionArray = (ICondition[])ArrayUtil.remove(iConditionArray, i);
            }
            if (iConditionArray.length == 0) {
                return null;
            }
            if (iConditionArray.length == 1) {
                return iConditionArray[0];
            }
            if (operatorCondition instanceof And) {
                return new And(iConditionArray);
            }
            if (operatorCondition instanceof Or) {
                return new Or(iConditionArray);
            }
        } else if (iCondition instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)iCondition;
            if (set.contains(compareCondition.getColumnName())) {
                map.put(compareCondition.getColumnName(), compareCondition);
                return null;
            }
        } else if (iCondition instanceof Not) {
            ICondition iCondition3 = this.findAndCreateReducedCondition(((Not)iCondition).getCondition(), set, map);
            if (iCondition3 != null) {
                return new Not(iCondition3);
            }
            return null;
        }
        return iCondition;
    }

    private Object[] formatParameter(Object[] objectArray) {
        if (objectArray != null) {
            Object[] objectArray2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof String)) continue;
                if (objectArray2 == null) {
                    objectArray2 = (Object[])objectArray.clone();
                }
                objectArray2[i] = "'" + objectArray[i] + "'";
            }
            if (objectArray2 != null) {
                return objectArray2;
            }
        }
        return objectArray;
    }

    protected String getMetaDataWhereClause() {
        return "1=2";
    }

    static {
        DBAccess.registerDBAccessClass("jdbc:oracle:", OracleDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:db2:", DB2DBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:derby:", DerbyDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:jtds:sqlserver:", MSSQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:mysql:", MySQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:postgresql:", PostgreSQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:hsqldb:", HSQLDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:sap:", HanaDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:sqlite:", SQLiteDBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:h2:", H2DBAccess.class);
        DBAccess.registerDBAccessClass("jdbc:tibero:", TiberoDBAccess.class);
        tmpAutoLinkColumnNames.put("*_id*", "*0*1");
        tmpAutoLinkColumnNames.put("*_ID*", "*0*1");
    }

    private static class DBAccessObserver
    implements IValidatable {
        private WeakReference<DBAccess> dBAccessToObserve;

        public DBAccessObserver(DBAccess dBAccess) {
            this.dBAccessToObserve = new WeakReference<DBAccess>(dBAccess);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isValid() {
            block6: {
                try {
                    DBAccess dBAccess = (DBAccess)this.dBAccessToObserve.get();
                    if (dBAccess == null) break block6;
                    long l = System.currentTimeMillis() - DBAccess.getDefaultCursorCacheTimeout();
                    Hashtable hashtable = dBAccess.htFetchResultSetCache;
                    synchronized (hashtable) {
                        for (Map.Entry entry : dBAccess.htFetchResultSetCache.entrySet()) {
                            Cursor cursor = (Cursor)entry.getValue();
                            if (cursor.iLastAccessTime >= l) continue;
                            cursor.close();
                            dBAccess.htFetchResultSetCache.remove(entry.getKey());
                        }
                    }
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static final class Cursor
    implements ICloseable {
        private PreparedStatement statement;
        private ResultSet rsResultSet;
        private int iExecutionTime;
        private String sSelectStatement;
        private Object[] oaParameter;
        private int iLastRow;
        private long iLastAccessTime;

        private Cursor() {
        }

        void init(PreparedStatement preparedStatement, ResultSet resultSet, String string, Object[] objectArray, int n) {
            this.statement = preparedStatement;
            this.rsResultSet = resultSet;
            this.sSelectStatement = string;
            this.oaParameter = objectArray;
            this.iExecutionTime = n;
        }

        private boolean isUseable(String string, Object[] objectArray, int n) {
            if (this.sSelectStatement.equals(string) && this.iLastRow == n) {
                return Arrays.equals(this.oaParameter, objectArray);
            }
            return false;
        }

        public void close() {
            CommonUtil.close(this.rsResultSet, this.statement);
        }

        static /* synthetic */ boolean access$000(Cursor cursor, String string, Object[] objectArray, int n) {
            return cursor.isUseable(string, objectArray, n);
        }

        static /* synthetic */ String access$100(Cursor cursor) {
            return cursor.sSelectStatement;
        }

        static /* synthetic */ PreparedStatement access$200(Cursor cursor) {
            return cursor.statement;
        }

        static /* synthetic */ ResultSet access$300(Cursor cursor) {
            return cursor.rsResultSet;
        }

        static /* synthetic */ int access$500(Cursor cursor) {
            return cursor.iExecutionTime;
        }

        static /* synthetic */ int access$602(Cursor cursor, int n) {
            cursor.iLastRow = n;
            return cursor.iLastRow;
        }

        static /* synthetic */ long access$702(Cursor cursor, long l) {
            cursor.iLastAccessTime = l;
            return cursor.iLastAccessTime;
        }
    }

    public static final class BlobFileHandle
    implements IFileHandle,
    IValidatable {
        private DBAccess dBAccess;
        private String statement;
        private Object[] parameter;
        private String columnName;
        private long length;
        private long iLastAccessTime;

        public BlobFileHandle(DBAccess dBAccess, String string, Object[] objectArray, String string2, long l) {
            this.dBAccess = dBAccess;
            this.statement = string;
            this.parameter = objectArray;
            this.columnName = string2;
            this.length = l;
            this.iLastAccessTime = System.currentTimeMillis();
        }

        public String getFileName() {
            return this.columnName;
        }

        public InputStream getInputStream() throws IOException {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block5: {
                InputStream inputStream;
                this.iLastAccessTime = System.currentTimeMillis();
                preparedStatement = null;
                resultSet = null;
                try {
                    preparedStatement = this.dBAccess.getPreparedStatement(this.statement);
                    for (int i = 0; i < this.parameter.length; ++i) {
                        preparedStatement.setObject(i + 1, this.parameter[i]);
                    }
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block5;
                    inputStream = ((Blob)this.dBAccess.getObjectFromResultSet(resultSet, 1)).getBinaryStream();
                }
                catch (Exception exception) {
                    try {
                        throw new IOException(exception.getMessage());
                    }
                    catch (Throwable throwable) {
                        CommonUtil.close(preparedStatement, resultSet);
                        throw throwable;
                    }
                }
                CommonUtil.close(preparedStatement, resultSet);
                return inputStream;
            }
            CommonUtil.close(preparedStatement, resultSet);
            throw new IOException("Row not found, fetch Blob failed!");
        }

        public long getLength() throws IOException {
            return this.length;
        }

        public boolean isValid() {
            try {
                long l = System.currentTimeMillis() - DBAccess.getDefaultCursorCacheTimeout();
                return this.dBAccess.isOpen() && this.iLastAccessTime >= l;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParameterizedStatement {
        private List<String> names = null;
        private Map<String, CompareCondition> nameToCondition = null;
        private String statement = null;
        private List<Object> values = null;
        private Object[] valuesAsArray = null;

        public ParameterizedStatement(String string, List<String> list, List<Object> list2, Map<String, CompareCondition> map) {
            this.statement = string;
            this.names = list;
            this.values = list2;
            this.nameToCondition = map;
        }

        public List<String> getNames() {
            return this.names;
        }

        public Map<String, CompareCondition> getNameToCondition() {
            return this.nameToCondition;
        }

        public String getStatement() {
            return this.statement;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public Object[] getValuesAsArray() {
            if (this.valuesAsArray == null) {
                this.valuesAsArray = this.values.toArray(new Object[this.values.size()]);
            }
            return this.valuesAsArray;
        }

        public void setStatement(String string) {
            this.statement = string;
        }

        public void setValues(List<Object> list) {
            this.values = list;
        }
    }
}

