/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.rad.persist.jdbc.TableInfo;
import com.sibvisions.rad.persist.jdbc.param.AbstractParam;
import com.sibvisions.rad.persist.jdbc.param.OutParam;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.type.CommonUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.model.condition.ICondition;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOracleDBAccess
extends DBAccess {
    private static String sUKSelect = "SELECT c.constraint_name FROM all_constraints c WHERE c.constraint_type = 'U' AND c.table_name = ? AND c.owner = ?";
    private static String sConstraintColumnsSelect = "SELECT c.column_name ,c.table_name FROM all_cons_columns c WHERE c.owner = ? AND c.constraint_name = ? ORDER BY POSITION";
    private static String sPKSelect = "SELECT c.constraint_name FROM all_constraints c WHERE c.constraint_type = 'P' AND c.table_name = ? AND c.owner = ?";
    private static String sFKSelect = "SELECT c.constraint_name fk_name ,c.r_owner pktable_schem ,c.r_constraint_name pk_name FROM all_constraints c WHERE c.constraint_type = 'R' AND c.table_name = ? AND c.owner = ?";
    private static String sCheckSelect = "select c.search_condition from all_constraints c where c.constraint_type = 'C' and c.generated = 'USER NAME' and c.table_name = ? and c.owner = ?";
    private static String sDefaultValueSelect = "select c.column_name, c.data_type, c.data_default from all_tab_columns c where c.data_default is not null and c.table_name = ? and c.owner = ?";

    protected abstract Object convertArrayToList(Object var1) throws SQLException;

    protected abstract Object convertToArray(AbstractParam var1) throws SQLException;

    @Override
    public String getDatabaseSpecificLockStatement(String string, ServerMetaData serverMetaData, ICondition iCondition) throws DataSourceException {
        return super.getDatabaseSpecificLockStatement(string, serverMetaData, iCondition) + " NOWAIT";
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        return this.insertOracle(string, string2, serverMetaData, objectArray, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void open() throws DataSourceException {
        super.open();
        Statement statement = null;
        try {
            try {
                statement = this.getConnectionIntern().createStatement();
                statement.executeUpdate("ALTER SESSION SET NLS_COMP='BINARY'");
                statement.executeUpdate("ALTER SESSION SET NLS_SORT='BINARY'");
            }
            catch (SQLException sQLException) {
                Object var4_3 = null;
                CommonUtil.close(statement);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CommonUtil.close(statement);
            throw throwable;
        }
        CommonUtil.close(statement);
    }

    @Override
    protected List<Key> getUniqueKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement2 = null;
        try {
            ArrayUtil<Key> arrayUtil = new ArrayUtil<Key>();
            ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sUKSelect);
            preparedStatement2 = this.getPreparedStatement(sConstraintColumnsSelect);
            preparedStatement.setString(1, AbstractOracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, AbstractOracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("CONSTRAINT_NAME");
                preparedStatement2.setString(1, AbstractOracleDBAccess.removeQuotes(string2));
                preparedStatement2.setString(2, (String)object);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    arrayUtil2.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                Key key = new Key((String)object, arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                arrayUtil.add(key);
                arrayUtil2.clear();
            }
            if (AbstractOracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                AbstractOracleDBAccess.debug("getUKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil;
            Object var15_14 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Unique Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
        return object;
    }

    @Override
    protected Key getPrimaryKeyIntern(String string, String string2, String string3) throws DataSourceException {
        String string4;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            Key key = null;
            ArrayUtil<Name> arrayUtil = new ArrayUtil<Name>();
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sPKSelect);
            preparedStatement.setString(1, AbstractOracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, AbstractOracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string4 = resultSet.getString("CONSTRAINT_NAME");
                CommonUtil.close(resultSet, preparedStatement);
                preparedStatement = this.getPreparedStatement(sConstraintColumnsSelect);
                preparedStatement.setString(1, AbstractOracleDBAccess.removeQuotes(string2));
                preparedStatement.setString(2, string4);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    do {
                        arrayUtil.add(new Name(resultSet.getString("COLUMN_NAME"), this.quote(resultSet.getString("COLUMN_NAME"))));
                    } while (resultSet.next());
                    if (arrayUtil.size() > 0) {
                        key = new Key(string4, arrayUtil.toArray(new Name[arrayUtil.size()]));
                    }
                }
            }
            if (AbstractOracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                AbstractOracleDBAccess.debug("getPK(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string4 = key;
            Object var12_11 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Primary Key couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string4;
    }

    @Override
    protected List<ForeignKey> getForeignKeysIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement2 = null;
        try {
            ArrayUtil<ForeignKey> arrayUtil = new ArrayUtil<ForeignKey>();
            long l = System.currentTimeMillis();
            String string4 = this.getConnectionIntern().getCatalog();
            preparedStatement = this.getPreparedStatement(sFKSelect);
            preparedStatement2 = this.getPreparedStatement(sConstraintColumnsSelect);
            preparedStatement.setString(1, AbstractOracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, AbstractOracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString("FK_NAME");
                String string5 = resultSet.getString("PK_NAME");
                String string6 = resultSet.getString("PKTABLE_SCHEM");
                String string7 = null;
                ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
                ArrayUtil<Name> arrayUtil3 = new ArrayUtil<Name>();
                preparedStatement2.setString(1, AbstractOracleDBAccess.removeQuotes(string2));
                preparedStatement2.setString(2, (String)object);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    arrayUtil3.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                preparedStatement2.setString(1, string6);
                preparedStatement2.setString(2, string5);
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    if (string7 == null) {
                        string7 = resultSet2.getString("TABLE_NAME");
                    }
                    arrayUtil2.add(new Name(resultSet2.getString("COLUMN_NAME"), this.quote(resultSet2.getString("COLUMN_NAME"))));
                }
                CommonUtil.close(resultSet2);
                if (string7 != null) {
                    ForeignKey foreignKey = new ForeignKey(new Name(string7, this.quote(string7)), new Name(string4, this.quote(string4)), new Name(string6, this.quote(string6)));
                    foreignKey.setFKName((String)object);
                    foreignKey.setFKColumns(arrayUtil3.toArray(new Name[arrayUtil3.size()]));
                    foreignKey.setPKColumns(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                    arrayUtil.add(foreignKey);
                }
                arrayUtil2.clear();
                arrayUtil3.clear();
            }
            if (AbstractOracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                AbstractOracleDBAccess.debug("getFKs(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = arrayUtil;
            Object var20_19 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Foreign Keys couldn't determined from database! - " + string3, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement, resultSet2, preparedStatement2);
        return object;
    }

    @Override
    protected Map<String, Object> getDefaultValuesIntern(String string, String string2, String string3) throws DataSourceException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<Object, Object> hashtable = null;
        try {
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sDefaultValueSelect);
            preparedStatement.setString(1, AbstractOracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, AbstractOracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Object>();
                }
                object = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                int n = 12;
                if (string4.contains("DATE") || string4.contains("TIME") || string4.contains("INTERVAL")) {
                    n = 91;
                } else if (string4.contains("NUMBER") || string4.contains("FLOAT") || string4.contains("INTEGER")) {
                    n = 3;
                }
                String string5 = resultSet.getString(3);
                try {
                    Object object2 = this.translateDefaultValue((String)object, n, string5.trim());
                    if (object2 == null) continue;
                    hashtable.put(object, object2);
                }
                catch (Exception exception) {}
            }
            if (AbstractOracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                AbstractOracleDBAccess.debug("getDefaultValuesIntern(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            object = hashtable;
            Object var15_15 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return object;
    }

    @Override
    protected Map<String, Object[]> getAllowedValuesIntern(String string, String string2, String string3) throws DataSourceException {
        Hashtable<String, Object[]> hashtable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, Object[]> hashtable2 = null;
        Hashtable<String, List<String>> hashtable3 = null;
        try {
            long l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(sCheckSelect);
            preparedStatement.setString(1, AbstractOracleDBAccess.removeQuotes(string3));
            preparedStatement.setString(2, AbstractOracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashtable3 = CheckConstraintSupport.parseCondition(resultSet.getString(1), hashtable3, true);
            }
            hashtable2 = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable3);
            if (AbstractOracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                AbstractOracleDBAccess.debug("getAllowedValuesIntern(", string3, ") in ", System.currentTimeMillis() - l, "ms");
            }
            hashtable = hashtable2;
            Object var12_11 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return hashtable;
    }

    @Override
    protected TableInfo getTableInfoIntern(String string) throws DataSourceException {
        String string2;
        TableInfo tableInfo = super.getTableInfoIntern(string);
        String string3 = tableInfo.getSchema();
        if (string3 == null) {
            string3 = this.getUsername().toUpperCase();
        }
        if ((string2 = tableInfo.getTable()) != null && !string2.startsWith("`") && !string2.endsWith("`")) {
            string2 = string2.toUpperCase();
        }
        return new TableInfo(tableInfo.getCatalog(), string3, string2);
    }

    @Override
    protected boolean detectModified() {
        try {
            return this.executeSql("select dbms_transaction.local_transaction_id from dual", new Object[0]).get(0) != null;
        }
        catch (SQLException sQLException) {
            return super.detectModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object executeFunction(String string, OutParam outParam, Object ... objectArray) throws SQLException {
        Object object;
        Record record = ProtocolFactory.openRecord("DB", "EXECUTE_FUNCTION", new Object[0]);
        try {
            AbstractParam.ParameterType parameterType;
            AbstractParam abstractParam;
            if (record != null) {
                if (objectArray != null && objectArray.length > 0) {
                    record.setParameter(string, objectArray);
                } else {
                    record.setParameter(string);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder("begin ? := ");
            StringBuilder stringBuilder3 = new StringBuilder();
            if (outParam.getSqlType() == 16) {
                stringBuilder2.append("sys.diutil.bool_to_int(");
            }
            stringBuilder2.append(string);
            int[] nArray = new int[]{};
            if (objectArray != null && objectArray.length > 0) {
                stringBuilder2.append("(");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder2.append(", ");
                    }
                    if (objectArray[i] instanceof AbstractParam) {
                        abstractParam = (AbstractParam)objectArray[i];
                        parameterType = abstractParam.getType();
                        if ((parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) && abstractParam.getSqlType() == 16) {
                            if (stringBuilder.length() == 0) {
                                stringBuilder.append("declare ");
                            }
                            String string2 = "bool" + nArray.length;
                            stringBuilder2.append(string2);
                            stringBuilder.append(string2).append(" boolean := sys.diutil.int_to_bool(?); ");
                            stringBuilder3.append("? := sys.diutil.bool_to_int(").append(string2).append(");");
                            nArray = ArrayUtil.add(nArray, i);
                            continue;
                        }
                        if (abstractParam.getSqlType() == 16 || abstractParam.getValue() instanceof Boolean) {
                            stringBuilder2.append("sys.diutil.int_to_bool(?)");
                            continue;
                        }
                        stringBuilder2.append("?");
                        continue;
                    }
                    if (objectArray[i] instanceof Boolean) {
                        stringBuilder2.append("sys.diutil.int_to_bool(?)");
                        continue;
                    }
                    stringBuilder2.append("?");
                }
                stringBuilder2.append(")");
            }
            if (outParam.getSqlType() == 16) {
                stringBuilder2.append(")");
            }
            stringBuilder2.append("; ");
            stringBuilder2.insert(0, stringBuilder);
            stringBuilder2.append((CharSequence)stringBuilder3);
            stringBuilder2.append(" end;");
            CallableStatement callableStatement = null;
            try {
                int n;
                AbstractOracleDBAccess.debug("executeFunction -> ", stringBuilder2);
                callableStatement = this.getConnection().prepareCall(this.translateQuotes(stringBuilder2.toString()));
                if (outParam.getSqlType() == 16) {
                    callableStatement.registerOutParameter(nArray.length + 1, 4);
                } else if (outParam.getTypeName() != null) {
                    callableStatement.registerOutParameter(nArray.length + 1, outParam.getSqlType(), outParam.getTypeName());
                } else {
                    callableStatement.registerOutParameter(nArray.length + 1, outParam.getSqlType());
                }
                int n2 = 0;
                for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                    int n3;
                    Object object2;
                    n = i + nArray.length - n2 + 2;
                    if (n2 < nArray.length && nArray[n2] == i) {
                        callableStatement.registerOutParameter(objectArray.length + n2 + 2, 4);
                        object2 = ((AbstractParam)objectArray[i]).getValue();
                        if (object2 == null) {
                            callableStatement.setNull(n2 + 1, 4);
                        } else {
                            n3 = 0;
                            if (object2 instanceof Boolean && (Boolean)object2 != false || object2 instanceof Number && ((Number)object2).intValue() != 0 || object2 instanceof String && Boolean.valueOf((String)object2).booleanValue()) {
                                n3 = 1;
                            }
                            callableStatement.setObject(n2 + 1, (Object)n3);
                        }
                        ++n2;
                        continue;
                    }
                    if (objectArray[i] == null) {
                        callableStatement.setNull(n, 12);
                        continue;
                    }
                    if (objectArray[i] instanceof AbstractParam) {
                        abstractParam = (AbstractParam)objectArray[i];
                        parameterType = abstractParam.getType();
                        if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                            if (abstractParam.getTypeName() != null) {
                                callableStatement.registerOutParameter(n, abstractParam.getSqlType(), abstractParam.getTypeName());
                            } else {
                                callableStatement.registerOutParameter(n, abstractParam.getSqlType());
                            }
                        }
                        if (abstractParam.getValue() == null) {
                            if (abstractParam.getTypeName() != null) {
                                callableStatement.setNull(n, abstractParam.getSqlType(), abstractParam.getTypeName());
                                continue;
                            }
                            if (abstractParam.getSqlType() == 16) {
                                callableStatement.setNull(n, 4);
                                continue;
                            }
                            callableStatement.setNull(n, abstractParam.getSqlType());
                            continue;
                        }
                        if (abstractParam.getSqlType() == 16 || abstractParam.getValue() instanceof Boolean) {
                            object2 = abstractParam.getValue();
                            n3 = 0;
                            if (object2 instanceof Boolean && (Boolean)object2 != false || object2 instanceof Number && ((Number)object2).intValue() != 0 || object2 instanceof String && Boolean.valueOf((String)object2).booleanValue()) {
                                n3 = 1;
                            }
                            callableStatement.setObject(n, (Object)n3, 4);
                            continue;
                        }
                        callableStatement.setObject(n, this.convertValueToDatabaseSpecificObject(this.convertToArray(abstractParam)), abstractParam.getSqlType());
                        continue;
                    }
                    if (objectArray[i] instanceof Boolean) {
                        callableStatement.setObject(n, (Object)((Boolean)objectArray[i] != false ? Integer.valueOf(1) : Integer.valueOf(0)));
                        continue;
                    }
                    callableStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[i]));
                }
                if (callableStatement.execute()) {
                    CommonUtil.close(callableStatement.getResultSet());
                }
                Object object3 = callableStatement.getObject(nArray.length + 1);
                if (outParam.getSqlType() == 16 && object3 != null) {
                    object3 = ((Number)object3).intValue() != 0;
                }
                n2 = 0;
                for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                    int n4 = n + nArray.length - n2 + 2;
                    if (n2 < nArray.length && nArray[n2] == n) {
                        abstractParam = (AbstractParam)objectArray[n];
                        Object object4 = callableStatement.getObject(objectArray.length + n2 + 2);
                        if (object4 instanceof Number) {
                            abstractParam.setValue(((Number)object4).intValue() != 0);
                        } else {
                            abstractParam.setValue(null);
                        }
                        ++n2;
                        continue;
                    }
                    if (!(objectArray[n] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[n]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
                    abstractParam.setValue(this.convertArrayToList(callableStatement.getObject(n4)));
                }
                outParam.setValue(this.convertArrayToList(object3));
                object = outParam.getValue();
                Object var18_25 = null;
            }
            catch (Throwable throwable) {
                Object var18_26 = null;
                CommonUtil.close(callableStatement);
                throw throwable;
            }
            CommonUtil.close(callableStatement);
            Object var20_27 = null;
        }
        catch (Throwable throwable) {
            Object var20_28 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcedure(String string, Object ... objectArray) throws SQLException {
        Record record = ProtocolFactory.openRecord("DB", "EXECUTE_PROCEDURE", new Object[0]);
        try {
            AbstractParam.ParameterType parameterType;
            AbstractParam abstractParam;
            if (record != null) {
                if (objectArray != null && objectArray.length > 0) {
                    record.setParameter(string, objectArray);
                } else {
                    record.setParameter(string);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder("begin ");
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder2.append(string);
            int[] nArray = new int[]{};
            if (objectArray != null && objectArray.length > 0) {
                stringBuilder2.append("(");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder2.append(", ");
                    }
                    if (objectArray[i] instanceof AbstractParam) {
                        abstractParam = (AbstractParam)objectArray[i];
                        parameterType = abstractParam.getType();
                        if ((parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) && abstractParam.getSqlType() == 16) {
                            if (stringBuilder.length() == 0) {
                                stringBuilder.append("declare ");
                            }
                            String string2 = "bool" + nArray.length;
                            stringBuilder2.append(string2);
                            stringBuilder.append(string2).append(" boolean := sys.diutil.int_to_bool(?); ");
                            stringBuilder3.append("? := sys.diutil.bool_to_int(").append(string2).append(");");
                            nArray = ArrayUtil.add(nArray, i);
                            continue;
                        }
                        if (abstractParam.getSqlType() == 16 || abstractParam.getValue() instanceof Boolean) {
                            stringBuilder2.append("sys.diutil.int_to_bool(?)");
                            continue;
                        }
                        stringBuilder2.append("?");
                        continue;
                    }
                    if (objectArray[i] instanceof Boolean) {
                        stringBuilder2.append("sys.diutil.int_to_bool(?)");
                        continue;
                    }
                    stringBuilder2.append("?");
                }
                stringBuilder2.append(")");
            }
            stringBuilder2.append("; ");
            stringBuilder2.insert(0, stringBuilder);
            stringBuilder2.append((CharSequence)stringBuilder3);
            stringBuilder2.append(" end;");
            CallableStatement callableStatement = null;
            try {
                Object object;
                int n;
                int n2;
                AbstractOracleDBAccess.debug("executeProcedure -> ", stringBuilder2);
                callableStatement = this.getConnection().prepareCall(this.translateQuotes(stringBuilder2.toString()));
                int n3 = 0;
                for (n2 = 0; objectArray != null && n2 < objectArray.length; ++n2) {
                    int n4;
                    n = n2 + nArray.length - n3 + 1;
                    if (n3 < nArray.length && nArray[n3] == n2) {
                        callableStatement.registerOutParameter(objectArray.length + n3 + 1, 4);
                        object = ((AbstractParam)objectArray[n2]).getValue();
                        if (object == null) {
                            callableStatement.setNull(n3 + 1, 4);
                        } else {
                            n4 = 0;
                            if (object instanceof Boolean && (Boolean)object != false || object instanceof Number && ((Number)object).intValue() != 0 || object instanceof String && Boolean.valueOf((String)object).booleanValue()) {
                                n4 = 1;
                            }
                            callableStatement.setObject(n3 + 1, (Object)n4);
                        }
                        ++n3;
                        continue;
                    }
                    if (objectArray[n2] == null) {
                        callableStatement.setNull(n, 12);
                        continue;
                    }
                    if (objectArray[n2] instanceof AbstractParam) {
                        abstractParam = (AbstractParam)objectArray[n2];
                        parameterType = abstractParam.getType();
                        if (parameterType == AbstractParam.ParameterType.Out || parameterType == AbstractParam.ParameterType.InOut) {
                            if (abstractParam.getTypeName() != null) {
                                callableStatement.registerOutParameter(n, abstractParam.getSqlType(), abstractParam.getTypeName());
                            } else {
                                callableStatement.registerOutParameter(n, abstractParam.getSqlType());
                            }
                        }
                        if (abstractParam.getValue() == null) {
                            if (abstractParam.getTypeName() != null) {
                                callableStatement.setNull(n, abstractParam.getSqlType(), abstractParam.getTypeName());
                                continue;
                            }
                            if (abstractParam.getSqlType() == 16) {
                                callableStatement.setNull(n, 4);
                                continue;
                            }
                            callableStatement.setNull(n, abstractParam.getSqlType());
                            continue;
                        }
                        if (abstractParam.getSqlType() == 16 || abstractParam.getValue() instanceof Boolean) {
                            object = abstractParam.getValue();
                            n4 = 0;
                            if (object instanceof Boolean && (Boolean)object != false || object instanceof Number && ((Number)object).intValue() != 0 || object instanceof String && Boolean.valueOf((String)object).booleanValue()) {
                                n4 = 1;
                            }
                            callableStatement.setObject(n, (Object)n4, 4);
                            continue;
                        }
                        callableStatement.setObject(n, this.convertValueToDatabaseSpecificObject(this.convertToArray(abstractParam)), abstractParam.getSqlType());
                        continue;
                    }
                    if (objectArray[n2] instanceof Boolean) {
                        callableStatement.setObject(n, (Object)((Boolean)objectArray[n2] != false ? Integer.valueOf(1) : Integer.valueOf(0)));
                        continue;
                    }
                    callableStatement.setObject(n, this.convertValueToDatabaseSpecificObject(objectArray[n2]));
                }
                callableStatement.execute();
                n3 = 0;
                for (n2 = 0; objectArray != null && n2 < objectArray.length; ++n2) {
                    n = n2 + nArray.length - n3 + 1;
                    if (n3 < nArray.length && nArray[n3] == n2) {
                        abstractParam = (AbstractParam)objectArray[n2];
                        object = callableStatement.getObject(objectArray.length + n3 + 1);
                        if (object instanceof Number) {
                            abstractParam.setValue(((Number)object).intValue() != 0);
                        } else {
                            abstractParam.setValue(null);
                        }
                        ++n3;
                        continue;
                    }
                    if (!(objectArray[n2] instanceof AbstractParam) || (parameterType = (abstractParam = (AbstractParam)objectArray[n2]).getType()) != AbstractParam.ParameterType.Out && parameterType != AbstractParam.ParameterType.InOut) continue;
                    abstractParam.setValue(this.convertArrayToList(callableStatement.getObject(n)));
                }
                Object var17_18 = null;
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                CommonUtil.close(callableStatement);
                throw throwable;
            }
            CommonUtil.close(callableStatement);
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    protected Object[] insertOracle(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        CallableStatement callableStatement;
        block19: {
            int n;
            int[] nArray = serverMetaData.getPrimaryKeyColumnIndices();
            boolean bl = false;
            if (nArray != null) {
                for (int i = 0; i < nArray.length && !bl; ++i) {
                    bl = objectArray[nArray[i]] == null;
                }
            }
            if (bl) {
                int n2;
                StringBuffer stringBuffer = new StringBuffer("BEGIN " + string2);
                stringBuffer.append(" RETURNING ");
                for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(serverMetaData.getServerColumnMetaData(nArray[n2]).getColumnName().getQuotedName());
                }
                stringBuffer.append(" INTO ");
                for (n2 = 0; nArray != null && n2 < nArray.length; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("?");
                }
                stringBuffer.append("; END;");
                string2 = stringBuffer.toString();
            }
            callableStatement = null;
            String string4 = this.translateQuotes(string2);
            AbstractOracleDBAccess.debug("executeSQL->", string4);
            callableStatement = this.getConnectionIntern().prepareCall(string4);
            ServerColumnMetaData[] serverColumnMetaDataArray = serverMetaData.getServerColumnMetaData();
            int[] nArray2 = serverMetaData.getWritableColumnIndices();
            int n3 = 0;
            if (string3 == null) {
                n3 = this.setColumnsToStore(callableStatement, serverColumnMetaDataArray, nArray2, objectArray, null);
            } else {
                for (n = 0; n < serverColumnMetaDataArray.length; ++n) {
                    if (!serverColumnMetaDataArray[n].getColumnName().getQuotedName().equals(string3)) continue;
                    callableStatement.setObject(1, null, serverColumnMetaDataArray[n].getSQLType());
                    break;
                }
                n3 = 1;
            }
            if (bl) {
                for (n = 0; nArray != null && n < nArray.length; ++n) {
                    int n4 = serverColumnMetaDataArray[nArray[n]].getColumnMetaData().getTypeIdentifier();
                    callableStatement.registerOutParameter(n3 + n + 1, n4);
                }
            }
            if (callableStatement.executeUpdate() != 1) break block19;
            if (bl) {
                for (n = 0; nArray != null && n < nArray.length; ++n) {
                    objectArray[nArray[n]] = callableStatement.getObject(n3 + n + 1);
                }
            }
            Object[] objectArray2 = objectArray;
            Object var16_20 = null;
            CommonUtil.close(callableStatement);
            return objectArray2;
        }
        try {
            try {
                throw new DataSourceException("Insert failed ! - Result row count != 1 ! - " + string2);
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("Insert failed! - " + string2, this.formatSQLException(sQLException));
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            CommonUtil.close(callableStatement);
            throw throwable;
        }
    }

    protected String getTableForSynonymIntern(String string, String string2) throws DataSourceException {
        String string3;
        long l;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            preparedStatement = null;
            resultSet = null;
            l = System.currentTimeMillis();
            preparedStatement = this.getPreparedStatement(string);
            preparedStatement.setString(1, AbstractOracleDBAccess.removeQuotes(string2));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block8;
            String string4 = string2;
            Object var13_9 = null;
            CommonUtil.close(resultSet, preparedStatement);
            return string4;
        }
        try {
            String string5 = resultSet.getString("TABLE_OWNER");
            String string6 = resultSet.getString("TABLE_NAME");
            String string7 = resultSet.getString("DB_LINK");
            StringBuilder stringBuilder = new StringBuilder();
            if (string5 != null) {
                stringBuilder.append(string5);
                stringBuilder.append('.');
            }
            stringBuilder.append(string6);
            if (string7 != null) {
                stringBuilder.append('@');
                stringBuilder.append(string7);
            }
            if (AbstractOracleDBAccess.isLogEnabled(ILogger.LogLevel.DEBUG)) {
                AbstractOracleDBAccess.debug("getTableForSynonym(", string2, ") in ", System.currentTimeMillis() - l, "ms");
            }
            string3 = stringBuilder.toString();
            Object var13_10 = null;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Synonyms couldn't determined from database! - " + string2, this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                CommonUtil.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        CommonUtil.close(resultSet, preparedStatement);
        return string3;
    }
}

