/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 17.11.2008 - [HM] - creation
 * 06.03.2010 - [JR] - get/setConstraints: used ComponentUIResource instead of UIResource [BUGFIX]
 */
package javax.rad.genui;

import javax.rad.ui.IComponent;
import javax.rad.ui.IInsets;
import javax.rad.ui.ILayout;

/**
 * Platform and technology independent layout.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 *  
 * @param <C> instance of ILayout
 * @param <CO> type of the constraints.
 * 
 * @author Martin Handsteiner
 */
public abstract class UILayout<C extends ILayout<CO>, CO> extends UIResource<C> 
                                         implements ILayout<CO>
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UILayout</code>.
     *
     * @param pLayout the ILayout.
     * @see ILayout
     */
	protected UILayout(C pLayout)
	{
		super(pLayout);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
/*	public IContainer getContainer()
	{
		IContainer container = uiResource.getContainer();
		if (container != null && container.getEventDispatcher() instanceof IContainer)
		{
			return (IContainer)container.getEventDispatcher();
		}
		else
		{
	    	return container;
		}
	}
*/	
	/**
	 * {@inheritDoc}
	 */
	public CO getConstraints(IComponent pComp)
	{
		if (pComp instanceof UIComponent)
		{
			return uiResource.getConstraints((IComponent)((UIComponent)pComp).getComponentUIResource());
		}
		else
		{
			return uiResource.getConstraints(pComp);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public void setConstraints(IComponent pComp, CO pConstraints)
	{
		if (pComp instanceof UIComponent)
		{
			uiResource.setConstraints((IComponent)((UIComponent)pComp).getComponentUIResource(), pConstraints);
		}
		else
		{
			uiResource.setConstraints(pComp, pConstraints);
		}
	}

	/**
	 * {@inheritDoc}
	 */
    public IInsets getMargins()
    {
    	return uiResource.getMargins();
    }
    
	/**
	 * {@inheritDoc}
	 */
    public void setMargins(IInsets pMargins)
    {
		// ensure that the factory gets his own resource, to prevent exception on factory internal casts!
		if (pMargins instanceof UIInsets)
		{
	    	uiResource.setMargins(((UIInsets)pMargins).getUIResource());
		}
		else
		{
	    	uiResource.setMargins(pMargins);
		}
    }

	/**
	 * Sets the insets with primitive types.
	 * 
	 * @param pTop the top insets.
	 * @param pLeft the left insets.
	 * @param pBottom the bottom insets.
	 * @param pRight the right insets.
	 */
    public void setMargins(int pTop, int pLeft, int pBottom, int pRight)
    {
    	uiResource.setMargins(UIFactoryManager.getFactory().createInsets(pTop, pLeft, pBottom, pRight));
    }

    /**
	 * {@inheritDoc}
	 */
    public int getHorizontalGap()
    {
    	return uiResource.getHorizontalGap();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setHorizontalGap(int pHorizontalGap)
    {
    	uiResource.setHorizontalGap(pHorizontalGap);
    }

	/**
	 * {@inheritDoc}
	 */
    public int getVerticalGap()
    {
    	return uiResource.getVerticalGap();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setVerticalGap(int pVerticalGap)
    {
    	uiResource.setVerticalGap(pVerticalGap);
    }
    
}	// UILayout
