/*
 * Copyright 2015 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 25.02.2015 - [JR] - creation
 */
package com.sibvisions.rad.server.protocol;

/**
 * The <code>ICategoryConstants</code> defines the standard protocol categories.
 * 
 * @author Ren Jahn
 */
public interface ICategoryConstants
{
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Constants
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /** the undefined category. */
    public static final String UNDEFINED        = "UNDEFINED"; 
    
    /** the server category. */
    public static final String SERVER           = "SERVER";
    /** the session category. */
    public static final String SESSION          = "SESSION";
    /** the session manager category. */
    public static final String SESSION_MANAGER  = "SESSION_MANAGER";
    /** the database category. */
    public static final String DATABASE         = "DB";
    /** the storage category. */
    public static final String STORAGE          = "STORAGE";
    /** the application category. */
    public static final String APPLICATION      = "APPLICATION";
    /** the work-screen category. */
    public static final String WORKSCREEN       = "WORKSCREEN";
    /** the lifecycle object category. */
    public static final String LIFECYCLE        = "LIFECYCLE";
    /** the server object category. */
    public static final String SERVER_OBJECT    = "SERVER_OBJECT";
    
}   // ICategoryConstants
