/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.List;
import javax.rad.util.IRunnable;
import javax.rad.util.SilentAbortException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventHandler<L> {
    private static ILogger logger = LoggerFactory.getInstance(EventHandler.class);
    private static final Object[] NULL_PARAMETER = new Object[1];
    private Class<L> listenerType;
    private Method listenerMethod;
    private boolean callListenerMethodReflective;
    private boolean listenerMethodHasOneParameter;
    private Class[] parameterTypes;
    private List<ListenerHandler> listeners = null;
    private ListenerHandler defaultListener = null;
    private static WeakReference<Object> wrefLastDispatchedObject = null;
    private static WeakReference<Object> wrefCurrentDispatchObject = null;
    private boolean bFirstDispatch = true;
    private boolean bDispatchEvents = true;

    public EventHandler(Class<L> clazz, Class ... classArray) {
        this(clazz, (String)null, classArray);
    }

    public EventHandler(Class<L> clazz, String string, Class ... classArray) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("The listener type class has to be an interface!");
        }
        this.listenerMethod = this.findMethodByName(clazz, string);
        this.listenerType = clazz;
        Class<?>[] classArray2 = this.listenerMethod.getParameterTypes();
        this.callListenerMethodReflective = classArray2.length > 0 && Object[].class.isAssignableFrom(classArray2[classArray2.length - 1]);
        boolean bl = this.listenerMethodHasOneParameter = classArray2.length == 1;
        if (classArray == null || classArray.length > 0) {
            if (!Reflective.isParamTypeListValid(classArray2, classArray, this.listenerMethod.isVarArgs())) {
                throw new IllegalArgumentException("The given parameter types are not suitable to the parameter types of the listener method!");
            }
            this.parameterTypes = classArray;
        } else {
            this.parameterTypes = null;
        }
    }

    private Method findMethodByName(Class<L> clazz, String string) {
        Method[] methodArray = clazz.getMethods();
        if (string == null) {
            if (methodArray.length == 1) {
                return methodArray[0];
            }
            throw new IllegalArgumentException("Listener class " + clazz.getName() + " has more than 1 method, the listener method has to be specified!");
        }
        for (int i = 0; i < methodArray.length; ++i) {
            if (!string.equals(methodArray[i].getName())) continue;
            return methodArray[i];
        }
        throw new IllegalArgumentException("Listener method " + string + " not found in class " + clazz.getName() + "!");
    }

    public void addListener(L l) {
        this.addListener(l, -1);
    }

    public void addListener(L l, int n) {
        int n2;
        if (this.listeners == null) {
            this.listeners = new ArrayUtil<ListenerHandler>();
        }
        if ((n2 = this.listeners.indexOf(l)) >= 0) {
            this.removeHandler(n2);
            if (n > n2) {
                --n;
            }
        }
        ListenerHandler listenerHandler = Proxy.isProxyClass(l.getClass()) ? (ListenerHandler)Proxy.getInvocationHandler(l) : new ListenerHandler(l);
        this.addHandler(n, listenerHandler);
    }

    public void addListener(Object object, String string) {
        this.addListener(object, string, -1);
    }

    public void addListener(IRunnable iRunnable) {
        this.addListener(iRunnable, "run");
    }

    public void addListener(Object object, String string, int n) {
        ListenerHandler listenerHandler;
        int n2;
        if (this.listeners == null) {
            this.listeners = new ArrayUtil<ListenerHandler>();
        }
        if ((n2 = this.listeners.indexOf(listenerHandler = new ListenerHandler(object, string))) >= 0) {
            this.removeHandler(n2);
            if (n > n2) {
                --n;
            }
        }
        this.addHandler(n, listenerHandler);
    }

    protected void addHandler(int n, ListenerHandler listenerHandler) {
        if (n < 0) {
            this.listeners.add(listenerHandler);
        } else {
            this.listeners.add(n, listenerHandler);
        }
    }

    protected ListenerHandler removeHandler(int n) {
        return this.listeners.remove(n);
    }

    private boolean removeHandler(Object object) {
        int n = this.listeners.indexOf(object);
        if (n >= 0) {
            return this.removeHandler(n) != null;
        }
        return false;
    }

    public void removeListener(int n) {
        if (this.listeners != null) {
            this.removeHandler(n);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public void removeListener(Object object) {
        if (this.listeners != null) {
            while (this.removeHandler(object)) {
            }
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public void removeListener(Object object, String string) {
        if (this.listeners != null) {
            this.removeHandler(new ListenerHandler(object, string));
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public void removeAllListeners() {
        if (this.listeners != null) {
            this.listeners = null;
        }
    }

    public int getListenerCount() {
        if (this.listeners == null) {
            return 0;
        }
        return this.listeners.size();
    }

    public L getListener(int n) {
        if (this.listeners == null) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 0");
        }
        return (L)this.listeners.get(n).listenerInterface;
    }

    public L[] getListeners() {
        if (this.listeners == null) {
            return (Object[])Array.newInstance(this.listenerType, 0);
        }
        Object[] objectArray = (Object[])Array.newInstance(this.listenerType, this.listeners.size());
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            objectArray[i] = this.listeners.get(i).listenerInterface;
        }
        return objectArray;
    }

    public void setDefaultListener(L l) {
        if (l == null) {
            this.defaultListener = null;
        } else if (this.defaultListener == null || !this.defaultListener.equals(l)) {
            this.defaultListener = new ListenerHandler(l);
        }
    }

    public void setDefaultListener(Object object, String string) {
        if (object == null) {
            this.defaultListener = null;
        } else if (this.defaultListener == null || !this.defaultListener.equals(object)) {
            this.defaultListener = new ListenerHandler(object, string);
        }
    }

    public L getDefaultListener() {
        if (this.defaultListener == null) {
            return null;
        }
        return (L)this.defaultListener.listenerInterface;
    }

    public boolean isDispatchable() {
        return this.bDispatchEvents && this.bFirstDispatch && (this.listeners != null || this.defaultListener != null);
    }

    public static boolean isDispatchable(EventHandler eventHandler) {
        return eventHandler != null && eventHandler.isDispatchable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatchEvent(Object ... objectArray) throws Throwable {
        block16: {
            if (this.isDispatchable()) {
                this.bFirstDispatch = false;
                try {
                    if (this.listeners != null) {
                        ArrayUtil<ListenerHandler> arrayUtil = new ArrayUtil<ListenerHandler>((Collection<ListenerHandler>)this.listeners);
                        this.setLastDispatchedObject();
                        if (objectArray != null && objectArray.length > 0) {
                            wrefCurrentDispatchObject = new WeakReference<Object>(objectArray[0]);
                        }
                        try {
                            int n = arrayUtil.size();
                            for (int i = 0; i < n; ++i) {
                                ((ListenerHandler)arrayUtil.get(i)).dispatchEvent(objectArray);
                            }
                            break block16;
                        }
                        finally {
                            this.setLastDispatchedObject();
                        }
                    }
                    if (this.defaultListener == null) break block16;
                    this.setLastDispatchedObject();
                    if (objectArray != null && objectArray.length > 0) {
                        wrefCurrentDispatchObject = new WeakReference<Object>(objectArray[0]);
                    }
                    try {
                        Object object = this.defaultListener.dispatchEvent(objectArray);
                        this.setLastDispatchedObject();
                        return object;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.setLastDispatchedObject();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            logger.debug(throwable2);
                            throw EventHandler.getWrappedExceptionAllowSilent(throwable2);
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
                finally {
                    this.bFirstDispatch = true;
                }
            }
        }
        return null;
    }

    public L createListener(Object object, String string) {
        return (L)new ListenerHandler(object, string).listenerInterface;
    }

    public boolean isDispatchEventsEnabled() {
        return this.bDispatchEvents;
    }

    public void setDispatchEventsEnabled(boolean bl) {
        this.bDispatchEvents = bl;
    }

    private void setLastDispatchedObject() {
        if (wrefCurrentDispatchObject != null) {
            wrefLastDispatchedObject = wrefCurrentDispatchObject;
            wrefCurrentDispatchObject = null;
        }
    }

    public static Object getLastDispatchedObject() {
        if (wrefLastDispatchedObject != null) {
            return wrefLastDispatchedObject.get();
        }
        return null;
    }

    public static Object getCurrentDispatchObject() {
        if (wrefCurrentDispatchObject != null) {
            return wrefCurrentDispatchObject.get();
        }
        return null;
    }

    public static Throwable getWrappedException(Throwable throwable) {
        Throwable throwable2 = throwable;
        while ((throwable2 instanceof InvocationTargetException || throwable2 instanceof UndeclaredThrowableException || throwable2 instanceof SilentAbortException) && throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static Throwable getWrappedExceptionAllowSilent(Throwable throwable) {
        Throwable throwable2 = throwable;
        while ((throwable2 instanceof InvocationTargetException || throwable2 instanceof UndeclaredThrowableException) && throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ListenerHandler
    implements InvocationHandler {
        private L listenerInterface;
        private Object listener;
        private Method method;
        private boolean callWithParameter;
        private boolean callReflective;

        public ListenerHandler(L l) {
            this.listenerInterface = l;
            this.listener = null;
        }

        public ListenerHandler(Object object, String string) {
            Class<?> clazz = object.getClass();
            Class[] classArray = EventHandler.this.parameterTypes == null ? EventHandler.this.listenerMethod.getParameterTypes() : EventHandler.this.parameterTypes;
            if (object instanceof IRunnable && "run".equals(string)) {
                try {
                    this.method = IRunnable.class.getMethod("run", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                this.callWithParameter = false;
                this.callReflective = false;
            } else {
                try {
                    this.method = clazz.getMethod(string, classArray);
                    this.callWithParameter = true;
                    this.callReflective = false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        this.method = Reflective.getMethod(clazz, string, classArray);
                        this.callWithParameter = true;
                        this.callReflective = true;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            this.method = clazz.getMethod(string, new Class[0]);
                            this.callWithParameter = false;
                            this.callReflective = false;
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            throw new IllegalArgumentException("Method " + string + " not found in class " + clazz.getName() + "!");
                        }
                    }
                }
            }
            this.listener = object;
            this.listenerInterface = Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{EventHandler.this.listenerType}, (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            try {
                if (string == EventHandler.this.listenerMethod.getName() || string.equals(EventHandler.this.listenerMethod.getName())) {
                    if (this.callWithParameter) {
                        return this.method.invoke(this.listener, objectArray);
                    }
                    return this.method.invoke(this.listener, new Object[0]);
                }
                if ("hashCode" == string || "hashCode".equals(string)) {
                    return this.listener.hashCode();
                }
                if ("equals" == string || "equals".equals(string)) {
                    return this.listenerInterface == objectArray[0] || this.listener.equals(objectArray[0]);
                }
                if ("toString" == string || "toString".equals(string)) {
                    return EventHandler.this.listenerMethod.toString() + " -> " + this.method.toString();
                }
            }
            catch (Throwable throwable) {
                logger.debug(throwable);
                throw EventHandler.getWrappedException(throwable);
            }
            throw new UnsupportedOperationException("The call of method " + string + " is not supported!");
        }

        public int hashCode() {
            if (this.listener == null) {
                return this.listenerInterface.hashCode();
            }
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (object.getClass() == ListenerHandler.class) {
                ListenerHandler listenerHandler = (ListenerHandler)object;
                return this.listener == listenerHandler.listener && this.method.equals(listenerHandler.method);
            }
            return this.listenerInterface == object || this.listener != null && this.listener == object;
        }

        public String toString() {
            if (this.listener == null) {
                return this.listenerInterface.toString();
            }
            return this.listener.toString();
        }

        public Object dispatchEvent(Object ... objectArray) throws Throwable {
            if (this.listener == null) {
                if (EventHandler.this.callListenerMethodReflective) {
                    return Reflective.call(this.listenerInterface, EventHandler.this.listenerMethod, objectArray);
                }
                if (EventHandler.this.listenerMethodHasOneParameter && objectArray == null) {
                    return EventHandler.this.listenerMethod.invoke(this.listenerInterface, NULL_PARAMETER);
                }
                return EventHandler.this.listenerMethod.invoke(this.listenerInterface, objectArray);
            }
            if (this.callWithParameter) {
                if (this.callReflective) {
                    return Reflective.call(this.listener, this.method, objectArray);
                }
                return this.method.invoke(this.listener, objectArray);
            }
            return this.method.invoke(this.listener, new Object[0]);
        }
    }
}

