/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.io;

import javax.rad.io.IDownloadExecutor;
import javax.rad.io.IUploadExecutor;
import javax.rad.remote.ConnectionInfo;

public class TransferContext {
    private static ThreadLocal<TransferContext> instance = new ThreadLocal();
    private ConnectionInfo info;
    private IDownloadExecutor download;
    private IUploadExecutor upload;

    public TransferContext(ConnectionInfo connectionInfo, IDownloadExecutor iDownloadExecutor, IUploadExecutor iUploadExecutor) {
        this.download = iDownloadExecutor;
        this.upload = iUploadExecutor;
        this.info = connectionInfo;
        this.setInstance(this);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.info;
    }

    public IDownloadExecutor getDownloadExecutor() {
        return this.download;
    }

    public IUploadExecutor getUploadExecutor() {
        return this.upload;
    }

    public static IDownloadExecutor getCurrentDownloadExecutor() {
        TransferContext transferContext = TransferContext.getCurrentInstance();
        if (transferContext != null) {
            return transferContext.getDownloadExecutor();
        }
        return null;
    }

    public static IUploadExecutor getCurrentUploadExecutor() {
        TransferContext transferContext = TransferContext.getCurrentInstance();
        if (transferContext != null) {
            return transferContext.getUploadExecutor();
        }
        return null;
    }

    public static ConnectionInfo getCurrentConnectionInfo() {
        TransferContext transferContext = TransferContext.getCurrentInstance();
        if (transferContext != null) {
            return transferContext.getConnectionInfo();
        }
        return null;
    }

    public static TransferContext getCurrentInstance() {
        return instance.get();
    }

    protected synchronized void setInstance(TransferContext transferContext) {
        instance.set(transferContext);
    }

    public final synchronized void release() {
        instance.set(null);
    }

    public boolean isReleased() {
        return instance.get() == null;
    }
}

