/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpUtil {
    private static HashMap<Character, String> hmpReplaceHtml4 = new HashMap();

    private HttpUtil() {
    }

    public static InputStream post(String string) throws Exception {
        return HttpUtil.post(string, null, null, null);
    }

    public static InputStream post(String string, InputStream inputStream) throws Exception {
        return HttpUtil.post(string, inputStream, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream post(String string, File file) throws Exception {
        InputStream inputStream;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            inputStream = HttpUtil.post(string, fileInputStream, file.getName(), null);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CommonUtil.close(fileInputStream);
            throw throwable;
        }
        CommonUtil.close(fileInputStream);
        return inputStream;
    }

    public static InputStream post(String string, InputStream inputStream, String string2) throws Exception {
        return HttpUtil.post(string, inputStream, string2, null);
    }

    public static InputStream post(String string, InputStream inputStream, String string2, Map<String, String> map) throws Exception {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(inputStream != null);
        uRLConnection.setDoInput(true);
        uRLConnection.setUseCaches(false);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                uRLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (inputStream != null) {
            uRLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            if (string2 != null) {
                uRLConnection.setRequestProperty("Content-Disposition", "attachment; filename=\"" + string2 + "\";");
            }
            FileUtil.copy(inputStream, uRLConnection.getOutputStream());
        }
        return uRLConnection.getInputStream();
    }

    public static InputStream get(String string) throws Exception {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(false);
        uRLConnection.setDoInput(true);
        uRLConnection.setUseCaches(false);
        return uRLConnection.getInputStream();
    }

    public static String escapeHtml(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + (int)((double)string.length() * 0.1));
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuilder.append("<br/>");
                continue;
            }
            String string2 = hmpReplaceHtml4.get(Character.valueOf(c));
            if (string2 == null) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    static {
        hmpReplaceHtml4.put(Character.valueOf('\"'), "&quot;");
        hmpReplaceHtml4.put(Character.valueOf('&'), "&amp;");
        hmpReplaceHtml4.put(Character.valueOf('<'), "&lt;");
        hmpReplaceHtml4.put(Character.valueOf('>'), "&gt;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a0'), "&nbsp;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a1'), "&iexcl;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a2'), "&cent;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a3'), "&pound;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a4'), "&curren;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a5'), "&yen;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a6'), "&brvbar;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a7'), "&sect;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a8'), "&uml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00a9'), "&copy;");
        hmpReplaceHtml4.put(Character.valueOf('\u00aa'), "&ordf;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ab'), "&laquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ac'), "&not;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ad'), "&shy;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ae'), "&reg;");
        hmpReplaceHtml4.put(Character.valueOf('\u00af'), "&macr;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b0'), "&deg;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b1'), "&plusmn;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b2'), "&sup2;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b3'), "&sup3;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b4'), "&acute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b5'), "&micro;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b6'), "&para;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b7'), "&middot;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b8'), "&cedil;");
        hmpReplaceHtml4.put(Character.valueOf('\u00b9'), "&sup1;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ba'), "&ordm;");
        hmpReplaceHtml4.put(Character.valueOf('\u00bb'), "&raquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u00bc'), "&frac14;");
        hmpReplaceHtml4.put(Character.valueOf('\u00bd'), "&frac12;");
        hmpReplaceHtml4.put(Character.valueOf('\u00be'), "&frac34;");
        hmpReplaceHtml4.put(Character.valueOf('\u00bf'), "&iquest;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c0'), "&Agrave;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c1'), "&Aacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c2'), "&Acirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c3'), "&Atilde;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c4'), "&Auml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c5'), "&Aring;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c6'), "&AElig;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c7'), "&Ccedil;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c8'), "&Egrave;");
        hmpReplaceHtml4.put(Character.valueOf('\u00c9'), "&Eacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ca'), "&Ecirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00cb'), "&Euml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00cc'), "&Igrave;");
        hmpReplaceHtml4.put(Character.valueOf('\u00cd'), "&Iacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ce'), "&Icirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00cf'), "&Iuml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d0'), "&ETH;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d1'), "&Ntilde;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d2'), "&Ograve;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d3'), "&Oacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d4'), "&Ocirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d5'), "&Otilde;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d6'), "&Ouml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d7'), "&times;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d8'), "&Oslash;");
        hmpReplaceHtml4.put(Character.valueOf('\u00d9'), "&Ugrave;");
        hmpReplaceHtml4.put(Character.valueOf('\u00da'), "&Uacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00db'), "&Ucirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00dc'), "&Uuml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00dd'), "&Yacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00de'), "&THORN;");
        hmpReplaceHtml4.put(Character.valueOf('\u00df'), "&szlig;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e0'), "&agrave;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e1'), "&aacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e2'), "&acirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e3'), "&atilde;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e4'), "&auml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e5'), "&aring;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e6'), "&aelig;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e7'), "&ccedil;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e8'), "&egrave;");
        hmpReplaceHtml4.put(Character.valueOf('\u00e9'), "&eacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ea'), "&ecirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00eb'), "&euml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ec'), "&igrave;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ed'), "&iacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ee'), "&icirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ef'), "&iuml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f0'), "&eth;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f1'), "&ntilde;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f2'), "&ograve;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f3'), "&oacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f4'), "&ocirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f5'), "&otilde;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f6'), "&ouml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f7'), "&divide;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f8'), "&oslash;");
        hmpReplaceHtml4.put(Character.valueOf('\u00f9'), "&ugrave;");
        hmpReplaceHtml4.put(Character.valueOf('\u00fa'), "&uacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00fb'), "&ucirc;");
        hmpReplaceHtml4.put(Character.valueOf('\u00fc'), "&uuml;");
        hmpReplaceHtml4.put(Character.valueOf('\u00fd'), "&yacute;");
        hmpReplaceHtml4.put(Character.valueOf('\u00fe'), "&thorn;");
        hmpReplaceHtml4.put(Character.valueOf('\u00ff'), "&yuml;");
        hmpReplaceHtml4.put(Character.valueOf('\u0192'), "&fnof;");
        hmpReplaceHtml4.put(Character.valueOf('\u0391'), "&Alpha;");
        hmpReplaceHtml4.put(Character.valueOf('\u0392'), "&Beta;");
        hmpReplaceHtml4.put(Character.valueOf('\u0393'), "&Gamma;");
        hmpReplaceHtml4.put(Character.valueOf('\u0394'), "&Delta;");
        hmpReplaceHtml4.put(Character.valueOf('\u0395'), "&Epsilon;");
        hmpReplaceHtml4.put(Character.valueOf('\u0396'), "&Zeta;");
        hmpReplaceHtml4.put(Character.valueOf('\u0397'), "&Eta;");
        hmpReplaceHtml4.put(Character.valueOf('\u0398'), "&Theta;");
        hmpReplaceHtml4.put(Character.valueOf('\u0399'), "&Iota;");
        hmpReplaceHtml4.put(Character.valueOf('\u039a'), "&Kappa;");
        hmpReplaceHtml4.put(Character.valueOf('\u039b'), "&Lambda;");
        hmpReplaceHtml4.put(Character.valueOf('\u039c'), "&Mu;");
        hmpReplaceHtml4.put(Character.valueOf('\u039d'), "&Nu;");
        hmpReplaceHtml4.put(Character.valueOf('\u039e'), "&Xi;");
        hmpReplaceHtml4.put(Character.valueOf('\u039f'), "&Omicron;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a0'), "&Pi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a1'), "&Rho;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a3'), "&Sigma;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a4'), "&Tau;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a5'), "&Upsilon;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a6'), "&Phi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a7'), "&Chi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a8'), "&Psi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03a9'), "&Omega;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b1'), "&alpha;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b2'), "&beta;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b3'), "&gamma;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b4'), "&delta;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b5'), "&epsilon;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b6'), "&zeta;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b7'), "&eta;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b8'), "&theta;");
        hmpReplaceHtml4.put(Character.valueOf('\u03b9'), "&iota;");
        hmpReplaceHtml4.put(Character.valueOf('\u03ba'), "&kappa;");
        hmpReplaceHtml4.put(Character.valueOf('\u03bb'), "&lambda;");
        hmpReplaceHtml4.put(Character.valueOf('\u03bc'), "&mu;");
        hmpReplaceHtml4.put(Character.valueOf('\u03bd'), "&nu;");
        hmpReplaceHtml4.put(Character.valueOf('\u03be'), "&xi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03bf'), "&omicron;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c0'), "&pi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c1'), "&rho;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c2'), "&sigmaf;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c3'), "&sigma;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c4'), "&tau;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c5'), "&upsilon;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c6'), "&phi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c7'), "&chi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c8'), "&psi;");
        hmpReplaceHtml4.put(Character.valueOf('\u03c9'), "&omega;");
        hmpReplaceHtml4.put(Character.valueOf('\u03d1'), "&thetasym;");
        hmpReplaceHtml4.put(Character.valueOf('\u03d2'), "&upsih;");
        hmpReplaceHtml4.put(Character.valueOf('\u03d6'), "&piv;");
        hmpReplaceHtml4.put(Character.valueOf('\u2022'), "&bull;");
        hmpReplaceHtml4.put(Character.valueOf('\u2026'), "&hellip;");
        hmpReplaceHtml4.put(Character.valueOf('\u2032'), "&prime;");
        hmpReplaceHtml4.put(Character.valueOf('\u2033'), "&Prime;");
        hmpReplaceHtml4.put(Character.valueOf('\u203e'), "&oline;");
        hmpReplaceHtml4.put(Character.valueOf('\u2044'), "&frasl;");
        hmpReplaceHtml4.put(Character.valueOf('\u2118'), "&weierp;");
        hmpReplaceHtml4.put(Character.valueOf('\u2111'), "&image;");
        hmpReplaceHtml4.put(Character.valueOf('\u211c'), "&real;");
        hmpReplaceHtml4.put(Character.valueOf('\u2122'), "&trade;");
        hmpReplaceHtml4.put(Character.valueOf('\u2135'), "&alefsym;");
        hmpReplaceHtml4.put(Character.valueOf('\u2190'), "&larr;");
        hmpReplaceHtml4.put(Character.valueOf('\u2191'), "&uarr;");
        hmpReplaceHtml4.put(Character.valueOf('\u2192'), "&rarr;");
        hmpReplaceHtml4.put(Character.valueOf('\u2193'), "&darr;");
        hmpReplaceHtml4.put(Character.valueOf('\u2194'), "&harr;");
        hmpReplaceHtml4.put(Character.valueOf('\u21b5'), "&crarr;");
        hmpReplaceHtml4.put(Character.valueOf('\u21d0'), "&lArr;");
        hmpReplaceHtml4.put(Character.valueOf('\u21d1'), "&uArr;");
        hmpReplaceHtml4.put(Character.valueOf('\u21d2'), "&rArr;");
        hmpReplaceHtml4.put(Character.valueOf('\u21d3'), "&dArr;");
        hmpReplaceHtml4.put(Character.valueOf('\u21d4'), "&hArr;");
        hmpReplaceHtml4.put(Character.valueOf('\u2200'), "&forall;");
        hmpReplaceHtml4.put(Character.valueOf('\u2202'), "&part;");
        hmpReplaceHtml4.put(Character.valueOf('\u2203'), "&exist;");
        hmpReplaceHtml4.put(Character.valueOf('\u2205'), "&empty;");
        hmpReplaceHtml4.put(Character.valueOf('\u2207'), "&nabla;");
        hmpReplaceHtml4.put(Character.valueOf('\u2208'), "&isin;");
        hmpReplaceHtml4.put(Character.valueOf('\u2209'), "&notin;");
        hmpReplaceHtml4.put(Character.valueOf('\u220b'), "&ni;");
        hmpReplaceHtml4.put(Character.valueOf('\u220f'), "&prod;");
        hmpReplaceHtml4.put(Character.valueOf('\u2211'), "&sum;");
        hmpReplaceHtml4.put(Character.valueOf('\u2212'), "&minus;");
        hmpReplaceHtml4.put(Character.valueOf('\u2217'), "&lowast;");
        hmpReplaceHtml4.put(Character.valueOf('\u221a'), "&radic;");
        hmpReplaceHtml4.put(Character.valueOf('\u221d'), "&prop;");
        hmpReplaceHtml4.put(Character.valueOf('\u221e'), "&infin;");
        hmpReplaceHtml4.put(Character.valueOf('\u2220'), "&ang;");
        hmpReplaceHtml4.put(Character.valueOf('\u2227'), "&and;");
        hmpReplaceHtml4.put(Character.valueOf('\u2228'), "&or;");
        hmpReplaceHtml4.put(Character.valueOf('\u2229'), "&cap;");
        hmpReplaceHtml4.put(Character.valueOf('\u222a'), "&cup;");
        hmpReplaceHtml4.put(Character.valueOf('\u222b'), "&int;");
        hmpReplaceHtml4.put(Character.valueOf('\u2234'), "&there4;");
        hmpReplaceHtml4.put(Character.valueOf('\u223c'), "&sim;");
        hmpReplaceHtml4.put(Character.valueOf('\u2245'), "&cong;");
        hmpReplaceHtml4.put(Character.valueOf('\u2248'), "&asymp;");
        hmpReplaceHtml4.put(Character.valueOf('\u2260'), "&ne;");
        hmpReplaceHtml4.put(Character.valueOf('\u2261'), "&equiv;");
        hmpReplaceHtml4.put(Character.valueOf('\u2264'), "&le;");
        hmpReplaceHtml4.put(Character.valueOf('\u2265'), "&ge;");
        hmpReplaceHtml4.put(Character.valueOf('\u2282'), "&sub;");
        hmpReplaceHtml4.put(Character.valueOf('\u2283'), "&sup;");
        hmpReplaceHtml4.put(Character.valueOf('\u2284'), "&nsub;");
        hmpReplaceHtml4.put(Character.valueOf('\u2286'), "&sube;");
        hmpReplaceHtml4.put(Character.valueOf('\u2287'), "&supe;");
        hmpReplaceHtml4.put(Character.valueOf('\u2295'), "&oplus;");
        hmpReplaceHtml4.put(Character.valueOf('\u2297'), "&otimes;");
        hmpReplaceHtml4.put(Character.valueOf('\u22a5'), "&perp;");
        hmpReplaceHtml4.put(Character.valueOf('\u22c5'), "&sdot;");
        hmpReplaceHtml4.put(Character.valueOf('\u2308'), "&lceil;");
        hmpReplaceHtml4.put(Character.valueOf('\u2309'), "&rceil;");
        hmpReplaceHtml4.put(Character.valueOf('\u230a'), "&lfloor;");
        hmpReplaceHtml4.put(Character.valueOf('\u230b'), "&rfloor;");
        hmpReplaceHtml4.put(Character.valueOf('\u2329'), "&lang;");
        hmpReplaceHtml4.put(Character.valueOf('\u232a'), "&rang;");
        hmpReplaceHtml4.put(Character.valueOf('\u25ca'), "&loz;");
        hmpReplaceHtml4.put(Character.valueOf('\u2660'), "&spades;");
        hmpReplaceHtml4.put(Character.valueOf('\u2663'), "&clubs;");
        hmpReplaceHtml4.put(Character.valueOf('\u2665'), "&hearts;");
        hmpReplaceHtml4.put(Character.valueOf('\u2666'), "&diams;");
        hmpReplaceHtml4.put(Character.valueOf('\u0152'), "&OElig;");
        hmpReplaceHtml4.put(Character.valueOf('\u0153'), "&oelig;");
        hmpReplaceHtml4.put(Character.valueOf('\u0160'), "&Scaron;");
        hmpReplaceHtml4.put(Character.valueOf('\u0161'), "&scaron;");
        hmpReplaceHtml4.put(Character.valueOf('\u0178'), "&Yuml;");
        hmpReplaceHtml4.put(Character.valueOf('\u02c6'), "&circ;");
        hmpReplaceHtml4.put(Character.valueOf('\u02dc'), "&tilde;");
        hmpReplaceHtml4.put(Character.valueOf('\u2002'), "&ensp;");
        hmpReplaceHtml4.put(Character.valueOf('\u2003'), "&emsp;");
        hmpReplaceHtml4.put(Character.valueOf('\u2009'), "&thinsp;");
        hmpReplaceHtml4.put(Character.valueOf('\u200c'), "&zwnj;");
        hmpReplaceHtml4.put(Character.valueOf('\u200d'), "&zwj;");
        hmpReplaceHtml4.put(Character.valueOf('\u200e'), "&lrm;");
        hmpReplaceHtml4.put(Character.valueOf('\u200f'), "&rlm;");
        hmpReplaceHtml4.put(Character.valueOf('\u2013'), "&ndash;");
        hmpReplaceHtml4.put(Character.valueOf('\u2014'), "&mdash;");
        hmpReplaceHtml4.put(Character.valueOf('\u2018'), "&lsquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u2019'), "&rsquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u201a'), "&sbquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u201c'), "&ldquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u201d'), "&rdquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u201e'), "&bdquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u2020'), "&dagger;");
        hmpReplaceHtml4.put(Character.valueOf('\u2021'), "&Dagger;");
        hmpReplaceHtml4.put(Character.valueOf('\u2030'), "&permil;");
        hmpReplaceHtml4.put(Character.valueOf('\u2039'), "&lsaquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u203a'), "&rsaquo;");
        hmpReplaceHtml4.put(Character.valueOf('\u20ac'), "&euro;");
    }
}

