/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.type.LocaleUtil;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtil {
    private SimpleDateFormat dateFormat;
    private Locale creationLocale = null;
    private String creationPattern = null;
    private List<String>[] parsedPattern = null;
    private List<String>[] parsedReference = null;
    private String[] months = null;
    private String[] shortMonths = null;
    private String[] lowerMonths = null;
    private String[] lowerShortMonths = null;
    private boolean strictFormatCheck = false;

    public DateUtil() {
        this.setDateFormat(null);
    }

    public DateUtil(DateFormat dateFormat) {
        this.setDateFormat(dateFormat);
    }

    public DateUtil(String string) {
        this.setDatePattern(string);
    }

    public Date parse(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.creationLocale != null) {
            this.setDateFormatIntern(LocaleUtil.getDefault(), this.creationPattern);
        }
        return this.parseStringIntern(string);
    }

    public String format(Date date) {
        if (date == null) {
            return null;
        }
        if (this.creationLocale != null) {
            this.setDateFormatIntern(LocaleUtil.getDefault(), this.creationPattern);
        }
        return this.dateFormat.format(date);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    private void setDateFormatIntern(Locale locale, String string) {
        if (string == null) {
            if (locale != this.creationLocale || this.creationPattern != null) {
                this.dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 3, LocaleUtil.getDefault());
                this.dateFormat.setLenient(false);
                this.creationLocale = locale;
                this.creationPattern = string;
                this.createReferenceDate();
            }
        } else if (locale != this.creationLocale || !string.equals(this.creationPattern)) {
            this.dateFormat = new SimpleDateFormat(string, LocaleUtil.getDefault());
            this.dateFormat.setLenient(false);
            this.creationLocale = locale;
            this.creationPattern = string;
            this.createReferenceDate();
        }
    }

    private void createReferenceDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        String string = this.dateFormat.format(gregorianCalendar.getTime());
        String string2 = this.dateFormat.toPattern();
        this.parsedPattern = this.getParsed(string2, true);
        this.parsedReference = this.getParsed(string, false);
        DateFormatSymbols dateFormatSymbols = this.dateFormat.getDateFormatSymbols();
        this.months = dateFormatSymbols.getMonths();
        this.shortMonths = dateFormatSymbols.getShortMonths();
        this.lowerMonths = new String[this.months.length];
        this.lowerShortMonths = new String[this.months.length];
        for (int i = 0; i < this.months.length; ++i) {
            this.lowerMonths[i] = this.toLowerAndWithoutUmlauts(this.months[i]);
            this.lowerShortMonths[i] = this.toLowerAndWithoutUmlauts(this.shortMonths[i]);
        }
    }

    private String toLowerAndWithoutUmlauts(String string) {
        return string.toLowerCase().replace('\u00e4', 'a').replace('\u00fc', 'u').replace('\u00f6', 'o');
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat == null) {
            this.setDateFormatIntern(LocaleUtil.getDefault(), null);
        } else if (dateFormat instanceof SimpleDateFormat) {
            this.dateFormat = (SimpleDateFormat)dateFormat;
            this.dateFormat.setLenient(false);
            this.creationLocale = null;
            this.creationPattern = null;
            this.createReferenceDate();
        } else {
            throw new IllegalArgumentException("Only SimpleDateFormat is supported!");
        }
    }

    public String getDatePattern() {
        return this.dateFormat.toPattern();
    }

    public void setDatePattern(String string) {
        if (string == null) {
            this.setDateFormat(null);
        } else {
            this.setDateFormatIntern(LocaleUtil.getDefault(), string);
        }
    }

    public boolean isStrictFormatCheck() {
        return this.strictFormatCheck;
    }

    public void setStrictFormatCheck(boolean bl) {
        this.strictFormatCheck = bl;
    }

    private String getPart(String string, String string2, String string3) {
        try {
            if (string2.startsWith("MMM")) {
                int n = Integer.parseInt(string);
                if (string2.length() == 3) {
                    return this.shortMonths[(n - 1) % 12];
                }
                return this.months[(n - 1) % 12];
            }
            if (string2.toLowerCase().startsWith("yy") && string3.length() > string.length()) {
                int n = Integer.parseInt(string3.substring(0, string3.length() - string.length()) + string);
                int n2 = Integer.parseInt(string3);
                if (string.length() == 2 && n >= n2 + 50) {
                    n -= 100;
                }
                return String.valueOf(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2.startsWith("M")) {
            String string4 = this.toLowerAndWithoutUmlauts(string);
            for (int i = 0; i < 12; ++i) {
                if (!this.lowerMonths[i].startsWith(string4) && (string4.length() > this.lowerMonths[i].length() + 2 || !string4.startsWith(this.lowerShortMonths[i]))) continue;
                int n = i + 1;
                if (string2.length() == 2 && n < 10) {
                    return "0" + n;
                }
                if (string2.length() <= 2) {
                    return String.valueOf(n);
                }
                if (string2.length() == 3) {
                    return this.shortMonths[i];
                }
                return this.months[i];
            }
        }
        return string;
    }

    private String getStrictPart(String string, String string2, String string3) {
        if (string2.startsWith("MMM")) {
            String string4 = this.toLowerAndWithoutUmlauts(string);
            for (int i = 0; i < 12; ++i) {
                if (!this.lowerMonths[i].equals(string4) && (string4.length() > this.lowerMonths[i].length() + 2 || !string4.startsWith(this.lowerShortMonths[i]))) continue;
                if (string2.length() == 3) {
                    return this.shortMonths[i];
                }
                return this.months[i];
            }
        }
        return string;
    }

    private char getCharacterType(char c, boolean bl) {
        if (Character.isLetterOrDigit(c)) {
            if (bl) {
                return c;
            }
            return Character.isDigit(c) ? (char)'0' : 'a';
        }
        return ' ';
    }

    private List<String>[] getParsed(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        boolean bl2 = Character.isLetterOrDigit(string.charAt(0));
        char c = this.getCharacterType(string.charAt(0), bl);
        for (int i = 1; i < n; ++i) {
            int n3;
            char c2 = string.charAt(i);
            boolean bl3 = Character.isLetterOrDigit(c2);
            char c3 = this.getCharacterType(c2, bl);
            String string2 = string.substring(n2, i);
            if (bl2 != bl3 || c != c3) {
                if (bl2) {
                    arrayList.add(string2);
                    if (bl2 == bl3 && c != c3) {
                        arrayList2.add("");
                    }
                } else {
                    arrayList2.add(string2);
                }
                n2 = i;
                bl2 = bl3;
                c = c3;
                continue;
            }
            if (!bl2 || bl || c3 != '0' || arrayList.size() >= this.parsedPattern[0].size()) continue;
            int n4 = n3 = this.parsedPattern[0].get(arrayList.size()).startsWith("y") ? 4 : 2;
            if (string2.length() != n3) continue;
            arrayList.add(string2);
            arrayList2.add("");
            n2 = i;
        }
        String string3 = string.substring(n2);
        if (bl2) {
            arrayList.add(string3);
        } else {
            arrayList2.add(string3);
        }
        return new List[]{arrayList, arrayList2};
    }

    private Date parseStringIntern(String string) throws ParseException {
        try {
            return this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                List<String>[] listArray = this.getParsed(string, false);
                int n = listArray[0].size();
                int n2 = this.strictFormatCheck ? listArray[1].size() : this.parsedPattern[1].size();
                StringBuffer stringBuffer = new StringBuffer(48);
                int n3 = this.parsedPattern[0].size();
                for (int i = 0; i < n3; ++i) {
                    if (i < n) {
                        if (this.strictFormatCheck) {
                            stringBuffer.append(this.getStrictPart(listArray[0].get(i), this.parsedPattern[0].get(i), this.parsedReference[0].get(i)));
                        } else {
                            stringBuffer.append(this.getPart(listArray[0].get(i), this.parsedPattern[0].get(i), this.parsedReference[0].get(i)));
                        }
                    } else if (!this.strictFormatCheck) {
                        stringBuffer.append(this.parsedReference[0].get(i));
                    }
                    if (i >= n2) continue;
                    if (this.strictFormatCheck) {
                        stringBuffer.append(listArray[1].get(i));
                        continue;
                    }
                    stringBuffer.append(this.parsedPattern[1].get(i));
                }
                return this.dateFormat.parse(stringBuffer.toString());
            }
            catch (ParseException parseException2) {
                throw parseException2;
            }
            catch (Exception exception) {
                throw new ParseException("Wrong Dateformat", 0);
            }
        }
    }

    public static String format(long l, String string) {
        return DateUtil.format(new Date(l), string);
    }

    public static String format(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static Date getDate(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, n);
        calendar.set(2, n2 - 1);
        calendar.set(1, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date convert(Date date, String string, String string2) {
        return DateUtil.convert(date, TimeZone.getTimeZone(string), TimeZone.getTimeZone(string2));
    }

    public static Date convert(Date date, TimeZone timeZone, TimeZone timeZone2) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance(timeZone2);
        calendar2.setTime(date);
        int n = calendar.get(15) + calendar.get(16);
        int n2 = calendar2.get(15) + calendar2.get(16);
        return new Date(calendar2.getTimeInMillis() + (long)n2 - (long)n);
    }
}

