/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.log.jdk;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.ExceptionUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JdkLineFormatter
extends Formatter {
    private static final String SPACE = "                                    ";
    private MessageFormat msgf = new MessageFormat("{0,date} {0, time}");
    private Date dateLog = new Date();

    public synchronized String format(LogRecord logRecord) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        this.dateLog.setTime(logRecord.getMillis());
        this.msgf.format(new Object[]{this.dateLog}, stringBuffer, (FieldPosition)null);
        if (logRecord.getMessage() != null && (logRecord.getMessage().length() > 100 || logRecord.getMessage().indexOf(10) >= 0 || logRecord.getThrown() != null)) {
            printStream.printf(" [ %-11s ] ", logRecord.getLevel().getName());
            printStream.close();
            stringBuffer.append(byteArrayOutputStream.toString());
            bl = true;
        } else {
            printStream.printf(" [ %-11s ] %-100s ", logRecord.getLevel().getName(), this.formatMessage(logRecord));
            printStream.close();
            stringBuffer.append(byteArrayOutputStream.toString());
        }
        if (logRecord.getSourceClassName() != null) {
            stringBuffer.append(logRecord.getSourceClassName());
        } else {
            stringBuffer.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(logRecord.getSourceMethodName());
        }
        stringBuffer.append("\n");
        if (bl) {
            stringBuffer.append((CharSequence)this.formatMultilineMessage(this.formatMessage(logRecord)));
            if (logRecord.getThrown() != null && !logRecord.getMessage().endsWith("\n")) {
                stringBuffer.append("\n");
            }
        }
        if (logRecord.getThrown() != null) {
            stringBuffer.append((CharSequence)this.formatMultilineMessage(ExceptionUtil.dump(logRecord.getThrown(), true)));
        }
        return stringBuffer.toString();
    }

    private StringBuilder formatMultilineMessage(String string) {
        ArrayUtil<String> arrayUtil = StringUtil.separateList(string, "\n", false);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : arrayUtil) {
            stringBuilder.append(SPACE);
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }

    public static String concat(Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) {
                    stringBuffer.append("null");
                    continue;
                }
                if (objectArray[i] instanceof Throwable) {
                    if (i > 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(ExceptionUtil.dump((Throwable)objectArray[i], true));
                    continue;
                }
                stringBuffer.append(StringUtil.toString(objectArray[i]));
            }
        }
        return stringBuffer.toString();
    }
}

