/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.log;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.jdk.JdkLoggerFactory;
import java.util.List;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggerFactory {
    public static final String LOGFACTORY_DEFAULT = "LoggerFactory.default";
    private static LoggerFactory factory = null;
    private static WeakHashMap<String, ILogger> whmLogger = null;

    protected LoggerFactory() {
    }

    public abstract ILogger createLogger(String var1);

    public abstract void init();

    public static void init(String string) {
        LoggerFactory loggerFactory;
        try {
            loggerFactory = (LoggerFactory)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            try {
                loggerFactory = (LoggerFactory)Class.forName(System.getProperty(LOGFACTORY_DEFAULT)).newInstance();
            }
            catch (Exception exception2) {
                loggerFactory = new JdkLoggerFactory();
            }
        }
        if (factory != null) {
            if (!factory.getClass().getName().equals(loggerFactory.getClass().getName())) {
                throw new RuntimeException("The log factory was already initialized: " + factory.getClass().getName());
            }
        } else {
            loggerFactory.init();
            factory = loggerFactory;
        }
    }

    public static boolean isInitialized() {
        return factory != null && factory.isInitDone();
    }

    public static void destroy() {
        factory = null;
        whmLogger = null;
    }

    public static ILogger getInstance(Class clazz) {
        return LoggerFactory.getInstance(clazz.getName());
    }

    public static ILogger getInstance(String string) {
        ILogger iLogger;
        if (factory == null) {
            LoggerFactory.init(null);
        }
        if (string == null) {
            string = "";
        }
        if (whmLogger == null) {
            whmLogger = new WeakHashMap();
            iLogger = null;
        } else {
            iLogger = whmLogger.get(string);
        }
        if (iLogger == null) {
            iLogger = factory.createLogger(string);
            whmLogger.put(string, iLogger);
        }
        return iLogger;
    }

    public static void setLevel(Class clazz, ILogger.LogLevel logLevel) {
        LoggerFactory.setLevel(clazz.getName(), logLevel);
    }

    public static void setLevel(String string, ILogger.LogLevel logLevel) {
        LoggerFactory.getInstance(string).setLevel(logLevel);
    }

    public static ILogger.LogLevel getLevel(Class clazz) {
        return LoggerFactory.getLevel(clazz.getName());
    }

    public static ILogger.LogLevel getLevel(String string) {
        return LoggerFactory.getInstance(string).getLevel();
    }

    public static List<ILogger> getLogger() {
        ArrayUtil<ILogger> arrayUtil = new ArrayUtil<ILogger>();
        if (whmLogger != null) {
            arrayUtil.addAll(whmLogger.values());
        }
        return arrayUtil;
    }

    protected boolean isInitDone() {
        return factory != null;
    }
}

