/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CommonUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangedHashtable<K, V>
extends Hashtable<K, V> {
    private ArrayUtil<Map.Entry<K, V>> auChanges = null;

    public ChangedHashtable() {
    }

    public ChangedHashtable(int n) {
        super(n);
    }

    public ChangedHashtable(int n, float f) {
        super(n, f);
    }

    public ChangedHashtable(Map<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    public synchronized V put(K k, V v) {
        return this.put(k, v, true, false);
    }

    @Override
    public synchronized V remove(Object object) {
        return this.remove(object, true, false);
    }

    @Override
    public synchronized void clear() {
        if (!this.isEmpty()) {
            this.auChanges = new ArrayUtil();
            for (Object k : this.keySet()) {
                this.auChanges.add(new Entry(k, null));
            }
        }
        super.clear();
    }

    public synchronized V put(K k, V v, boolean bl) {
        return this.put(k, v, bl, false);
    }

    public synchronized V put(K k, V v, boolean bl, boolean bl2) {
        V v2;
        if (v == null) {
            v2 = this.remove(k, bl, bl2);
        } else {
            v2 = super.put(k, v);
            if (bl && (v2 == null || !v2.equals(v) || bl2)) {
                if (this.auChanges == null) {
                    this.auChanges = new ArrayUtil();
                }
                this.auChanges.add(new Entry(k, v));
            }
        }
        return v2;
    }

    public synchronized V remove(Object object, boolean bl) {
        return this.remove(object, bl, false);
    }

    public synchronized V remove(Object object, boolean bl, boolean bl2) {
        Object v = super.remove(object);
        if (bl && (v != null || bl2)) {
            if (this.auChanges == null) {
                this.auChanges = new ArrayUtil();
            }
            this.auChanges.add(new Entry(object, null));
        }
        return v;
    }

    public synchronized List<Map.Entry<K, V>> getChanges(Class<? extends V> ... classArray) {
        ArrayUtil<Map.Entry<K, V>> arrayUtil = this.auChanges;
        this.auChanges = null;
        if (arrayUtil == null || classArray == null || classArray.length == 0) {
            return arrayUtil;
        }
        for (int i = arrayUtil.size() - 1; i >= 0; --i) {
            boolean bl;
            Map.Entry<K, V> entry = arrayUtil.get(i);
            V v = entry.getValue();
            if (v == null) {
                bl = true;
            } else {
                bl = false;
                for (int j = 0; j < classArray.length && !bl; ++j) {
                    if (!classArray[j].isAssignableFrom(v.getClass())) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            arrayUtil.remove(i);
        }
        return arrayUtil;
    }

    public synchronized List<Map.Entry<K, V>> getLastChanges() {
        ArrayUtil<Map.Entry<K, V>> arrayUtil = this.auChanges;
        this.auChanges = null;
        if (arrayUtil == null) {
            return arrayUtil;
        }
        Hashtable<K, K> hashtable = new Hashtable<K, K>();
        for (int i = arrayUtil.size() - 1; i >= 0; --i) {
            Map.Entry<K, V> entry = arrayUtil.get(i);
            K k = entry.getKey();
            if (hashtable.get(k) != null) {
                arrayUtil.remove(i);
                continue;
            }
            hashtable.put(k, k);
        }
        return arrayUtil;
    }

    public synchronized void clearChanges() {
        this.auChanges = null;
    }

    public synchronized List<Map.Entry<K, V>> getMapping(Class<? extends V> ... classArray) {
        ArrayUtil<Map.Entry<K, V>> arrayUtil = new ArrayUtil<Map.Entry<K, V>>();
        for (Map.Entry entry : this.entrySet()) {
            boolean bl;
            Object v = entry.getValue();
            if (v == null) {
                bl = true;
            } else if (classArray != null && classArray.length > 0) {
                bl = false;
                for (int i = 0; i < classArray.length && !bl; ++i) {
                    if (!classArray[i].isAssignableFrom(v.getClass())) continue;
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            arrayUtil.add(new Entry(entry.getKey(), entry.getValue()));
        }
        return arrayUtil;
    }

    public synchronized boolean isChanged(K k) {
        if (k instanceof Map.Entry) {
            return this.auChanges != null && this.auChanges.indexOf(k) >= 0;
        }
        if (this.auChanges != null) {
            Enumeration<Map.Entry<K, V>> enumeration = this.auChanges.enumeration();
            while (enumeration.hasMoreElements()) {
                if (!CommonUtil.equals(enumeration.nextElement().getKey(), k)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<KI, VI>
    implements Map.Entry {
        private KI key;
        private VI value;

        private Entry(KI KI, VI VI) {
            this.key = KI;
            this.value = VI;
        }

        public KI getKey() {
            return this.key;
        }

        public VI getValue() {
            return this.value;
        }

        public VI setValue(Object object) {
            return this.value;
        }
    }
}

