/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl;

import com.sibvisions.rad.remote.http.HttpConnection;
import com.sibvisions.rad.ui.ApplicationUtil;
import com.sibvisions.rad.ui.Webstart;
import com.sibvisions.rad.ui.awt.impl.AwtCursor;
import com.sibvisions.rad.ui.awt.impl.AwtFactory;
import com.sibvisions.rad.ui.swing.ext.JVxDesktopPane;
import com.sibvisions.rad.ui.swing.impl.FileChooser;
import com.sibvisions.rad.ui.swing.impl.JSBridge;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import com.sibvisions.rad.ui.swing.impl.SwingImage;
import com.sibvisions.rad.ui.swing.impl.container.SwingAbstractFrame;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.FileViewer;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CodecUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.rad.application.IApplication;
import javax.rad.application.IConnectable;
import javax.rad.application.IFileHandleReceiver;
import javax.rad.application.ILauncher;
import javax.rad.application.genui.UILauncher;
import javax.rad.genui.UIFactoryManager;
import javax.rad.io.FileHandle;
import javax.rad.io.IFileHandle;
import javax.rad.io.RemoteFileHandle;
import javax.rad.remote.AbstractConnection;
import javax.rad.remote.IConnection;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.ICursor;
import javax.rad.ui.IImage;
import javax.rad.ui.IRectangle;
import javax.rad.ui.UIException;
import javax.rad.ui.event.UIWindowEvent;
import javax.rad.ui.menu.IMenuBar;
import javax.rad.util.ExceptionHandler;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class SwingApplet
extends JApplet {
    public static final String PROPERTY_APPLICATION = "application";
    private static final String CONFIG_ROOT_NODE = "application";
    private SwingAppletLauncher launcher;
    private Frame frame = null;
    private JSBridge jscript = null;
    private Vector<Thread> uploadThreads = new Vector();
    private Thread thStartup;
    private ArrayUtil<WindowListener> lisApplet;
    private boolean bNotified = false;
    private boolean bApplicationStarted = false;

    public SwingApplet() {
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        try {
            Class.forName("javax.swing.text.html.parser.ParserDelegator").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        final String string = this.getParameter("main");
        if (string == null || string.length() == 0) {
            throw new UIException("The application parameter 'main' was not found!");
        }
        if (this.bNotified) {
            this.initLauncher(string);
        } else if (this.thStartup == null) {
            Thread thread = this.thStartup = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread thread = SwingApplet.this.thStartup;
                    synchronized (thread) {
                        SwingApplet.this.thStartup.notifyAll();
                        try {
                            SwingApplet.this.thStartup.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                SwingApplet.this.initLauncher(string);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        SwingApplet.this.initLauncher(string);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        LoggerFactory.getInstance(this.getClass()).error("init launcher failed", invocationTargetException);
                    }
                    SwingApplet.this.thStartup = null;
                }
            };
            synchronized (thread) {
                this.thStartup.start();
                try {
                    this.thStartup.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void destroy() {
        if (this.launcher != null) {
            this.launcher.destroy();
            this.launcher = null;
        }
        if (Webstart.isJnlp() && this.frame != null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this.frame, 201));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        System.exit(0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void addNotify() {
        super.addNotify();
        this.searchFrame();
        this.bNotified = true;
    }

    private void initLauncher(String string) {
        this.launcher = new SwingAppletLauncher(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchFrame() {
        Object object;
        if (this.getParent() != null && this.frame == null) {
            WindowListener[] windowListenerArray;
            int n;
            object = this;
            while (object != null && !(object instanceof Frame)) {
                if ((object = ((Component)object).getParent()) == null) continue;
                int n2 = ((Container)object).getComponentCount();
                for (n = 0; n < n2; ++n) {
                    windowListenerArray = ((Container)object).getComponent(n);
                    if (!(windowListenerArray instanceof JLabel) && !(windowListenerArray instanceof Label)) continue;
                    windowListenerArray.setVisible(false);
                }
            }
            if (object != null) {
                this.frame = (Frame)object;
                if (this.frame instanceof JFrame) {
                    ((JFrame)this.frame).setDefaultCloseOperation(0);
                    windowListenerArray = ((JFrame)this.frame).getWindowListeners();
                    for (n = 0; n < windowListenerArray.length; ++n) {
                        if (windowListenerArray[n] == this) continue;
                        if (this.lisApplet == null) {
                            this.lisApplet = new ArrayUtil();
                        }
                        this.lisApplet.add(windowListenerArray[n]);
                        ((JFrame)this.frame).removeWindowListener(windowListenerArray[n]);
                    }
                }
            }
        }
        if (this.thStartup != null && this.launcher == null) {
            object = this.thStartup;
            synchronized (object) {
                this.thStartup.notify();
            }
        }
    }

    public boolean isJavaScriptAvailable() {
        return this.jscript != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SwingAppletLauncher
    extends SwingAbstractFrame<JApplet>
    implements ILauncher,
    ComponentListener,
    WindowListener {
        private UILauncher uilauncher;
        private JRootPane rootPane;
        private JVxDesktopPane desktopModal;
        private IApplication application;
        private HashMap<String, String> hmpParams;
        private FileChooser fileChooser;

        public SwingAppletLauncher(JApplet jApplet, String string) {
            Class clazz;
            super(jApplet);
            this.application = null;
            this.hmpParams = null;
            this.fileChooser = null;
            this.parseUrlParams();
            this.loadConfiguration();
            Locale locale = Locale.getDefault();
            this.setParameter("client.locale.language", locale.getLanguage());
            this.setParameter("client.locale.country", locale.getCountry());
            this.setParameter("client.locale.variant", locale.getVariant());
            try {
                this.setParameter("client.file.encoding", System.getProperty("file.encoding"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            LoggerFactory.init(this.getParameter("Launcher.logfactory"));
            try {
                SwingApplet.this.jscript = new JSBridge(jApplet);
                this.hmpParams.put("Launcher.canExit", "false");
            }
            catch (Throwable throwable) {
                SwingApplet.this.jscript = null;
            }
            SwingFactory.setLookAndFeel(this, this.getParameter("Application.LookAndFeel"));
            try {
                clazz = Class.forName(this.getParameter("Launcher.uifactory"));
            }
            catch (Exception exception) {
                clazz = SwingFactory.class;
                LoggerFactory.getInstance(SwingApplet.class).debug("Fallback to SwingFactory", exception);
            }
            this.setFactory(UIFactoryManager.getFactoryInstance(clazz));
            this.rootPane = new JRootPane();
            this.rootPane.setOpaque(false);
            this.rootPane.setContentPane(((JApplet)this.resource).getContentPane());
            this.desktopModal = new JVxDesktopPane();
            this.desktopModal.add(this.rootPane);
            ((JApplet)this.resource).setContentPane(this.desktopModal);
            this.uilauncher = new UILauncher(this);
            try {
                this.application = ApplicationUtil.createApplication(this.uilauncher, string);
                this.uilauncher.setTitle(this.application.getName());
                if (SwingApplet.this.frame == null) {
                    ((JApplet)this.resource).addComponentListener(this);
                }
                this.uilauncher.add((IComponent)this.application, "Center");
                ((JApplet)this.resource).getRootPane().putClientProperty("application", this.application);
                if (SwingApplet.this.frame != null) {
                    if (SwingApplet.this.frame instanceof JFrame && (this.eventWindowClosing == null || this.eventWindowClosing.getDefaultListener() == null)) {
                        this.eventWindowClosing().setDefaultListener(this, "dispose");
                    }
                    this.startDelayed();
                }
            }
            catch (Throwable throwable) {
                this.desktopModal.setSize(((JApplet)this.resource).getSize());
                this.handleException(throwable);
            }
        }

        @Override
        protected void setLayoutIntern(LayoutManager layoutManager) {
            this.rootPane.getContentPane().setLayout(layoutManager);
        }

        @Override
        protected void addIntern(Component component, Object object, int n) {
            this.rootPane.getContentPane().add(component, object, n);
        }

        @Override
        protected void removeIntern(Component component) {
            this.rootPane.getContentPane().remove(component);
        }

        @Override
        public IImage capture(int n, int n2) {
            return new SwingImage(null, new ImageIcon(this.createImage(((JApplet)this.resource).getRootPane(), n, n2)));
        }

        @Override
        protected void addWindowListenerToResource() {
            if (SwingApplet.this.frame != null) {
                SwingApplet.this.frame.addWindowListener(this);
            }
        }

        @Override
        public String getParameter(String string) {
            String string2 = this.hmpParams.containsKey(string) ? this.hmpParams.get(string) : ((JApplet)this.resource).getParameter(string);
            if (string2 != null) {
                string2 = string2.replace("\\n", "\n");
                string2 = string2.replace("<br>", "\n");
            }
            return ApplicationUtil.replaceParameter(string2, this);
        }

        @Override
        public void setParameter(String string, String string2) {
            this.hmpParams.put(string, string2);
        }

        @Override
        public void showDocument(String string, IRectangle iRectangle, String string2) throws Exception {
            try {
                FileViewer.open(string);
            }
            catch (Throwable throwable) {
                if (SwingApplet.this.jscript == null) {
                    ((JApplet)this.resource).getAppletContext().showDocument(new URL(string), string2);
                }
                try {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    if (iRectangle == null) {
                        n4 = 20;
                        n3 = 20;
                        n2 = 800;
                        n = 600;
                    } else {
                        n4 = iRectangle.getX();
                        n3 = iRectangle.getY();
                        n2 = iRectangle.getWidth();
                        n = iRectangle.getHeight();
                    }
                    SwingApplet.this.jscript.openWindow(string, string2, n4, n3, n2, n, true);
                }
                catch (Throwable throwable2) {
                    ((JApplet)this.resource).getAppletContext().showDocument(new URL(string), string2);
                }
            }
        }

        @Override
        public void showFileHandle(IFileHandle iFileHandle, IRectangle iRectangle, String string) throws Throwable {
            try {
                File file = null;
                if (iFileHandle instanceof FileHandle) {
                    file = ((FileHandle)iFileHandle).getFile();
                }
                if (file == null) {
                    file = FileUtil.getNotExistingFile(new File(System.getProperty("java.io.tmpdir"), iFileHandle.getFileName()));
                    file.deleteOnExit();
                    FileUtil.copy(iFileHandle.getInputStream(), true, new FileOutputStream(file), true);
                }
                FileViewer.open(file);
            }
            catch (Throwable throwable) {
                this.handleDownload(iFileHandle, iRectangle, string);
            }
        }

        @Override
        public void showFileHandle(IFileHandle iFileHandle) throws Throwable {
            this.showFileHandle(iFileHandle, null, "_blank");
        }

        @Override
        public void saveFileHandle(IFileHandle iFileHandle, String string) throws Throwable {
            try {
                if (this.fileChooser == null) {
                    this.fileChooser = new FileChooser();
                }
                this.fileChooser.saveAs(this.uilauncher, SwingApplet.this.frame, iFileHandle, string);
            }
            catch (SecurityException securityException) {
                if (Webstart.isJnlp()) {
                    Webstart.showSaveDialog(iFileHandle);
                }
                this.handleDownload(iFileHandle, null, "_blank");
            }
        }

        @Override
        public void getFileHandle(final IFileHandleReceiver iFileHandleReceiver, String string) throws Throwable {
            IFileHandle[] iFileHandleArray;
            block10: {
                iFileHandleArray = null;
                try {
                    if (this.fileChooser == null) {
                        this.fileChooser = new FileChooser();
                    }
                    iFileHandleArray = this.fileChooser.open(this.uilauncher, SwingApplet.this.frame, string);
                }
                catch (SecurityException securityException) {
                    String string2;
                    if (Webstart.isJnlp()) {
                        iFileHandleArray = Webstart.showOpenDialog(true);
                    }
                    HttpConnection httpConnection = this.getHttpConnection();
                    if (httpConnection == null || (string2 = httpConnection.getUploadURL()) == null) break block10;
                    final RemoteFileHandle remoteFileHandle = httpConnection.createRemoteFileHandle();
                    String string3 = this.getApplicationName();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string2);
                    if (string2.indexOf(63) > 0) {
                        stringBuilder.append("&");
                    } else {
                        stringBuilder.append("?");
                    }
                    final String string4 = stringBuilder.toString();
                    if (string3 != null) {
                        stringBuilder.append("APPLICATION=");
                        stringBuilder.append(CodecUtil.encodeURLParameter(string3));
                        stringBuilder.append("&");
                    }
                    if (Webstart.isJnlp()) {
                        stringBuilder.append("WEBSTART=Y&");
                    }
                    Object object = this.getConnectionId();
                    stringBuilder.append("TITLE=");
                    stringBuilder.append(CodecUtil.encodeURLParameter(this.uilauncher.translate(string == null ? "Open file" : string)));
                    stringBuilder.append("&INFOTEXT=");
                    stringBuilder.append(CodecUtil.encodeURLParameter(this.uilauncher.translate("Please choose the file:")));
                    stringBuilder.append("&UPLOADBUTTON=");
                    stringBuilder.append(CodecUtil.encodeURLParameter(this.uilauncher.translate("Upload")));
                    stringBuilder.append("&CANCELBUTTON=");
                    stringBuilder.append(CodecUtil.encodeURLParameter(this.uilauncher.translate("Cancel")));
                    stringBuilder.append("&KEY=");
                    stringBuilder.append(remoteFileHandle.getObjectCacheKey());
                    stringBuilder.append("&CONNECTION_ID=");
                    stringBuilder.append(CodecUtil.encodeHex(object != null ? object.toString() : null));
                    String string5 = this.getParameter("Application.serverbase");
                    if (string5 != null) {
                        stringBuilder.append("&CONURL=");
                        stringBuilder.append(CodecUtil.encodeURLParameter(string5));
                    }
                    this.showDocument(stringBuilder.toString(), null, "Loaddialog");
                    SwingApplet.this.uploadThreads.add(ThreadHandler.start(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            ICursor iCursor = SwingAppletLauncher.this.getCursor();
                            try {
                                block8: {
                                    try {
                                        URL uRL = new URL(string4 + "WAIT=true&KEY=" + remoteFileHandle.getObjectCacheKey());
                                        String string = "WAIT";
                                        while ("WAIT".equals(string) && !ThreadHandler.isStopped()) {
                                            SwingAppletLauncher.this.setCursor(AwtCursor.getPredefinedCursor(3));
                                            URLConnection uRLConnection = uRL.openConnection();
                                            uRLConnection.setUseCaches(false);
                                            uRLConnection.setDoInput(true);
                                            DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                                            string = dataInputStream.readUTF();
                                            if ("FILENAME".equals(string)) {
                                                remoteFileHandle.setFileName(dataInputStream.readUTF());
                                            }
                                            dataInputStream.close();
                                        }
                                        if (!"FILENAME".equals(string)) break block8;
                                        SwingUtilities.invokeLater(new Runnable(){

                                            public void run() {
                                                try {
                                                    iFileHandleReceiver.receiveFileHandle(remoteFileHandle);
                                                }
                                                catch (Throwable throwable) {
                                                    ExceptionHandler.show(throwable);
                                                }
                                            }
                                        });
                                    }
                                    catch (Exception exception) {
                                        try {
                                            SwingUtilities.invokeLater(new Runnable(){

                                                public void run() {
                                                    ExceptionHandler.show(exception);
                                                }
                                            });
                                        }
                                        catch (Exception exception2) {
                                            ExceptionHandler.show(exception);
                                        }
                                        Object var7_9 = null;
                                        SwingApplet.this.uploadThreads.remove(Thread.currentThread());
                                        SwingAppletLauncher.this.setCursor(iCursor);
                                        return;
                                    }
                                }
                                Object var7_8 = null;
                                SwingApplet.this.uploadThreads.remove(Thread.currentThread());
                                SwingAppletLauncher.this.setCursor(iCursor);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var7_10 = null;
                                SwingApplet.this.uploadThreads.remove(Thread.currentThread());
                                SwingAppletLauncher.this.setCursor(iCursor);
                                throw throwable;
                            }
                        }
                    }));
                }
            }
            if (iFileHandleArray != null) {
                final IFileHandle[] iFileHandleArray2 = iFileHandleArray;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            for (int i = 0; i < iFileHandleArray2.length; ++i) {
                                iFileHandleReceiver.receiveFileHandle(iFileHandleArray2[i]);
                            }
                        }
                        catch (Throwable throwable) {
                            ExceptionHandler.show(throwable);
                        }
                    }
                });
            }
        }

        @Override
        public void cancelPendingThreads() {
            Vector vector = (Vector)SwingApplet.this.uploadThreads.clone();
            for (Thread thread : vector) {
                ThreadHandler.stop(thread);
            }
        }

        @Override
        public void setRegistryKey(String string, String string2) {
            block5: {
                String string3 = ApplicationUtil.getRegistryApplicationName(this);
                try {
                    ApplicationUtil.setRegistryKey(string3, string, string2);
                }
                catch (SecurityException securityException) {
                    if (SwingApplet.this.jscript != null) {
                        try {
                            SwingApplet.this.jscript.setCookie(string3 + "." + string, string2, 30758400L);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (!Webstart.isJnlp()) break block5;
                    Webstart.setProperty(string, string2);
                }
            }
        }

        @Override
        public String getRegistryKey(String string) {
            String string2 = ApplicationUtil.getRegistryApplicationName(this);
            try {
                return ApplicationUtil.getRegistryKey(string2, string);
            }
            catch (SecurityException securityException) {
                if (SwingApplet.this.jscript != null) {
                    try {
                        return SwingApplet.this.jscript.getCookie(string2 + "." + string);
                    }
                    catch (Throwable throwable) {
                    }
                } else if (Webstart.isJnlp()) {
                    return Webstart.getProperty(string);
                }
                return null;
            }
        }

        @Override
        public String getEnvironmentName() {
            return "DESKTOP";
        }

        @Override
        public void handleException(Throwable throwable) {
            SwingFactory.showError(throwable, this.desktopModal);
        }

        @Override
        public String getTitle() {
            if (SwingApplet.this.jscript != null) {
                try {
                    return SwingApplet.this.jscript.getTitle();
                }
                catch (Throwable throwable) {
                }
            } else if (SwingApplet.this.frame != null) {
                return SwingApplet.this.frame.getTitle();
            }
            return null;
        }

        @Override
        public void setTitle(String string) {
            if (SwingApplet.this.jscript != null) {
                try {
                    SwingApplet.this.jscript.setTitle(string);
                }
                catch (Throwable throwable) {}
            } else if (SwingApplet.this.frame != null) {
                SwingApplet.this.frame.setTitle(string);
            }
        }

        @Override
        public void setIconImage(IImage iImage) {
            this.iconImage = iImage;
            if (SwingApplet.this.frame != null) {
                if (iImage == null) {
                    SwingApplet.this.frame.setIconImage(null);
                } else {
                    SwingApplet.this.frame.setIconImage(((ImageIcon)iImage.getResource()).getImage());
                }
            }
        }

        @Override
        public int getState() {
            if (SwingApplet.this.frame != null) {
                return SwingApplet.this.frame.getState();
            }
            return 0;
        }

        @Override
        public void setState(int n) {
            if (SwingApplet.this.frame != null) {
                SwingApplet.this.frame.setState(n);
            }
        }

        @Override
        public boolean isResizable() {
            if (SwingApplet.this.frame != null) {
                return SwingApplet.this.frame.isResizable();
            }
            return true;
        }

        @Override
        public void setResizable(boolean bl) {
            if (Webstart.isJnlp() && SwingApplet.this.frame != null) {
                SwingApplet.this.frame.setResizable(bl);
            }
        }

        @Override
        public void pack() {
            if (Webstart.isJnlp() && SwingApplet.this.frame != null) {
                SwingApplet.this.frame.pack();
            } else {
                ((JApplet)this.resource).validate();
                ((JApplet)this.resource).repaint();
            }
        }

        @Override
        public void dispose() {
            block16: {
                int n;
                if (this.application != null && SwingApplet.this.bApplicationStarted) {
                    SwingApplet.this.bApplicationStarted = false;
                    try {
                        this.application.notifyDestroy();
                    }
                    catch (Exception exception) {
                        this.uilauncher.error(exception);
                    }
                }
                if (SwingApplet.this.frame instanceof JFrame) {
                    Rectangle rectangle = SwingApplet.this.frame.getBounds();
                    n = ((JFrame)SwingApplet.this.frame).getExtendedState();
                    this.setRegistryKey("framebounds", rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
                    this.setRegistryKey("maximized", "" + (n == 6 || n == 2 || n == 4));
                    try {
                        this.setRegistryKey("display", ((JApplet)this.resource).getGraphicsConfiguration().getDevice().getIDstring());
                    }
                    catch (Exception exception) {
                        this.setRegistryKey("display", null);
                    }
                }
                if (SwingApplet.this.lisApplet != null) {
                    ((JFrame)SwingApplet.this.frame).removeWindowListener(this);
                    n = SwingApplet.this.lisApplet.size();
                    for (int i = 0; i < n; ++i) {
                        ((JFrame)SwingApplet.this.frame).addWindowListener((WindowListener)SwingApplet.this.lisApplet.get(i));
                    }
                }
                if (Webstart.isJnlp() && SwingApplet.this.frame != null) {
                    try {
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(SwingApplet.this.frame, 201));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    System.exit(0);
                }
                catch (Exception exception) {
                    if (SwingApplet.this.jscript == null) break block16;
                    try {
                        SwingApplet.this.jscript.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (SwingApplet.this.isShowing()) {
                this.uilauncher.addNotify();
            }
        }

        @Override
        public boolean isActive() {
            if (SwingApplet.this.frame != null) {
                return SwingApplet.this.frame.isActive();
            }
            return ((JApplet)this.resource).isActive();
        }

        @Override
        public void toFront() {
            if (SwingApplet.this.jscript != null) {
                try {
                    SwingApplet.this.jscript.requestFocus();
                }
                catch (Throwable throwable) {}
            } else if (SwingApplet.this.frame != null) {
                SwingApplet.this.frame.toFront();
            }
        }

        @Override
        public void toBack() {
            if (SwingApplet.this.frame != null) {
                SwingApplet.this.frame.toBack();
            }
        }

        @Override
        public void setMenuBar(IMenuBar iMenuBar) {
            if (this.menuBar != null) {
                this.menuBar.setParent(null);
            }
            IContainer iContainer = null;
            if (iMenuBar != null) {
                iContainer = iMenuBar.getParent();
                iMenuBar.setParent(this);
            }
            try {
                if (iMenuBar != null) {
                    this.rootPane.setJMenuBar((JMenuBar)iMenuBar.getResource());
                } else {
                    this.rootPane.setJMenuBar(null);
                }
            }
            catch (RuntimeException runtimeException) {
                if (iMenuBar != null) {
                    iMenuBar.setParent(iContainer);
                }
                throw runtimeException;
            }
            catch (Error error) {
                if (iMenuBar != null) {
                    iMenuBar.setParent(iContainer);
                }
                throw error;
            }
            this.menuBar = iMenuBar;
        }

        @Override
        public void centerRelativeTo(IComponent iComponent) {
            if (SwingApplet.this.frame != null) {
                if (iComponent != null) {
                    SwingApplet.this.frame.setLocationRelativeTo((Component)iComponent.getResource());
                } else {
                    SwingApplet.this.frame.setLocationRelativeTo(null);
                }
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.start();
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (this.eventWindowClosing != null) {
                this.eventWindowClosing.dispatchEvent(new UIWindowEvent(this.eventSource, 201, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            if (this.eventWindowClosed != null) {
                this.eventWindowClosed.dispatchEvent(new UIWindowEvent(this.eventSource, 202, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (this.eventWindowActivated != null) {
                this.eventWindowActivated.dispatchEvent(new UIWindowEvent(this.eventSource, 205, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (this.eventWindowDeactivated != null) {
                this.eventWindowDeactivated.dispatchEvent(new UIWindowEvent(this.eventSource, 206, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            if (this.eventWindowIconified != null) {
                this.eventWindowIconified.dispatchEvent(new UIWindowEvent(this.eventSource, 203, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            if (this.eventWindowDeiconified != null) {
                this.eventWindowDeiconified.dispatchEvent(new UIWindowEvent(this.eventSource, 204, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
            }
        }

        public void startDelayed() {
            ThreadHandler.start(new Runnable(){

                public void run() {
                    try {
                        for (int i = 0; (SwingAppletLauncher.this.application.getSize().getWidth() <= 0 || SwingAppletLauncher.this.application.getSize().getHeight() <= 0) && i < 50; ++i) {
                            Thread.sleep(20L);
                        }
                        SwingAppletLauncher.this.start();
                    }
                    catch (Throwable throwable) {
                        SwingAppletLauncher.this.start();
                    }
                }
            });
        }

        public synchronized void start() {
            if (!SwingApplet.this.bApplicationStarted) {
                SwingApplet.this.bApplicationStarted = true;
                if (SwingApplet.this.frame != null) {
                    SwingApplet.this.frame.setResizable(true);
                    if (!ApplicationUtil.configureFrameBounds(this, SwingApplet.this.frame)) {
                        SwingApplet.this.frame.setLocationRelativeTo(null);
                    }
                }
                this.uilauncher.setVisible(true);
                if (this.eventWindowOpened != null) {
                    this.eventWindowOpened.dispatchEvent(new UIWindowEvent(this.eventSource, 200, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SwingAppletLauncher.this.application.notifyVisible();
                    }
                });
            }
        }

        public void destroy() {
            if (this.application != null && SwingApplet.this.bApplicationStarted) {
                SwingApplet.this.bApplicationStarted = false;
                this.application.notifyDestroy();
            }
            if (SwingApplet.this.frame == null && this.eventWindowClosed != null) {
                this.eventWindowClosed.dispatchEvent(new UIWindowEvent(this.eventSource, 202, AwtFactory.getMostRecentEventTime(), AwtFactory.getCurrentModifiers()));
            }
        }

        private void loadConfiguration() {
            String string = this.getParameter("config");
            if (string == null) {
                string = "application.xml";
            }
            try {
                XmlNode xmlNode = ApplicationUtil.getConfig(string);
                if (xmlNode != null) {
                    for (XmlNode xmlNode2 : xmlNode.getNode("application").getNodes()) {
                        String string2;
                        if (this.hmpParams.containsKey(xmlNode2.getName()) || (string2 = ((JApplet)this.resource).getParameter(xmlNode2.getName())) != null) continue;
                        this.hmpParams.put(xmlNode2.getName(), xmlNode2.getValue());
                    }
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(this.getClass()).error("Configuration load error!", exception);
            }
        }

        private void parseUrlParams() {
            URL uRL = ((JApplet)this.resource).getDocumentBase();
            String string = uRL.getQuery();
            this.hmpParams = new HashMap();
            this.hmpParams.put("Launcher.codebase", ((JApplet)this.resource).getCodeBase().toString());
            this.hmpParams.put("Launcher.documentBase", uRL.toString());
            String string2 = uRL.getProtocol() + "://" + uRL.getAuthority();
            if (uRL.getPath() != null) {
                int n = uRL.getPath().lastIndexOf(47);
                string2 = string2 + uRL.getPath().substring(0, n);
            }
            if (StringUtil.isEmpty(((JApplet)this.resource).getParameter("Application.serverbase"))) {
                this.hmpParams.put("Application.serverbase", string2);
            }
            if (string != null && string.trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    int n = string3.indexOf(61);
                    if (n <= 0) continue;
                    this.hmpParams.put(string3.substring(0, n), string3.substring(n + 1));
                }
            }
        }

        private void handleDownload(IFileHandle iFileHandle, IRectangle iRectangle, String string) throws Throwable {
            String string2;
            RemoteFileHandle remoteFileHandle = null;
            HttpConnection httpConnection = this.getHttpConnection();
            if (httpConnection != null && (string2 = httpConnection.getDownloadURL()) != null) {
                remoteFileHandle = iFileHandle instanceof RemoteFileHandle ? (RemoteFileHandle)iFileHandle : httpConnection.writeContent(iFileHandle);
                if (remoteFileHandle == null) {
                    throw new RuntimeException("Can't handle download without remote file handle!");
                }
                String string3 = this.getApplicationName();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                if (string2.indexOf(63) > 0) {
                    stringBuilder.append("&");
                } else {
                    stringBuilder.append("?");
                }
                stringBuilder.append("ONLOAD=true");
                if (string3 != null) {
                    stringBuilder.append("&APPLICATION=");
                    stringBuilder.append(CodecUtil.encodeURLParameter(string3));
                }
                stringBuilder.append("&INFOTEXT=");
                stringBuilder.append(CodecUtil.encodeURLParameter(this.uilauncher.translate("Please download your file")));
                stringBuilder.append("&DOWNLOADBUTTON=");
                stringBuilder.append(CodecUtil.encodeURLParameter(this.uilauncher.translate("Download")));
                stringBuilder.append("&CANCELBUTTON=");
                stringBuilder.append(CodecUtil.encodeURLParameter(this.uilauncher.translate("Close")));
                stringBuilder.append("&KEY=");
                stringBuilder.append(remoteFileHandle.getObjectCacheKey());
                String string4 = this.getParameter("Application.serverbase");
                if (string4 != null) {
                    stringBuilder.append("&CONURL=");
                    stringBuilder.append(CodecUtil.encodeURLParameter(string4));
                }
                this.showDocument(stringBuilder.toString(), iRectangle, string);
            }
        }

        private String getApplicationName() {
            AbstractConnection abstractConnection;
            if (this.application instanceof IConnectable && (abstractConnection = ((IConnectable)((Object)this.application)).getConnection()) != null) {
                return abstractConnection.getApplicationName();
            }
            return this.getParameter("Application.name");
        }

        private HttpConnection getHttpConnection() {
            IConnection iConnection;
            AbstractConnection abstractConnection;
            if (this.application instanceof IConnectable && (abstractConnection = ((IConnectable)((Object)this.application)).getConnection()) != null && (iConnection = abstractConnection.getConnection()) instanceof HttpConnection) {
                return (HttpConnection)iConnection;
            }
            return null;
        }

        private Object getConnectionId() {
            AbstractConnection abstractConnection;
            if (this.application instanceof IConnectable && (abstractConnection = ((IConnectable)((Object)this.application)).getConnection()) != null) {
                return abstractConnection.getConnectionId();
            }
            return null;
        }
    }
}

