/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.http;

import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceServlet
extends HttpServlet {
    public static final String PARAM_KEY = "KEY";
    public static final String PARAM_RESOURCE = "RESOURCE";
    public static final String PARAM_CANCELBUTTON = "CANCELBUTTON";
    public static final String PARAM_APPLICATION = "APPLICATION";
    public static final String PARAM_TITLE = "TITLE";
    public static final String PARAM_INFOTEXT = "INFOTEXT";
    public static final String PARAM_CONURL = "CONURL";

    protected abstract String getResourceDirectoryName();

    protected String getFileName(String string) {
        String string2;
        String string3 = null;
        if (string != null && ((string2 = string.toLowerCase()).startsWith("form-data") || string2.startsWith("attachment"))) {
            ParameterParser parameterParser = new ParameterParser();
            parameterParser.setLowerCaseNames(true);
            Map map = parameterParser.parse(string, ';');
            string3 = (String)map.get("filename");
            if (string3 != null) {
                string3 = string3.trim();
            }
        }
        return string3;
    }

    protected FileItemStream getFileItemStream(HttpServletRequest httpServletRequest) throws IOException {
        try {
            FileItemIterator fileItemIterator = new ServletFileUpload().getItemIterator(httpServletRequest);
            while (fileItemIterator.hasNext()) {
                FileItemStream fileItemStream = fileItemIterator.next();
                if (fileItemStream.isFormField()) continue;
                return fileItemStream;
            }
        }
        catch (FileUploadException fileUploadException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFile(String string, String string2, Hashtable<String, String> hashtable, HttpServletResponse httpServletResponse) throws Exception {
        String string3;
        String string4 = this.getResourceDirectoryName();
        InputStream inputStream = null;
        if (string != null && string.trim().length() > 0) {
            string3 = Configuration.getApplicationZone(string).getProperty("/application/" + string4 + "/searchpath");
            if (string3 == null) {
                string3 = "/com/sibvisions/rad/server/http/" + string4 + "/";
            }
            if (!string3.endsWith("/") && !string3.endsWith("\\")) {
                string3 = string3 + "/";
            }
            if (!this.checkResourceAccess(httpServletResponse, string3, string2)) {
                return;
            }
            inputStream = ResourceUtil.getResourceAsStream(string3 + string2);
        }
        if (inputStream == null) {
            string3 = Configuration.getServerZone().getProperty("/server/" + string4 + "/searchpath");
            if (string3 == null) {
                string3 = "/com/sibvisions/rad/server/http/" + string4 + "/";
            }
            if (!string3.endsWith("/") && !string3.endsWith("\\")) {
                string3 = string3 + "/";
            }
            if (!this.checkResourceAccess(httpServletResponse, string3, string2)) {
                return;
            }
            inputStream = ResourceUtil.getResourceAsStream(string3 + string2);
        }
        if (inputStream == null) {
            httpServletResponse.sendError(404);
        } else {
            ServletOutputStream servletOutputStream;
            block19: {
                httpServletResponse.setContentType(this.getServletContext().getMimeType(string2));
                servletOutputStream = httpServletResponse.getOutputStream();
                try {
                    if (string2.toLowerCase().endsWith(".html")) {
                        String string5 = new String(FileUtil.getContent(inputStream));
                        int n = 0;
                        int n2 = 0;
                        n2 = string5.indexOf(91);
                        while (n2 >= 0) {
                            int n3 = string5.indexOf(93, n2 + 1);
                            if (n3 >= 0) {
                                servletOutputStream.write(string5.substring(n, n2).getBytes("UTF-8"));
                                String string6 = string5.substring(n2 + 1, n3);
                                String string7 = null;
                                if (hashtable != null && (string7 = hashtable.get(string6)) != null) {
                                    servletOutputStream.write(string7.getBytes("UTF-8"));
                                }
                                if (string7 == null) {
                                    servletOutputStream.write(91);
                                    servletOutputStream.write(string6.getBytes("UTF-8"));
                                    servletOutputStream.write(93);
                                }
                                n = n3 + 1;
                                n2 = string5.indexOf(91, n + 1);
                                continue;
                            }
                            n2 = -1;
                        }
                        servletOutputStream.write(string5.substring(n).getBytes("UTF-8"));
                    } else {
                        FileUtil.copy(inputStream, (OutputStream)servletOutputStream);
                    }
                    Object var16_15 = null;
                    if (inputStream == null) break block19;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    servletOutputStream.flush();
                    servletOutputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            servletOutputStream.flush();
            servletOutputStream.close();
            {
            }
        }
    }

    protected String getRequestURI(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter(PARAM_CONURL);
        if (string != null && string.trim().length() > 0) {
            String string2 = httpServletRequest.getRequestURL().toString();
            try {
                URL uRL = new URL(string);
                String string3 = uRL.getProtocol() + "://" + uRL.getAuthority();
                if (!string2.toLowerCase().startsWith(string3.toLowerCase())) {
                    int n = string2.indexOf("://");
                    if ((n = string2.indexOf("/", n + 3)) >= 0) {
                        return string3 + string2.substring(n);
                    }
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(((Object)((Object)this)).getClass()).error(exception);
            }
        }
        return httpServletRequest.getRequestURL().toString();
    }

    private boolean checkResourceAccess(HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        if (StringUtil.isEmpty(string2) || string2.trim().startsWith(".") || string2.trim().startsWith("/") || string2.trim().startsWith("\\") || string2.indexOf("/../") >= 0 || string2.indexOf("/./") >= 0) {
            httpServletResponse.sendError(403, string2);
            return false;
        }
        File file = new File(string + string2);
        try {
            if (file.exists() || file.getCanonicalFile().exists()) {
                httpServletResponse.sendError(403, string2);
                return false;
            }
        }
        catch (IOException iOException) {
            httpServletResponse.sendError(403, string2);
            return false;
        }
        return true;
    }
}

