/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.Server;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.SessionExpiredException;
import javax.rad.remote.event.CallBackForward;
import javax.rad.remote.event.CallBackResultEvent;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.remote.event.ICallBackResultListener;
import javax.rad.remote.event.IConnectionPropertyChangedListener;
import javax.rad.remote.event.PropertyEvent;
import javax.rad.server.ResultObject;
import javax.rad.server.push.IPushReceiver;
import javax.rad.server.push.PushMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectServerConnection
implements IConnection {
    private IDirectServer server = null;
    private boolean bCalling = false;
    private ArrayUtil<IConnectionPropertyChangedListener> auPropertyChangedListeners;
    private ArrayUtil<ICallBackResultListener> auCallBackResultListeners;

    public DirectServerConnection() {
        if (this.server == null) {
            this.server = Server.getInstance();
        }
    }

    public DirectServerConnection(IDirectServer iDirectServer) {
        this.server = iDirectServer;
    }

    @Override
    public synchronized void open(ConnectionInfo connectionInfo) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfo.getConnectionId() != null) {
            throw new SecurityException("Session is already open!");
        }
        Object object = this.server.createSession(connectionInfo.getProperties());
        connectionInfo.setConnectionId(object);
        this.syncWithServer(connectionInfo);
        this.server.registerPushReceiver(object, new DirectServerPushReceiver(this));
    }

    @Override
    public synchronized void openSub(ConnectionInfo connectionInfo, ConnectionInfo connectionInfo2) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfo2.getConnectionId() != null) {
            throw new SecurityException("Session is already open!");
        }
        Object object = this.server.createSubSession(connectionInfo.getConnectionId(), connectionInfo2.getProperties());
        connectionInfo2.setConnectionId(object);
        this.syncWithServer(connectionInfo2);
    }

    @Override
    public boolean isOpen(ConnectionInfo connectionInfo) {
        return connectionInfo != null && connectionInfo.getConnectionId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(ConnectionInfo connectionInfo) throws Throwable {
        Object object;
        if (this.isOpen(connectionInfo)) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            object = connectionInfo.getConnectionId();
            try {
                block5: {
                    try {
                        this.checkCallBackResults(connectionInfo);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof SessionExpiredException) break block5;
                        LoggerFactory.getInstance(DirectServerConnection.class).error(throwable);
                    }
                }
                this.server.destroySession(object);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.server.unregisterPushReceiver(object);
                connectionInfo.setConnectionId(null);
                throw throwable;
            }
        }
        throw new IllegalStateException("Connection not open");
        this.server.unregisterPushReceiver(object);
        connectionInfo.setConnectionId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object[] call(ConnectionInfo connectionInfo, String[] stringArray, String[] stringArray2, Object[][] objectArray, ICallBackListener[] iCallBackListenerArray) throws Throwable {
        try {
            this.bCalling = true;
            if (connectionInfo == null) {
                throw new IllegalArgumentException("Invalid connection information: null");
            }
            if (connectionInfo.getConnectionId() == null) {
                throw new IllegalStateException("The connection is not open!");
            }
            if (stringArray2 == null) {
                throw new IllegalArgumentException("No remote method specified!");
            }
            if (stringArray != null && stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException("More or less objects than methods!");
            }
            if (objectArray != null && objectArray.length != stringArray2.length) {
                throw new IllegalArgumentException("More or less params than methods!");
            }
            Object object = connectionInfo.getConnectionId();
            if (!(object != null || stringArray != null && "Session!".equals(stringArray[0]) && ("createSession".equals(stringArray2[0]) || "createSubSession".equals(stringArray2[0])))) {
                throw new IOException("Connection is not open!");
            }
            if (iCallBackListenerArray != null && iCallBackListenerArray.length != stringArray2.length) {
                throw new IllegalArgumentException("More or less callbacks than methods!");
            }
            Object[] objectArray2 = new Object[stringArray2.length];
            Object object2 = connectionInfo.getConnectionId();
            Throwable throwable = null;
            if (objectArray2.length > 0) {
                this.server.beforeFirstCall(object2);
            }
            int n = objectArray2.length;
            for (int i = 0; i < n && throwable == null; ++i) {
                Object var14_15;
                try {
                    block23: {
                        try {
                            if (iCallBackListenerArray == null || iCallBackListenerArray[i] == null) {
                                objectArray2[i] = this.server.execute(object2, stringArray != null ? stringArray[i] : null, stringArray2[i], objectArray != null ? objectArray[i] : null);
                                break block23;
                            }
                            this.server.executeCallBack(object2, new CallBackForward(this, iCallBackListenerArray[i]), stringArray != null ? stringArray[i] : null, stringArray2[i], objectArray != null ? objectArray[i] : null);
                            objectArray2[i] = null;
                        }
                        catch (Throwable throwable2) {
                            objectArray2[i] = null;
                            throwable = throwable2;
                            var14_15 = null;
                            connectionInfo.setLastCallTime(System.currentTimeMillis());
                            continue;
                        }
                    }
                    var14_15 = null;
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                    continue;
                }
                catch (Throwable throwable3) {
                    var14_15 = null;
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                    throw throwable3;
                }
            }
            if (objectArray2.length > 0) {
                this.server.afterLastCall(object2, throwable != null);
            }
            try {
                try {
                    this.syncWithServer(connectionInfo);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    }
                    Object var16_18 = null;
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                }
                Object var16_17 = null;
                connectionInfo.setLastCallTime(System.currentTimeMillis());
            }
            catch (Throwable throwable5) {
                Object var16_19 = null;
                connectionInfo.setLastCallTime(System.currentTimeMillis());
                throw throwable5;
            }
            if (throwable != null) {
                throw throwable;
            }
            Object[] objectArray3 = objectArray2;
            Object var18_21 = null;
            this.bCalling = false;
            return objectArray3;
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            this.bCalling = false;
            throw throwable;
        }
    }

    @Override
    public boolean isCalling() {
        return this.bCalling;
    }

    @Override
    public synchronized ConnectionInfo[] setAndCheckAlive(ConnectionInfo connectionInfo, ConnectionInfo[] connectionInfoArray) throws Throwable {
        Object[] objectArray;
        Hashtable<Object, ConnectionInfo> hashtable;
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfoArray != null) {
            hashtable = new Hashtable<Object, ConnectionInfo>();
            objectArray = new Object[connectionInfoArray.length];
            int n = connectionInfoArray.length;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = connectionInfoArray[i].getConnectionId();
                hashtable.put(objectArray[i], connectionInfoArray[i]);
            }
        } else {
            hashtable = null;
            objectArray = null;
        }
        Object[] objectArray2 = this.server.setAndCheckAlive(connectionInfo.getConnectionId(), objectArray);
        this.syncWithServer(connectionInfo);
        if (objectArray2 == null) {
            return null;
        }
        ConnectionInfo[] connectionInfoArray2 = new ConnectionInfo[objectArray2.length];
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            connectionInfoArray2[i] = (ConnectionInfo)hashtable.get(objectArray2[i]);
        }
        return connectionInfoArray2;
    }

    @Override
    public synchronized void setProperty(ConnectionInfo connectionInfo, String string, Object object) throws Throwable {
        if (string != null) {
            if (string.startsWith("client.")) {
                if (this.isOpen(connectionInfo)) {
                    throw new SecurityException("Client properties are not accessible after the connection was opened!");
                }
                Object object2 = connectionInfo.getProperties().put(string, object, false);
                this.firePropertyChanged(string, object2, object, false);
            } else {
                Object object3 = connectionInfo.getProperties().put(string, object, false);
                this.firePropertyChanged(string, object3, object, false);
                if (this.isOpen(connectionInfo)) {
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                    this.server.setProperty(connectionInfo.getConnectionId(), string, object);
                    this.syncWithServer(connectionInfo);
                }
            }
        }
    }

    @Override
    public synchronized Object getProperty(ConnectionInfo connectionInfo, String string) throws Throwable {
        if (connectionInfo != null) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            if (this.isOpen(connectionInfo)) {
                this.syncWithServer(connectionInfo);
            }
            return connectionInfo.getProperties().get(string);
        }
        return null;
    }

    @Override
    public synchronized Hashtable<String, Object> getProperties(ConnectionInfo connectionInfo) throws Throwable {
        if (connectionInfo != null) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            if (this.isOpen(connectionInfo)) {
                this.syncWithServer(connectionInfo);
            }
            return (Hashtable)connectionInfo.getProperties().clone();
        }
        return null;
    }

    @Override
    public synchronized void setNewPassword(ConnectionInfo connectionInfo, String string, String string2) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        this.server.setNewPassword(connectionInfo.getConnectionId(), string, string2);
        this.syncWithServer(connectionInfo);
    }

    @Override
    public void addPropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.auPropertyChangedListeners == null) {
            this.auPropertyChangedListeners = new ArrayUtil();
        }
        if (!this.auPropertyChangedListeners.contains(iConnectionPropertyChangedListener)) {
            this.auPropertyChangedListeners.add(iConnectionPropertyChangedListener);
        }
    }

    @Override
    public void removePropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.auPropertyChangedListeners != null) {
            this.auPropertyChangedListeners.remove(iConnectionPropertyChangedListener);
        }
    }

    @Override
    public void addCallBackResultListener(ICallBackResultListener iCallBackResultListener) {
        if (this.auCallBackResultListeners == null) {
            this.auCallBackResultListeners = new ArrayUtil();
        }
        if (!this.auCallBackResultListeners.contains(iCallBackResultListener)) {
            this.auCallBackResultListeners.add(iCallBackResultListener);
        }
    }

    @Override
    public void removeCallBackResultListener(ICallBackResultListener iCallBackResultListener) {
        if (this.auCallBackResultListeners != null) {
            this.auCallBackResultListeners.remove(iCallBackResultListener);
        }
    }

    private void syncWithServer(ConnectionInfo connectionInfo) throws Throwable {
        this.syncProperties(connectionInfo);
        this.checkCallBackResults(connectionInfo);
    }

    private void syncProperties(ConnectionInfo connectionInfo) throws Throwable {
        ChangedHashtable<String, Object> changedHashtable = this.server.getProperties(connectionInfo.getConnectionId());
        ChangedHashtable<String, Object> changedHashtable2 = connectionInfo.getProperties();
        for (Map.Entry object : changedHashtable.entrySet()) {
            String string = (String)object.getKey();
            Object v = object.getValue();
            Object object2 = changedHashtable2.put(string, v, false);
            this.firePropertyChanged(string, object2, v, true);
        }
        Hashtable hashtable = (Hashtable)changedHashtable2.clone();
        for (String string : hashtable.keySet()) {
            if (changedHashtable.containsKey(string)) continue;
            changedHashtable2.remove(string);
        }
    }

    private void checkCallBackResults(ConnectionInfo connectionInfo) throws Throwable {
        List<ResultObject> list;
        if (this.auCallBackResultListeners != null && (list = this.server.getCallBackResults(connectionInfo.getConnectionId())) != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ResultObject resultObject = list.get(i);
                if (resultObject.getType() != 6) continue;
                CallBackResultEvent callBackResultEvent = new CallBackResultEvent((String)resultObject.getCallBackId(), resultObject.getObject());
                int n2 = this.auCallBackResultListeners.size();
                for (int j = 0; j < n2; ++j) {
                    this.auCallBackResultListeners.get(j).callBackResult(callBackResultEvent);
                }
            }
        }
    }

    private void firePropertyChanged(String string, Object object, Object object2, boolean bl) throws Throwable {
        if (!(this.auPropertyChangedListeners == null || object == null && object2 == null || object != null && object.equals(object2))) {
            PropertyEvent propertyEvent = new PropertyEvent(string, object, object2);
            for (IConnectionPropertyChangedListener iConnectionPropertyChangedListener : this.auPropertyChangedListeners) {
                try {
                    iConnectionPropertyChangedListener.propertyChanged(propertyEvent);
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        throw throwable;
                    }
                    LoggerFactory.getInstance(DirectServerConnection.class).error(throwable);
                }
            }
        }
    }

    private static final class DirectServerPushReceiver
    implements IPushReceiver {
        private static ILogger log = LoggerFactory.getInstance(DirectServerConnection.class);
        private DirectServerConnection connection;

        private DirectServerPushReceiver(DirectServerConnection directServerConnection) {
            this.connection = directServerConnection;
        }

        public void receivedMessage(PushMessage pushMessage) {
            ResultObject resultObject = pushMessage.getObject();
            if (log.isEnabled(ILogger.LogLevel.INFO)) {
                log.info("Received push message: ", resultObject.getType());
            }
            if (resultObject.getType() == 6 && this.connection.auCallBackResultListeners != null) {
                CallBackResultEvent callBackResultEvent = new CallBackResultEvent((String)resultObject.getCallBackId(), resultObject.getObject());
                int n = this.connection.auCallBackResultListeners.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        ((ICallBackResultListener)this.connection.auCallBackResultListeners.get(i)).callBackResult(callBackResultEvent);
                        continue;
                    }
                    catch (Throwable throwable) {
                        log.error(throwable);
                    }
                }
            }
        }
    }
}

