/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.IInjectObject;
import com.sibvisions.rad.server.Monitoring;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.ServerContextImpl;
import com.sibvisions.rad.server.SessionCallHandler;
import com.sibvisions.rad.server.SessionContextImpl;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import com.sibvisions.util.xml.XmlNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.InjectObject;
import javax.rad.server.ResultObject;
import javax.rad.server.ServerContext;
import javax.rad.server.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession
implements ISession {
    protected ILogger log = LoggerFactory.getInstance(this.getClass());
    private DefaultSessionManager manager = null;
    private AbstractObjectProvider objProvider = null;
    private SessionCallHandler callHandler = null;
    private ISerializer serializer = null;
    private ArrayUtil<ResultObject> auCallBackResult = null;
    private Object oId;
    protected ChangedHashtable<String, Object> chtProperties = new ChangedHashtable();
    protected ChangedHashtable<String, Object> chtExternalProperties = null;
    private Object oSyncCallBack = new Object();
    private ChangedHashtable<String, InjectObject> chtInjectObjects = null;
    private int iExecution = 0;
    private long lStartTime;
    private long lLastAccessTime;
    private long lLastAliveTime;
    private int iMaxInactiveInterval = 0;
    private long lAliveInterval = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractSession(DefaultSessionManager defaultSessionManager, ChangedHashtable<String, Object> changedHashtable) {
        Record record = ProtocolFactory.openRecord("SESSION", "INIT_SESSION", new Object[0]);
        try {
            this.manager = defaultSessionManager;
            this.objProvider = defaultSessionManager.getServer().getObjectProvider();
            this.chtExternalProperties = changedHashtable;
            this.oId = UUID.randomUUID().toString();
            this.lStartTime = System.currentTimeMillis();
            this.setLastAccessTime(this.lStartTime);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(changedHashtable);
            for (Map.Entry<String, Object> entry : hashtable.entrySet()) {
                this.setPropertyIntern(entry.getKey(), entry.getValue());
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
    }

    protected abstract ApplicationZone getApplicationZone();

    public abstract IAccessController getAccessController();

    public abstract void setNewPassword(String var1, String var2) throws Exception;

    @Override
    public Object getId() {
        return this.oId;
    }

    @Override
    public String getLifeCycleName() {
        return this.getPropertyAsString("client.lifecyclename");
    }

    @Override
    public final String getApplicationName() {
        return this.getPropertyAsString("client.application");
    }

    @Override
    public final String getUserName() {
        return this.getPropertyAsString("client.username");
    }

    @Override
    public final String getPassword() {
        return this.getPropertyAsString("client.password");
    }

    @Override
    public Object getProperty(String string) {
        this.setLastAccessTime(System.currentTimeMillis());
        return this.getPropertyIntern(string);
    }

    @Override
    public long getStartTime() {
        return this.lStartTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lLastAccessTime;
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        this.iMaxInactiveInterval = n;
        this.chtProperties.put("server.session.timeoutSeconds", n);
        this.chtProperties.put("server.session.timeout", n > 0 ? n / 60 : n);
        if (this.chtExternalProperties != null) {
            this.chtExternalProperties.put("server.session.timeoutSeconds", n);
            this.chtExternalProperties.put("server.session.timeout", n > 0 ? n / 60 : n);
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.iMaxInactiveInterval;
    }

    @Override
    public boolean isInactive(long l) {
        return this.iMaxInactiveInterval > 0 && !this.isExecuting() && this.getLastAccessTime() + (long)this.iMaxInactiveInterval * 1000L < l;
    }

    @Override
    public long getLastAliveTime() {
        return this.lLastAliveTime;
    }

    @Override
    public void setAliveInterval(long l) {
        this.lAliveInterval = l;
        this.chtProperties.put("client.alive.interval", l);
        if (this.chtExternalProperties != null) {
            this.chtExternalProperties.put("client.alive.interval", l);
        }
    }

    @Override
    public long getAliveInterval() {
        return this.lAliveInterval;
    }

    @Override
    public boolean isAlive(long l) {
        return this.isExecuting() || this.lAliveInterval < 0L || this.getLastAliveTime() + this.lAliveInterval * 4L >= l;
    }

    @Override
    public Object call(String string, String string2, Object ... objectArray) throws Throwable {
        Object object;
        Record record = this.openRecord("CALL", new Object[0]);
        try {
            if (record != null) {
                record.setParameter(this.getLifeCycleName(), string, string2, objectArray);
            }
            object = this.executeIntern(new Call(null, string, string2, objectArray));
        }
        catch (Throwable throwable) {
            try {
                if (record != null) {
                    record.setException(throwable);
                }
                throw throwable;
            }
            catch (Throwable throwable2) {
                CommonUtil.close(record);
                throw throwable2;
            }
        }
        CommonUtil.close(record);
        return object;
    }

    @Override
    public Object callAction(String string, Object ... objectArray) throws Throwable {
        Object object;
        Record record = this.openRecord("CALL_ACTION", new Object[0]);
        try {
            if (record != null) {
                record.setParameter(this.getLifeCycleName(), string, objectArray);
            }
            object = this.executeIntern(new Call(null, null, string, objectArray));
        }
        catch (Throwable throwable) {
            try {
                if (record != null) {
                    record.setException(throwable);
                }
                throw throwable;
            }
            catch (Throwable throwable2) {
                CommonUtil.close(record);
                throw throwable2;
            }
        }
        CommonUtil.close(record);
        return object;
    }

    @Override
    public Object get(String string) throws Throwable {
        SessionContext sessionContext = this.createSessionContext(string, null);
        try {
            Object object = this.objProvider.getObject(this, string);
            return object;
        }
        catch (Throwable throwable) {
            throw this.addCallInfo(throwable, string, null);
        }
        finally {
            if (sessionContext != null) {
                sessionContext.release();
            }
        }
    }

    @Override
    public Object put(String string, Object object) throws Throwable {
        SessionContext sessionContext = this.createSessionContext(string, null);
        try {
            Object object2 = this.objProvider.putObject(this, string, object);
            return object2;
        }
        catch (Throwable throwable) {
            throw this.addCallInfo(throwable, string, null);
        }
        finally {
            if (sessionContext != null) {
                sessionContext.release();
            }
        }
    }

    private final String getPropertyAsString(String string) {
        Object v = this.chtProperties.get(string);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    final void setLifeCycleName(String string) {
        this.chtProperties.put("client.lifecyclename", string);
    }

    final void setApplicationName(String string) {
        this.chtProperties.put("client.application", string);
    }

    public final void setUserName(String string) {
        this.chtProperties.put("client.username", string);
    }

    public final void setPassword(String string) {
        this.chtProperties.put("client.password", string);
    }

    void setSerializer(ISerializer iSerializer) {
        this.serializer = iSerializer;
        if (iSerializer != null) {
            this.setPropertyIntern("server.session.serializer", iSerializer.getClass().getSimpleName());
        } else {
            this.setPropertyIntern("server.session.serializer", "");
        }
    }

    ISerializer getSerializer() {
        return this.serializer;
    }

    public void setLastAccessTime(long l) {
        this.lLastAccessTime = l;
        this.setLastAliveTime(l);
    }

    public void setLastAliveTime(long l) {
        this.lLastAliveTime = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    final Object execute(Call call) throws Throwable {
        Object object;
        Record record = this.openRecord("CALL", new Object[0]);
        this.chtExternalProperties = null;
        this.setExecuting(true);
        if (record != null) {
            record.setParameter(this.getLifeCycleName(), call.getObjectName(), call.getMethodName(), call.getParameters());
        }
        this.setLastAccessTime(System.currentTimeMillis());
        Object object2 = object = this.executeIntern(call);
        this.setLastAccessTime(System.currentTimeMillis());
        this.setExecuting(false);
        CommonUtil.close(record);
        return object2;
        {
            catch (Throwable throwable) {
                try {
                    this.setLastAccessTime(System.currentTimeMillis());
                    this.setExecuting(false);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CommonUtil.close(record);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object executeIntern(Call call) throws Throwable {
        SessionContext sessionContext = this.createSessionContext(call.getObjectName(), call.getMethodName());
        try {
            Object object = this.executeWithSessionContext(sessionContext, call);
            return object;
        }
        finally {
            if (sessionContext != null) {
                sessionContext.release();
            }
        }
    }

    protected Object executeWithSessionContext(SessionContext sessionContext, Call call) throws Throwable {
        if (this.callHandler != null) {
            this.callHandler.fireBeforeCall(call);
        }
        if (call.isCallBack()) {
            ThreadHandler.start(new CallBackWorker(call));
            if (this.callHandler != null) {
                this.callHandler.fireAfterCall(call, null, null);
            }
            return null;
        }
        String string = call.getObjectName();
        String string2 = call.getMethodName();
        Object[] objectArray = call.getParameters();
        try {
            Object object = this.objProvider.invoke(this, string, string2, objectArray);
            if (this.callHandler != null) {
                this.callHandler.fireAfterCall(call, object, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (this.callHandler != null) {
                this.callHandler.fireAfterCall(call, null, throwable);
            }
            throw this.addCallInfo(throwable, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCallBackResult(ResultObject resultObject) {
        Object object = this.oSyncCallBack;
        synchronized (object) {
            if (this.auCallBackResult == null) {
                this.auCallBackResult = new ArrayUtil();
            }
            this.auCallBackResult.add(resultObject);
        }
    }

    ArrayUtil<ResultObject> removeCallBackResults() {
        return this.removeCallBackResultsIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayUtil<ResultObject> removeCallBackResultsIntern() {
        this.setLastAliveTime(System.currentTimeMillis());
        Object object = this.oSyncCallBack;
        synchronized (object) {
            ArrayUtil<ResultObject> arrayUtil = this.auCallBackResult;
            this.auCallBackResult = null;
            return arrayUtil;
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        this.setLastAccessTime(System.currentTimeMillis());
        this.setPropertyIntern(string, object);
    }

    protected void setProperties(List<Object[]> list) {
        this.setLastAccessTime(System.currentTimeMillis());
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = list.get(i);
                this.setPropertyIntern((String)objectArray[0], objectArray[1]);
            }
        }
    }

    protected final void setPropertyIntern(String string, Object object) {
        this.setLastAliveTime(System.currentTimeMillis());
        this.checkPropertyAccess(string, object);
        if ("server.session.timeout".equals(string)) {
            int n = object instanceof String ? Integer.valueOf((String)object).intValue() : ((Number)object).intValue();
            if (n > 0) {
                this.setMaxInactiveInterval(n * 60);
            } else {
                this.setMaxInactiveInterval(n);
            }
        } else if ("server.session.timeoutSeconds".equals(string)) {
            if (object instanceof String) {
                this.setMaxInactiveInterval(Integer.valueOf((String)object));
            } else {
                this.setMaxInactiveInterval(((Number)object).intValue());
            }
        } else if ("client.alive.interval".equals(string)) {
            if (object instanceof String) {
                this.setAliveInterval(Long.valueOf((String)object));
            } else {
                this.setAliveInterval(((Number)object).longValue());
            }
        } else {
            this.chtProperties.put(string, object);
            if (this.chtExternalProperties != null) {
                this.chtExternalProperties.put(string, object);
            }
        }
    }

    private void checkPropertyAccess(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid property name: null");
        }
        if (("server.session.timeout".equals(string) || "server.session.timeoutSeconds".equals(string)) && object == null) {
            throw new SecurityException("It's not allowed to change the property '" + string + "' to '" + object + "'");
        }
    }

    private Object getPropertyIntern(String string) {
        this.setLastAliveTime(System.currentTimeMillis());
        if (string == null) {
            throw new IllegalArgumentException("Invalid property name '" + string + "'");
        }
        return this.chtProperties.get(string);
    }

    public ChangedHashtable<String, Object> getProperties() {
        return this.chtProperties;
    }

    protected DefaultSessionManager getSessionManager() {
        return this.manager;
    }

    AbstractObjectProvider getObjectProvider() {
        return this.objProvider;
    }

    final SessionContext createSessionContext(String string, String string2) {
        SessionContextImpl sessionContextImpl = new SessionContextImpl(this);
        sessionContextImpl.setObjectName(string);
        sessionContextImpl.setMethodName(string2);
        return sessionContextImpl;
    }

    public InjectObject putObject(InjectObject injectObject) {
        if (injectObject == null) {
            return null;
        }
        String string = injectObject.getName();
        if (string == null || string.startsWith("!")) {
            throw new RuntimeException("The object name '" + string + "' is not valid!");
        }
        try {
            this.initInjectObjects();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.chtInjectObjects.containsKey("!" + string)) {
            throw new RuntimeException("It is not allowed to change the preconfigured object '" + string + "'!");
        }
        return this.chtInjectObjects.put(string, injectObject);
    }

    public InjectObject removeObject(InjectObject injectObject) {
        if (injectObject == null) {
            return null;
        }
        String string = injectObject.getName();
        if (string == null || string.startsWith("!")) {
            throw new RuntimeException("The object name '" + string + "' is not valid!");
        }
        try {
            this.initInjectObjects();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.chtInjectObjects.containsKey("!" + string)) {
            throw new RuntimeException("It is not allowed to remove the preconfigured object '" + string + "'!");
        }
        return this.chtInjectObjects.remove(string);
    }

    public InjectObject getObject(String string) {
        try {
            this.initInjectObjects();
            InjectObject injectObject = (InjectObject)this.chtInjectObjects.get("!" + string);
            if (injectObject != null) {
                return injectObject;
            }
            return (InjectObject)this.chtInjectObjects.get(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    Enumeration<InjectObject> getInjectObjects() throws Exception {
        this.initInjectObjects();
        return this.chtInjectObjects.elements();
    }

    List<Map.Entry<String, InjectObject>> getChangedInjectObjects() {
        if (this.chtInjectObjects == null) {
            return null;
        }
        return this.chtInjectObjects.getChanges(new Class[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initInjectObjects() throws Exception {
        if (this.chtInjectObjects != null) return;
        this.chtInjectObjects = new ChangedHashtable();
        try {
            List<XmlNode> list = this.getApplicationZone().getNodes("/application/inject");
            if (list == null) return;
            for (XmlNode xmlNode : list) {
                void var4_6;
                void var4_9;
                Object var4_7 = null;
                String string = null;
                XmlNode xmlNode2 = xmlNode.getNode("name");
                String string2 = xmlNode2 != null ? xmlNode2.getValue() : null;
                XmlNode xmlNode3 = xmlNode.getNode("object");
                if (xmlNode3 != null) {
                    String string3 = xmlNode3.getValue();
                    if (!"monitoring".equals(string3)) throw new SecurityException("Object '" + string3 + "' is not supported!");
                    Monitoring monitoring = ((Server)this.getSessionManager().getServer()).getMonitoring();
                    if (string2 == null) {
                        string2 = string3;
                    }
                } else {
                    xmlNode3 = xmlNode.getNode("class");
                    if (xmlNode3 == null) throw new SecurityException("Unsupported inject definition: " + xmlNode);
                    string = xmlNode3.getValue();
                }
                if (var4_9 == null && StringUtil.isEmpty(string) || !this.isInjectionAllowed(xmlNode)) continue;
                if (var4_9 == null) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        Object obj = clazz.newInstance();
                        if (obj instanceof IInjectObject) {
                            ((IInjectObject)obj).init(this);
                        }
                        if (string2 == null) {
                            string2 = clazz.getSimpleName();
                        }
                    }
                    catch (Throwable throwable) {
                        this.log.error(throwable);
                        Object var4_11 = null;
                    }
                }
                if (var4_6 == null) continue;
                if (this.chtInjectObjects.containsKey("!" + string2)) {
                    throw new IllegalArgumentException("Object name '" + string2 + "' is already used!");
                }
                this.chtInjectObjects.put("!" + string2, new InjectObject(string2, var4_6), false);
            }
            return;
        }
        catch (Exception exception) {
            this.chtInjectObjects = null;
            throw exception;
        }
    }

    private boolean isInjectionAllowed(XmlNode xmlNode) {
        List<XmlNode> list = xmlNode.getNodes("allow");
        if (list == null) {
            return true;
        }
        String string = this.getLifeCycleName();
        for (XmlNode xmlNode2 : list) {
            XmlNode xmlNode3 = xmlNode2.getNode("instanceof");
            XmlNode xmlNode4 = xmlNode2.getNode("lifecyclename");
            if (xmlNode4 != null && string.equals(xmlNode4.getValue())) {
                return true;
            }
            if (xmlNode3 == null) continue;
            String string2 = xmlNode3.getValue();
            try {
                Class<?> clazz = Class.forName(string2);
                if (!clazz.isAssignableFrom(this.getClass())) continue;
                return true;
            }
            catch (Exception exception) {
                this.log.error(exception);
            }
        }
        return false;
    }

    protected boolean isExecuting() {
        return this.iExecution > 0;
    }

    protected void setExecuting(boolean bl) {
        this.iExecution = bl ? ++this.iExecution : --this.iExecution;
    }

    protected void checkAccess() {
        IAccessController iAccessController = this.getAccessController();
        if (iAccessController != null && !iAccessController.isAllowed(this.getLifeCycleName())) {
            throw new SecurityException("Access to '" + this.getLifeCycleName() + "' denied!");
        }
    }

    private Throwable addCallInfo(Throwable throwable, String string, String string2) {
        Throwable throwable2 = throwable;
        do {
            StackTraceElement[] stackTraceElementArray;
            if ((stackTraceElementArray = throwable2.getStackTrace()) == null) continue;
            ArrayUtil<StackTraceElement> arrayUtil = new ArrayUtil<StackTraceElement>();
            boolean bl = false;
            for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
                try {
                    if (!bl && AbstractObjectProvider.class.isAssignableFrom(Class.forName(stackTraceElementArray[i].getClassName()))) {
                        bl = true;
                        StackTraceElement stackTraceElement = new StackTraceElement(this.getLifeCycleName() + ".<" + string + ">", string2 != null ? string2 : "", null, -1);
                        if (i + 1 >= stackTraceElementArray.length || !stackTraceElementArray[i + 1].equals(stackTraceElement)) {
                            arrayUtil.add(0, stackTraceElement);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                arrayUtil.add(0, stackTraceElementArray[i]);
            }
            StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[arrayUtil.size()];
            arrayUtil.toArray(stackTraceElementArray2);
            throwable2.setStackTrace(stackTraceElementArray2);
        } while ((throwable2 = throwable2.getCause()) != null);
        return throwable;
    }

    protected Record openRecord(String string, Object ... objectArray) {
        Record record = ProtocolFactory.openRecord("SESSION", string, objectArray);
        try {
            if (record != null) {
                record.addIdentifier(this.getId());
            }
        }
        catch (RuntimeException runtimeException) {
            CommonUtil.close(record);
            throw runtimeException;
        }
        return record;
    }

    SessionCallHandler getCallHandler() {
        if (this.callHandler == null) {
            this.callHandler = new SessionCallHandler(this);
        }
        return this.callHandler;
    }

    protected void initMaxInactiveInterval(ChangedHashtable<String, Object> changedHashtable, Zone zone, String string, int n) throws Exception {
        if (changedHashtable.get("server.session.timeout") == null && changedHashtable.get("server.session.timeoutSeconds") == null) {
            String string2 = zone.getProperty("/application/timeoutSeconds/" + string);
            String string3 = null;
            if (string2 == null) {
                string3 = zone.getProperty("/application/timeout/" + string);
            }
            if (string2 != null || string3 != null) {
                int n2 = -1;
                int n3 = -1;
                if (string2 != null) {
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.info("Invalid timeout (seconds)!", numberFormatException);
                    }
                }
                if (string3 != null) {
                    try {
                        n3 = Integer.parseInt(string3) * 60;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.info("Invalid timeout (minutes)!", numberFormatException);
                    }
                }
                if (n2 == -1 && n3 == -1) {
                    this.setMaxInactiveInterval(n);
                } else if (n2 >= 0 && n3 >= 0) {
                    this.setMaxInactiveInterval(Math.min(n2, n3));
                } else {
                    this.setMaxInactiveInterval(Math.max(n2, n3));
                }
            } else {
                this.setMaxInactiveInterval(n);
            }
        }
    }

    final class CallBackWorker
    implements Runnable {
        private Call call = null;

        private CallBackWorker(Call call) {
            this.call = call;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ServerContext serverContext = ((Server)AbstractSession.this.getSessionManager().getServer()).createServerContext();
            try {
                ((ServerContextImpl)serverContext).setSession(AbstractSession.this);
                SessionCallHandler sessionCallHandler = AbstractSession.this.getCallHandler();
                Record record = AbstractSession.this.openRecord("CALLBACK", new Object[0]);
                boolean bl = false;
                try {
                    if (record != null) {
                        record.addIdentifier("(thread)", 0);
                        record.setParameter(AbstractSession.this.getLifeCycleName(), this.call.getObjectName(), this.call.getMethodName(), this.call.getParameters());
                    }
                    sessionCallHandler.fireBeforeFirstCall();
                    try {
                        Object object = AbstractSession.this.executeIntern(new Call((Object)null, this.call.getObjectName(), this.call.getMethodName(), this.call.getParameters()));
                        sessionCallHandler.fireAfterCall(this.call, object, null);
                        this.call.success(AbstractSession.this, object);
                    }
                    catch (Throwable throwable) {
                        bl = true;
                        if (record != null) {
                            record.setException(throwable);
                        }
                        sessionCallHandler.fireAfterCall(this.call, null, throwable);
                        this.call.error(AbstractSession.this, AbstractSession.this.addCallInfo(AbstractSecurityManager.prepareException(throwable), this.call.getObjectName(), this.call.getMethodName()));
                    }
                }
                catch (Throwable throwable) {
                    CommonUtil.close(record);
                    sessionCallHandler.fireAfterLastCall(bl);
                    throw throwable;
                }
                CommonUtil.close(record);
                sessionCallHandler.fireAfterLastCall(bl);
            }
            finally {
                serverContext.release();
            }
        }
    }
}

