/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<short[]> {
    private static final int TYPE_SHORT_ARRAY_MIN = 62;
    private static final int TYPE_SHORT_ARRAY_MAX = 64;

    @Override
    public Class<short[]> getTypeClass() {
        return short[].class;
    }

    @Override
    public int getMinValue() {
        return 62;
    }

    @Override
    public int getMaxValue() {
        return 64;
    }

    @Override
    public short[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 62, 64);
        short[] sArray = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, short[] sArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, sArray.length, 62, 64);
        for (int i = 0; i < sArray.length; ++i) {
            dataOutputStream.writeShort(sArray[i]);
        }
    }
}

