/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongSerializer
implements ITypeSerializer<Long> {
    private static final int TYPE_LONG = 13;
    private static final int TYPE_LONG_0 = 14;
    private static final Long LONG_0 = 0L;

    @Override
    public Class<Long> getTypeClass() {
        return Long.class;
    }

    @Override
    public int getMinValue() {
        return 13;
    }

    @Override
    public int getMaxValue() {
        return 14;
    }

    @Override
    public Long read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        if (n == 13) {
            return dataInputStream.readLong();
        }
        return LONG_0;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Long l, TypeCache typeCache) throws Exception {
        long l2 = l;
        if (l2 == 0L) {
            dataOutputStream.writeByte(14);
        } else {
            dataOutputStream.writeByte(13);
            dataOutputStream.writeLong(l2);
        }
    }
}

