/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.IConnectionPool;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceConnectionPool
implements IConnectionPool {
    private static ILogger logger;
    private DataSource dataSource;
    private String username;
    private String password;

    public DataSourceConnectionPool(DataSource dataSource) {
        this(dataSource, null, null);
    }

    public DataSourceConnectionPool(DataSource dataSource, String string, String string2) {
        if (dataSource == null) {
            throw new IllegalArgumentException("The DataSource may not be null!");
        }
        this.dataSource = dataSource;
        this.username = string;
        this.password = string2;
    }

    public Connection getConnection() throws SQLException {
        DataSourceConnectionPool.debug("Get connection from connection pool: ", this.dataSource);
        if (!StringUtil.isEmpty(this.username) && !StringUtil.isEmpty(this.password)) {
            return this.dataSource.getConnection(this.username, this.password);
        }
        return this.dataSource.getConnection();
    }

    public void releaseConnection(Connection connection) {
        DataSourceConnectionPool.debug("Release connection of connection pool: ", this.dataSource);
        CommonUtil.close(connection);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected static void debug(Object ... objectArray) {
        if (logger == null) {
            logger = LoggerFactory.getInstance(DataSourceConnectionPool.class);
        }
        logger.debug(objectArray);
    }
}

