/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.genui.celleditor;

import com.sibvisions.rad.model.mem.MemDataBook;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.celleditor.UIComboCellEditor;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.ObjectDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.ui.celleditor.ILinkedCellEditor;
import javax.rad.util.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIEnumCellEditor
extends UIComboCellEditor<ILinkedCellEditor> {
    private static final String DISPLAY_COLUMN_NAME = "DISPLAY";
    private static final String VALUE_COLUMN_NAME = "VALUE";
    private Object[] allowedValues = null;
    private String columnName = null;
    private String[] displayValues = null;
    private ReferenceDefinition linkReference = new ReferenceDefinition();
    private StringDataType displayValueDataType = new StringDataType();
    private IDataBook referencedDataBook = new MemDataBook();

    public UIEnumCellEditor() {
        super(UIFactoryManager.getFactory().createLinkedCellEditor());
        Object object;
        try {
            this.referencedDataBook.setName("REFERENCE");
            object = this.referencedDataBook.getRowDefinition();
            object.addColumnDefinition(new ColumnDefinition(VALUE_COLUMN_NAME, new ObjectDataType()));
            object.addColumnDefinition(new ColumnDefinition(DISPLAY_COLUMN_NAME, this.displayValueDataType));
            this.referencedDataBook.open();
        }
        catch (ModelException modelException) {
            ExceptionHandler.raise(modelException);
        }
        this.linkReference.setReferencedColumnNames(new String[]{VALUE_COLUMN_NAME});
        this.linkReference.setReferencedDataBook(this.referencedDataBook);
        object = (ILinkedCellEditor)this.getUIResource();
        object.setLinkReference(this.linkReference);
        object.setColumnView(new ColumnView(DISPLAY_COLUMN_NAME));
        object.setDisplayReferencedColumnName(DISPLAY_COLUMN_NAME);
        object.setTableHeaderVisible(false);
    }

    public UIEnumCellEditor(Object[] objectArray) {
        this(objectArray, null);
    }

    public UIEnumCellEditor(Object[] objectArray, String[] stringArray) {
        this();
        this.setAllowedValues(objectArray);
        this.setDisplayValues(stringArray);
    }

    @Override
    public ICellEditorHandler createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        this.displayValueDataType.setTranslator(iCellEditorListener.getControl());
        return super.createCellEditorHandler(iCellEditorListener, iDataRow, string);
    }

    public Object[] getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Object[] objectArray) {
        this.allowedValues = objectArray;
        this.updateReferencedDataBook();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        this.linkReference.setColumnNames(new String[]{this.columnName});
    }

    public String[] getDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(String[] stringArray) {
        this.displayValues = stringArray;
        this.updateReferencedDataBook();
    }

    private void updateReferencedDataBook() {
        try {
            int n;
            this.referencedDataBook.setReadOnly(false);
            this.referencedDataBook.setFilter(null);
            this.referencedDataBook.setSort(null);
            int n2 = this.allowedValues == null ? 0 : this.allowedValues.length;
            for (n = 0; n < n2; ++n) {
                if (n >= this.referencedDataBook.getRowCount()) {
                    this.referencedDataBook.insert(false);
                } else {
                    this.referencedDataBook.setSelectedRow(n);
                }
                this.referencedDataBook.setValue(VALUE_COLUMN_NAME, this.allowedValues[n]);
                if (this.displayValues != null && n < this.displayValues.length) {
                    this.referencedDataBook.setValue(DISPLAY_COLUMN_NAME, this.displayValues[n]);
                    continue;
                }
                this.referencedDataBook.setValue(DISPLAY_COLUMN_NAME, this.allowedValues[n]);
            }
            int n3 = this.referencedDataBook.getRowCount();
            for (n = n2; n < n3; ++n) {
                this.referencedDataBook.setSelectedRow(n2);
                this.referencedDataBook.delete();
            }
            this.referencedDataBook.saveAllRows();
            this.referencedDataBook.setSelectedRow(-1);
            this.referencedDataBook.setReadOnly(true);
        }
        catch (ModelException modelException) {
            ExceptionHandler.raise(modelException);
        }
    }
}

