/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.server;

import java.util.Hashtable;
import java.util.Vector;
import javax.rad.remote.IConnection;
import javax.rad.server.ICallBackBroker;
import javax.rad.server.ICallHandler;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;
import javax.rad.server.InjectObject;

public abstract class SessionContext {
    private static ThreadLocal<Vector<SessionContext>> contexts = new ThreadLocal();
    private static ThreadLocal<SessionContext> instance = new ThreadLocal();
    private Hashtable<String, InjectObject> htObjects = null;
    private int iElementPos = -1;

    protected abstract void destroy();

    public abstract ISession getSession();

    public abstract ISession getMasterSession();

    public abstract IConfiguration getSessionConfig();

    public abstract IConfiguration getServerConfig();

    public abstract IConnection getServerConnection();

    public abstract String getObjectName();

    public abstract String getMethodName();

    public abstract InjectObject putObject(InjectObject var1);

    public abstract InjectObject removeObject(InjectObject var1);

    public abstract InjectObject getObject(String var1);

    public abstract ICallHandler getCallHandler();

    public abstract ICallBackBroker getCallBackBroker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void release() {
        try {
            this.destroy();
        }
        finally {
            this.htObjects = null;
        }
    }

    public static SessionContext getCurrentInstance() {
        return instance.get();
    }

    public static ISession getCurrentSession() {
        SessionContext sessionContext = instance.get();
        if (sessionContext == null) {
            return null;
        }
        return sessionContext.getSession();
    }

    public static IConfiguration getCurrentSessionConfig() {
        SessionContext sessionContext = instance.get();
        if (sessionContext == null) {
            return null;
        }
        return sessionContext.getSessionConfig();
    }

    public static IConfiguration getCurrentServerConfig() {
        SessionContext sessionContext = instance.get();
        if (sessionContext == null) {
            return null;
        }
        return sessionContext.getServerConfig();
    }

    public static ICallBackBroker.PublishState publishCallBackResult(String string, Object object) {
        SessionContext sessionContext = instance.get();
        if (sessionContext == null) {
            return ICallBackBroker.PublishState.Failed;
        }
        return sessionContext.getCallBackBroker().publish(string, object);
    }

    public boolean isReleased() {
        return instance.get() == null;
    }

    protected synchronized void setCurrentInstance(SessionContext sessionContext) {
        Vector<SessionContext> vector = contexts.get();
        if (vector == null) {
            vector = new Vector();
            contexts.set(vector);
        }
        if (sessionContext == null) {
            int n = vector.size();
            if (n > 0) {
                SessionContext sessionContext2 = vector.remove(n - 1);
                sessionContext2.iElementPos = n - 1;
                instance.set(sessionContext2);
            } else {
                instance.set(null);
            }
        } else {
            SessionContext sessionContext3 = instance.get();
            if (sessionContext3 != sessionContext) {
                if (sessionContext3 != null) {
                    vector.add(sessionContext3);
                    sessionContext3.iElementPos = vector.size() - 1;
                }
                instance.set(sessionContext);
                sessionContext.iElementPos = vector.size();
            }
        }
    }

    public InjectObject putObject(String string, Object object) {
        if (object == null) {
            return this.removeObject(string);
        }
        return this.putObject(new InjectObject(string, object));
    }

    public InjectObject removeObject(String string) {
        if (this.htObjects == null) {
            return null;
        }
        return this.htObjects.remove(string);
    }

    public SessionContext getPreviousContext() {
        if (this.iElementPos > 0) {
            return contexts.get().get(this.iElementPos - 1);
        }
        return null;
    }

    public SessionContext getNextContext() {
        Vector<SessionContext> vector = contexts.get();
        int n = vector != null ? vector.size() - 1 : 0;
        if (n == this.iElementPos) {
            return instance.get();
        }
        if (this.iElementPos < n) {
            return vector.get(this.iElementPos + 1);
        }
        return null;
    }
}

