/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.remote;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.ICloseable;
import com.sibvisions.util.KeyValueList;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.nio.charset.Charset;
import java.text.DecimalFormatSymbols;
import java.util.AbstractList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rad.remote.CommunicationException;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.event.CallBackEvent;
import javax.rad.remote.event.CallBackForward;
import javax.rad.remote.event.CallBackResultEvent;
import javax.rad.remote.event.CallBackResultForward;
import javax.rad.remote.event.CallErrorEvent;
import javax.rad.remote.event.CallEvent;
import javax.rad.remote.event.ConnectionEvent;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.remote.event.ICallBackResultListener;
import javax.rad.remote.event.IConnectionListener;
import javax.rad.remote.event.IConnectionPropertyChangedListener;
import javax.rad.remote.event.PropertyEvent;
import javax.rad.util.EventHandler;
import javax.rad.util.UIInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnection
implements ICloseable {
    private static final String[] USED_SYSPROPS = new String[]{"user.name", "os.name", "os.version", "os.arch", "java.vendor", "java.version", "java.class.version", "java.vm.name", "file.encoding", "file.separator", "path.separator", "line.separator", "user.language", "user.timezone"};
    private static final ICallBackListener CBL_INTERN = new ICallBackListener(){

        public void callBack(CallBackEvent callBackEvent) {
            try {
                log.debug(callBackEvent.getObject());
            }
            catch (Throwable throwable) {
                log.debug(throwable);
            }
        }
    };
    private static final ICallBackResultListener CBRL_INTERN = new ICallBackResultListener(){

        public void callBackResult(CallBackResultEvent callBackResultEvent) {
            log.debug(callBackResultEvent.getInstruction(), callBackResultEvent.getObject());
        }
    };
    private static ILogger log = LoggerFactory.getInstance(AbstractConnection.class);
    private static EventHandler<ICallBackListener> callBackProvider = new EventHandler<ICallBackListener>(ICallBackListener.class, new Class[0]);
    protected IConnection connection;
    protected ConnectionInfo coninf;
    private ArrayUtil<IConnectionListener> auConListener = null;
    private PropertyChangedDelegate pcdHandler;
    private CallBackResultDelegate cbrHandler;

    protected AbstractConnection(IConnection iConnection) {
        this.connection = iConnection;
        this.coninf = new ConnectionInfo(this.createConnectionProperties());
    }

    protected abstract void openConnection() throws Throwable;

    protected abstract UIInvoker getUIInvoker();

    protected void finalize() throws Throwable {
        this.auConListener = null;
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public void setLifeCycleName(String string) {
        this.coninf.getProperties().put("client.lifecyclename", string);
    }

    public String getLifeCycleName() {
        return (String)this.coninf.getProperties().get("client.lifecyclename");
    }

    public void setApplicationName(String string) {
        if (!this.isOpen()) {
            this.coninf.getProperties().put("client.application", string);
        }
    }

    public String getApplicationName() {
        return (String)this.coninf.getProperties().get("client.application");
    }

    public void setUserName(String string) {
        this.coninf.getProperties().put("client.username", string);
    }

    public String getUserName() {
        return (String)this.coninf.getProperties().get("client.username");
    }

    public void setPassword(String string) {
        if (!this.isOpen()) {
            this.coninf.getProperties().put("client.password", string);
        }
    }

    public String getPassword() {
        return (String)this.coninf.getProperties().get("client.password");
    }

    public void open() throws Throwable {
        long l = System.currentTimeMillis();
        String string = null;
        try {
            this.openConnection();
            if (log.isEnabled(ILogger.LogLevel.DEBUG)) {
                string = "open" + StringUtil.getShortenedWords(this.getClass().getSimpleName(), 2);
                this.logCommunication(l, string, null, new Object[0]);
            }
            this.fireOpen();
        }
        catch (Throwable throwable) {
            if (log.isEnabled(ILogger.LogLevel.DEBUG)) {
                this.logCommunication(l, string, throwable, new Object[0]);
            }
            throw this.handleCallError(throwable);
        }
    }

    public boolean isOpen() {
        return this.connection.isOpen(this.coninf);
    }

    @Override
    public void close() throws Throwable {
        this.close(true);
    }

    protected void close(boolean bl) throws Throwable {
        long l = System.currentTimeMillis();
        if (bl) {
            try {
                this.connection.close(this.coninf);
            }
            catch (Throwable throwable) {
                this.logCommunication(l, "close", throwable, new Object[0]);
            }
        } else {
            this.coninf.setConnectionId(null);
        }
        this.logCommunication(l, "close", null, new Object[0]);
        this.fireClose();
    }

    public void reopen() throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.close(this.coninf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.openConnection();
            this.logCommunication(l, "reopen", null, new Object[0]);
            this.fireReOpen();
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "reopen", throwable, new Object[0]);
            throw this.handleCallError(throwable);
        }
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public Object getConnectionId() {
        return this.coninf.getConnectionId();
    }

    public void callBack(Object[] objectArray, String[] stringArray, String[] stringArray2, String[] stringArray3, Object[][] objectArray2) throws Throwable {
        this.call(this.createCallBackListener(objectArray, stringArray), stringArray2, stringArray3, objectArray2);
    }

    public void call(ICallBackListener[] iCallBackListenerArray, String[] stringArray, String[] stringArray2, Object[][] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, stringArray, stringArray2, objectArray, this.createCallBackListener(stringArray2, iCallBackListenerArray));
            this.logCommunication(l, "call", null, iCallBackListenerArray, stringArray, stringArray2);
            if (this.auConListener != null && stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.fireCall(true, stringArray != null && stringArray.length > i ? stringArray[i] : null, stringArray2[i], objectArray != null && objectArray.length > i ? objectArray[i] : null);
                }
            }
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, iCallBackListenerArray, stringArray, stringArray2);
            throw this.handleCallError(throwable);
        }
    }

    public void callBack(Object object, String string, String string2, String string3, Object ... objectArray) throws Throwable {
        this.call(callBackProvider.createListener(object, string), string2, string3, objectArray);
    }

    public void call(ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, new String[]{string}, new String[]{string2}, new Object[][]{objectArray}, new ICallBackListener[]{this.createCallBackListener(iCallBackListener)});
            this.logCommunication(l, "call", null, iCallBackListener, string, string2);
            this.fireCall(true, string, string2, objectArray);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, iCallBackListener, string);
            throw this.handleCallError(throwable);
        }
    }

    public void callBack(Object object, String string, String string2, String string3) throws Throwable {
        this.call(callBackProvider.createListener(object, string), string2, string3);
    }

    public void call(ICallBackListener iCallBackListener, String string, String string2) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, new String[]{string}, new String[]{string2}, null, new ICallBackListener[]{this.createCallBackListener(iCallBackListener)});
            this.logCommunication(l, "call", null, iCallBackListener, string, string2);
            this.fireCall(true, string, string2, new Object[0]);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, iCallBackListener, string, string2);
            throw this.handleCallError(throwable);
        }
    }

    public Object[] call(String[] stringArray, String[] stringArray2, Object[][] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object[] objectArray2 = this.connection.call(this.coninf, stringArray, stringArray2, objectArray, null);
            this.logCommunication(l, "call", null, null, stringArray, stringArray2);
            if (this.auConListener != null && objectArray2 != null) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    this.fireCall(false, stringArray != null && stringArray.length > i ? stringArray[i] : null, stringArray2[i], objectArray != null && objectArray.length > i ? objectArray[i] : null);
                }
            }
            return objectArray2;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, null, stringArray, stringArray2);
            throw this.handleCallError(throwable);
        }
    }

    public Object[] call(String[] stringArray, String[] stringArray2) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object[] objectArray = this.connection.call(this.coninf, stringArray, stringArray2, null, null);
            this.logCommunication(l, "call", null, null, stringArray, stringArray2);
            if (this.auConListener != null && objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.fireCall(false, stringArray != null && stringArray.length > i ? stringArray[i] : null, stringArray2[i], new Object[0]);
                }
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, null, stringArray, stringArray2);
            throw this.handleCallError(throwable);
        }
    }

    public Object call(String string, String string2, Object ... objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.call(this.coninf, new String[]{string}, new String[]{string2}, new Object[][]{objectArray}, null)[0];
            this.logCommunication(l, "call", null, null, string, string2);
            this.fireCall(false, string, string2, objectArray);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, null, string, string2);
            throw this.handleCallError(throwable);
        }
    }

    public Object call(String string, String string2) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.call(this.coninf, new String[]{string}, new String[]{string2}, null, null)[0];
            this.logCommunication(l, "call", null, null, string, string2);
            this.fireCall(false, string, string2, new Object[0]);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "call", throwable, null, string, string2);
            throw this.handleCallError(throwable);
        }
    }

    public Object callAction(String string) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.call(this.coninf, null, new String[]{string}, null, null)[0];
            this.logCommunication(l, "callAction", null, null, string);
            this.fireCallAction(false, string, new Object[0]);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, null, string);
            throw this.handleCallError(throwable);
        }
    }

    public Object callAction(String string, Object ... objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.call(this.coninf, null, new String[]{string}, new Object[][]{objectArray}, null)[0];
            this.logCommunication(l, "callAction", null, null, string);
            this.fireCallAction(false, string, objectArray);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, null, string);
            throw this.handleCallError(throwable);
        }
    }

    public Object[] callAction(String[] stringArray, Object[][] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object[] objectArray2 = this.connection.call(this.coninf, null, stringArray, objectArray, null);
            this.logCommunication(l, "callAction", null, null, stringArray);
            if (objectArray2 != null) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    this.fireCallAction(false, stringArray[i], objectArray != null && objectArray.length > i ? objectArray[i] : null);
                }
            }
            return objectArray2;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, null, stringArray);
            throw this.handleCallError(throwable);
        }
    }

    public Object[] callAction(String[] stringArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object[] objectArray = this.connection.call(this.coninf, null, stringArray, null, null);
            this.logCommunication(l, "callAction", null, null, stringArray);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.fireCallAction(false, stringArray[i], new Object[0]);
                }
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, null, stringArray);
            throw this.handleCallError(throwable);
        }
    }

    public void callBackAction(Object object, String string, String string2) throws Throwable {
        this.callAction(callBackProvider.createListener(object, string), string2);
    }

    public void callAction(ICallBackListener iCallBackListener, String string) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, null, new String[]{string}, null, new ICallBackListener[]{this.createCallBackListener(iCallBackListener)});
            this.logCommunication(l, "callAction", null, iCallBackListener, string);
            this.fireCallAction(true, string, new Object[0]);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, iCallBackListener, string);
            throw this.handleCallError(throwable);
        }
    }

    public void callBackAction(Object object, String string, String string2, Object ... objectArray) throws Throwable {
        this.callAction(callBackProvider.createListener(object, string), string2, objectArray);
    }

    public void callAction(ICallBackListener iCallBackListener, String string, Object ... objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, null, new String[]{string}, new Object[][]{objectArray}, new ICallBackListener[]{this.createCallBackListener(iCallBackListener)});
            this.logCommunication(l, "callAction", null, iCallBackListener, string);
            this.fireCallAction(true, string, objectArray);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, iCallBackListener, string);
            throw this.handleCallError(throwable);
        }
    }

    public void callBackAction(Object[] objectArray, String[] stringArray, String[] stringArray2, Object[][] objectArray2) throws Throwable {
        this.callAction(this.createCallBackListener(objectArray, stringArray), stringArray2, objectArray2);
    }

    public void callAction(ICallBackListener[] iCallBackListenerArray, String[] stringArray, Object[][] objectArray) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.call(this.coninf, null, stringArray, objectArray, this.createCallBackListener(stringArray, iCallBackListenerArray));
            this.logCommunication(l, "callAction", null, iCallBackListenerArray, stringArray);
            if (this.auConListener != null && stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fireCallAction(true, stringArray[i], objectArray != null && objectArray.length > i ? objectArray[i] : null);
                }
            }
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "callAction", throwable, iCallBackListenerArray, stringArray);
            throw this.handleCallError(throwable);
        }
    }

    public void setProperty(String string, Object object) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            this.connection.setProperty(this.coninf, string, object);
            this.logCommunication(l, "setProperty", null, string);
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "setProperty", throwable, string);
            throw this.handleCallError(throwable);
        }
    }

    public Object getProperty(String string) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object object = this.connection.getProperty(this.coninf, string);
            this.logCommunication(l, "getProperty", null, string);
            return object;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "getProperty", throwable, string);
            throw this.handleCallError(throwable);
        }
    }

    public Hashtable<String, Object> getProperties() throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Hashtable<String, Object> hashtable = this.connection.getProperties(this.coninf);
            this.logCommunication(l, "getProperties", null, new Object[0]);
            return hashtable;
        }
        catch (Throwable throwable) {
            this.logCommunication(l, "getProperties", null, new Object[0]);
            throw this.handleCallError(throwable);
        }
    }

    public void setTimeout(int n) throws Throwable {
        this.setProperty("server.session.timeout", n);
    }

    public int getTimeout() throws Throwable {
        Integer n = (Integer)this.getProperty("server.session.timeout");
        if (n != null) {
            int n2 = n;
            if (n2 < 0) {
                return n2;
            }
            return n2 / 60;
        }
        return -2;
    }

    protected ChangedHashtable<String, Object> createConnectionProperties() {
        Object object;
        Object object2;
        ChangedHashtable<String, Object> changedHashtable = new ChangedHashtable<String, Object>();
        try {
            object2 = Charset.defaultCharset();
            changedHashtable.put("client.defaultCharset", ((Charset)object2).name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = "client.sysprop.";
        int n = USED_SYSPROPS.length;
        for (int i = 0; i < n; ++i) {
            try {
                object2 = System.getProperty(USED_SYSPROPS[i]);
                if (object2 == null) continue;
                changedHashtable.put(string + USED_SYSPROPS[i], object2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = "client.envprop.";
        try {
            object = System.getenv();
            for (Map.Entry<String, String> entry : object.entrySet()) {
                String string2 = entry.getKey();
                object2 = entry.getValue();
                if (string2 == null || object2 == null) continue;
                changedHashtable.put(string + entry.getKey(), object2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new DecimalFormatSymbols();
        string = "client.decimalFormatSymbols.";
        changedHashtable.put(string + "currencySymbol", ((DecimalFormatSymbols)object).getCurrencySymbol());
        changedHashtable.put(string + "currencyCode", ((DecimalFormatSymbols)object).getCurrency().getCurrencyCode());
        changedHashtable.put(string + "internationalCurrencySymbol", ((DecimalFormatSymbols)object).getInternationalCurrencySymbol());
        changedHashtable.put(string + "decimalsSparator", Character.toString(((DecimalFormatSymbols)object).getDecimalSeparator()));
        changedHashtable.put(string + "digit", Character.toString(((DecimalFormatSymbols)object).getDigit()));
        changedHashtable.put(string + "groupingSeparator", Character.toString(((DecimalFormatSymbols)object).getGroupingSeparator()));
        changedHashtable.put(string + "infinity", ((DecimalFormatSymbols)object).getInfinity());
        changedHashtable.put(string + "minusSign", Character.toString(((DecimalFormatSymbols)object).getMinusSign()));
        changedHashtable.put(string + "monetaryDecimalSeparator", Character.toString(((DecimalFormatSymbols)object).getMonetaryDecimalSeparator()));
        changedHashtable.put(string + "NaN", ((DecimalFormatSymbols)object).getNaN());
        changedHashtable.put(string + "patternSeparator", Character.toString(((DecimalFormatSymbols)object).getPatternSeparator()));
        changedHashtable.put(string + "percent", Character.toString(((DecimalFormatSymbols)object).getPercent()));
        changedHashtable.put(string + "perMill", Character.toString(((DecimalFormatSymbols)object).getPerMill()));
        changedHashtable.put(string + "zeroDigit", Character.toString(((DecimalFormatSymbols)object).getZeroDigit()));
        changedHashtable.put("client.oslib_version", "2.5");
        changedHashtable.put("client.spec_version", "0.4.1");
        changedHashtable.put("client.creationTime", new Date());
        IConnection iConnection = this.getConnection();
        if (iConnection != null) {
            changedHashtable.put("client.connectionClass", iConnection.getClass().getName());
        }
        changedHashtable.put("client.session.compression", "true");
        return changedHashtable;
    }

    public void addConnectionListener(IConnectionListener iConnectionListener) {
        if (iConnectionListener != null) {
            if (this.auConListener == null) {
                this.auConListener = new ArrayUtil();
            }
            if (this.auConListener.indexOf(iConnectionListener) < 0) {
                this.auConListener.add(iConnectionListener);
                this.connection.addPropertyChangedListener(iConnectionListener);
            }
        }
    }

    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        if (this.auConListener != null && iConnectionListener != null) {
            this.connection.removePropertyChangedListener(iConnectionListener);
            this.auConListener.remove(iConnectionListener);
            if (this.auConListener.size() == 0) {
                this.auConListener = null;
            }
        }
    }

    public IConnectionListener[] getConnectionListener() {
        if (this.auConListener != null) {
            IConnectionListener[] iConnectionListenerArray = new IConnectionListener[this.auConListener.size()];
            return this.auConListener.toArray(iConnectionListenerArray);
        }
        return null;
    }

    public void addPropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        this.addPropertyChangedListener(null, iConnectionPropertyChangedListener);
    }

    public void addPropertyChangedListener(String string, IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.pcdHandler == null) {
            this.pcdHandler = new PropertyChangedDelegate();
            this.connection.addPropertyChangedListener(this.pcdHandler);
        }
        this.pcdHandler.add(string, iConnectionPropertyChangedListener);
    }

    public void removePropertyChangedListener(String string) {
        this.removePropertyChangedListener(string, null);
    }

    public void removePropertyChangedListener(IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.pcdHandler != null) {
            this.pcdHandler.remove(iConnectionPropertyChangedListener);
        }
    }

    public void removePropertyChangedListener(String string, IConnectionPropertyChangedListener iConnectionPropertyChangedListener) {
        if (this.pcdHandler != null) {
            this.pcdHandler.remove(string, iConnectionPropertyChangedListener);
        }
    }

    public void addCallBackResultListener(ICallBackResultListener iCallBackResultListener) {
        this.addCallBackResultListener(null, iCallBackResultListener);
    }

    public void addCallBackResultListener(String string, ICallBackResultListener iCallBackResultListener) {
        if (this.cbrHandler == null) {
            this.cbrHandler = new CallBackResultDelegate();
        }
        this.cbrHandler.add(string, this.createCallBackResultListener(iCallBackResultListener));
    }

    public void removeCallBackResultListener(ICallBackResultListener iCallBackResultListener) {
        if (this.cbrHandler != null) {
            this.cbrHandler.remove(iCallBackResultListener);
        }
    }

    public void removeCallBackResultListener(String string) {
        this.removeCallBackResultListener(string, null);
    }

    public void removeCallBackResultListener(String string, ICallBackResultListener iCallBackResultListener) {
        if (this.cbrHandler != null) {
            this.cbrHandler.remove(string, iCallBackResultListener);
        }
    }

    protected void fireCallError(Throwable throwable) {
        if (this.auConListener != null) {
            CallErrorEvent callErrorEvent = new CallErrorEvent(this, throwable);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.callError(callErrorEvent);
            }
        }
    }

    protected void fireCallBackResult(CallBackResultEvent callBackResultEvent) throws Throwable {
        if (this.cbrHandler != null) {
            this.cbrHandler.callBackResult(callBackResultEvent);
        }
    }

    protected Throwable handleCallError(Throwable throwable) {
        Throwable throwable2 = this.setConnection(throwable);
        this.fireCallError(throwable2);
        return throwable2;
    }

    protected Throwable setConnection(Throwable throwable) {
        if (throwable != null) {
            for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                if (!(throwable2 instanceof CommunicationException)) continue;
                ((CommunicationException)throwable2).setConnection(this);
            }
        }
        return throwable;
    }

    protected void fireOpen() {
        if (this.auConListener != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.connectionOpened(connectionEvent);
            }
        }
    }

    protected void fireReOpen() {
        if (this.auConListener != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.connectionReOpened(connectionEvent);
            }
        }
    }

    protected void fireClose() {
        if (this.auConListener != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.connectionClosed(connectionEvent);
            }
        }
    }

    protected void fireCall(boolean bl, String string, String string2, Object ... objectArray) {
        if (this.auConListener != null) {
            CallEvent callEvent = new CallEvent(this, string, string2, objectArray, bl);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.objectCalled(callEvent);
            }
        }
    }

    protected void fireCallAction(boolean bl, String string, Object ... objectArray) {
        if (this.auConListener != null) {
            CallEvent callEvent = new CallEvent(this, null, string, objectArray, bl);
            Iterator iterator = ((AbstractList)this.auConListener.clone()).iterator();
            while (iterator.hasNext()) {
                IConnectionListener iConnectionListener = (IConnectionListener)iterator.next();
                iConnectionListener.actionCalled(callEvent);
            }
        }
    }

    private ICallBackListener createCallBackListener(ICallBackListener iCallBackListener) {
        if (iCallBackListener == null) {
            return CBL_INTERN;
        }
        return new CallBackForward(this.getUIInvoker(), this, iCallBackListener);
    }

    private ICallBackResultListener createCallBackResultListener(ICallBackResultListener iCallBackResultListener) {
        if (iCallBackResultListener == null) {
            return CBRL_INTERN;
        }
        return new CallBackResultForward(this.getUIInvoker(), iCallBackResultListener);
    }

    private ICallBackListener[] createCallBackListener(String[] stringArray, ICallBackListener[] iCallBackListenerArray) {
        ICallBackListener[] iCallBackListenerArray2 = iCallBackListenerArray;
        if (iCallBackListenerArray == null && stringArray != null) {
            iCallBackListenerArray2 = new ICallBackListener[stringArray.length];
        }
        if (iCallBackListenerArray2 != null) {
            for (int i = 0; i < iCallBackListenerArray2.length; ++i) {
                iCallBackListenerArray2[i] = iCallBackListenerArray2[i] == null ? CBL_INTERN : new CallBackForward(this.getUIInvoker(), this, iCallBackListenerArray2[i]);
            }
        }
        return iCallBackListenerArray2;
    }

    private ICallBackListener[] createCallBackListener(Object[] objectArray, String[] stringArray) {
        ICallBackListener[] iCallBackListenerArray = null;
        if (objectArray != null) {
            iCallBackListenerArray = new ICallBackListener[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                iCallBackListenerArray[i] = callBackProvider.createListener(objectArray[i], stringArray[i]);
            }
        }
        return iCallBackListenerArray;
    }

    protected void logCommunication(long l, String string, Throwable throwable, Object ... objectArray) {
        if (log.isEnabled(ILogger.LogLevel.DEBUG)) {
            if (throwable != null) {
                log.debug(string, " error: " + Long.valueOf(System.currentTimeMillis() - l), " ms", " ", objectArray, throwable);
            } else {
                log.debug(string, ": ", System.currentTimeMillis() - l, " ms", " ", objectArray);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallBackResultDelegate
    extends ListenerDelegate<ICallBackResultListener>
    implements ICallBackResultListener {
        @Override
        public void callBackResult(CallBackResultEvent callBackResultEvent) throws Throwable {
            List list = this.getListeners(callBackResultEvent.getInstruction());
            for (int i = 0; i < list.size(); ++i) {
                ((ICallBackResultListener)list.get(i)).callBackResult(callBackResultEvent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyChangedDelegate
    extends ListenerDelegate<IConnectionPropertyChangedListener>
    implements IConnectionPropertyChangedListener {
        @Override
        public void propertyChanged(PropertyEvent propertyEvent) throws Throwable {
            List list = this.getListeners(propertyEvent.getPropertyName());
            for (int i = 0; i < list.size(); ++i) {
                ((IConnectionPropertyChangedListener)list.get(i)).propertyChanged(propertyEvent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListenerDelegate<K> {
        private KeyValueList<String, K> kvlListener = new KeyValueList();
        private List<K> liAllListeners = null;

        public List<K> getListeners(String string) {
            ArrayUtil<K> arrayUtil = new ArrayUtil<K>();
            List<K> list = this.kvlListener.get(string);
            if (list != null) {
                arrayUtil.addAll(list);
            }
            if (this.liAllListeners != null) {
                arrayUtil.addAll(this.liAllListeners);
            }
            return arrayUtil;
        }

        public void add(String string, K k) {
            if (string == null) {
                if (this.liAllListeners == null) {
                    this.liAllListeners = new ArrayUtil<K>();
                    this.liAllListeners.add(k);
                } else if (!this.liAllListeners.contains(k)) {
                    this.liAllListeners.add(k);
                }
            } else if (!this.kvlListener.contains(string, (String)k)) {
                this.kvlListener.put(string, (String)k);
            }
        }

        public void remove(String string, K k) {
            if (string == null) {
                if (this.liAllListeners != null) {
                    if (k == null) {
                        this.liAllListeners = null;
                    } else {
                        this.liAllListeners.remove(k);
                    }
                }
            } else if (k == null) {
                this.kvlListener.remove(string);
            } else {
                this.kvlListener.remove(string, (String)k);
            }
        }

        public void remove(K k) {
            if (this.liAllListeners != null) {
                if (k == null) {
                    this.liAllListeners.clear();
                } else {
                    this.liAllListeners.remove(k);
                }
            }
            if (k == null) {
                this.kvlListener.clear();
            } else {
                this.kvlListener.removeValue(k);
            }
        }
    }
}

